/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.system;

import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.system.ActorThread;

public abstract class ActorThreadFactory {
    public abstract ActorSystem system();

    public abstract void setSystem(ActorSystem var1);

    public abstract ActorThread newThread();

    public static class DefaultActorThreadFactory
    extends ActorThreadFactory {
        private ActorSystem sys;

        @Override
        public void setSystem(ActorSystem actorSystem) {
            this.sys = actorSystem;
        }

        @Override
        public ActorSystem system() {
            return this.sys;
        }

        @Override
        public ActorThread newThread() {
            ActorThread thread = new ActorThread(this.system());
            if (thread.isDaemon()) {
                thread.setDaemon(false);
            }
            if (thread.getPriority() != 5) {
                thread.setPriority(5);
            }
            return thread;
        }
    }
}

