/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.system;

import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.system.ActorThread;
import cc.otavia.core.system.ActorThreadFactory;
import cc.otavia.core.system.ActorThreadPool;
import cc.otavia.core.system.ActorThreadPool$;
import cc.otavia.core.system.TilingThreadSelector;
import java.io.Serializable;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class DefaultActorThreadPool
implements ActorThreadPool {
    private final ActorSystem system;
    private final ActorThreadFactory actorThreadFactory;
    private final int size;
    private int cursor;
    private final ActorThread[] threads;
    private volatile boolean inited;
    private final TilingThreadSelector normalSelector;
    private final TilingThreadSelector ioSelector;

    public DefaultActorThreadPool(ActorSystem system, ActorThreadFactory actorThreadFactory, int size) {
        this.system = system;
        this.actorThreadFactory = actorThreadFactory;
        this.size = size;
        this.cursor = ActorThreadPool$.MODULE$.INVALID_THREAD_ID();
        this.threads = new ActorThread[size];
        this.inited = false;
        this.normalSelector = new TilingThreadSelector(this.threads);
        this.ioSelector = new TilingThreadSelector(this.threads);
    }

    @Override
    public ActorSystem system() {
        return this.system;
    }

    @Override
    public ActorThreadFactory actorThreadFactory() {
        return this.actorThreadFactory;
    }

    @Override
    public int size() {
        return this.size;
    }

    private void init() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)index -> {
            ActorThread thread;
            this.threads[index] = thread = this.createActorThread();
            thread.start();
        });
        this.inited = true;
    }

    @Override
    public boolean isInit() {
        return this.inited;
    }

    @Override
    public int nextThreadId() {
        ++this.cursor;
        return this.cursor;
    }

    @Override
    public ActorThread createActorThread() {
        return this.actorThreadFactory().newThread();
    }

    @Override
    public ActorThread next(boolean channels) {
        if (!this.inited) {
            DefaultActorThreadPool defaultActorThreadPool = this;
            synchronized (defaultActorThreadPool) {
                this.init();
            }
        }
        if (!channels) {
            return this.normalSelector.select();
        }
        return this.ioSelector.select();
    }

    @Override
    public Seq<ActorThread> nexts(int num, boolean channels) {
        if (!this.inited) {
            DefaultActorThreadPool defaultActorThreadPool = this;
            synchronized (defaultActorThreadPool) {
                this.init();
            }
        }
        if (!channels) {
            return this.normalSelector.select(num);
        }
        return this.ioSelector.select(num);
    }

    @Override
    public ActorThread[] workers() {
        return this.threads;
    }

    @Override
    public Option<ActorThread> busiest() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }
}

