/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.system;

import cc.otavia.core.system.ActorHouse;
import cc.otavia.core.system.HouseManager;
import cc.otavia.core.system.HouseQueue;
import cc.otavia.core.util.SpinLock;
import java.util.concurrent.atomic.AtomicInteger;

public class FIFOHouseQueue
extends HouseQueue {
    private final SpinLock readLock = new SpinLock();
    private final SpinLock writeLock = new SpinLock();
    private final AtomicInteger size = new AtomicInteger(0);
    private volatile ActorHouse head;
    private volatile ActorHouse tail;

    public FIFOHouseQueue(HouseManager manager) {
        super(manager);
    }

    private HouseManager manager$accessor() {
        return super.manager();
    }

    @Override
    public boolean available() {
        return this.size.get() > 0;
    }

    @Override
    public int readies() {
        return this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    @Override
    public boolean nonEmpty() {
        return this.size.get() > 0;
    }

    @Override
    public void enqueue(ActorHouse house) {
        this.writeLock.lock();
        if (this.size.get() == 0) {
            this.readLock.lock();
            this.head = house;
            this.tail = house;
            this.size.incrementAndGet();
            this.writeLock.unlock();
            this.readLock.unlock();
            return;
        }
        this.tail.next_$eq(house);
        this.tail = house;
        this.size.incrementAndGet();
        this.writeLock.unlock();
    }

    @Override
    public final ActorHouse dequeue() {
        if (this.size.get() == 0) {
            return null;
        }
        return this.dequeue0();
    }

    private final ActorHouse dequeue0() {
        if (this.size.get() == 0) {
            return null;
        }
        if (this.size.get() == 1) {
            this.writeLock.lock();
            this.readLock.lock();
            if (this.size.get() == 1) {
                ActorHouse house = this.head;
                this.head = null;
                this.tail = null;
                this.size.decrementAndGet();
                house.schedule();
                this.writeLock.unlock();
                this.readLock.unlock();
                return house;
            }
            this.writeLock.unlock();
            ActorHouse house = this.cc$otavia$core$system$FIFOHouseQueue$$inline$head();
            this.cc$otavia$core$system$FIFOHouseQueue$$inline$head_$eq(house.next());
            this.cc$otavia$core$system$FIFOHouseQueue$$inline$size().decrementAndGet();
            house.schedule();
            this.cc$otavia$core$system$FIFOHouseQueue$$inline$readLock().unlock();
            house.deChain();
            return house;
        }
        this.readLock.lock();
        ActorHouse house = this.cc$otavia$core$system$FIFOHouseQueue$$inline$head();
        this.cc$otavia$core$system$FIFOHouseQueue$$inline$head_$eq(house.next());
        this.cc$otavia$core$system$FIFOHouseQueue$$inline$size().decrementAndGet();
        house.schedule();
        this.cc$otavia$core$system$FIFOHouseQueue$$inline$readLock().unlock();
        house.deChain();
        return house;
    }

    public final ActorHouse cc$otavia$core$system$FIFOHouseQueue$$inline$head() {
        return this.head;
    }

    public final void cc$otavia$core$system$FIFOHouseQueue$$inline$head_$eq(ActorHouse x$0) {
        this.head = x$0;
    }

    public final AtomicInteger cc$otavia$core$system$FIFOHouseQueue$$inline$size() {
        return this.size;
    }

    public final SpinLock cc$otavia$core$system$FIFOHouseQueue$$inline$readLock() {
        return this.readLock;
    }
}

