/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.system;

import cc.otavia.core.actor.Actor;
import cc.otavia.core.slf4a.Logger;
import cc.otavia.core.slf4a.Logger$;
import cc.otavia.core.system.ActorHouse;
import cc.otavia.core.system.ActorHouse$;
import cc.otavia.core.system.ActorThread;
import cc.otavia.core.system.FIFOHouseQueue;
import cc.otavia.core.system.HouseManager$;
import cc.otavia.core.system.HouseQueue;
import cc.otavia.core.system.PriorityHouseQueue;
import cc.otavia.core.system.monitor.HouseManagerMonitor;
import cc.otavia.core.system.monitor.HouseManagerMonitor$;
import scala.collection.mutable.ArrayDeque;

public class HouseManager {
    private final ActorThread thread;
    private final FIFOHouseQueue mountingQueue;
    private final FIFOHouseQueue serverActorQueue;
    private final PriorityHouseQueue channelsActorQueue;
    private final PriorityHouseQueue actorQueue;
    private volatile long runningStart;
    private Actor<?> currentRunning;

    public HouseManager(ActorThread thread) {
        this.thread = thread;
        Logger logger = Logger$.MODULE$.getLogger(this.getClass(), thread.system());
        this.mountingQueue = new FIFOHouseQueue(this);
        this.serverActorQueue = new FIFOHouseQueue(this);
        this.channelsActorQueue = new PriorityHouseQueue(this);
        this.actorQueue = new PriorityHouseQueue(this);
        long serverRuns = 0L;
        long serverTimes = 0L;
        long channelsRuns = 0L;
        long channelsTimes = 0L;
        long actorRuns = 0L;
        long actorTimes = 0L;
        this.runningStart = Long.MAX_VALUE;
    }

    public ActorThread thread() {
        return this.thread;
    }

    public Actor<?> currentRunningActor() {
        return this.currentRunning;
    }

    public ArrayDeque<Runnable> laterTasks() {
        return this.thread().laterTasks();
    }

    public void mount(ActorHouse house) {
        this.mountingQueue.enqueue(house);
        this.thread().notifyThread();
    }

    public void ready(ActorHouse house) {
        if (house.actorType() == ActorHouse$.MODULE$.STATE_ACTOR()) {
            this.actorQueue.enqueue(house);
        } else if (house.actorType() == ActorHouse$.MODULE$.CHANNELS_ACTOR()) {
            this.channelsActorQueue.enqueue(house);
        } else if (house.actorType() == ActorHouse$.MODULE$.SERVER_CHANNELS_ACTOR()) {
            this.serverActorQueue.enqueue(house);
        }
        this.thread().notifyThread();
    }

    public void change(ActorHouse house) {
        if (house.highPriority() && !house.inHighPriorityQueue()) {
            if (house.actorType() == ActorHouse$.MODULE$.CHANNELS_ACTOR()) {
                this.channelsActorQueue.adjustPriority(house);
                return;
            }
            if (house.actorType() == ActorHouse$.MODULE$.STATE_ACTOR()) {
                this.actorQueue.adjustPriority(house);
                return;
            }
            return;
        }
    }

    private final void adjustPriority(PriorityHouseQueue queue, ActorHouse house) {
        if (queue.adjust(house)) {
            queue.enqueue(house);
            return;
        }
    }

    public boolean run() {
        ActorHouse house;
        this.runningStart = System.nanoTime();
        boolean success = false;
        if (this.run0(this.serverActorQueue)) {
            success = true;
        }
        if (this.run0(this.channelsActorQueue)) {
            success = true;
        }
        if (this.run0(this.actorQueue)) {
            success = true;
        }
        if (this.mountingQueue.available() && (house = this.mountingQueue.dequeue()) != null) {
            this.currentRunning = house.actor();
            if (house.actorType() == ActorHouse$.MODULE$.CHANNELS_ACTOR()) {
                this.thread().prepared();
            }
            house.doMount();
            this.currentRunning = null;
            success = true;
        }
        this.runningStart = Long.MAX_VALUE;
        return success;
    }

    private final boolean run0(HouseQueue houseQueue) {
        ActorHouse house = houseQueue.dequeue();
        if (house != null) {
            this.currentRunning = house.actor();
            house.run();
            this.currentRunning = null;
            return true;
        }
        return false;
    }

    private boolean stealable() {
        return this.actorQueue.readies() > HouseManager$.cc$otavia$core$system$HouseManager$$$STEAL_REMAINING_THRESHOLD || System.nanoTime() - this.runningStart > (long)HouseManager$.cc$otavia$core$system$HouseManager$$$STEAL_NANO_THRESHOLD && this.actorQueue.nonEmpty();
    }

    public boolean trySteal() {
        ActorThread[] threads = this.thread().parent().workers();
        boolean bl = true;
        ActorThread stealThread = null;
        for (int i = 1; i < threads.length && bl; ++i) {
            ActorThread thread = threads[(i + this.thread().index()) % threads.length];
            if (thread == null || !thread.houseManager().stealable()) continue;
            bl = false;
            stealThread = thread;
        }
        if (stealThread != null) {
            boolean success = stealThread.houseManager().runSteal();
            return success;
        }
        return false;
    }

    private final boolean runSteal() {
        if (this.actorQueue.available()) {
            ActorHouse house = this.actorQueue.dequeue();
            if (house != null) {
                house.run();
                return true;
            }
            return false;
        }
        return false;
    }

    public HouseManagerMonitor monitor() {
        return HouseManagerMonitor$.MODULE$.apply(this.mountingQueue.readies(), this.serverActorQueue.readies(), this.channelsActorQueue.readies(), this.actorQueue.readies());
    }

    public String toString() {
        return new StringBuilder(20).append("mounting=").append(this.mountingQueue.readies()).append(", server=").append(this.serverActorQueue.readies()).append(", ").append(new StringBuilder(17).append("channels=").append(this.channelsActorQueue.readies()).append(", state=").append(this.actorQueue.readies()).toString()).toString();
    }
}

