/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.system;

import cc.otavia.core.system.ActorHouse;
import cc.otavia.core.util.Nextable;

public class MailBox {
    private final ActorHouse house;
    private Nextable head;
    private Nextable tail;
    private volatile int count;

    public MailBox(ActorHouse house) {
        this.house = house;
        this.count = 0;
    }

    public ActorHouse house() {
        return this.house;
    }

    public void put(Nextable obj) {
        MailBox mailBox = this;
        synchronized (mailBox) {
            Nextable oldTail = this.tail;
            if (oldTail == null) {
                this.head = obj;
                this.tail = obj;
            } else {
                this.tail = obj;
                oldTail.next_$eq(this.tail);
            }
            ++this.count;
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T extends Nextable> T get() {
        void var2_3;
        MailBox mailBox = this;
        synchronized (mailBox) {
            void var3_2;
            Nextable obj = null;
            if (this.count == 1) {
                obj = this.head;
                this.head = null;
                this.tail = null;
            } else {
                obj = this.head;
                this.head = obj.next();
                obj.dechain();
            }
            --this.count;
            var2_3 = var3_2;
        }
        return var2_3;
    }

    public Nextable getChain(int max) {
        Nextable nextable;
        MailBox mailBox = this;
        synchronized (mailBox) {
            Nextable obj = null;
            if (this.count <= max) {
                obj = this.head;
                this.head = null;
                this.tail = null;
                this.count = 0;
            } else {
                obj = this.head;
                Nextable cursor = this.head;
                for (int i = 0; i < max - 1; ++i) {
                    cursor = cursor.next();
                }
                Nextable chainTail = cursor;
                this.head = cursor.next();
                chainTail.next_$eq(null);
                this.count -= max;
            }
            nextable = obj;
        }
        return nextable;
    }

    public int size() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public boolean nonEmpty() {
        return this.count > 0;
    }

    public String toString() {
        return new StringBuilder(7).append("size = ").append(this.count).toString();
    }
}

