/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.system;

import cc.otavia.core.system.ActorHouse;
import cc.otavia.core.system.HouseManager;
import cc.otavia.core.system.HouseQueue;
import cc.otavia.core.util.SpinLock;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Predef$;

public class PriorityHouseQueue
extends HouseQueue {
    private final SpinLock readLock = new SpinLock();
    private final SpinLock writeLock = new SpinLock();
    private final AtomicInteger size = new AtomicInteger(0);
    private volatile ActorHouse head;
    private volatile ActorHouse tail;
    private final SpinLock highReadLock = new SpinLock();
    private final SpinLock highWriteLock = new SpinLock();
    private final AtomicInteger highSize = new AtomicInteger(0);
    private volatile ActorHouse highHead;
    private volatile ActorHouse highTail;

    public PriorityHouseQueue(HouseManager manager) {
        super(manager);
    }

    private HouseManager manager$accessor() {
        return super.manager();
    }

    @Override
    public boolean available() {
        return this.size.get() > 0 || this.highSize.get() > 0;
    }

    @Override
    public int readies() {
        return this.highSize.get() + this.size.get();
    }

    @Override
    public boolean isEmpty() {
        return this.highSize.get() == 0 && this.size.get() == 0;
    }

    @Override
    public boolean nonEmpty() {
        return this.size.get() > 0 || this.highSize.get() > 0;
    }

    @Override
    public void enqueue(ActorHouse house) {
        int n;
        if (!house.highPriority()) {
            int n2;
            this.writeLock.lock();
            if (this.size.get() == 0) {
                this.head = house;
                this.tail = house;
                n2 = this.size.incrementAndGet();
            } else {
                ActorHouse oldTail = this.tail;
                this.tail = house;
                oldTail.next_$eq(this.tail);
                this.tail.pre_$eq(oldTail);
                n2 = this.size.incrementAndGet();
            }
            house.inHighPriorityQueue_$eq(false);
            this.writeLock.unlock();
            return;
        }
        this.highWriteLock.lock();
        if (this.highSize.get() == 0) {
            this.highHead = house;
            this.highTail = house;
            n = this.highSize.incrementAndGet();
        } else {
            ActorHouse oldTail = this.highTail;
            this.highTail = house;
            oldTail.next_$eq(this.highTail);
            n = this.highSize.incrementAndGet();
        }
        house.inHighPriorityQueue_$eq(true);
        this.highWriteLock.unlock();
    }

    @Override
    public ActorHouse dequeue() {
        if (this.highSize.get() > 0) {
            return this.dequeuePriority();
        }
        if (this.size.get() > 0) {
            return this.dequeueNormal();
        }
        return null;
    }

    private ActorHouse dequeueNormal() {
        this.readLock.lock();
        int sizeShadow = this.size.get();
        if (sizeShadow == 0) {
            this.readLock.unlock();
            return null;
        }
        if (sizeShadow == 1) {
            this.writeLock.lock();
            if (this.size.get() == 1) {
                ActorHouse house = this.head;
                this.head = null;
                this.tail = null;
                this.size.decrementAndGet();
                house.deChain();
                house.schedule();
                this.writeLock.unlock();
                this.readLock.unlock();
                return house;
            }
            ActorHouse house = this.head;
            this.head = house.next();
            this.head.pre_$eq(null);
            this.size.decrementAndGet();
            house.deChain();
            house.schedule();
            this.writeLock.unlock();
            this.readLock.unlock();
            return house;
        }
        ActorHouse house = this.head;
        this.head = house.next();
        this.head.pre_$eq(null);
        this.size.decrementAndGet();
        house.deChain();
        house.schedule();
        this.readLock.unlock();
        return house;
    }

    private ActorHouse dequeuePriority() {
        this.highReadLock.lock();
        int sizeShadow = this.highSize.get();
        if (sizeShadow == 0) {
            this.highReadLock.unlock();
            return null;
        }
        if (sizeShadow == 1) {
            this.highWriteLock.lock();
            if (this.highSize.get() == 1) {
                ActorHouse house = this.highHead;
                this.highHead = null;
                this.highTail = null;
                this.highSize.decrementAndGet();
                house.deChain();
                house.schedule();
                this.highWriteLock.unlock();
                this.highReadLock.unlock();
                return house;
            }
            ActorHouse house = this.highHead;
            this.highHead = house.next();
            this.highSize.decrementAndGet();
            house.deChain();
            house.schedule();
            this.highWriteLock.unlock();
            this.highReadLock.unlock();
            return house;
        }
        ActorHouse house = this.highHead;
        this.highHead = house.next();
        this.highSize.decrementAndGet();
        house.deChain();
        house.schedule();
        this.highReadLock.unlock();
        return house;
    }

    public void adjustPriority(ActorHouse house) {
        this.readLock.lock();
        this.writeLock.lock();
        if (house.isReady() && !house.inHighPriorityQueue()) {
            ActorHouse pre = house.pre();
            ActorHouse next = house.next();
            if (pre != null) {
                pre.next_$eq(next);
                if (next != null) {
                    next.pre_$eq(pre);
                } else {
                    this.tail = pre;
                }
            } else if (next != null) {
                next.pre_$eq(null);
                this.head = next;
            } else {
                this.head = null;
                this.tail = null;
            }
            this.size.decrementAndGet();
            if (this.size.get() == -1) {
                Predef$.MODULE$.println((Object)"-1");
            }
            house.inHighPriorityQueue_$eq(true);
        }
        this.writeLock.unlock();
        this.readLock.unlock();
        house.deChain();
        this.enqueue(house);
    }

    public boolean adjust(ActorHouse house) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }
}

