/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.system.monitor;

import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.system.monitor.ActorThreadMonitor;
import cc.otavia.core.system.monitor.SystemMonitor;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class SystemMonitorTask
implements Runnable {
    private final ActorSystem system;
    private FileChannel[] fs;
    private volatile boolean c;

    public SystemMonitorTask(ActorSystem system) {
        this.system = system;
        this.c = false;
    }

    public ActorSystem system() {
        return this.system;
    }

    @Override
    public void run() {
        if (!this.c) {
            if (this.system().pool().isInit()) {
                if (this.fs == null) {
                    this.openLogFile();
                }
                long time = System.currentTimeMillis();
                SystemMonitor stats = this.system().monitor();
                Object object = Predef$.MODULE$.refArrayOps((Object[])stats.threadMonitor().actorThreadMonitors());
                Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(object));
                ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    if (tuple2 != null) {
                        ActorThreadMonitor m = (ActorThreadMonitor)tuple2._1();
                        int d = BoxesRunTime.unboxToInt((Object)tuple2._2());
                        String sample = new StringBuilder(5).append(time).append(",").append(m.manager().mounts()).append(",").append(m.manager().serverActors()).append(",").append(m.manager().channelsActors()).append(",").append(m.manager().stateActors()).append("\n").toString();
                        return this.fs[d].write(ByteBuffer.wrap(sample.getBytes()));
                    }
                    throw new MatchError((Object)tuple2);
                });
                return;
            }
            return;
        }
    }

    private void openLogFile() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.system().pool().workers());
        this.fs = (FileChannel[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)thread -> {
            File file = new File(new StringBuilder(12).append("monitor.").append(thread.index()).append(".log").toString());
            return FileChannel.open(file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }, ClassTag$.MODULE$.apply(FileChannel.class));
    }

    public void close() {
        this.c = true;
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.fs);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)_$2 -> _$2.close());
        this.fs = null;
    }
}

