/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.timer;

import cc.otavia.core.slf4a.Logger;
import cc.otavia.core.slf4a.Logger$;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.timer.HashedWheelTimer$;
import cc.otavia.core.timer.HashedWheelTimer$HashedWheelBucket$;
import cc.otavia.core.timer.HashedWheelTimer$HashedWheelTimeout$;
import cc.otavia.core.timer.ImmediateExecutor$;
import cc.otavia.core.timer.InternalTimer;
import cc.otavia.core.timer.Timeout;
import cc.otavia.core.timer.TimerTask;
import cc.otavia.core.util.Nextable;
import cc.otavia.core.util.SpinLockQueue;
import cc.otavia.internal.Platform$;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.mutable.HashSet$;
import scala.collection.mutable.Set;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.function.JProcedure1;

public class HashedWheelTimer
extends AtomicInteger
implements InternalTimer {
    private final ActorSystem system;
    private final long tickDuration;
    private final int ticksPerWheel;
    private final Executor taskExecutor;
    private final Logger logger;
    private final Worker worker;
    private final Thread workerThread;
    private final HashedWheelBucket[] wheel;
    private final int mask;
    private final long duration;
    private final SpinLockQueue timeouts;
    private final SpinLockQueue cancelledTimeouts;
    private final AtomicLong pendingTimeouts;

    public HashedWheelTimer(ActorSystem system, ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel, boolean leakDetection, long maxPendingTimeouts, Executor taskExecutor) {
        long l;
        this.system = system;
        this.tickDuration = tickDuration;
        this.ticksPerWheel = ticksPerWheel;
        this.taskExecutor = taskExecutor;
        this.logger = Logger$.MODULE$.getLogger(this.getClass(), system);
        this.worker = new Worker(this);
        this.workerThread = threadFactory.newThread(this.cc$otavia$core$timer$HashedWheelTimer$$worker());
        this.wheel = HashedWheelTimer$.MODULE$.cc$otavia$core$timer$HashedWheelTimer$$$createWheel(ticksPerWheel);
        this.mask = this.cc$otavia$core$timer$HashedWheelTimer$$wheel().length - 1;
        long d = unit.toNanos(tickDuration);
        if (d >= Long.MAX_VALUE / (long)this.cc$otavia$core$timer$HashedWheelTimer$$wheel().length) {
            throw new IllegalArgumentException(new StringBuilder(54).append("tickDuration: ").append(tickDuration).append(" (expected: 0 < tickDuration in nanos < ").append(Long.MAX_VALUE / (long)this.cc$otavia$core$timer$HashedWheelTimer$$wheel().length).toString());
        }
        if (d < HashedWheelTimer$.cc$otavia$core$timer$HashedWheelTimer$$$MILLISECOND_NANOS) {
            this.logger().warn(new StringBuilder(53).append("Configured tickDuration ").append(tickDuration).append(" smaller than 1ms, using 1ms.").toString());
            l = HashedWheelTimer$.cc$otavia$core$timer$HashedWheelTimer$$$MILLISECOND_NANOS;
        } else {
            l = d;
        }
        this.duration = l;
        this.timeouts = new SpinLockQueue();
        this.cancelledTimeouts = new SpinLockQueue();
        this.pendingTimeouts = new AtomicLong(0L);
    }

    public ActorSystem system() {
        return this.system;
    }

    public long tickDuration() {
        return this.tickDuration;
    }

    public int ticksPerWheel() {
        return this.ticksPerWheel;
    }

    public Executor cc$otavia$core$timer$HashedWheelTimer$$taskExecutor() {
        return this.taskExecutor;
    }

    public Logger logger() {
        return this.logger;
    }

    public HashedWheelTimer(ActorSystem system, ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel, boolean leakDetection, long maxPendingTimeouts) {
        this(system, threadFactory, tickDuration, unit, ticksPerWheel, leakDetection, maxPendingTimeouts, ImmediateExecutor$.MODULE$);
    }

    public HashedWheelTimer(ActorSystem system, ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel, boolean leakDetection) {
        this(system, threadFactory, tickDuration, unit, ticksPerWheel, leakDetection, -1L);
    }

    public HashedWheelTimer(ActorSystem system, ThreadFactory threadFactory, long tickDuration, TimeUnit unit, int ticksPerWheel) {
        this(system, threadFactory, tickDuration, unit, ticksPerWheel, true);
    }

    public HashedWheelTimer(ActorSystem system, ThreadFactory threadFactory, long tickDuration, TimeUnit unit) {
        this(system, threadFactory, tickDuration, unit, 512);
    }

    public HashedWheelTimer(ActorSystem system, ThreadFactory threadFactory) {
        this(system, threadFactory, 100L, scala.concurrent.duration.package$.MODULE$.MILLISECONDS());
    }

    public HashedWheelTimer(ActorSystem system, long tickDuration, TimeUnit unit, int ticksPerWheel) {
        this(system, Executors.defaultThreadFactory(), tickDuration, unit, ticksPerWheel);
    }

    public HashedWheelTimer(ActorSystem system, long tickDuration, TimeUnit unit) {
        this(system, Executors.defaultThreadFactory(), tickDuration, unit);
    }

    public HashedWheelTimer(ActorSystem system) {
        this(system, Executors.defaultThreadFactory());
    }

    public final Worker cc$otavia$core$timer$HashedWheelTimer$$worker() {
        return this.worker;
    }

    public HashedWheelBucket[] cc$otavia$core$timer$HashedWheelTimer$$wheel() {
        return this.wheel;
    }

    public int mask() {
        return this.mask;
    }

    public long duration() {
        return this.duration;
    }

    public SpinLockQueue<HashedWheelTimeout> timeouts() {
        return this.timeouts;
    }

    public SpinLockQueue<HashedWheelTimeout> cancelledTimeouts() {
        return this.cancelledTimeouts;
    }

    public AtomicLong cc$otavia$core$timer$HashedWheelTimer$$pendingTimeouts() {
        return this.pendingTimeouts;
    }

    @Override
    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        if (delay <= 0L) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"delay must large than 0");
        }
        return this.newTimeout0(task, unit.toNanos(delay), 0L);
    }

    @Override
    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit, long period, TimeUnit punit) {
        if (delay <= 0L) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"delay must large than 0");
        }
        if (period <= 0L) {
            throw Scala3RunTime$.MODULE$.assertFailed((Object)"period must large than 0");
        }
        return this.newTimeout0(task, unit.toNanos(delay), punit.toNanos(period));
    }

    private Timeout newTimeout0(TimerTask task, long delay, long period) {
        this.start();
        HashedWheelTimeout timeout = new HashedWheelTimeout(this, task, System.nanoTime(), delay, period);
        this.timeouts().enqueue(timeout);
        return timeout;
    }

    public final void start() {
        if (this.get() == HashedWheelTimer$.cc$otavia$core$timer$HashedWheelTimer$$$WORKER_STATE_STARTED) {
            return;
        }
        int n = this.get();
        if (HashedWheelTimer$.cc$otavia$core$timer$HashedWheelTimer$$$WORKER_STATE_INIT == n) {
            if (this.compareAndSet(HashedWheelTimer$.cc$otavia$core$timer$HashedWheelTimer$$$WORKER_STATE_INIT, HashedWheelTimer$.cc$otavia$core$timer$HashedWheelTimer$$$WORKER_STATE_STARTED)) {
                this.workerThread.start();
                return;
            }
            return;
        }
        if (HashedWheelTimer$.cc$otavia$core$timer$HashedWheelTimer$$$WORKER_STATE_STARTED == n) {
            return;
        }
        if (HashedWheelTimer$.cc$otavia$core$timer$HashedWheelTimer$$$WORKER_STATE_SHUTDOWN == n) {
            throw new IllegalStateException("cannot be started once stopped");
        }
        throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
    }

    @Override
    public scala.collection.immutable.Set<Timeout> stop() {
        Thread thread = Thread.currentThread();
        Thread thread2 = this.workerThread;
        if (!(thread != null ? !thread.equals(thread2) : thread2 != null)) {
            throw new IllegalStateException(new StringBuilder(28).append(this.getClass().getSimpleName()).append(".stop cannot be called from ").append(TimerTask.class.getSimpleName()).toString());
        }
        if (this.compareAndSet(HashedWheelTimer$.cc$otavia$core$timer$HashedWheelTimer$$$WORKER_STATE_STARTED, HashedWheelTimer$.cc$otavia$core$timer$HashedWheelTimer$$$WORKER_STATE_SHUTDOWN)) {
            try {
                boolean interrupted = false;
                while (this.workerThread.isAlive()) {
                    this.workerThread.interrupt();
                    try {
                        this.workerThread.join(100L);
                    }
                    catch (InterruptedException ignored) {
                        interrupted = true;
                    }
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (Throwable throwable) {}
            return this.cc$otavia$core$timer$HashedWheelTimer$$worker().unprocessedTimeouts();
        }
        return Predef$.MODULE$.Set().empty();
    }

    public static final class HashedWheelBucket {
        private HashedWheelTimeout head;
        private HashedWheelTimeout tail;
        private long longRemainingRounds = Int$.MODULE$.int2long(HashedWheelTimer$HashedWheelBucket$.MODULE$.LONG_DEADLINE());
        private HashedWheelTimeout longHead;
        private HashedWheelTimeout longTail;

        public static int LONG_DEADLINE() {
            return HashedWheelTimer$HashedWheelBucket$.MODULE$.LONG_DEADLINE();
        }

        public void addTimeout(HashedWheelTimeout timeout) {
            timeout.bucket_$eq(this);
            if (timeout.remainingRounds() < (long)HashedWheelTimer$HashedWheelBucket$.MODULE$.LONG_DEADLINE()) {
                if (this.head == null) {
                    this.head = timeout;
                    this.tail = timeout;
                    return;
                }
                this.tail.next_$eq(timeout);
                timeout.prevNode_$eq(this.tail);
                this.tail = timeout;
                return;
            }
            timeout.remainingRounds_$eq(timeout.remainingRounds() + ((long)HashedWheelTimer$HashedWheelBucket$.MODULE$.LONG_DEADLINE() - this.longRemainingRounds));
            if (this.longHead == null) {
                this.longHead = timeout;
                this.longTail = timeout;
                return;
            }
            this.longTail.next_$eq(timeout);
            timeout.prevNode_$eq(this.longTail);
            this.longTail = timeout;
        }

        public void expireTimeouts(long deadline) {
            HashedWheelTimeout timeout = this.head;
            while (timeout != null) {
                HashedWheelTimeout next = timeout.nextNode();
                if (timeout.isCancelled()) {
                    next = this.remove(timeout);
                } else if (timeout.remainingRounds() <= 0L) {
                    next = this.remove(timeout);
                    this.expire0(timeout);
                } else {
                    HashedWheelTimeout hashedWheelTimeout = timeout;
                    hashedWheelTimeout.remainingRounds_$eq(hashedWheelTimeout.remainingRounds() - 1L);
                }
                timeout = next;
            }
            this.expireLongTimeouts();
        }

        private void expire0(HashedWheelTimeout timeout) {
            long now = System.nanoTime();
            timeout.expire();
            timeout.bucket_$eq(null);
            if (timeout.periodic()) {
                long l;
                if (timeout.period() >= timeout.timer().duration()) {
                    l = timeout.period();
                } else {
                    String taskName = timeout.task().getClass().getSimpleName();
                    String timerName = timeout.timer().getClass().getSimpleName();
                    timeout.timer().logger().warn(new StringBuilder(52).append(taskName).append(" period is less than duration of ").append(timerName).append(", use ").append(timerName).append(".tickDuration").toString());
                    l = timeout.timer().duration();
                }
                long delay = l;
                long deadline = timeout.timer().cc$otavia$core$timer$HashedWheelTimer$$worker().tick() * timeout.timer().duration() + delay;
                timeout.timer().cc$otavia$core$timer$HashedWheelTimer$$worker().putBucket(timeout, deadline);
                return;
            }
        }

        private void expireLongTimeouts() {
            --this.longRemainingRounds;
            if (this.longRemainingRounds == 0L) {
                HashedWheelTimeout timeout = this.longHead;
                while (timeout != null) {
                    HashedWheelTimeout next = timeout.nextNode();
                    if (timeout.isCancelled()) {
                        next = this.removeLong(timeout);
                    } else if (timeout.remainingRounds() <= (long)HashedWheelTimer$HashedWheelBucket$.MODULE$.LONG_DEADLINE()) {
                        next = this.removeLong(timeout);
                        this.expire0(timeout);
                    } else if (timeout.remainingRounds() - (long)HashedWheelTimer$HashedWheelBucket$.MODULE$.LONG_DEADLINE() < (long)HashedWheelTimer$HashedWheelBucket$.MODULE$.LONG_DEADLINE()) {
                        next = this.remove(timeout);
                        HashedWheelTimeout hashedWheelTimeout = timeout;
                        hashedWheelTimeout.remainingRounds_$eq(hashedWheelTimeout.remainingRounds() - (long)HashedWheelTimer$HashedWheelBucket$.MODULE$.LONG_DEADLINE());
                        this.addTimeout(timeout);
                    } else {
                        HashedWheelTimeout hashedWheelTimeout = timeout;
                        hashedWheelTimeout.remainingRounds_$eq(hashedWheelTimeout.remainingRounds() - (long)HashedWheelTimer$HashedWheelBucket$.MODULE$.LONG_DEADLINE());
                    }
                    timeout = next;
                }
            }
            this.longRemainingRounds = Int$.MODULE$.int2long(HashedWheelTimer$HashedWheelBucket$.MODULE$.LONG_DEADLINE());
        }

        public HashedWheelTimeout remove(HashedWheelTimeout timeout) {
            HashedWheelTimeout next = (HashedWheelTimeout)timeout.next();
            if (timeout.prevNode() != null) {
                timeout.prevNode().next_$eq(next);
            }
            if (timeout.nextNode() != null) {
                timeout.nextNode().prevNode_$eq(timeout.prevNode());
            }
            if (BoxesRunTime.equals((Object)timeout, (Object)this.head)) {
                if (BoxesRunTime.equals((Object)timeout, (Object)this.tail)) {
                    this.tail = null;
                    this.head = null;
                } else {
                    this.head = next;
                }
            } else if (BoxesRunTime.equals((Object)timeout, (Object)this.tail)) {
                this.tail = timeout.prevNode();
            }
            timeout.prevNode_$eq(null);
            timeout.nextNode_$eq(null);
            timeout.bucket_$eq(null);
            timeout.timer().cc$otavia$core$timer$HashedWheelTimer$$pendingTimeouts().decrementAndGet();
            return next;
        }

        public HashedWheelTimeout removeLong(HashedWheelTimeout timeout) {
            HashedWheelTimeout next = (HashedWheelTimeout)timeout.next();
            if (timeout.prevNode() != null) {
                timeout.prevNode().next_$eq(next);
            }
            if (timeout.nextNode() != null) {
                timeout.nextNode().prevNode_$eq(timeout.prevNode());
            }
            if (BoxesRunTime.equals((Object)timeout, (Object)this.longHead)) {
                if (BoxesRunTime.equals((Object)timeout, (Object)this.longTail)) {
                    this.longTail = null;
                    this.longHead = null;
                } else {
                    this.longHead = next;
                }
            } else if (BoxesRunTime.equals((Object)timeout, (Object)this.longTail)) {
                this.longTail = timeout.prevNode();
            }
            timeout.prevNode_$eq(null);
            timeout.nextNode_$eq(null);
            timeout.bucket_$eq(null);
            timeout.timer().cc$otavia$core$timer$HashedWheelTimer$$pendingTimeouts().decrementAndGet();
            return next;
        }

        public void clearTimeouts(Set<Timeout> set) {
            HashedWheelTimeout timeout = this.head;
            while (timeout != null) {
                HashedWheelTimeout next = this.remove(timeout);
                if (!timeout.isCancelled() && (!timeout.isExpired() || timeout.isExpired() && timeout.periodic())) {
                    set.add((Object)timeout);
                }
                timeout = next;
            }
            timeout = this.longHead;
            while (timeout != null) {
                HashedWheelTimeout next = this.remove(timeout);
                if (!timeout.isCancelled() && (!timeout.isExpired() || timeout.isExpired() && timeout.periodic())) {
                    set.add((Object)timeout);
                }
                timeout = next;
            }
        }
    }

    public static final class HashedWheelTimeout
    extends AtomicInteger
    implements Timeout,
    Runnable,
    Nextable {
        private volatile Nextable cc$otavia$core$util$Nextable$$n;
        private final HashedWheelTimer timer;
        private final TimerTask task;
        private final long createTime;
        private final long delay;
        private final long period;
        private long remainingRounds;
        private HashedWheelTimeout nextNode;
        private HashedWheelTimeout prevNode;
        private HashedWheelBucket bucket;

        public static int ST_CANCELLED() {
            return HashedWheelTimer$HashedWheelTimeout$.MODULE$.ST_CANCELLED();
        }

        public static int ST_EXPIRED() {
            return HashedWheelTimer$HashedWheelTimeout$.MODULE$.ST_EXPIRED();
        }

        public static int ST_INIT() {
            return HashedWheelTimer$HashedWheelTimeout$.MODULE$.ST_INIT();
        }

        public HashedWheelTimeout(HashedWheelTimer timer, TimerTask task, long createTime, long delay, long period) {
            this.timer = timer;
            this.task = task;
            this.createTime = createTime;
            this.delay = delay;
            this.period = period;
            Nextable.$init$(this);
            this.remainingRounds = 0L;
        }

        @Override
        public Nextable cc$otavia$core$util$Nextable$$n() {
            return this.cc$otavia$core$util$Nextable$$n;
        }

        @Override
        public void cc$otavia$core$util$Nextable$$n_$eq(Nextable x$1) {
            this.cc$otavia$core$util$Nextable$$n = x$1;
        }

        @Override
        public HashedWheelTimer timer() {
            return this.timer;
        }

        @Override
        public TimerTask task() {
            return this.task;
        }

        public long createTime() {
            return this.createTime;
        }

        public long delay() {
            return this.delay;
        }

        public long period() {
            return this.period;
        }

        public long remainingRounds() {
            return this.remainingRounds;
        }

        public void remainingRounds_$eq(long x$1) {
            this.remainingRounds = x$1;
        }

        public HashedWheelTimeout nextNode() {
            return this.nextNode;
        }

        public void nextNode_$eq(HashedWheelTimeout x$1) {
            this.nextNode = x$1;
        }

        public HashedWheelTimeout prevNode() {
            return this.prevNode;
        }

        public void prevNode_$eq(HashedWheelTimeout x$1) {
            this.prevNode = x$1;
        }

        public HashedWheelBucket bucket() {
            return this.bucket;
        }

        public void bucket_$eq(HashedWheelBucket x$1) {
            this.bucket = x$1;
        }

        @Override
        public boolean periodic() {
            return this.period() > 0L;
        }

        @Override
        public boolean cancel() {
            if (this.compareAndSet(HashedWheelTimer$HashedWheelTimeout$.MODULE$.ST_INIT(), HashedWheelTimer$HashedWheelTimeout$.MODULE$.ST_CANCELLED()) || this.periodic() && this.compareAndSet(HashedWheelTimer$HashedWheelTimeout$.MODULE$.ST_EXPIRED(), HashedWheelTimer$HashedWheelTimeout$.MODULE$.ST_CANCELLED())) {
                if (this.bucket() != null) {
                    this.timer().cancelledTimeouts().enqueue(this);
                }
                return true;
            }
            return false;
        }

        public void remove() {
            if (this.bucket() != null) {
                if (this.remainingRounds() < (long)HashedWheelTimer$HashedWheelBucket$.MODULE$.LONG_DEADLINE()) {
                    this.bucket().remove(this);
                    return;
                }
                this.bucket().removeLong(this);
                return;
            }
            this.timer().cc$otavia$core$timer$HashedWheelTimer$$pendingTimeouts().decrementAndGet();
        }

        public int state() {
            return this.get();
        }

        @Override
        public boolean isCancelled() {
            return this.get() == HashedWheelTimer$HashedWheelTimeout$.MODULE$.ST_CANCELLED();
        }

        @Override
        public boolean isExpired() {
            return this.get() == HashedWheelTimer$HashedWheelTimeout$.MODULE$.ST_EXPIRED();
        }

        public void expire() {
            if (this.compareAndSet(HashedWheelTimer$HashedWheelTimeout$.MODULE$.ST_INIT(), HashedWheelTimer$HashedWheelTimeout$.MODULE$.ST_EXPIRED()) || this.get() == HashedWheelTimer$HashedWheelTimeout$.MODULE$.ST_EXPIRED() && this.periodic()) {
                block3: {
                    try {
                        this.timer().cc$otavia$core$timer$HashedWheelTimer$$taskExecutor().execute(this);
                    }
                    catch (Throwable t) {
                        if (!this.timer().logger().isWarnEnabled()) break block3;
                        this.timer().logger().warn(new StringBuilder(52).append("An exception was thrown while submit ").append(this.task().getClass().getSimpleName()).append(" for execution.").toString(), t);
                    }
                }
                return;
            }
        }

        @Override
        public void run() {
            block2: {
                try {
                    this.task().run(this);
                }
                catch (Throwable t) {
                    if (!this.timer().logger().isWarnEnabled()) break block2;
                    this.timer().logger().warn(new StringBuilder(28).append("An exception was thrown by ").append(this.task().getClass().getSimpleName()).append(".").toString(), t);
                }
            }
        }
    }

    public static final class Worker
    implements Runnable {
        private final HashedWheelTimer timer;
        private final Set<Timeout> unprocessed;
        private long startTime;
        private long tick;

        public Worker(HashedWheelTimer timer) {
            this.timer = timer;
            this.unprocessed = HashSet$.MODULE$.empty();
            this.startTime = 0L;
            this.tick = 0L;
        }

        public HashedWheelTimer timer() {
            return this.timer;
        }

        public long startTime() {
            return this.startTime;
        }

        public void startTime_$eq(long x$1) {
            this.startTime = x$1;
        }

        public long tick() {
            return this.tick;
        }

        public void tick_$eq(long x$1) {
            this.tick = x$1;
        }

        @Override
        public void run() {
            this.startTime_$eq(System.nanoTime());
            while (this.timer().get() == HashedWheelTimer$.cc$otavia$core$timer$HashedWheelTimer$$$WORKER_STATE_STARTED) {
                long deadline = this.waitForNextTick();
                if (deadline <= 0L) continue;
                int idx = (int)(this.tick() & (long)this.timer().mask());
                this.processCancelledTasks();
                HashedWheelBucket bucket2 = this.timer().cc$otavia$core$timer$HashedWheelTimer$$wheel()[idx];
                this.transferTimeoutsToBuckets();
                bucket2.expireTimeouts(deadline);
                this.tick_$eq(this.tick() + 1L);
            }
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.timer().cc$otavia$core$timer$HashedWheelTimer$$wheel());
            ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)bucket -> bucket.clearTimeouts(this.unprocessed));
            while (this.timer().timeouts().nonEmpty()) {
                HashedWheelTimeout timeout = (HashedWheelTimeout)this.timer().timeouts().dequeue();
                if (timeout.isCancelled()) continue;
                this.unprocessed.add((Object)timeout);
            }
            this.processCancelledTasks();
        }

        private void transferTimeoutsToBuckets() {
            for (int i = 0; i < 100000 && this.timer().timeouts().nonEmpty(); ++i) {
                HashedWheelTimeout timeout = (HashedWheelTimeout)this.timer().timeouts().dequeue();
                if (timeout.state() == HashedWheelTimer$HashedWheelTimeout$.MODULE$.ST_CANCELLED()) continue;
                long deadline = timeout.createTime() - this.startTime() + timeout.delay();
                this.putBucket(timeout, deadline);
            }
        }

        public void putBucket(HashedWheelTimeout timeout, long deadline) {
            long calculated = deadline / this.timer().duration();
            timeout.remainingRounds_$eq((calculated - this.tick()) / (long)this.timer().cc$otavia$core$timer$HashedWheelTimer$$wheel().length);
            long ticks = package$.MODULE$.max(calculated, this.tick());
            int stopIdx = (int)(ticks & (long)this.timer().mask());
            HashedWheelBucket bucket = this.timer().cc$otavia$core$timer$HashedWheelTimer$$wheel()[stopIdx];
            bucket.addTimeout(timeout);
        }

        private void processCancelledTasks() {
            while (this.timer().cancelledTimeouts().nonEmpty()) {
                HashedWheelTimeout timeout = (HashedWheelTimeout)this.timer().cancelledTimeouts().dequeue();
                try {
                    timeout.remove();
                }
                catch (Throwable t) {
                    if (!this.timer().logger().isWarnEnabled()) continue;
                    this.timer().logger().warn("An exception was thrown while process a cancellation task", t);
                }
            }
        }

        private long waitForNextTick() {
            long deadline = this.timer().duration() * (this.tick() + 1L);
            long ret = 0L;
            boolean bl = true;
            while (bl) {
                long currentTime = System.nanoTime() - this.startTime();
                long sleepTimeMs = (deadline - currentTime + 999999L) / 1000000L;
                if (sleepTimeMs <= 0L) {
                    ret = currentTime == Long.MAX_VALUE ? -9223372036854775807L : currentTime;
                    bl = false;
                    continue;
                }
                if (Platform$.MODULE$.isWindows() && (sleepTimeMs = sleepTimeMs / 10L * 10L) == 0L) {
                    sleepTimeMs = 1L;
                }
                try {
                    Thread.sleep(sleepTimeMs);
                }
                catch (InterruptedException ignored) {
                    if (this.timer().get() != HashedWheelTimer$.cc$otavia$core$timer$HashedWheelTimer$$$WORKER_STATE_SHUTDOWN) continue;
                    ret = Long.MIN_VALUE;
                    bl = false;
                }
            }
            return ret;
        }

        public scala.collection.immutable.Set<Timeout> unprocessedTimeouts() {
            return this.unprocessed.toSet();
        }
    }
}

