/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.timer;

import cc.otavia.core.address.EventableAddress;
import cc.otavia.core.message.TimerEvent;
import cc.otavia.core.slf4a.Logger;
import cc.otavia.core.slf4a.Logger$;
import cc.otavia.core.timer.InternalTimer;
import cc.otavia.core.timer.Timeout;
import cc.otavia.core.timer.TimerTask;
import cc.otavia.core.timer.TimerTaskManager;
import java.util.concurrent.TimeUnit;
import scala.runtime.BoxedUnit;
import scala.runtime.Scala3RunTime$;

public abstract class TimeoutTask
implements TimerTask {
    private final TimerTaskManager manager;
    private final Logger logger;
    private final long id;
    private EventableAddress address;
    private long period;
    private TimeUnit periodUnit;
    private volatile Timeout handle;

    public TimeoutTask(TimerTaskManager manager) {
        this.manager = manager;
        this.logger = Logger$.MODULE$.getLogger(this.getClass(), manager.system());
        this.id = manager.timer().nextRegisterId();
        this.period = -1L;
        this.periodUnit = TimeUnit.MILLISECONDS;
    }

    public TimerTaskManager manager() {
        return this.manager;
    }

    public Logger logger() {
        return this.logger;
    }

    public long id() {
        return this.id;
    }

    public EventableAddress address() {
        return this.address;
    }

    public void address_$eq(EventableAddress x$1) {
        this.address = x$1;
    }

    public long period() {
        return this.period;
    }

    public void period_$eq(long x$1) {
        this.period = x$1;
    }

    public TimeUnit periodUnit() {
        return this.periodUnit;
    }

    public void periodUnit_$eq(TimeUnit x$1) {
        this.periodUnit = x$1;
    }

    public Timeout handle() {
        return this.handle;
    }

    public void handle_$eq(Timeout x$1) {
        this.handle = x$1;
    }

    public void setAddress(EventableAddress address) {
        this.address_$eq(address);
    }

    public void setPeriod(long period) {
        this.period_$eq(period);
    }

    public void setPeriodUnit(TimeUnit periodUnit) {
        this.periodUnit_$eq(periodUnit);
    }

    public void set(EventableAddress address, long period, TimeUnit periodUnit) {
        this.address_$eq(address);
        this.period_$eq(period);
        this.periodUnit_$eq(periodUnit);
    }

    public TimerTaskManager parent() {
        return this.manager();
    }

    public Timeout timeout() {
        return this.handle();
    }

    public long registerId() {
        return this.id();
    }

    public void setHandle(Timeout timeout) {
        TimeoutTask timeoutTask = this;
        synchronized (timeoutTask) {
            this.handle_$eq(timeout);
        }
    }

    public void update(long period, TimeUnit periodUnit) {
        TimeoutTask timeoutTask = this;
        synchronized (timeoutTask) {
            this.period_$eq(period);
            this.periodUnit_$eq(periodUnit);
        }
    }

    public TimeUnit update$default$2() {
        return TimeUnit.MILLISECONDS;
    }

    @Override
    public void run(Timeout timeout) {
        TimeoutTask timeoutTask = this;
        synchronized (timeoutTask) {
            BoxedUnit boxedUnit;
            this.logger().trace(new StringBuilder(14).append("task[").append(this).append("] timeout").toString());
            this.address().inform(this.newEvent());
            if (this.period() > 0L) {
                InternalTimer timer = timeout.timer();
                Timeout x$proxy1 = timer.newTimeout(this, this.period(), this.periodUnit());
                if (x$proxy1 == null) {
                    throw Scala3RunTime$.MODULE$.nnFail();
                }
                Timeout newTimeout = x$proxy1;
                this.setHandle(newTimeout);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.parent().remove(this.id());
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public abstract TimerEvent newEvent();
}

