/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.timer;

import cc.otavia.core.address.EventableAddress;
import cc.otavia.core.cache.ResourceTimer;
import cc.otavia.core.channel.Channel;
import cc.otavia.core.message.AskTimeoutEvent$;
import cc.otavia.core.message.ChannelTimeoutEvent$;
import cc.otavia.core.message.ResourceTimeoutEvent$;
import cc.otavia.core.message.TimeoutEvent$;
import cc.otavia.core.slf4a.Logger;
import cc.otavia.core.slf4a.Logger$;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.system.monitor.TimerMonitor;
import cc.otavia.core.system.monitor.TimerMonitor$;
import cc.otavia.core.timer.ActorTimeoutTask;
import cc.otavia.core.timer.AskTimeoutTask;
import cc.otavia.core.timer.ChannelTimeoutTask;
import cc.otavia.core.timer.HashedWheelTimer;
import cc.otavia.core.timer.InternalTimer;
import cc.otavia.core.timer.ResourceTimeoutTask;
import cc.otavia.core.timer.TimeoutTask;
import cc.otavia.core.timer.TimeoutTrigger;
import cc.otavia.core.timer.TimeoutTrigger$DelayPeriod$;
import cc.otavia.core.timer.TimeoutTrigger$DelayTime$;
import cc.otavia.core.timer.TimeoutTrigger$FirstTimePeriod$;
import cc.otavia.core.timer.TimeoutTrigger$FixTime$;
import cc.otavia.core.timer.Timer;
import cc.otavia.core.timer.Timer$;
import cc.otavia.core.timer.TimerTaskManager;
import cc.otavia.core.timer.TimerThreadFactory;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import scala.MatchError;
import scala.Option;
import scala.Tuple4;
import scala.Tuple4$;
import scala.runtime.BoxesRunTime;

public final class TimerImpl
implements Timer {
    private final ActorSystem system;
    private final HashedWheelTimer hashedWheelTimer;
    private final TimerTaskManager taskManager;
    private final AtomicLong nextId;
    private final Logger logger;

    public TimerImpl(ActorSystem system) {
        this.system = system;
        this.hashedWheelTimer = new HashedWheelTimer(system, new TimerThreadFactory());
        this.taskManager = new TimerTaskManager(this);
        this.nextId = new AtomicLong(Timer$.MODULE$.INVALID_TIMEOUT_REGISTER_ID() + 1L);
        this.logger = Logger$.MODULE$.getLogger(this.getClass(), system);
    }

    @Override
    public ActorSystem system() {
        return this.system;
    }

    public Logger logger() {
        return this.logger;
    }

    @Override
    public long nextRegisterId() {
        return this.nextId.getAndIncrement();
    }

    @Override
    public void cancelTimerTask(long registerId) {
        this.taskManager.remove(registerId);
    }

    @Override
    public InternalTimer internalTimer() {
        return this.hashedWheelTimer;
    }

    @Override
    public TimerMonitor monitor() {
        return TimerMonitor$.MODULE$.apply(this.taskManager.count());
    }

    @Override
    public long registerActorTimeout(TimeoutTrigger trigger, EventableAddress address, Option<Object> attach) {
        Tuple4 tuple4;
        TimeoutTrigger timeoutTrigger = trigger;
        if (timeoutTrigger instanceof TimeoutTrigger.FixTime) {
            Date date;
            TimeoutTrigger.FixTime fixTime = TimeoutTrigger$FixTime$.MODULE$.unapply((TimeoutTrigger.FixTime)timeoutTrigger);
            Date date2 = date = fixTime._1();
            tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(date2.getTime() - System.currentTimeMillis())), (Object)BoxesRunTime.boxToLong((long)-1L), (Object)TimeUnit.MILLISECONDS, (Object)TimeUnit.MILLISECONDS);
        } else if (timeoutTrigger instanceof TimeoutTrigger.DelayTime) {
            TimeoutTrigger.DelayTime delayTime = TimeoutTrigger$DelayTime$.MODULE$.unapply((TimeoutTrigger.DelayTime)timeoutTrigger);
            long l = delayTime._1();
            TimeUnit timeUnit = delayTime._2();
            long delay = l;
            TimeUnit unit = timeUnit;
            tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)delay), (Object)BoxesRunTime.boxToLong((long)-1L), (Object)unit, (Object)TimeUnit.MILLISECONDS);
        } else if (timeoutTrigger instanceof TimeoutTrigger.DelayPeriod) {
            TimeoutTrigger.DelayPeriod delayPeriod = TimeoutTrigger$DelayPeriod$.MODULE$.unapply((TimeoutTrigger.DelayPeriod)timeoutTrigger);
            long l = delayPeriod._1();
            long l2 = delayPeriod._2();
            TimeUnit timeUnit = delayPeriod._3();
            TimeUnit timeUnit2 = delayPeriod._4();
            long delay = l;
            long period = l2;
            TimeUnit delayUnit = timeUnit;
            TimeUnit periodUnit = timeUnit2;
            tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)delay), (Object)BoxesRunTime.boxToLong((long)period), (Object)delayUnit, (Object)periodUnit);
        } else if (timeoutTrigger instanceof TimeoutTrigger.FirstTimePeriod) {
            TimeoutTrigger.FirstTimePeriod firstTimePeriod = TimeoutTrigger$FirstTimePeriod$.MODULE$.unapply((TimeoutTrigger.FirstTimePeriod)timeoutTrigger);
            Date date = firstTimePeriod._1();
            long l = firstTimePeriod._2();
            TimeUnit timeUnit = firstTimePeriod._3();
            Date first = date;
            long period = l;
            TimeUnit periodUnit = timeUnit;
            long delay = first.getTime() - System.currentTimeMillis();
            tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)delay), (Object)BoxesRunTime.boxToLong((long)period), (Object)TimeUnit.MILLISECONDS, (Object)periodUnit);
        } else {
            throw new MatchError((Object)timeoutTrigger);
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        long delay = BoxesRunTime.unboxToLong((Object)tuple42._1());
        long period = BoxesRunTime.unboxToLong((Object)tuple42._2());
        TimeUnit delayUnit = (TimeUnit)((Object)tuple42._3());
        TimeUnit periodUnit = (TimeUnit)((Object)tuple42._4());
        Tuple4 tuple43 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)delay), (Object)BoxesRunTime.boxToLong((long)period), (Object)delayUnit, (Object)periodUnit);
        long delay2 = BoxesRunTime.unboxToLong((Object)tuple43._1());
        long period2 = BoxesRunTime.unboxToLong((Object)tuple43._2());
        TimeUnit delayUnit2 = (TimeUnit)((Object)tuple43._3());
        TimeUnit periodUnit2 = (TimeUnit)((Object)tuple43._4());
        this.logger().trace(new StringBuilder(48).append("register timeout trigger with delay: ").append(delay2).append(" ").append((Object)delayUnit2).append(" period: ").append(period2).append(" ").append((Object)periodUnit2).toString());
        if (delay2 <= 0L && period2 < 0L) {
            long registerId = this.nextRegisterId();
            address.inform(TimeoutEvent$.MODULE$.apply(registerId, attach));
            return registerId;
        }
        ActorTimeoutTask timerTask = this.taskManager.newActorTimeoutTask(address, period2, attach, periodUnit2);
        return this.handle(timerTask, delay2, period2, delayUnit2, periodUnit2);
    }

    @Override
    public long registerChannelTimeout(TimeoutTrigger trigger, Channel channel) {
        Tuple4 tuple4;
        TimeoutTrigger timeoutTrigger = trigger;
        if (timeoutTrigger instanceof TimeoutTrigger.FixTime) {
            Date date;
            TimeoutTrigger.FixTime fixTime = TimeoutTrigger$FixTime$.MODULE$.unapply((TimeoutTrigger.FixTime)timeoutTrigger);
            Date date2 = date = fixTime._1();
            tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(date2.getTime() - System.currentTimeMillis())), (Object)BoxesRunTime.boxToLong((long)-1L), (Object)TimeUnit.MILLISECONDS, (Object)TimeUnit.MILLISECONDS);
        } else if (timeoutTrigger instanceof TimeoutTrigger.DelayTime) {
            TimeoutTrigger.DelayTime delayTime = TimeoutTrigger$DelayTime$.MODULE$.unapply((TimeoutTrigger.DelayTime)timeoutTrigger);
            long l = delayTime._1();
            TimeUnit timeUnit = delayTime._2();
            long delay = l;
            TimeUnit unit = timeUnit;
            tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)delay), (Object)BoxesRunTime.boxToLong((long)-1L), (Object)unit, (Object)TimeUnit.MILLISECONDS);
        } else if (timeoutTrigger instanceof TimeoutTrigger.DelayPeriod) {
            TimeoutTrigger.DelayPeriod delayPeriod = TimeoutTrigger$DelayPeriod$.MODULE$.unapply((TimeoutTrigger.DelayPeriod)timeoutTrigger);
            long l = delayPeriod._1();
            long l2 = delayPeriod._2();
            TimeUnit timeUnit = delayPeriod._3();
            TimeUnit timeUnit2 = delayPeriod._4();
            long delay = l;
            long period = l2;
            TimeUnit delayUnit = timeUnit;
            TimeUnit periodUnit = timeUnit2;
            tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)delay), (Object)BoxesRunTime.boxToLong((long)period), (Object)delayUnit, (Object)periodUnit);
        } else if (timeoutTrigger instanceof TimeoutTrigger.FirstTimePeriod) {
            TimeoutTrigger.FirstTimePeriod firstTimePeriod = TimeoutTrigger$FirstTimePeriod$.MODULE$.unapply((TimeoutTrigger.FirstTimePeriod)timeoutTrigger);
            Date date = firstTimePeriod._1();
            long l = firstTimePeriod._2();
            TimeUnit timeUnit = firstTimePeriod._3();
            Date first = date;
            long period = l;
            TimeUnit periodUnit = timeUnit;
            long delay = first.getTime() - System.currentTimeMillis();
            tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)delay), (Object)BoxesRunTime.boxToLong((long)period), (Object)TimeUnit.MILLISECONDS, (Object)periodUnit);
        } else {
            throw new MatchError((Object)timeoutTrigger);
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        long delay = BoxesRunTime.unboxToLong((Object)tuple42._1());
        long period = BoxesRunTime.unboxToLong((Object)tuple42._2());
        TimeUnit delayUnit = (TimeUnit)((Object)tuple42._3());
        TimeUnit periodUnit = (TimeUnit)((Object)tuple42._4());
        Tuple4 tuple43 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)delay), (Object)BoxesRunTime.boxToLong((long)period), (Object)delayUnit, (Object)periodUnit);
        long delay2 = BoxesRunTime.unboxToLong((Object)tuple43._1());
        long period2 = BoxesRunTime.unboxToLong((Object)tuple43._2());
        TimeUnit delayUnit2 = (TimeUnit)((Object)tuple43._3());
        TimeUnit periodUnit2 = (TimeUnit)((Object)tuple43._4());
        if (delay2 <= 0L && period2 < 0L) {
            long registerId = this.nextRegisterId();
            channel.executorAddress().inform(ChannelTimeoutEvent$.MODULE$.apply(registerId, channel));
            return registerId;
        }
        ChannelTimeoutTask timerTask = this.taskManager.newChannelTimeoutTask(channel.executorAddress(), period2, channel, periodUnit2);
        return this.handle(timerTask, delay2, period2, delayUnit2, periodUnit2);
    }

    @Override
    public long registerAskTimeout(TimeoutTrigger trigger, EventableAddress sender, long askId) {
        Tuple4 tuple4;
        TimeoutTrigger timeoutTrigger = trigger;
        if (timeoutTrigger instanceof TimeoutTrigger.FixTime) {
            Date date;
            TimeoutTrigger.FixTime fixTime = TimeoutTrigger$FixTime$.MODULE$.unapply((TimeoutTrigger.FixTime)timeoutTrigger);
            Date date2 = date = fixTime._1();
            tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(date2.getTime() - System.currentTimeMillis())), (Object)BoxesRunTime.boxToLong((long)-1L), (Object)TimeUnit.MILLISECONDS, (Object)TimeUnit.MILLISECONDS);
        } else if (timeoutTrigger instanceof TimeoutTrigger.DelayTime) {
            TimeoutTrigger.DelayTime delayTime = TimeoutTrigger$DelayTime$.MODULE$.unapply((TimeoutTrigger.DelayTime)timeoutTrigger);
            long l = delayTime._1();
            TimeUnit timeUnit = delayTime._2();
            long delay = l;
            TimeUnit unit = timeUnit;
            tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)delay), (Object)BoxesRunTime.boxToLong((long)-1L), (Object)unit, (Object)TimeUnit.MILLISECONDS);
        } else if (timeoutTrigger instanceof TimeoutTrigger.DelayPeriod) {
            TimeoutTrigger.DelayPeriod delayPeriod = TimeoutTrigger$DelayPeriod$.MODULE$.unapply((TimeoutTrigger.DelayPeriod)timeoutTrigger);
            long l = delayPeriod._1();
            long l2 = delayPeriod._2();
            TimeUnit timeUnit = delayPeriod._3();
            TimeUnit timeUnit2 = delayPeriod._4();
            long delay = l;
            long period = l2;
            TimeUnit delayUnit = timeUnit;
            TimeUnit periodUnit = timeUnit2;
            tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)delay), (Object)BoxesRunTime.boxToLong((long)period), (Object)delayUnit, (Object)periodUnit);
        } else if (timeoutTrigger instanceof TimeoutTrigger.FirstTimePeriod) {
            TimeoutTrigger.FirstTimePeriod firstTimePeriod = TimeoutTrigger$FirstTimePeriod$.MODULE$.unapply((TimeoutTrigger.FirstTimePeriod)timeoutTrigger);
            Date date = firstTimePeriod._1();
            long l = firstTimePeriod._2();
            TimeUnit timeUnit = firstTimePeriod._3();
            Date first = date;
            long period = l;
            TimeUnit periodUnit = timeUnit;
            long delay = first.getTime() - System.currentTimeMillis();
            tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)delay), (Object)BoxesRunTime.boxToLong((long)period), (Object)TimeUnit.MILLISECONDS, (Object)periodUnit);
        } else {
            throw new MatchError((Object)timeoutTrigger);
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        long delay = BoxesRunTime.unboxToLong((Object)tuple42._1());
        long period = BoxesRunTime.unboxToLong((Object)tuple42._2());
        TimeUnit delayUnit = (TimeUnit)((Object)tuple42._3());
        TimeUnit periodUnit = (TimeUnit)((Object)tuple42._4());
        Tuple4 tuple43 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)delay), (Object)BoxesRunTime.boxToLong((long)period), (Object)delayUnit, (Object)periodUnit);
        long delay2 = BoxesRunTime.unboxToLong((Object)tuple43._1());
        long period2 = BoxesRunTime.unboxToLong((Object)tuple43._2());
        TimeUnit delayUnit2 = (TimeUnit)((Object)tuple43._3());
        TimeUnit periodUnit2 = (TimeUnit)((Object)tuple43._4());
        if (delay2 <= 0L && period2 < 0L) {
            long registerId = this.nextRegisterId();
            sender.inform(AskTimeoutEvent$.MODULE$.apply(registerId, askId));
            return registerId;
        }
        AskTimeoutTask timerTask = this.taskManager.newAskTimeoutTask(sender, period2, askId, periodUnit2);
        return this.handle(timerTask, delay2, period2, delayUnit2, periodUnit2);
    }

    @Override
    public long registerResourceTimeout(TimeoutTrigger trigger, EventableAddress address, ResourceTimer resource) {
        Tuple4 tuple4;
        TimeoutTrigger timeoutTrigger = trigger;
        if (timeoutTrigger instanceof TimeoutTrigger.FixTime) {
            Date date;
            TimeoutTrigger.FixTime fixTime = TimeoutTrigger$FixTime$.MODULE$.unapply((TimeoutTrigger.FixTime)timeoutTrigger);
            Date date2 = date = fixTime._1();
            tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(date2.getTime() - System.currentTimeMillis())), (Object)BoxesRunTime.boxToLong((long)-1L), (Object)TimeUnit.MILLISECONDS, (Object)TimeUnit.MILLISECONDS);
        } else if (timeoutTrigger instanceof TimeoutTrigger.DelayTime) {
            TimeoutTrigger.DelayTime delayTime = TimeoutTrigger$DelayTime$.MODULE$.unapply((TimeoutTrigger.DelayTime)timeoutTrigger);
            long l = delayTime._1();
            TimeUnit timeUnit = delayTime._2();
            long delay = l;
            TimeUnit unit = timeUnit;
            tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)delay), (Object)BoxesRunTime.boxToLong((long)-1L), (Object)unit, (Object)TimeUnit.MILLISECONDS);
        } else if (timeoutTrigger instanceof TimeoutTrigger.DelayPeriod) {
            TimeoutTrigger.DelayPeriod delayPeriod = TimeoutTrigger$DelayPeriod$.MODULE$.unapply((TimeoutTrigger.DelayPeriod)timeoutTrigger);
            long l = delayPeriod._1();
            long l2 = delayPeriod._2();
            TimeUnit timeUnit = delayPeriod._3();
            TimeUnit timeUnit2 = delayPeriod._4();
            long delay = l;
            long period = l2;
            TimeUnit delayUnit = timeUnit;
            TimeUnit periodUnit = timeUnit2;
            tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)delay), (Object)BoxesRunTime.boxToLong((long)period), (Object)delayUnit, (Object)periodUnit);
        } else if (timeoutTrigger instanceof TimeoutTrigger.FirstTimePeriod) {
            TimeoutTrigger.FirstTimePeriod firstTimePeriod = TimeoutTrigger$FirstTimePeriod$.MODULE$.unapply((TimeoutTrigger.FirstTimePeriod)timeoutTrigger);
            Date date = firstTimePeriod._1();
            long l = firstTimePeriod._2();
            TimeUnit timeUnit = firstTimePeriod._3();
            Date first = date;
            long period = l;
            TimeUnit periodUnit = timeUnit;
            long delay = first.getTime() - System.currentTimeMillis();
            tuple4 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)delay), (Object)BoxesRunTime.boxToLong((long)period), (Object)TimeUnit.MILLISECONDS, (Object)periodUnit);
        } else {
            throw new MatchError((Object)timeoutTrigger);
        }
        Tuple4 tuple42 = tuple4;
        if (tuple42 == null) {
            throw new MatchError((Object)tuple42);
        }
        long delay = BoxesRunTime.unboxToLong((Object)tuple42._1());
        long period = BoxesRunTime.unboxToLong((Object)tuple42._2());
        TimeUnit delayUnit = (TimeUnit)((Object)tuple42._3());
        TimeUnit periodUnit = (TimeUnit)((Object)tuple42._4());
        Tuple4 tuple43 = Tuple4$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)delay), (Object)BoxesRunTime.boxToLong((long)period), (Object)delayUnit, (Object)periodUnit);
        long delay2 = BoxesRunTime.unboxToLong((Object)tuple43._1());
        long period2 = BoxesRunTime.unboxToLong((Object)tuple43._2());
        TimeUnit delayUnit2 = (TimeUnit)((Object)tuple43._3());
        TimeUnit periodUnit2 = (TimeUnit)((Object)tuple43._4());
        if (delay2 <= 0L && period2 < 0L) {
            long registerId = this.nextRegisterId();
            address.inform(ResourceTimeoutEvent$.MODULE$.apply(registerId, resource));
            return registerId;
        }
        ResourceTimeoutTask timerTask = this.taskManager.newResourceTimeoutTask(address, period2, resource, periodUnit2);
        return this.handle(timerTask, delay2, period2, delayUnit2, periodUnit2);
    }

    private long handle(TimeoutTask timerTask, long delay, long period, TimeUnit delayUnit, TimeUnit periodUnit) {
        if (delay <= 0L && period > 0L) {
            timerTask.setHandle(this.hashedWheelTimer.newTimeout(timerTask, 0L, periodUnit));
        } else {
            timerTask.setHandle(this.hashedWheelTimer.newTimeout(timerTask, delay, delayUnit));
        }
        return timerTask.registerId();
    }

    @Override
    public void updateTimerTask(TimeoutTrigger trigger, long registerId) {
        this.taskManager.update(trigger, registerId);
    }
}

