/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.timer;

import cc.otavia.core.address.EventableAddress;
import cc.otavia.core.cache.ResourceTimer;
import cc.otavia.core.channel.Channel;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.timer.ActorTimeoutTask;
import cc.otavia.core.timer.AskTimeoutTask;
import cc.otavia.core.timer.ChannelTimeoutTask;
import cc.otavia.core.timer.InternalTimer;
import cc.otavia.core.timer.ResourceTimeoutTask;
import cc.otavia.core.timer.Timeout;
import cc.otavia.core.timer.TimeoutTask;
import cc.otavia.core.timer.TimeoutTrigger;
import cc.otavia.core.timer.TimeoutTrigger$DelayPeriod$;
import cc.otavia.core.timer.TimeoutTrigger$DelayTime$;
import cc.otavia.core.timer.TimeoutTrigger$FirstTimePeriod$;
import cc.otavia.core.timer.TimeoutTrigger$FixTime$;
import cc.otavia.core.timer.Timer;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;

public class TimerTaskManager {
    private final Timer timer;
    private final ConcurrentHashMap<Object, TimeoutTask> registeredTasks;

    public TimerTaskManager(Timer timer) {
        this.timer = timer;
        this.registeredTasks = new ConcurrentHashMap();
    }

    public Timer timer() {
        return this.timer;
    }

    public final ActorSystem system() {
        return this.timer().system();
    }

    public int count() {
        return this.registeredTasks.size();
    }

    public ActorTimeoutTask newActorTimeoutTask(EventableAddress address, long period, Option<Object> attach, TimeUnit periodUnit) {
        ActorTimeoutTask timerTask = new ActorTimeoutTask(this);
        timerTask.setAttach(attach);
        timerTask.set(address, period, periodUnit);
        this.registeredTasks.put(BoxesRunTime.boxToLong((long)timerTask.registerId()), timerTask);
        return timerTask;
    }

    public TimeUnit newActorTimeoutTask$default$4() {
        return TimeUnit.MILLISECONDS;
    }

    public AskTimeoutTask newAskTimeoutTask(EventableAddress address, long period, long askId, TimeUnit periodUnit) {
        AskTimeoutTask timerTask = new AskTimeoutTask(this);
        timerTask.setAskId(askId);
        timerTask.set(address, period, periodUnit);
        this.registeredTasks.put(BoxesRunTime.boxToLong((long)timerTask.registerId()), timerTask);
        return timerTask;
    }

    public TimeUnit newAskTimeoutTask$default$4() {
        return TimeUnit.MILLISECONDS;
    }

    public ChannelTimeoutTask newChannelTimeoutTask(EventableAddress address, long period, Channel channel, TimeUnit periodUnit) {
        ChannelTimeoutTask timerTask = new ChannelTimeoutTask(this);
        timerTask.setChannel(channel);
        timerTask.set(address, period, periodUnit);
        this.registeredTasks.put(BoxesRunTime.boxToLong((long)timerTask.registerId()), timerTask);
        return timerTask;
    }

    public TimeUnit newChannelTimeoutTask$default$4() {
        return TimeUnit.MILLISECONDS;
    }

    public ResourceTimeoutTask newResourceTimeoutTask(EventableAddress address, long period, ResourceTimer resourceTimer, TimeUnit periodUnit) {
        ResourceTimeoutTask timerTask = new ResourceTimeoutTask(this);
        timerTask.setResourceTimer(resourceTimer);
        timerTask.set(address, period, periodUnit);
        this.registeredTasks.put(BoxesRunTime.boxToLong((long)timerTask.registerId()), timerTask);
        return timerTask;
    }

    public TimeUnit newResourceTimeoutTask$default$4() {
        return TimeUnit.MILLISECONDS;
    }

    public void remove(long id) {
        TimeoutTask timeoutTask = this.registeredTasks.remove(BoxesRunTime.boxToLong((long)id));
        if (timeoutTask == null) {
            return;
        }
        if (timeoutTask != null) {
            TimeoutTask timerTask = timeoutTask;
            timerTask.timeout().cancel();
            return;
        }
        throw new MatchError((Object)timeoutTask);
    }

    public void update(TimeoutTrigger trigger, long registerId) {
        TimeoutTask timeoutTask = this.registeredTasks.remove(BoxesRunTime.boxToLong((long)registerId));
        if (timeoutTask != null) {
            TimeoutTask task = timeoutTask;
            InternalTimer nettyTimer = task.timeout().timer();
            task.timeout().cancel();
            this.registeredTasks.put(BoxesRunTime.boxToLong((long)registerId), task);
            TimeoutTrigger timeoutTrigger = trigger;
            if (timeoutTrigger instanceof TimeoutTrigger.FixTime) {
                Date date;
                TimeoutTrigger.FixTime fixTime = TimeoutTrigger$FixTime$.MODULE$.unapply((TimeoutTrigger.FixTime)timeoutTrigger);
                Date date2 = date = fixTime._1();
                this.updateTimeoutTrigger(nettyTimer, task, date2.getTime() - System.currentTimeMillis(), this.updateTimeoutTrigger$default$4(), this.updateTimeoutTrigger$default$5(), this.updateTimeoutTrigger$default$6());
                return;
            }
            if (timeoutTrigger instanceof TimeoutTrigger.DelayTime) {
                TimeoutTrigger.DelayTime delayTime = TimeoutTrigger$DelayTime$.MODULE$.unapply((TimeoutTrigger.DelayTime)timeoutTrigger);
                long l = delayTime._1();
                TimeUnit timeUnit = delayTime._2();
                long delay = l;
                TimeUnit unit = timeUnit;
                this.updateTimeoutTrigger(nettyTimer, task, delay, this.updateTimeoutTrigger$default$4(), unit, this.updateTimeoutTrigger$default$6());
                return;
            }
            if (timeoutTrigger instanceof TimeoutTrigger.DelayPeriod) {
                TimeoutTrigger.DelayPeriod delayPeriod = TimeoutTrigger$DelayPeriod$.MODULE$.unapply((TimeoutTrigger.DelayPeriod)timeoutTrigger);
                long l = delayPeriod._1();
                long l2 = delayPeriod._2();
                TimeUnit timeUnit = delayPeriod._3();
                TimeUnit timeUnit2 = delayPeriod._4();
                long delay = l;
                long period = l2;
                TimeUnit delayUnit = timeUnit;
                TimeUnit periodUnit = timeUnit2;
                this.updateTimeoutTrigger(nettyTimer, task, delay, period, delayUnit, periodUnit);
                return;
            }
            if (timeoutTrigger instanceof TimeoutTrigger.FirstTimePeriod) {
                TimeoutTrigger.FirstTimePeriod firstTimePeriod = TimeoutTrigger$FirstTimePeriod$.MODULE$.unapply((TimeoutTrigger.FirstTimePeriod)timeoutTrigger);
                Date date = firstTimePeriod._1();
                long l = firstTimePeriod._2();
                TimeUnit timeUnit = firstTimePeriod._3();
                Date first = date;
                long period = l;
                TimeUnit unit = timeUnit;
                long delay = first.getTime() - System.currentTimeMillis();
                this.updateTimeoutTrigger(nettyTimer, task, delay, period, this.updateTimeoutTrigger$default$5(), unit);
                return;
            }
            throw new MatchError((Object)timeoutTrigger);
        }
        Predef$.MODULE$.println((Object)new StringBuilder(58).append("Timer task register id ").append(registerId).append(" is not registered in system timer.").toString());
    }

    private void updateTimeoutTrigger(InternalTimer nettyTimer, TimeoutTask task, long delay, long period, TimeUnit delayUnit, TimeUnit periodUnit) {
        task.update(period, periodUnit);
        Timeout x$proxy1 = nettyTimer.newTimeout(task, delay < 0L ? 0L : delay, delayUnit);
        if (x$proxy1 == null) {
            throw Scala3RunTime$.MODULE$.nnFail();
        }
        Timeout handle = x$proxy1;
        task.setHandle(handle);
    }

    private long updateTimeoutTrigger$default$4() {
        return -1L;
    }

    private TimeUnit updateTimeoutTrigger$default$5() {
        return TimeUnit.MILLISECONDS;
    }

    private TimeUnit updateTimeoutTrigger$default$6() {
        return TimeUnit.MILLISECONDS;
    }
}

