/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.transport;

import cc.otavia.common.Report$;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.transport.TransportFactory;
import cc.otavia.core.transport.nio.NIOTransportServiceProvider;
import cc.otavia.core.transport.spi.TransportServiceProvider;
import java.io.Serializable;
import java.util.ServiceLoader;
import scala.Function1;
import scala.MatchError;
import scala.collection.mutable.ArrayBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;

public final class TransportFactory$
implements Serializable {
    private static final int UNINITIALIZED;
    private static final int ONGOING_INITIALIZATION;
    private static final int FAILED_INITIALIZATION;
    private static final int SUCCESSFUL_INITIALIZATION;
    private static final int NOP_FALLBACK_INITIALIZATION;
    private static volatile int INITIALIZATION_STATE;
    private static volatile TransportServiceProvider PROVIDER;
    private static final NIOTransportServiceProvider NIO_SERVICE_PROVIDER;
    public static final TransportFactory$ MODULE$;

    private TransportFactory$() {
    }

    static {
        MODULE$ = new TransportFactory$();
        UNINITIALIZED = 0;
        ONGOING_INITIALIZATION = 1;
        FAILED_INITIALIZATION = 2;
        SUCCESSFUL_INITIALIZATION = 3;
        NOP_FALLBACK_INITIALIZATION = 4;
        INITIALIZATION_STATE = UNINITIALIZED;
        NIO_SERVICE_PROVIDER = new NIOTransportServiceProvider();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(TransportFactory$.class);
    }

    public TransportFactory getTransportFactory(ActorSystem system) {
        TransportServiceProvider provider = this.getProvider(system);
        return provider.getTransportFactory();
    }

    private TransportServiceProvider getProvider(ActorSystem system) {
        TransportServiceProvider transportServiceProvider;
        TransportFactory$ transportFactory$ = this;
        synchronized (transportFactory$) {
            TransportServiceProvider transportServiceProvider2;
            int n;
            if (INITIALIZATION_STATE == UNINITIALIZED) {
                INITIALIZATION_STATE = ONGOING_INITIALIZATION;
                this.bind(system);
            }
            if (SUCCESSFUL_INITIALIZATION == (n = INITIALIZATION_STATE)) {
                transportServiceProvider2 = PROVIDER;
            } else if (NOP_FALLBACK_INITIALIZATION == n) {
                NIO_SERVICE_PROVIDER.initialize(system);
                transportServiceProvider2 = NIO_SERVICE_PROVIDER;
            } else {
                if (FAILED_INITIALIZATION == n) {
                    throw new IllegalStateException();
                }
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            transportServiceProvider = transportServiceProvider2;
        }
        return transportServiceProvider;
    }

    private final void bind(ActorSystem system) {
        try {
            ArrayBuffer<TransportServiceProvider> providerList = this.findServiceProviders();
            if (providerList.length() > 1) {
                Report$.MODULE$.report("Class path contains multiple Transport providers.", "TRANSPORT");
                providerList.foreach((Function1)(JProcedure1 & Serializable)provider -> Report$.MODULE$.report(new StringBuilder(18).append("Found provider [").append(provider).append("].").toString(), "TRANSPORT"));
            }
            if (providerList.nonEmpty()) {
                PROVIDER = (TransportServiceProvider)providerList.head();
                PROVIDER.initialize(system);
                INITIALIZATION_STATE = SUCCESSFUL_INITIALIZATION;
                Report$.MODULE$.report(new StringBuilder(29).append("Actual provider is of type [").append(providerList.head()).append("]").toString(), "TRANSPORT");
            } else {
                INITIALIZATION_STATE = NOP_FALLBACK_INITIALIZATION;
                Report$.MODULE$.report("No Transport providers were found.", "TRANSPORT");
                Report$.MODULE$.report("Defaulting to JDK NIO transport implementation.", "TRANSPORT");
            }
        }
        catch (Exception e) {
            INITIALIZATION_STATE = FAILED_INITIALIZATION;
            Report$.MODULE$.report("Failed to instantiate transport TransportFactory", (Throwable)e);
            throw new IllegalStateException("Unexpected initialization failure", e);
        }
    }

    private final ArrayBuffer<TransportServiceProvider> findServiceProviders() {
        ClassLoader classLoaderOfLoggerFactory = this.getClass().getClassLoader();
        ServiceLoader<TransportServiceProvider> serviceLoader = this.getServiceLoader(classLoaderOfLoggerFactory);
        ArrayBuffer providerList = new ArrayBuffer();
        for (TransportServiceProvider provider : serviceLoader) {
            if (provider.checkPlatformSupport()) {
                providerList.addOne((Object)provider);
                continue;
            }
            Report$.MODULE$.report(new StringBuilder(52).append("Transport ").append(provider).append(" is not support current platform, ignored!").toString(), "TRANSPORT");
        }
        return providerList;
    }

    private ServiceLoader<TransportServiceProvider> getServiceLoader(ClassLoader classLoaderOfLoggerFactory) {
        return ServiceLoader.load(TransportServiceProvider.class, classLoaderOfLoggerFactory);
    }
}

