/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.transport.nio;

import cc.otavia.core.channel.Channel;
import cc.otavia.core.channel.ChannelException;
import cc.otavia.core.reactor.Reactor;
import cc.otavia.core.slf4a.Logger;
import cc.otavia.core.slf4a.Logger$;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.transport.TransportFactory;
import cc.otavia.core.transport.nio.channel.NioDatagramChannel;
import cc.otavia.core.transport.nio.channel.NioFileChannel;
import cc.otavia.core.transport.nio.channel.NioServerSocketChannel;
import cc.otavia.core.transport.nio.channel.NioSocketChannel;
import cc.otavia.core.transport.nio.channel.NioUnsafeDatagramChannel;
import cc.otavia.core.transport.nio.channel.NioUnsafeFileChannel;
import cc.otavia.core.transport.nio.channel.NioUnsafeServerSocketChannel;
import cc.otavia.core.transport.nio.channel.NioUnsafeSocketChannel;
import cc.otavia.core.transport.reactor.nio.NioReactor;
import cc.otavia.core.transport.reactor.nio.NioReactor$;
import java.io.IOException;
import java.net.ProtocolFamily;
import java.net.StandardProtocolFamily;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;

public class NIOTransportFactory
extends TransportFactory {
    private final ActorSystem system;
    private final SelectorProvider selectorProvider;
    private Reactor reactor;
    private final Logger logger;

    public NIOTransportFactory(ActorSystem system) {
        this.system = system;
        this.selectorProvider = SelectorProvider.provider();
        this.logger = Logger$.MODULE$.getLogger(this.getClass(), system);
    }

    public ActorSystem system() {
        return this.system;
    }

    private void initialJdkChannel(SelectableChannel ch) {
        try {
            ch.configureBlocking(false);
        }
        catch (IOException e) {
            try {
                ch.close();
            }
            catch (IOException e2) {
                this.logger.warn("Failed to close a partially initialized socket.", e2);
            }
            throw new ChannelException("Failed to enter non-blocking mode.", e);
        }
    }

    @Override
    public Channel createServerSocketChannel() {
        StandardProtocolFamily family = null;
        ServerSocketChannel ch = null;
        try {
            family = StandardProtocolFamily.INET6;
            ch = this.selectorProvider.openServerSocketChannel(family);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            family = StandardProtocolFamily.INET;
            ch = this.selectorProvider.openServerSocketChannel(family);
        }
        this.initialJdkChannel(ch);
        return this.createServerChannel0(ch);
    }

    @Override
    public Channel createServerSocketChannel(ProtocolFamily family) {
        ServerSocketChannel ch = this.selectorProvider.openServerSocketChannel(family);
        this.initialJdkChannel(ch);
        return this.createServerChannel0(ch);
    }

    private Channel createServerChannel0(ServerSocketChannel ch) {
        NioServerSocketChannel channel = new NioServerSocketChannel(this.system());
        NioUnsafeServerSocketChannel unsafe = new NioUnsafeServerSocketChannel((Channel)channel, ch, 16);
        channel.setUnsafeChannel(unsafe);
        return channel;
    }

    @Override
    public Channel createSocketChannel() {
        StandardProtocolFamily family = null;
        SocketChannel ch = null;
        try {
            family = StandardProtocolFamily.INET6;
            ch = this.selectorProvider.openSocketChannel(family);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            family = StandardProtocolFamily.INET;
            ch = this.selectorProvider.openSocketChannel(family);
        }
        this.initialJdkChannel(ch);
        return this.createSocketChannel0(ch);
    }

    @Override
    public Channel createSocketChannel(ProtocolFamily family) {
        SocketChannel ch = this.selectorProvider.openSocketChannel(family);
        this.initialJdkChannel(ch);
        return this.createSocketChannel0(ch);
    }

    private Channel createSocketChannel0(SocketChannel ch) {
        NioSocketChannel channel = new NioSocketChannel(this.system());
        NioUnsafeSocketChannel unsafe = new NioUnsafeSocketChannel((Channel)channel, ch, 1);
        channel.setUnsafeChannel(unsafe);
        return channel;
    }

    @Override
    public Channel createDatagramChannel() {
        StandardProtocolFamily family = null;
        DatagramChannel ch = null;
        try {
            family = StandardProtocolFamily.INET6;
            ch = this.selectorProvider.openDatagramChannel(family);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            family = StandardProtocolFamily.INET;
            ch = this.selectorProvider.openDatagramChannel(family);
        }
        this.initialJdkChannel(ch);
        return this.createDatagramChannel0(ch);
    }

    @Override
    public Channel createDatagramChannel(ProtocolFamily family) {
        DatagramChannel ch = this.selectorProvider.openDatagramChannel(family);
        this.initialJdkChannel(ch);
        return this.createDatagramChannel0(ch);
    }

    private Channel createDatagramChannel0(DatagramChannel ch) {
        NioDatagramChannel channel = new NioDatagramChannel(this.system());
        NioUnsafeDatagramChannel unsafe = new NioUnsafeDatagramChannel((Channel)channel, ch, 1);
        channel.setUnsafeChannel(unsafe);
        return channel;
    }

    @Override
    public Channel createFileChannel() {
        NioFileChannel channel = new NioFileChannel(this.system());
        NioUnsafeFileChannel unsafe = new NioUnsafeFileChannel(channel);
        channel.setUnsafeChannel(unsafe);
        return channel;
    }

    @Override
    public Reactor openReactor(ActorSystem system) {
        if (this.reactor != null) {
            return this.reactor;
        }
        this.reactor = new NioReactor(system, this, NioReactor$.MODULE$.$lessinit$greater$default$3());
        return this.reactor;
    }
}

