/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.transport.nio.channel;

import cc.otavia.core.channel.AbstractUnsafeChannel;
import cc.otavia.core.channel.Channel;
import cc.otavia.core.channel.ChannelShutdownDirection$;
import cc.otavia.core.channel.message.AutoReadPlan$;
import cc.otavia.core.channel.message.ReadPlan;
import cc.otavia.core.message.ReactorEvent$ChannelClose$;
import cc.otavia.core.message.ReactorEvent$DeregisterReply$;
import cc.otavia.core.message.ReactorEvent$OpenReply$;
import cc.otavia.core.message.ReactorEvent$ReadCompletedEvent$;
import cc.otavia.core.transport.nio.channel.NioUnsafeChannel;
import cc.otavia.core.transport.nio.channel.NioUnsafeServerSocketChannel;
import java.io.IOException;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.Seq;

public abstract class AbstractNioUnsafeChannel<C extends SelectableChannel>
extends AbstractUnsafeChannel
implements NioUnsafeChannel {
    private final SelectableChannel ch;
    private final int readInterestOp;
    private SelectionKey _selectionKey;

    public AbstractNioUnsafeChannel(Channel channel, C ch, int readInterestOp) {
        this.ch = ch;
        this.readInterestOp = readInterestOp;
        super(channel);
    }

    private Channel channel$accessor() {
        return super.channel();
    }

    public C ch() {
        return (C)this.ch;
    }

    public int readInterestOp() {
        return this.readInterestOp;
    }

    public SelectionKey _selectionKey() {
        return this._selectionKey;
    }

    public void _selectionKey_$eq(SelectionKey x$1) {
        this._selectionKey = x$1;
    }

    public C javaChannel() {
        return this.ch();
    }

    public abstract SocketAddress localAddress();

    @Override
    public void registerSelector(Selector selector) {
        int interestOps = 0;
        if (this._selectionKey() != null) {
            interestOps = this._selectionKey().interestOps();
            this._selectionKey().cancel();
        }
        this._selectionKey_$eq(((SelectableChannel)this.ch()).register(selector, interestOps, this));
    }

    @Override
    public void deregisterSelector() {
        if (this._selectionKey() != null) {
            try {
                this._selectionKey().cancel();
                this._selectionKey_$eq(null);
                this.executorAddress().inform(ReactorEvent$DeregisterReply$.MODULE$.apply(this.channel$accessor(), false, this.isOpen(), ReactorEvent$DeregisterReply$.MODULE$.$lessinit$greater$default$4()));
            }
            catch (Throwable e) {
                this.executorAddress().inform(ReactorEvent$DeregisterReply$.MODULE$.apply(this.channel$accessor(), false, this.isOpen(), (Option<Throwable>)Some$.MODULE$.apply((Object)e)));
            }
            return;
        }
        this.executorAddress().inform(ReactorEvent$DeregisterReply$.MODULE$.apply(this.channel$accessor(), false, this.isOpen(), (Option<Throwable>)Some$.MODULE$.apply((Object)new IllegalStateException())));
    }

    @Override
    public void handle(SelectionKey key) {
        if (!key.isValid()) {
            this.unsafeClose((Option<Throwable>)None$.MODULE$);
            return;
        }
        try {
            int readOps = key.readyOps();
            if ((readOps & 8) != 0) {
                int ops = key.interestOps();
                key.interestOps(ops &= 0xFFFFFFF7);
                this.finishConnect();
            }
            if ((readOps & 4) != 0) {
                this.unsafeFlush(null);
            }
            if ((readOps & 0x11) != 0 || readOps == 0) {
                this.readNow();
            }
        }
        catch (CancelledKeyException ignored) {
            this.unsafeClose((Option<Throwable>)Some$.MODULE$.apply((Object)ignored));
        }
    }

    @Override
    public void closeProcessor() {
        this.executorAddress().inform(ReactorEvent$ChannelClose$.MODULE$.apply(this.channel$accessor(), ReactorEvent$ChannelClose$.MODULE$.$lessinit$greater$default$2()));
    }

    @Override
    public void unsafeRead(ReadPlan readPlan) {
        if (this._selectionKey().isValid()) {
            ReadPlan readPlan2 = readPlan;
            AutoReadPlan$ autoReadPlan$ = AutoReadPlan$.MODULE$;
            if (!(readPlan2 != null ? !readPlan2.equals(autoReadPlan$) : autoReadPlan$ != null)) {
                this.setAutoRead(true);
                this.currentReadPlan_$eq(this.readPlanFactory().newPlan(this.channel$accessor()));
            } else {
                this.currentReadPlan_$eq(readPlan);
            }
            int ops = this._selectionKey().interestOps();
            if ((ops & this.readInterestOp()) == 0) {
                this._selectionKey().interestOps(ops | this.readInterestOp());
                return;
            }
            return;
        }
    }

    @Override
    public void unsafeOpen(Path path, Seq<OpenOption> options, Seq<FileAttribute<?>> attrs) {
        this.channel$accessor().executorAddress().inform(ReactorEvent$OpenReply$.MODULE$.apply(this.channel$accessor(), (Option<Throwable>)Some$.MODULE$.apply((Object)new UnsupportedOperationException())));
    }

    @Override
    public void unsafeClose(Option<Throwable> cause) {
        try {
            this._selectionKey_$eq(null);
            ((AbstractInterruptibleChannel)this.ch()).close();
            this.executorAddress().inform(ReactorEvent$ChannelClose$.MODULE$.apply(this.channel$accessor(), cause));
        }
        catch (Throwable t) {
            this.executorAddress().inform(ReactorEvent$ChannelClose$.MODULE$.apply(this.channel$accessor(), (Option<Throwable>)Some$.MODULE$.apply((Object)t)));
        }
    }

    public void finishConnect() {
    }

    private void readNow() {
        if (this.isShutdown(ChannelShutdownDirection$.Inbound) && (this.inputClosedSeenErrorOnRead() || !this.isAllowHalfClosure())) {
            this.clearScheduledRead();
            return;
        }
        this.readLoop();
    }

    @Override
    public void doClearScheduledRead() {
        SelectionKey key = this._selectionKey();
        if (key == null || !key.isValid()) {
            return;
        }
        int interestOps = key.interestOps();
        if ((interestOps & this.readInterestOp()) != 0) {
            key.interestOps(interestOps & ~this.readInterestOp());
            return;
        }
    }

    private void readLoop() {
        boolean closed = false;
        try {
            do {
                try {
                    closed = this.doReadNow();
                }
                catch (Throwable cause) {
                    Throwable throwable = cause;
                    if (throwable instanceof PortUnreachableException) {
                        this.shutdownReadSide();
                        continue;
                    }
                    if (throwable instanceof IOException && !(this instanceof NioUnsafeServerSocketChannel)) {
                        this.unsafeClose((Option<Throwable>)Some$.MODULE$.apply((Object)cause));
                        continue;
                    }
                    throw new MatchError((Object)throwable);
                }
            } while (this.currentReadPlan().continueReading() && !closed && !this.isShutdown(ChannelShutdownDirection$.Inbound));
            this.completed();
        }
        finally {
            if (!this.autoRead()) {
                this.clearScheduledRead();
            }
        }
        if (closed) {
            this.shutdownReadSide();
            return;
        }
    }

    private void completed() {
        this.currentReadPlan().readComplete();
        this.executorAddress().inform(ReactorEvent$ReadCompletedEvent$.MODULE$.apply(this.channel$accessor(), ReactorEvent$ReadCompletedEvent$.MODULE$.$lessinit$greater$default$2()));
    }

    public void processRead(int attemptedBytesRead, int actualBytesRead, int numMessagesRead) {
        this.currentReadPlan().lastRead(attemptedBytesRead, actualBytesRead, numMessagesRead);
    }

    public abstract boolean doReadNow();

    public void shutdownReadSide() {
        if (!this.isShutdown(ChannelShutdownDirection$.Inbound)) {
            if (this.isAllowHalfClosure()) {
                this.unsafeShutdown(ChannelShutdownDirection$.Inbound);
                return;
            }
            this.unsafeClose((Option<Throwable>)None$.MODULE$);
            return;
        }
        this.inputClosedSeenErrorOnRead_$eq(true);
    }
}

