/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.transport.nio.channel;

import cc.otavia.core.channel.AbstractDatagramChannel;
import cc.otavia.core.channel.ChannelOption;
import cc.otavia.core.channel.ChannelOption$;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.transport.nio.channel.NioChannelOption$;
import cc.otavia.core.transport.nio.channel.NioUnsafeDatagramChannel;
import cc.otavia.internal.Platform$;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.DatagramChannel;
import java.nio.channels.NetworkChannel;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.runtime.BoxesRunTime;

public class NioDatagramChannel
extends AbstractDatagramChannel {
    private boolean activeOnOpen = false;

    public NioDatagramChannel(ActorSystem system) {
        super(system);
    }

    private ActorSystem system$accessor() {
        return super.system();
    }

    @Override
    public NioUnsafeDatagramChannel unsafeChannel() {
        return (NioUnsafeDatagramChannel)super.unsafeChannel();
    }

    @Override
    public Option<SocketAddress> localAddress() {
        return Some$.MODULE$.apply((Object)this.unsafeChannel().localAddress());
    }

    @Override
    public Option<SocketAddress> remoteAddress() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public final <T> T getTransportExtendedOption(ChannelOption<T> option) {
        ChannelOption<T> channelOption = option;
        ChannelOption<Object> channelOption2 = ChannelOption$.MODULE$.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION();
        if (!(channelOption != null ? !channelOption.equals(channelOption2) : channelOption2 != null)) {
            return (T)BoxesRunTime.boxToBoolean((boolean)this.activeOnOpen);
        }
        SocketOption socketOption = NioChannelOption$.MODULE$.toSocketOption(option);
        if (socketOption != null) {
            return (T)NioChannelOption$.MODULE$.getOption((NetworkChannel)this.unsafeChannel().ch(), socketOption).getOrElse(() -> this.getTransportExtendedOption$$anonfun$1(option));
        }
        return super.getTransportExtendedOption(option);
    }

    @Override
    public final <T> void setTransportExtendedOption(ChannelOption<T> option, T value) {
        ChannelOption<T> channelOption = option;
        ChannelOption<Object> channelOption2 = ChannelOption$.MODULE$.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION();
        if (!(channelOption != null ? !channelOption.equals(channelOption2) : channelOption2 != null)) {
            this.activeOnOpen = BoxesRunTime.unboxToBoolean(value);
            return;
        }
        SocketOption socketOption = NioChannelOption$.MODULE$.toSocketOption(option);
        if (socketOption != null) {
            SocketOption socketOption2 = socketOption;
            SocketOption<Boolean> socketOption3 = StandardSocketOptions.SO_BROADCAST;
            if (!(socketOption2 != null ? !socketOption2.equals(socketOption3) : socketOption3 != null)) {
                if (!(this.isAnyLocalAddress() || Platform$.MODULE$.isWindows() || Platform$.MODULE$.maybeSuperUser())) {
                    this.logger().warn(new StringBuilder(192).append("A non-root user can't receive a broadcast packet if the socket is not bound to a wildcard address; setting the SO_BROADCAST flag anyway as requested on the socket which is bound to ").append(((DatagramChannel)this.unsafeChannel().ch()).getLocalAddress()).append('.').toString());
                }
            }
            Platform$.MODULE$.maybeSuperUser();
            NioChannelOption$.MODULE$.setOption((NetworkChannel)this.unsafeChannel().ch(), socketOption, value);
            return;
        }
        super.setTransportExtendedOption(option, value);
    }

    private boolean isAnyLocalAddress() {
        SocketAddress address = ((DatagramChannel)this.unsafeChannel().ch()).getLocalAddress();
        SocketAddress socketAddress = address;
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress address2 = (InetSocketAddress)socketAddress;
            return address2.getAddress().isAnyLocalAddress();
        }
        return false;
    }

    @Override
    public boolean isTransportExtendedOptionSupported(ChannelOption<?> option) {
        ChannelOption<?> channelOption = option;
        ChannelOption<Object> channelOption2 = ChannelOption$.MODULE$.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION();
        if (!(channelOption != null ? !channelOption.equals(channelOption2) : channelOption2 != null)) {
            return true;
        }
        SocketOption socketOption = NioChannelOption$.MODULE$.toSocketOption(option);
        if (socketOption != null) {
            return NioChannelOption$.MODULE$.isOptionSupported((NetworkChannel)this.unsafeChannel().ch(), socketOption);
        }
        return super.isTransportExtendedOptionSupported(option);
    }

    private final Object getTransportExtendedOption$$anonfun$1(ChannelOption option$1) {
        return super.getTransportExtendedOption(option$1);
    }
}

