/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.transport.nio.channel;

import cc.otavia.buffer.Buffer;
import cc.otavia.buffer.pool.RecyclablePageBuffer;
import cc.otavia.core.channel.Channel;
import cc.otavia.core.channel.ChannelShutdownDirection;
import cc.otavia.core.channel.ChannelShutdownDirection$;
import cc.otavia.core.channel.FileRegion;
import cc.otavia.core.channel.message.ReadPlan;
import cc.otavia.core.message.ReactorEvent$ConnectReply$;
import cc.otavia.core.message.ReactorEvent$DisconnectReply$;
import cc.otavia.core.message.ReactorEvent$ReadBuffer$;
import cc.otavia.core.message.ReactorEvent$ShutdownReply$;
import cc.otavia.core.transport.nio.channel.AbstractNioUnsafeChannel;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;

public class NioUnsafeDatagramChannel
extends AbstractNioUnsafeChannel<DatagramChannel> {
    public NioUnsafeDatagramChannel(Channel channel2, DatagramChannel ch, int readInterestOp) {
        super(channel2, ch, readInterestOp);
        this.setReadPlanFactory(channel -> new NioDatagramChannelReadPlan());
    }

    private Channel channel$accessor() {
        return super.channel();
    }

    private DatagramChannel ch$accessor() {
        return (DatagramChannel)super.ch();
    }

    private int readInterestOp$accessor() {
        return super.readInterestOp();
    }

    @Override
    public SocketAddress localAddress() {
        SocketAddress socketAddress;
        try {
            socketAddress = ((DatagramChannel)this.javaChannel()).getLocalAddress();
        }
        catch (IOException e) {
            socketAddress = null;
        }
        return socketAddress;
    }

    @Override
    public void unsafeBind(SocketAddress local) {
        ((DatagramChannel)this.javaChannel()).bind(local);
        this.bound_$eq(true);
    }

    @Override
    public void unsafeConnect(SocketAddress remote, Option<SocketAddress> local, boolean fastOpen) {
        Option<SocketAddress> option = local;
        if (!None$.MODULE$.equals(option)) {
            if (option instanceof Some) {
                SocketAddress value = (SocketAddress)((Some)option).value();
                this.unsafeBind(value);
            } else {
                throw new MatchError(option);
            }
        }
        try {
            ((DatagramChannel)this.javaChannel()).connect(remote);
            this.bound_$eq(true);
            this.executorAddress().inform(ReactorEvent$ConnectReply$.MODULE$.apply(this.channel$accessor(), true, ReactorEvent$ConnectReply$.MODULE$.$lessinit$greater$default$3()));
        }
        catch (Throwable t) {
            Some some = Some$.MODULE$.apply((Object)t);
            boolean bl = ReactorEvent$ConnectReply$.MODULE$.$lessinit$greater$default$2();
            this.executorAddress().inform(ReactorEvent$ConnectReply$.MODULE$.apply(this.channel$accessor(), bl, (Option<Throwable>)some));
        }
    }

    @Override
    public void unsafeDisconnect() {
        this.ch$accessor().disconnect();
        this.channel$accessor().executorAddress().inform(ReactorEvent$DisconnectReply$.MODULE$.apply(this.channel$accessor(), ReactorEvent$DisconnectReply$.MODULE$.$lessinit$greater$default$2()));
    }

    @Override
    public void unsafeShutdown(ChannelShutdownDirection direction) {
        ChannelShutdownDirection channelShutdownDirection = direction;
        ChannelShutdownDirection channelShutdownDirection2 = ChannelShutdownDirection$.Inbound;
        ChannelShutdownDirection channelShutdownDirection3 = channelShutdownDirection;
        if (!(channelShutdownDirection2 != null ? !channelShutdownDirection2.equals(channelShutdownDirection3) : channelShutdownDirection3 != null)) {
            this.shutdownedInbound_$eq(true);
        } else {
            ChannelShutdownDirection channelShutdownDirection4 = ChannelShutdownDirection$.Outbound;
            ChannelShutdownDirection channelShutdownDirection5 = channelShutdownDirection;
            if (!(channelShutdownDirection4 != null ? !channelShutdownDirection4.equals(channelShutdownDirection5) : channelShutdownDirection5 != null)) {
                this.shutdownedOutbound_$eq(true);
            } else {
                throw new MatchError((Object)channelShutdownDirection);
            }
        }
        this.executorAddress().inform(ReactorEvent$ShutdownReply$.MODULE$.apply(this.channel$accessor(), direction, ReactorEvent$ShutdownReply$.MODULE$.$lessinit$greater$default$3()));
    }

    @Override
    public void unsafeFlush(Object payload) {
        Object object = payload;
        if (object instanceof FileRegion) {
            FileRegion fileRegion = (FileRegion)object;
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        if (object instanceof RecyclablePageBuffer) {
            RecyclablePageBuffer buffer;
            for (RecyclablePageBuffer cursor = buffer = (RecyclablePageBuffer)object; cursor != null; cursor = cursor.next()) {
                RecyclablePageBuffer buf = cursor;
                buf.next_$eq(null);
                ByteBuffer byteBuffer = buf.byteBuffer();
                byteBuffer.limit(buffer.writerOffset());
                byteBuffer.position(buffer.readerOffset());
                this.ch$accessor().write(byteBuffer);
                buf.close();
            }
            return;
        }
        throw new MatchError(object);
    }

    @Override
    public boolean isOpen() {
        return this.ch$accessor().isOpen();
    }

    @Override
    public boolean isActive() {
        return this.isOpen() && this.bound();
    }

    @Override
    public boolean isShutdown(ChannelShutdownDirection direction) {
        boolean bl;
        if (!this.isActive()) {
            return true;
        }
        NioUnsafeDatagramChannel nioUnsafeDatagramChannel = this;
        synchronized (nioUnsafeDatagramChannel) {
            boolean bl2;
            ChannelShutdownDirection channelShutdownDirection = direction;
            ChannelShutdownDirection channelShutdownDirection2 = ChannelShutdownDirection$.Inbound;
            ChannelShutdownDirection channelShutdownDirection3 = channelShutdownDirection;
            if (!(channelShutdownDirection2 != null ? !channelShutdownDirection2.equals(channelShutdownDirection3) : channelShutdownDirection3 != null)) {
                bl2 = this.shutdownedInbound();
            } else {
                ChannelShutdownDirection channelShutdownDirection4 = ChannelShutdownDirection$.Outbound;
                ChannelShutdownDirection channelShutdownDirection5 = channelShutdownDirection;
                if (!(channelShutdownDirection4 != null ? !channelShutdownDirection4.equals(channelShutdownDirection5) : channelShutdownDirection5 != null)) {
                    bl2 = this.shutdownedOutbound();
                } else {
                    throw new MatchError((Object)channelShutdownDirection);
                }
            }
            bl = bl2;
        }
        return bl;
    }

    @Override
    public boolean doReadNow() {
        RecyclablePageBuffer page = this.directAllocator().allocate();
        int attempted = page.writableBytes();
        int read = 0;
        SocketAddress address = null;
        try {
            ByteBuffer byteBuffer = page.byteBuffer();
            address = this.ch$accessor().receive(page.byteBuffer());
            read = byteBuffer.position();
            if (address != null) {
                this.processRead(attempted, read, 1);
            } else {
                this.processRead(attempted, read, 0);
            }
        }
        catch (Throwable t) {
            this.unsafeClose((Option<Throwable>)Some$.MODULE$.apply((Object)t));
        }
        if (read > 0) {
            this.executorAddress().inform(ReactorEvent$ReadBuffer$.MODULE$.apply(this.channel$accessor(), page, (Option<SocketAddress>)Some$.MODULE$.apply((Object)address), this.localAddress(), ReactorEvent$ReadBuffer$.MODULE$.$lessinit$greater$default$5()));
            return false;
        }
        if (read == 0) {
            page.close();
            this.channel$accessor().directAllocator().recycle((Buffer)page);
            return false;
        }
        return true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class NioDatagramChannelReadPlan
    implements ReadPlan {
        private boolean continue = true;

        @Override
        public int estimatedNextSize() {
            return 0;
        }

        @Override
        public boolean lastRead(int attemptedBytesRead, int actualBytesRead, int numMessagesRead) {
            this.continue = attemptedBytesRead == actualBytesRead && actualBytesRead > 0;
            return this.continue;
        }

        @Override
        public void readComplete() {
            this.continue = true;
        }

        @Override
        public boolean continueReading() {
            return this.continue;
        }
    }
}

