/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.transport.nio.channel;

import cc.otavia.buffer.pool.RecyclablePageBuffer;
import cc.otavia.core.channel.AbstractUnsafeChannel;
import cc.otavia.core.channel.Channel;
import cc.otavia.core.channel.ChannelShutdownDirection;
import cc.otavia.core.channel.message.FileReadPlan;
import cc.otavia.core.channel.message.FileReadPlan$;
import cc.otavia.core.channel.message.ReadPlan;
import cc.otavia.core.message.ReactorEvent$BindReply$;
import cc.otavia.core.message.ReactorEvent$ChannelClose$;
import cc.otavia.core.message.ReactorEvent$ConnectReply$;
import cc.otavia.core.message.ReactorEvent$DisconnectReply$;
import cc.otavia.core.message.ReactorEvent$OpenReply$;
import cc.otavia.core.message.ReactorEvent$ReadBuffer$;
import cc.otavia.core.message.ReactorEvent$ReadCompletedEvent$;
import cc.otavia.core.message.ReactorEvent$ReadEvent$;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.Arrays$;

public class NioUnsafeFileChannel
extends AbstractUnsafeChannel {
    private FileChannel ch;

    public NioUnsafeFileChannel(Channel channel2) {
        super(channel2);
        this.setReadPlanFactory(channel -> FileReadPlan$.MODULE$.apply(FileReadPlan$.MODULE$.$lessinit$greater$default$1(), FileReadPlan$.MODULE$.$lessinit$greater$default$2()));
    }

    private Channel channel$accessor() {
        return super.channel();
    }

    private FileChannel javaChannel() {
        return this.ch;
    }

    @Override
    public void unsafeBind(SocketAddress local) {
        Some some = Some$.MODULE$.apply((Object)new UnsupportedOperationException());
        boolean bl = ReactorEvent$BindReply$.MODULE$.$lessinit$greater$default$2();
        this.executorAddress().inform(ReactorEvent$BindReply$.MODULE$.apply(this.channel$accessor(), bl, (Option<Throwable>)some));
    }

    @Override
    public void unsafeOpen(Path path, Seq<OpenOption> options, Seq<FileAttribute<?>> attrs) {
        try {
            this.ch = FileChannel.open(path, CollectionConverters$.MODULE$.SetHasAsJava((Set)options.toSet()).asJava(), (FileAttribute[])Arrays$.MODULE$.seqToArray(attrs, FileAttribute.class));
            this.executorAddress().inform(ReactorEvent$OpenReply$.MODULE$.apply(this.channel$accessor(), ReactorEvent$OpenReply$.MODULE$.$lessinit$greater$default$2()));
        }
        catch (Throwable t) {
            this.executorAddress().inform(ReactorEvent$OpenReply$.MODULE$.apply(this.channel$accessor(), (Option<Throwable>)Some$.MODULE$.apply((Object)t)));
        }
    }

    @Override
    public void unsafeDisconnect() {
        this.executorAddress().inform(ReactorEvent$DisconnectReply$.MODULE$.apply(this.channel$accessor(), (Option<Throwable>)Some$.MODULE$.apply((Object)new UnsupportedOperationException())));
    }

    @Override
    public void unsafeClose(Option<Throwable> cause) {
        try {
            this.ch.close();
            this.ch = null;
            this.executorAddress().inform(ReactorEvent$ChannelClose$.MODULE$.apply(this.channel$accessor(), cause));
        }
        catch (Throwable t) {
            this.executorAddress().inform(ReactorEvent$ChannelClose$.MODULE$.apply(this.channel$accessor(), (Option<Throwable>)Some$.MODULE$.apply((Object)t)));
        }
    }

    @Override
    public void unsafeShutdown(ChannelShutdownDirection direction) {
        throw new IllegalStateException("Never should be call!");
    }

    @Override
    public void unsafeRead(ReadPlan readPlan) {
        ReadPlan readPlan2 = readPlan;
        if (readPlan2 instanceof FileReadPlan) {
            FileReadPlan fileReadPlan = FileReadPlan$.MODULE$.unapply((FileReadPlan)readPlan2);
            int n = fileReadPlan._1();
            long l = fileReadPlan._2();
            int length = n;
            long position = l;
            if (length > 0) {
                try {
                    if (position != -1L) {
                        int remaining = length;
                        long pos = position;
                        boolean bl = true;
                        while (bl) {
                            RecyclablePageBuffer buffer = this.directAllocator().allocate();
                            int read = Math.min(buffer.writableBytes(), remaining);
                            ByteBuffer byteBuffer = buffer.byteBuffer();
                            byteBuffer.limit(read);
                            int realRead = this.ch.read(byteBuffer, pos);
                            if (realRead > 0) {
                                pos += (long)realRead;
                                remaining -= realRead;
                                byteBuffer.clear();
                                buffer.writerOffset(realRead);
                                this.executorAddress().inform(ReactorEvent$ReadBuffer$.MODULE$.apply(this.channel$accessor(), buffer, ReactorEvent$ReadBuffer$.MODULE$.$lessinit$greater$default$3(), null, ReactorEvent$ReadBuffer$.MODULE$.$lessinit$greater$default$5()));
                                if (remaining != 0) continue;
                                bl = false;
                                this.executorAddress().inform(ReactorEvent$ReadCompletedEvent$.MODULE$.apply(this.channel$accessor(), ReactorEvent$ReadCompletedEvent$.MODULE$.$lessinit$greater$default$2()));
                                continue;
                            }
                            if (realRead == 0) {
                                bl = false;
                                continue;
                            }
                            bl = false;
                            IndexOutOfBoundsException cause = new IndexOutOfBoundsException(new StringBuilder(70).append("require read length [").append(length).append("] is large than file remaining [").append(length - remaining).append("], actual read [").append(length - remaining).append("]").toString());
                            this.executorAddress().inform(ReactorEvent$ReadEvent$.MODULE$.apply(this.channel$accessor(), (Option<Throwable>)Some$.MODULE$.apply((Object)cause)));
                        }
                    } else {
                        int remaining = length;
                        boolean bl = true;
                        while (bl) {
                            RecyclablePageBuffer buffer = this.directAllocator().allocate();
                            ByteBuffer byteBuffer = buffer.byteBuffer();
                            byteBuffer.limit(Math.min(buffer.writableBytes(), remaining));
                            int realRead = this.ch.read(byteBuffer);
                            if (realRead > 0) {
                                remaining -= realRead;
                                byteBuffer.clear();
                                buffer.writerOffset(realRead);
                                this.executorAddress().inform(ReactorEvent$ReadBuffer$.MODULE$.apply(this.channel$accessor(), buffer, ReactorEvent$ReadBuffer$.MODULE$.$lessinit$greater$default$3(), null, ReactorEvent$ReadBuffer$.MODULE$.$lessinit$greater$default$5()));
                                if (remaining != 0) continue;
                                bl = false;
                                this.executorAddress().inform(ReactorEvent$ReadCompletedEvent$.MODULE$.apply(this.channel$accessor(), ReactorEvent$ReadCompletedEvent$.MODULE$.$lessinit$greater$default$2()));
                                continue;
                            }
                            if (realRead == 0) {
                                bl = false;
                                continue;
                            }
                            bl = false;
                            IndexOutOfBoundsException cause = new IndexOutOfBoundsException(new StringBuilder(70).append("require read length [").append(length).append("] is large than file remaining [").append(length - remaining).append("], actual read [").append(length - remaining).append("]").toString());
                            this.executorAddress().inform(ReactorEvent$ReadCompletedEvent$.MODULE$.apply(this.channel$accessor(), (Option<Throwable>)Some$.MODULE$.apply((Object)cause)));
                        }
                    }
                }
                catch (Throwable t) {
                    this.executorAddress().inform(ReactorEvent$ReadEvent$.MODULE$.apply(this.channel$accessor(), (Option<Throwable>)Some$.MODULE$.apply((Object)t)));
                }
                return;
            }
            if (length == -1) {
                try {
                    if (position != -1L) {
                        long readLength;
                        long remaining = readLength = this.ch.size();
                        long pos = position;
                        boolean bl = true;
                        while (bl) {
                            RecyclablePageBuffer buffer = this.directAllocator().allocate();
                            ByteBuffer byteBuffer = buffer.byteBuffer();
                            byteBuffer.limit((int)Math.min((long)buffer.writableBytes(), remaining));
                            int realRead = this.ch.read(byteBuffer, pos);
                            if (realRead > 0) {
                                pos += (long)realRead;
                                remaining -= (long)realRead;
                                byteBuffer.clear();
                                buffer.writerOffset(realRead);
                                this.executorAddress().inform(ReactorEvent$ReadBuffer$.MODULE$.apply(this.channel$accessor(), buffer, ReactorEvent$ReadBuffer$.MODULE$.$lessinit$greater$default$3(), null, ReactorEvent$ReadBuffer$.MODULE$.$lessinit$greater$default$5()));
                                if (remaining != 0L) continue;
                                bl = false;
                                this.executorAddress().inform(ReactorEvent$ReadCompletedEvent$.MODULE$.apply(this.channel$accessor(), ReactorEvent$ReadCompletedEvent$.MODULE$.$lessinit$greater$default$2()));
                                continue;
                            }
                            if (realRead != 0) continue;
                            bl = false;
                        }
                    } else {
                        long readLength;
                        long remaining = readLength = this.ch.size();
                        boolean bl = true;
                        while (bl) {
                            RecyclablePageBuffer buffer = this.directAllocator().allocate();
                            ByteBuffer byteBuffer = buffer.byteBuffer();
                            byteBuffer.limit((int)Math.min((long)buffer.writableBytes(), remaining));
                            int realRead = this.ch.read(byteBuffer);
                            if (realRead > 0) {
                                remaining -= (long)realRead;
                                byteBuffer.clear();
                                buffer.writerOffset(realRead);
                                this.executorAddress().inform(ReactorEvent$ReadBuffer$.MODULE$.apply(this.channel$accessor(), buffer, ReactorEvent$ReadBuffer$.MODULE$.$lessinit$greater$default$3(), null, ReactorEvent$ReadBuffer$.MODULE$.$lessinit$greater$default$5()));
                                if (remaining != 0L) continue;
                                bl = false;
                                this.executorAddress().inform(ReactorEvent$ReadCompletedEvent$.MODULE$.apply(this.channel$accessor(), ReactorEvent$ReadCompletedEvent$.MODULE$.$lessinit$greater$default$2()));
                                continue;
                            }
                            if (realRead != 0) continue;
                            bl = false;
                        }
                    }
                }
                catch (Throwable t) {
                    this.executorAddress().inform(ReactorEvent$ReadEvent$.MODULE$.apply(this.channel$accessor(), (Option<Throwable>)Some$.MODULE$.apply((Object)t)));
                }
                return;
            }
            UnsupportedOperationException cause = new UnsupportedOperationException(new StringBuilder(15).append("read length is ").append(length).toString());
            this.executorAddress().inform(ReactorEvent$ReadCompletedEvent$.MODULE$.apply(this.channel$accessor(), (Option<Throwable>)Some$.MODULE$.apply((Object)cause)));
            return;
        }
        IllegalArgumentException cause = new IllegalArgumentException(new StringBuilder(23).append(this.getClass().getSimpleName()).append(" not support ").append(readPlan.getClass().getSimpleName()).append(" read plan").toString());
        this.executorAddress().inform(ReactorEvent$ReadCompletedEvent$.MODULE$.apply(this.channel$accessor(), (Option<Throwable>)Some$.MODULE$.apply((Object)cause)));
    }

    @Override
    public void unsafeFlush(Object payload) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    @Override
    public void unsafeConnect(SocketAddress remote, Option<SocketAddress> local, boolean fastOpen) {
        Some some = Some$.MODULE$.apply((Object)new UnsupportedOperationException());
        boolean bl = ReactorEvent$ConnectReply$.MODULE$.$lessinit$greater$default$2();
        this.executorAddress().inform(ReactorEvent$ConnectReply$.MODULE$.apply(this.channel$accessor(), bl, (Option<Throwable>)some));
    }

    @Override
    public boolean isOpen() {
        return this.ch != null && this.ch.isOpen();
    }

    @Override
    public boolean isActive() {
        return this.isOpen();
    }

    @Override
    public boolean isShutdown(ChannelShutdownDirection direction) {
        return !this.isOpen();
    }
}

