/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.transport.nio.channel;

import cc.otavia.core.channel.Channel;
import cc.otavia.core.channel.ChannelShutdownDirection;
import cc.otavia.core.channel.message.ReadPlan;
import cc.otavia.core.message.ReactorEvent$AcceptedEvent$;
import cc.otavia.core.message.ReactorEvent$BindReply$;
import cc.otavia.core.message.ReactorEvent$ShutdownReply$;
import cc.otavia.core.transport.nio.channel.AbstractNioUnsafeChannel;
import cc.otavia.core.transport.nio.channel.NioSocketChannel;
import cc.otavia.core.transport.nio.channel.NioUnsafeServerSocketChannel$;
import cc.otavia.core.transport.nio.channel.NioUnsafeSocketChannel;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.runtime.Scala3RunTime$;

public class NioUnsafeServerSocketChannel
extends AbstractNioUnsafeChannel<ServerSocketChannel> {
    private int backlog = NioUnsafeServerSocketChannel$.cc$otavia$core$transport$nio$channel$NioUnsafeServerSocketChannel$$$BACKLOG;

    public NioUnsafeServerSocketChannel(Channel channel2, ServerSocketChannel ch, int readInterestOp) {
        super(channel2, ch, readInterestOp);
        this.setReadPlanFactory(channel -> new NioServerSocketReadPlan());
    }

    private Channel channel$accessor() {
        return super.channel();
    }

    private ServerSocketChannel ch$accessor() {
        return (ServerSocketChannel)super.ch();
    }

    private int readInterestOp$accessor() {
        return super.readInterestOp();
    }

    @Override
    public SocketAddress localAddress() {
        return ((ServerSocketChannel)this.javaChannel()).getLocalAddress();
    }

    public final int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int back) {
        NioUnsafeServerSocketChannel nioUnsafeServerSocketChannel = this;
        synchronized (nioUnsafeServerSocketChannel) {
            if (back < 0) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)new StringBuilder(47).append("in setBacklog(back: Int) back:").append(back).append(" (expected: >= 0)").toString());
            }
            this.backlog = back;
        }
    }

    @Override
    public void unsafeBind(SocketAddress local) {
        boolean bindWasActive = this.isActive();
        ((ServerSocketChannel)this.javaChannel()).bind(local, this.getBacklog());
        this.bound_$eq(true);
        boolean firstActive = !bindWasActive && this.channel$accessor().unsafeChannel().isActive();
        this.channel$accessor().executorAddress().inform(ReactorEvent$BindReply$.MODULE$.apply(this.channel$accessor(), firstActive, (Option<Throwable>)None$.MODULE$));
    }

    @Override
    public void unsafeOpen(Path path, Seq<OpenOption> options, Seq<FileAttribute<?>> attrs) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unsafeDisconnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unsafeConnect(SocketAddress remote, Option<SocketAddress> local, boolean fastOpen) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unsafeShutdown(ChannelShutdownDirection direction) {
        Some cause = Some$.MODULE$.apply((Object)new UnsupportedOperationException());
        this.executorAddress().inform(ReactorEvent$ShutdownReply$.MODULE$.apply(this.channel$accessor(), direction, (Option<Throwable>)cause));
    }

    @Override
    public void unsafeFlush(Object payload) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isOpen() {
        return this.ch$accessor().isOpen();
    }

    @Override
    public boolean isActive() {
        return this.isOpen() && this.bound();
    }

    @Override
    public boolean isShutdown(ChannelShutdownDirection direction) {
        return !this.isActive();
    }

    @Override
    public boolean doReadNow() {
        SocketChannel socket = ((ServerSocketChannel)this.javaChannel()).accept();
        if (socket != null) {
            socket.configureBlocking(false);
            NioSocketChannel c = new NioSocketChannel(this.channel$accessor().system());
            NioUnsafeSocketChannel u = new NioUnsafeSocketChannel((Channel)c, socket, 1);
            c.setUnsafeChannel(u);
            this.executorAddress().inform(ReactorEvent$AcceptedEvent$.MODULE$.apply(this.channel$accessor(), c));
            this.processRead(0, 0, 1);
        } else {
            this.processRead(0, 0, 0);
        }
        return false;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class NioServerSocketReadPlan
    implements ReadPlan {
        private boolean continue = true;
        private int readCompleted = 0;

        @Override
        public int estimatedNextSize() {
            return 0;
        }

        @Override
        public boolean lastRead(int attemptedBytesRead, int actualBytesRead, int numMessagesRead) {
            this.readCompleted += actualBytesRead;
            this.continue = numMessagesRead != 0;
            return this.continue;
        }

        @Override
        public void readComplete() {
            this.continue = true;
            this.readCompleted = 0;
        }

        @Override
        public boolean continueReading() {
            return this.continue;
        }
    }
}

