/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.transport.nio.channel;

import cc.otavia.buffer.pool.RecyclablePageBuffer;
import cc.otavia.core.channel.Channel;
import cc.otavia.core.channel.ChannelShutdownDirection;
import cc.otavia.core.channel.ChannelShutdownDirection$;
import cc.otavia.core.channel.FileRegion;
import cc.otavia.core.channel.message.ReadPlan;
import cc.otavia.core.message.ReactorEvent$BindReply$;
import cc.otavia.core.message.ReactorEvent$ConnectReply$;
import cc.otavia.core.message.ReactorEvent$ReadBuffer$;
import cc.otavia.core.message.ReactorEvent$ShutdownReply$;
import cc.otavia.core.transport.nio.channel.AbstractNioUnsafeChannel;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.mutable.ArrayDeque;
import scala.collection.mutable.ArrayDeque$;
import scala.runtime.BoxedUnit;

public class NioUnsafeSocketChannel
extends AbstractNioUnsafeChannel<SocketChannel> {
    private ArrayDeque<Object> flushQueue;

    public NioUnsafeSocketChannel(Channel channel2, SocketChannel ch, int readInterestOp) {
        super(channel2, ch, readInterestOp);
        this.setReadPlanFactory(channel -> new NioSocketChannelReadPlan());
    }

    private Channel channel$accessor() {
        return super.channel();
    }

    private SocketChannel ch$accessor() {
        return (SocketChannel)super.ch();
    }

    private int readInterestOp$accessor() {
        return super.readInterestOp();
    }

    @Override
    public SocketAddress localAddress() {
        return ((SocketChannel)this.javaChannel()).getLocalAddress();
    }

    @Override
    public void unsafeBind(SocketAddress local) {
        try {
            ((SocketChannel)this.javaChannel()).bind(local);
            this.executorAddress().inform(ReactorEvent$BindReply$.MODULE$.apply(this.channel$accessor(), ReactorEvent$BindReply$.MODULE$.$lessinit$greater$default$2(), ReactorEvent$BindReply$.MODULE$.$lessinit$greater$default$3()));
        }
        catch (Throwable t) {
            Some some = Some$.MODULE$.apply((Object)t);
            boolean bl = ReactorEvent$BindReply$.MODULE$.$lessinit$greater$default$2();
            this.executorAddress().inform(ReactorEvent$BindReply$.MODULE$.apply(this.channel$accessor(), bl, (Option<Throwable>)some));
        }
    }

    @Override
    public void unsafeConnect(SocketAddress remote, Option<SocketAddress> local, boolean fastOpen) {
        block7: {
            Object object;
            Option<SocketAddress> option = local;
            if (None$.MODULE$.equals(option)) {
                object = BoxedUnit.UNIT;
            } else if (option instanceof Some) {
                SocketAddress value = (SocketAddress)((Some)option).value();
                object = ((SocketChannel)this.javaChannel()).bind(value);
            } else {
                throw new MatchError(option);
            }
            try {
                boolean connected = ((SocketChannel)this.javaChannel()).connect(remote);
                if (!connected) {
                    this._selectionKey().interestOps(8);
                    break block7;
                }
                this.executorAddress().inform(ReactorEvent$ConnectReply$.MODULE$.apply(this.channel$accessor(), true, ReactorEvent$ConnectReply$.MODULE$.$lessinit$greater$default$3()));
            }
            catch (Throwable t) {
                Some some = Some$.MODULE$.apply((Object)t);
                boolean bl = ReactorEvent$ConnectReply$.MODULE$.$lessinit$greater$default$2();
                this.executorAddress().inform(ReactorEvent$ConnectReply$.MODULE$.apply(this.channel$accessor(), bl, (Option<Throwable>)some));
            }
        }
    }

    @Override
    public void finishConnect() {
        try {
            ((SocketChannel)this.javaChannel()).finishConnect();
            this.executorAddress().inform(ReactorEvent$ConnectReply$.MODULE$.apply(this.channel$accessor(), true, ReactorEvent$ConnectReply$.MODULE$.$lessinit$greater$default$3()));
        }
        catch (Throwable t) {
            Some some = Some$.MODULE$.apply((Object)t);
            boolean bl = ReactorEvent$ConnectReply$.MODULE$.$lessinit$greater$default$2();
            this.executorAddress().inform(ReactorEvent$ConnectReply$.MODULE$.apply(this.channel$accessor(), bl, (Option<Throwable>)some));
        }
    }

    @Override
    public void unsafeDisconnect() {
        throw new UnsupportedOperationException("should never execute this method");
    }

    @Override
    public void unsafeShutdown(ChannelShutdownDirection direction) {
        try {
            ChannelShutdownDirection channelShutdownDirection = direction;
            ChannelShutdownDirection channelShutdownDirection2 = ChannelShutdownDirection$.Inbound;
            ChannelShutdownDirection channelShutdownDirection3 = channelShutdownDirection;
            if (!(channelShutdownDirection2 != null ? !channelShutdownDirection2.equals(channelShutdownDirection3) : channelShutdownDirection3 != null)) {
                ((SocketChannel)this.javaChannel()).shutdownInput();
                this.shutdownedInbound_$eq(true);
            } else {
                ChannelShutdownDirection channelShutdownDirection4 = ChannelShutdownDirection$.Outbound;
                ChannelShutdownDirection channelShutdownDirection5 = channelShutdownDirection;
                if (!(channelShutdownDirection4 != null ? !channelShutdownDirection4.equals(channelShutdownDirection5) : channelShutdownDirection5 != null)) {
                    ((SocketChannel)this.javaChannel()).shutdownOutput();
                    this.shutdownedOutbound_$eq(true);
                } else {
                    throw new MatchError((Object)channelShutdownDirection);
                }
            }
            this.executorAddress().inform(ReactorEvent$ShutdownReply$.MODULE$.apply(this.channel$accessor(), direction, ReactorEvent$ShutdownReply$.MODULE$.$lessinit$greater$default$3()));
        }
        catch (Throwable e) {
            this.executorAddress().inform(ReactorEvent$ShutdownReply$.MODULE$.apply(this.channel$accessor(), direction, (Option<Throwable>)Some$.MODULE$.apply((Object)e)));
        }
    }

    @Override
    public void unsafeFlush(Object payload) {
        if (this.flushQueue != null && this.flushQueue.nonEmpty()) {
            if (payload != null) {
                this.flushQueue.addOne(payload);
            }
            boolean resize = this.flushQueue.size() > 64;
            boolean bl = true;
            while (bl && this.flushQueue.nonEmpty()) {
                ArrayDeque<Object> arrayDeque = this.flushQueue;
                Object object = arrayDeque.removeHead(arrayDeque.removeHead$default$1());
                if (object instanceof RecyclablePageBuffer) {
                    RecyclablePageBuffer buffer = (RecyclablePageBuffer)object;
                    bl = this.unsafeFlushBuffer(buffer);
                    continue;
                }
                if (object instanceof FileRegion) {
                    FileRegion fileRegion = (FileRegion)object;
                    this.unsafeFlushFileRegion(fileRegion);
                    continue;
                }
                throw new MatchError(object);
            }
            if (this._selectionKey() != null && this._selectionKey().isValid()) {
                int interestOps = this._selectionKey().interestOps();
                if (this.flushQueue.nonEmpty()) {
                    if ((interestOps & 4) == 0) {
                        this._selectionKey().interestOps(interestOps | 4);
                        return;
                    }
                    return;
                }
                if ((interestOps & 4) != 0) {
                    this._selectionKey().interestOps(interestOps & 0xFFFFFFFB);
                }
                if (resize) {
                    ArrayDeque<Object> arrayDeque = this.flushQueue;
                    arrayDeque.clearAndShrink(arrayDeque.clearAndShrink$default$1());
                    return;
                }
                return;
            }
            return;
        }
        Object object = payload;
        if (object instanceof RecyclablePageBuffer) {
            RecyclablePageBuffer buffer = (RecyclablePageBuffer)object;
            this.unsafeFlushBuffer(buffer);
            return;
        }
        if (object instanceof FileRegion) {
            FileRegion fileRegion = (FileRegion)object;
            this.unsafeFlushFileRegion(fileRegion);
            return;
        }
        throw new MatchError(object);
    }

    private boolean unsafeFlushBuffer(RecyclablePageBuffer buffer) {
        boolean closed = false;
        RecyclablePageBuffer cursor = buffer;
        boolean bl = true;
        while (cursor != null && bl) {
            RecyclablePageBuffer buf = cursor;
            cursor = cursor.next();
            buf.next_$eq(null);
            if (!closed) {
                int writable = buf.readableBytes();
                ByteBuffer byteBuffer = buf.byteBuffer();
                byteBuffer.limit(buf.writerOffset());
                byteBuffer.position(buf.readerOffset());
                try {
                    int write = this.ch$accessor().write(byteBuffer);
                    if (write != writable) {
                        bl = false;
                        buf.skipReadableBytes(write);
                        buf.next_$eq(cursor);
                        if (this.flushQueue == null) {
                            this.flushQueue = ArrayDeque$.MODULE$.empty();
                        }
                        this.flushQueue.prepend((Object)buf);
                        int interestOps = this._selectionKey().interestOps();
                        if ((interestOps & 4) != 0) continue;
                        this._selectionKey().interestOps(interestOps | 4);
                        continue;
                    }
                    buf.close();
                }
                catch (IOException e) {
                    this.unsafeClose((Option<Throwable>)Some$.MODULE$.apply((Object)e));
                    closed = true;
                }
                continue;
            }
            buf.close();
        }
        return bl;
    }

    private void unsafeFlushFileRegion(FileRegion fileRegion) {
        fileRegion.transferTo(this.ch$accessor(), 0L);
        fileRegion.release();
    }

    @Override
    public boolean isOpen() {
        boolean bl;
        NioUnsafeSocketChannel nioUnsafeSocketChannel = this;
        synchronized (nioUnsafeSocketChannel) {
            bl = this.ch$accessor().isOpen();
        }
        return bl;
    }

    @Override
    public boolean isActive() {
        boolean bl;
        NioUnsafeSocketChannel nioUnsafeSocketChannel = this;
        synchronized (nioUnsafeSocketChannel) {
            bl = this.ch$accessor().isOpen() && this.ch$accessor().isConnected();
        }
        return bl;
    }

    @Override
    public boolean isShutdown(ChannelShutdownDirection direction) {
        boolean bl;
        if (!this.isActive()) {
            return true;
        }
        NioUnsafeSocketChannel nioUnsafeSocketChannel = this;
        synchronized (nioUnsafeSocketChannel) {
            boolean bl2;
            ChannelShutdownDirection channelShutdownDirection = direction;
            ChannelShutdownDirection channelShutdownDirection2 = ChannelShutdownDirection$.Inbound;
            ChannelShutdownDirection channelShutdownDirection3 = channelShutdownDirection;
            if (!(channelShutdownDirection2 != null ? !channelShutdownDirection2.equals(channelShutdownDirection3) : channelShutdownDirection3 != null)) {
                bl2 = this.shutdownedInbound();
            } else {
                ChannelShutdownDirection channelShutdownDirection4 = ChannelShutdownDirection$.Outbound;
                ChannelShutdownDirection channelShutdownDirection5 = channelShutdownDirection;
                if (!(channelShutdownDirection4 != null ? !channelShutdownDirection4.equals(channelShutdownDirection5) : channelShutdownDirection5 != null)) {
                    bl2 = this.shutdownedOutbound();
                } else {
                    throw new MatchError((Object)channelShutdownDirection);
                }
            }
            bl = bl2;
        }
        return bl;
    }

    @Override
    public boolean doReadNow() {
        RecyclablePageBuffer page = this.directAllocator().allocate();
        int attempted = page.writableBytes();
        int read = 0;
        try {
            read = page.transferFrom((ReadableByteChannel)this.ch$accessor(), attempted);
            this.processRead(attempted, read, 1);
        }
        catch (Throwable t) {
            this.unsafeClose((Option<Throwable>)Some$.MODULE$.apply((Object)t));
        }
        if (read > 0) {
            this.executorAddress().inform(ReactorEvent$ReadBuffer$.MODULE$.apply(this.channel$accessor(), page, ReactorEvent$ReadBuffer$.MODULE$.$lessinit$greater$default$3(), null, ReactorEvent$ReadBuffer$.MODULE$.$lessinit$greater$default$5()));
            return false;
        }
        if (read == 0) {
            page.close();
            return false;
        }
        page.close();
        return true;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class NioSocketChannelReadPlan
    implements ReadPlan {
        private boolean continue = true;

        @Override
        public int estimatedNextSize() {
            return 0;
        }

        @Override
        public boolean lastRead(int attemptedBytesRead, int actualBytesRead, int numMessagesRead) {
            this.continue = attemptedBytesRead == actualBytesRead && actualBytesRead > 0;
            return this.continue;
        }

        @Override
        public void readComplete() {
            this.continue = true;
        }

        @Override
        public boolean continueReading() {
            return this.continue;
        }
    }
}

