/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.transport.reactor.nio;

import cc.otavia.common.ThrowableUtil$;
import cc.otavia.core.channel.Channel;
import cc.otavia.core.channel.ChannelException;
import cc.otavia.core.channel.message.ReadPlan;
import cc.otavia.core.message.ReactorEvent$BindReply$;
import cc.otavia.core.message.ReactorEvent$ChannelClose$;
import cc.otavia.core.message.ReactorEvent$ConnectReply$;
import cc.otavia.core.message.ReactorEvent$DisconnectReply$;
import cc.otavia.core.message.ReactorEvent$OpenReply$;
import cc.otavia.core.message.ReactorEvent$RegisterReply$;
import cc.otavia.core.reactor.DefaultSelectStrategyFactory$;
import cc.otavia.core.reactor.IoExecutionContext;
import cc.otavia.core.reactor.IoHandler;
import cc.otavia.core.reactor.SelectStrategy;
import cc.otavia.core.reactor.SelectStrategy$;
import cc.otavia.core.slf4a.Logger;
import cc.otavia.core.slf4a.Logger$;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.transport.nio.channel.NioUnsafeChannel;
import cc.otavia.core.transport.reactor.nio.NioHandler$;
import cc.otavia.core.transport.reactor.nio.NioHandler$SelectorTuple$;
import cc.otavia.core.transport.reactor.nio.SelectedSelectionKeySet;
import cc.otavia.core.transport.reactor.nio.SelectedSelectionKeySetSelector;
import cc.otavia.internal.Platform$;
import cc.otavia.internal.ReflectionUtil$;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.net.SocketAddress;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelector;
import java.nio.channels.spi.SelectorProvider;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.IntSupplier;
import scala.Function0;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class NioHandler
extends IoHandler {
    private final SelectorProvider selectorProvider;
    private final SelectStrategy selectStrategy;
    private final Logger logger;
    private final IntSupplier selectNowSupplier;
    private Selector selector;
    private Selector unwrappedSelector;
    private SelectedSelectionKeySet selectedKeys;
    private final AtomicBoolean wakenUp;
    private int cancelledKeys;
    private boolean needsToSelectAgain;

    public NioHandler(SelectorProvider selectorProvider, SelectStrategy selectStrategy, ActorSystem sys) {
        this.selectorProvider = selectorProvider;
        this.selectStrategy = selectStrategy;
        super(sys);
        this.logger = Logger$.MODULE$.getLogger(this.getClass(), sys);
        this.selectNowSupplier = new IntSupplier(this){
            private final /* synthetic */ NioHandler $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int getAsInt() {
                int n;
                try {
                    n = this.$outer.cc$otavia$core$transport$reactor$nio$NioHandler$$selectNow();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                return n;
            }
        };
        SelectorTuple selectorTuple = this.openSelector();
        this.selector = selectorTuple.selector();
        this.unwrappedSelector = selectorTuple.unwrappedSelector();
        this.wakenUp = new AtomicBoolean();
        this.cancelledKeys = 0;
        this.needsToSelectAgain = false;
    }

    public SelectorProvider selectorProvider() {
        return this.selectorProvider;
    }

    public SelectStrategy selectStrategy() {
        return this.selectStrategy;
    }

    public NioHandler(ActorSystem system) {
        this(SelectorProvider.provider(), DefaultSelectStrategyFactory$.MODULE$.newSelectStrategy(), system);
    }

    private SelectorTuple openSelector() {
        AbstractSelector abstractSelector;
        try {
            abstractSelector = this.selectorProvider().openSelector();
        }
        catch (IOException e) {
            throw new ChannelException(new StringBuilder(30).append("failed to open a new selector ").append(e).toString());
        }
        AbstractSelector unwrappedSelector = abstractSelector;
        if (NioHandler$.cc$otavia$core$transport$reactor$nio$NioHandler$$$DISABLE_KEY_SET_OPTIMIZATION) {
            return NioHandler$SelectorTuple$.MODULE$.apply(unwrappedSelector);
        }
        Try try_ = Try$.MODULE$.apply(NioHandler::openSelector$$anonfun$1);
        if (try_ instanceof Failure) {
            Throwable throwable = ((Failure)try_).exception();
            String msg = new StringBuilder(52).append("failed to instrument a special java.util.Set into: ").append(unwrappedSelector).append(" ").append(throwable).toString();
            this.logger.trace(msg);
            return NioHandler$SelectorTuple$.MODULE$.apply(unwrappedSelector);
        }
        if (try_ instanceof Success) {
            Class selectorImplClass = (Class)((Success)try_).value();
            if (!selectorImplClass.isAssignableFrom(unwrappedSelector.getClass())) {
                return NioHandler$SelectorTuple$.MODULE$.apply(unwrappedSelector);
            }
            SelectedSelectionKeySet selectedKeySet = new SelectedSelectionKeySet();
            Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                NioHandler.openSelector$$anonfun$2(unwrappedSelector, selectorImplClass, selectedKeySet);
                return BoxedUnit.UNIT;
            });
            if (try_2 instanceof Failure) {
                Throwable e = ((Failure)try_2).exception();
                String msg = new StringBuilder(52).append("failed to instrument a special java.util.Set into: ").append(unwrappedSelector).append(" ").append(e).toString();
                this.logger.trace(msg);
                return NioHandler$SelectorTuple$.MODULE$.apply(unwrappedSelector);
            }
            if (try_2 instanceof Success) {
                this.selectedKeys = selectedKeySet;
                this.logger.trace(new StringBuilder(43).append("instrumented a special java.util.Set into: ").append(unwrappedSelector).toString());
                return NioHandler$SelectorTuple$.MODULE$.apply(unwrappedSelector, new SelectedSelectionKeySetSelector(unwrappedSelector, selectedKeySet));
            }
            throw new MatchError((Object)try_2);
        }
        throw new MatchError((Object)try_);
    }

    private void rebuildSelector() {
        Selector oldSelector = this.selector;
        Try try_ = Try$.MODULE$.apply(this::rebuildSelector$$anonfun$1);
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            String msg = new StringBuilder(33).append("Failed to create a new Selector. ").append(ThrowableUtil$.MODULE$.stackTraceToString(e)).toString();
            this.logger.warn(msg);
            return;
        }
        if (try_ instanceof Success) {
            SelectorTuple newSelectorTuple = (SelectorTuple)((Success)try_).value();
            IntRef nChannels = IntRef.create((int)0);
            oldSelector.keys().forEach(key -> {
                NioUnsafeChannel processor = (NioUnsafeChannel)key.attachment();
                try {
                    if (key.isValid() && key.channel().keyFor(newSelectorTuple.unwrappedSelector()) == null) {
                        int n;
                        processor.registerSelector(newSelectorTuple.unwrappedSelector());
                        nChannels$1.elem = n = nChannels$1.elem + 1;
                    }
                }
                catch (Exception e) {
                    String trace = ThrowableUtil$.MODULE$.stackTraceToString((Throwable)e);
                    this.logger.warn(new StringBuilder(55).append("Failed to re-register a NioHandle to the new Selector. ").append(trace).toString());
                    processor.closeProcessor();
                }
            });
            this.selector = newSelectorTuple.selector();
            this.unwrappedSelector = newSelectorTuple.unwrappedSelector();
            try {
                oldSelector.close();
            }
            catch (Throwable t) {
                String msg = ThrowableUtil$.MODULE$.stackTraceToString(t);
                this.logger.warn(new StringBuilder(34).append("Failed to close the old Selector. ").append(msg).toString());
            }
            this.logger.info(new StringBuilder(41).append("Migrated ").append(nChannels.elem).append(" channel(s) to the new Selector.").toString());
            return;
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public int run(IoExecutionContext runner) {
        int handled = 0;
        try {
            int strategy = this.selectStrategy().calculateStrategy(this.selectNowSupplier, !runner.canBlock());
            if (strategy == SelectStrategy$.MODULE$.SELECT()) {
                try {
                    this.select(runner);
                    if (this.wakenUp.get()) {
                        this.wakenUp.set(false);
                    }
                }
                catch (IOException e) {
                    this.rebuildSelector();
                    this.handleLoopException(e);
                    handled = 0;
                }
            }
            this.cancelledKeys = 0;
            this.needsToSelectAgain = false;
            handled = this.processSelectedKeys();
        }
        catch (Error e) {
            e.printStackTrace();
            throw e;
        }
        catch (Throwable t) {
            this.handleLoopException(t);
        }
        return handled;
    }

    private void handleLoopException(Throwable t) {
        this.logger.warn(new StringBuilder(43).append("Unexpected exception in the selector loop. ").append(ThrowableUtil$.MODULE$.stackTraceToString(t)).toString());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private int processSelectedKeys() {
        if (this.selectedKeys != null) {
            return this.processSelectedKeysOptimized();
        }
        return this.processSelectedKeysPlain();
    }

    @Override
    public void destroy() {
        try {
            this.selector.close();
        }
        catch (IOException e) {
            this.logger.warn(new StringBuilder(28).append("Failed to close a selector. ").append(ThrowableUtil$.MODULE$.stackTraceToString((Throwable)e)).toString());
        }
    }

    private int processSelectedKeysPlain() {
        Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
        if (!selectedKeys.isEmpty()) {
            Iterator<SelectionKey> iterator = selectedKeys.iterator();
            int handled = 0;
            boolean bl = false;
            while (!bl) {
                SelectionKey key = iterator.next();
                iterator.remove();
                this.processSelectedKey(key);
                ++handled;
                if (!iterator.hasNext()) {
                    bl = true;
                }
                if (!this.needsToSelectAgain) continue;
                this.selectAgain();
                selectedKeys = this.selector.selectedKeys();
                if (selectedKeys.isEmpty()) {
                    bl = true;
                    continue;
                }
                iterator = selectedKeys.iterator();
            }
            return handled;
        }
        return 0;
    }

    private int processSelectedKeysOptimized() {
        int handled = 0;
        SelectedSelectionKeySet keys = this.selectedKeys;
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            SelectionKey key = keys.keys()[i];
            keys.keys()[i] = null;
            this.processSelectedKey(key);
            ++handled;
            if (!this.needsToSelectAgain) continue;
            keys.reset(i + 1);
            this.selectAgain();
            i = -1;
        }
        return handled;
    }

    private void processSelectedKey(SelectionKey key) {
        NioUnsafeChannel processor = (NioUnsafeChannel)key.attachment();
        processor.handle(key);
    }

    @Override
    public void prepareToDestroy() {
        this.selectAgain();
        Set<SelectionKey> keys = this.selector.keys();
        keys.forEach(key -> {
            NioUnsafeChannel processor = (NioUnsafeChannel)key.attachment();
            processor.closeProcessor();
        });
    }

    @Override
    public void register(Channel channel) {
        NioUnsafeChannel nioUnsafeChannel = NioHandler$.MODULE$.cc$otavia$core$transport$reactor$nio$NioHandler$$$nioUnsafe(channel);
        boolean selected = false;
        boolean success = false;
        while (!success) {
            try {
                nioUnsafeChannel.registerSelector(this.unwrappedSelector);
                channel.executorAddress().inform(ReactorEvent$RegisterReply$.MODULE$.apply(channel, nioUnsafeChannel.isActive(), ReactorEvent$RegisterReply$.MODULE$.$lessinit$greater$default$3()));
                success = true;
            }
            catch (CancelledKeyException e) {
                if (!selected) {
                    this.cc$otavia$core$transport$reactor$nio$NioHandler$$selectNow();
                    selected = true;
                    continue;
                }
                Some some = Some$.MODULE$.apply((Object)e);
                boolean bl = ReactorEvent$RegisterReply$.MODULE$.$lessinit$greater$default$2();
                channel.executorAddress().inform(ReactorEvent$RegisterReply$.MODULE$.apply(channel, bl, (Option<Throwable>)some));
            }
        }
    }

    @Override
    public void deregister(Channel channel) {
        NioUnsafeChannel nioUnsafeChannel = NioHandler$.MODULE$.cc$otavia$core$transport$reactor$nio$NioHandler$$$nioUnsafe(channel);
        nioUnsafeChannel.deregisterSelector();
        ++this.cancelledKeys;
        if (this.cancelledKeys >= NioHandler$.cc$otavia$core$transport$reactor$nio$NioHandler$$$CLEANUP_INTERVAL) {
            this.cancelledKeys = 0;
            this.needsToSelectAgain = true;
            return;
        }
    }

    @Override
    public void bind(Channel channel, SocketAddress local) {
        try {
            channel.unsafeChannel().unsafeBind(local);
        }
        catch (Throwable t) {
            Some some = Some$.MODULE$.apply((Object)t);
            boolean bl = ReactorEvent$BindReply$.MODULE$.$lessinit$greater$default$2();
            channel.executorAddress().inform(ReactorEvent$BindReply$.MODULE$.apply(channel, bl, (Option<Throwable>)some));
        }
    }

    @Override
    public void open(Channel channel, Path path, Seq<OpenOption> options, Seq<FileAttribute<?>> attrs) {
        try {
            channel.unsafeChannel().unsafeOpen(path, options, attrs);
        }
        catch (Throwable t) {
            channel.executorAddress().inform(ReactorEvent$OpenReply$.MODULE$.apply(channel, (Option<Throwable>)Some$.MODULE$.apply((Object)t)));
        }
    }

    @Override
    public void connect(Channel channel, SocketAddress remote, Option<SocketAddress> local, boolean fastOpen) {
        try {
            channel.unsafeChannel().unsafeConnect(remote, local, fastOpen);
        }
        catch (Throwable t) {
            Some some = Some$.MODULE$.apply((Object)t);
            boolean bl = ReactorEvent$ConnectReply$.MODULE$.$lessinit$greater$default$2();
            channel.executorAddress().inform(ReactorEvent$ConnectReply$.MODULE$.apply(channel, bl, (Option<Throwable>)some));
        }
    }

    @Override
    public void disconnect(Channel channel) {
        try {
            channel.unsafeChannel().unsafeDisconnect();
        }
        catch (Throwable t) {
            channel.executorAddress().inform(ReactorEvent$DisconnectReply$.MODULE$.apply(channel, (Option<Throwable>)Some$.MODULE$.apply((Object)t)));
        }
    }

    @Override
    public void close(Channel channel) {
        try {
            channel.unsafeChannel().unsafeClose((Option<Throwable>)None$.MODULE$);
        }
        catch (Throwable t) {
            channel.executorAddress().inform(ReactorEvent$ChannelClose$.MODULE$.apply(channel, (Option<Throwable>)Some$.MODULE$.apply((Object)t)));
        }
    }

    @Override
    public void read(Channel channel, ReadPlan plan) {
        channel.unsafeChannel().unsafeRead(plan);
    }

    @Override
    public void flush(Channel channel, Object payload) {
        channel.unsafeChannel().unsafeFlush(payload);
    }

    @Override
    public void wakeup() {
        if (this.wakenUp.compareAndSet(true, false)) {
            this.selector.wakeup();
            return;
        }
    }

    @Override
    public boolean isCompatible(Class<? extends Channel> handleType) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public int cc$otavia$core$transport$reactor$nio$NioHandler$$selectNow() throws IOException {
        return this.selector.selectNow();
    }

    private void select(IoExecutionContext runner) throws IOException {
        Selector selector = this.selector;
        try {
            int selectCnt = 0;
            boolean bl = false;
            int blocks = 0;
            while (!bl) {
                int n;
                if (!runner.canBlock()) {
                    selector.selectNow();
                    selectCnt = 1;
                    bl = true;
                    continue;
                }
                long currentTimeMillis = System.currentTimeMillis();
                if (blocks > 10) {
                    if (!this.wakenUp.get()) {
                        this.wakenUp.compareAndSet(false, true);
                    }
                    n = 200 * blocks;
                } else {
                    n = 0;
                }
                int timeoutMillis = n;
                int selectedKeys = timeoutMillis != 0 ? selector.select(Int$.MODULE$.int2long(timeoutMillis)) : selector.selectNow();
                ++selectCnt;
                ++blocks;
                if (selectedKeys != 0 || !runner.canBlock()) {
                    bl = true;
                    continue;
                }
                long time = System.currentTimeMillis();
                if (time - (long)timeoutMillis >= currentTimeMillis) {
                    selectCnt = 1;
                    continue;
                }
                if (NioHandler$.cc$otavia$core$transport$reactor$nio$NioHandler$$$SELECTOR_AUTO_REBUILD_THRESHOLD <= 0 || selectCnt < NioHandler$.cc$otavia$core$transport$reactor$nio$NioHandler$$$SELECTOR_AUTO_REBUILD_THRESHOLD) continue;
                selector = this.selectRebuildSelector(selectCnt);
                selectCnt = 1;
                bl = true;
            }
            if (selectCnt > NioHandler$.cc$otavia$core$transport$reactor$nio$NioHandler$$$MIN_PREMATURE_SELECTOR_RETURNS) {
                this.logger.debug(new StringBuilder(69).append("Selector.select() returned prematurely ").append(selectCnt - 1).append(" times in a row for Selector ").append(selector).append(".").toString());
            }
        }
        catch (CancelledKeyException e) {
            String trace = ThrowableUtil$.MODULE$.stackTraceToString((Throwable)e);
            this.logger.debug(new StringBuilder(33).append(CancelledKeyException.class.getSimpleName()).append(" raised by a Selector ").append(trace).append(" - JDK bug?").toString());
        }
    }

    private Selector selectRebuildSelector(int selectCnt) throws IOException {
        this.logger.warn(new StringBuilder(77).append("Selector.select() returned prematurely ").append(selectCnt).append(" times in a row; rebuilding Selector ").append(this.selector).append(".").toString());
        this.rebuildSelector();
        Selector selector = this.selector;
        selector.selectNow();
        return selector;
    }

    private void selectAgain() {
        try {
            this.needsToSelectAgain = false;
            this.selector.selectNow();
        }
        catch (Throwable t) {
            String trace = ThrowableUtil$.MODULE$.stackTraceToString(t);
            this.logger.warn(new StringBuilder(32).append("Failed to update SelectionKeys. ").append(trace).toString());
        }
    }

    private static final Class openSelector$$anonfun$1() {
        return Class.forName("sun.nio.ch.SelectorImpl", false, Platform$.MODULE$.getSystemClassLoader());
    }

    private static final void openSelector$$anonfun$2(AbstractSelector unwrappedSelector$1, Class selectorImplClass$1, SelectedSelectionKeySet selectedKeySet$1) {
        Field selectedKeysField = selectorImplClass$1.getDeclaredField("selectedKeys");
        Field publicSelectedKeysField = selectorImplClass$1.getDeclaredField("publicSelectedKeys");
        boolean success = false;
        if (Platform$.MODULE$.hasUnsafe()) {
            long selectedKeysFieldOffset = Platform$.MODULE$.objectFieldOffset(selectedKeysField);
            long publicSelectedKeysFieldOffset = Platform$.MODULE$.objectFieldOffset(publicSelectedKeysField);
            if (selectedKeysFieldOffset != -1L && publicSelectedKeysFieldOffset != -1L) {
                Platform$.MODULE$.putObject((Object)unwrappedSelector$1, selectedKeysFieldOffset, (Object)selectedKeySet$1);
                Platform$.MODULE$.putObject((Object)unwrappedSelector$1, publicSelectedKeysFieldOffset, (Object)selectedKeySet$1);
                success = true;
            }
        }
        if (!success) {
            Option option = ReflectionUtil$.MODULE$.trySetAccessible((AccessibleObject)selectedKeysField, true);
            if (option instanceof Some) {
                Throwable cause = (Throwable)((Some)option).value();
                throw cause;
            }
            if (!None$.MODULE$.equals(option)) {
                throw new MatchError((Object)option);
            }
            Option option2 = ReflectionUtil$.MODULE$.trySetAccessible((AccessibleObject)publicSelectedKeysField, true);
            if (option2 instanceof Some) {
                Throwable cause = (Throwable)((Some)option2).value();
                throw cause;
            }
            if (!None$.MODULE$.equals(option2)) {
                throw new MatchError((Object)option2);
            }
            selectedKeysField.set(unwrappedSelector$1, selectedKeySet$1);
            publicSelectedKeysField.set(unwrappedSelector$1, selectedKeySet$1);
            return;
        }
    }

    private final SelectorTuple rebuildSelector$$anonfun$1() {
        return this.openSelector();
    }

    public static final class SelectorTuple
    implements Product,
    Serializable {
        private final Selector unwrappedSelector;
        private final Selector selector;

        public static SelectorTuple apply(Selector selector) {
            return NioHandler$SelectorTuple$.MODULE$.apply(selector);
        }

        public static SelectorTuple apply(Selector selector, Selector selector2) {
            return NioHandler$SelectorTuple$.MODULE$.apply(selector, selector2);
        }

        public static SelectorTuple fromProduct(Product product) {
            return NioHandler$SelectorTuple$.MODULE$.fromProduct(product);
        }

        public static SelectorTuple unapply(SelectorTuple selectorTuple) {
            return NioHandler$SelectorTuple$.MODULE$.unapply(selectorTuple);
        }

        public SelectorTuple(Selector unwrappedSelector, Selector selector) {
            this.unwrappedSelector = unwrappedSelector;
            this.selector = selector;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SelectorTuple)) return false;
            SelectorTuple selectorTuple = (SelectorTuple)object;
            Selector selector = this.unwrappedSelector();
            Selector selector2 = selectorTuple.unwrappedSelector();
            if (selector == null) {
                if (selector2 != null) {
                    return false;
                }
            } else if (!selector.equals(selector2)) return false;
            Selector selector3 = this.selector();
            Selector selector4 = selectorTuple.selector();
            if (selector3 == null) {
                if (selector4 == null) return true;
                return false;
            } else {
                if (!selector3.equals(selector4)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SelectorTuple;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "SelectorTuple";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "unwrappedSelector";
            }
            if (1 == n2) {
                return "selector";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Selector unwrappedSelector() {
            return this.unwrappedSelector;
        }

        public Selector selector() {
            return this.selector;
        }

        public SelectorTuple(Selector unwrappedSelector) {
            this(unwrappedSelector, unwrappedSelector);
        }

        public SelectorTuple copy(Selector unwrappedSelector, Selector selector) {
            return new SelectorTuple(unwrappedSelector, selector);
        }

        public Selector copy$default$1() {
            return this.unwrappedSelector();
        }

        public Selector copy$default$2() {
            return this.selector();
        }

        public Selector _1() {
            return this.unwrappedSelector();
        }

        public Selector _2() {
            return this.selector();
        }
    }
}

