/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.transport.reactor.nio;

import cc.otavia.core.reactor.IoHandler;
import cc.otavia.core.reactor.IoHandlerFactory;
import cc.otavia.core.reactor.LoopExecutor$;
import cc.otavia.core.reactor.Reactor;
import cc.otavia.core.slf4a.Logger;
import cc.otavia.core.slf4a.Logger$;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.transport.TransportFactory;
import cc.otavia.core.transport.reactor.nio.NioHandler;
import cc.otavia.core.transport.reactor.nio.NioReactor$;
import cc.otavia.core.transport.reactor.nio.NioReactorWorker;
import java.io.Serializable;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.math.package$;
import scala.runtime.java8.JFunction1;

public class NioReactor
extends AtomicInteger
implements Reactor {
    private final ActorSystem system;
    private final TransportFactory transportFactory;
    private final int maxTasksPerRun;
    private final NioThreadFactory threadFactory;
    private final NioReactorWorker[] workers;

    public static int NIO_REACTOR_WORKERS() {
        return NioReactor$.MODULE$.NIO_REACTOR_WORKERS();
    }

    public static int $lessinit$greater$default$3() {
        return NioReactor$.MODULE$.$lessinit$greater$default$3();
    }

    public NioReactor(ActorSystem system, TransportFactory transportFactory, int maxTasksPerRun) {
        this.system = system;
        this.transportFactory = transportFactory;
        this.maxTasksPerRun = maxTasksPerRun;
        Logger logger = Logger$.MODULE$.getLogger(this.getClass(), system);
        this.threadFactory = new NioThreadFactory();
        this.workers = new NioReactorWorker[NioReactor$.MODULE$.NIO_REACTOR_WORKERS()];
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.workers);
        ArrayOps$.MODULE$.indices$extension(object).foreach((Function1)(JFunction1.mcVI.sp & Serializable)idx -> {
            this.workers[idx] = new NioReactorWorker(LoopExecutor$.MODULE$.apply(this.threadFactory), system, maxTasksPerRun, new IoHandlerFactory(this){
                private final /* synthetic */ NioReactor $outer;
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public IoHandler newHandler() {
                    return new NioHandler(this.$outer.system());
                }
            });
        });
    }

    public ActorSystem system() {
        return this.system;
    }

    public TransportFactory transportFactory() {
        return this.transportFactory;
    }

    public int maxTasksPerRun() {
        return this.maxTasksPerRun;
    }

    @Override
    public void submit(Reactor.Command command) {
        int idx = package$.MODULE$.abs(command.channel().hashCode()) % NioReactor$.MODULE$.NIO_REACTOR_WORKERS();
        NioReactorWorker worker = this.workers[idx];
        worker.submitCommand(command);
    }

    public static final class NioThreadFactory
    implements ThreadFactory {
        private final AtomicInteger tid = new AtomicInteger(0);

        private int getThreadId() {
            int cid = this.tid.get();
            while (!this.tid.compareAndSet(cid, cid + 1)) {
                cid = this.tid.get();
            }
            return cid;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, new StringBuilder(19).append("otavia-reactor-nio-").append(this.getThreadId()).toString());
            try {
                if (thread.isDaemon()) {
                    thread.setDaemon(false);
                }
                if (thread.getPriority() != 5) {
                    thread.setPriority(5);
                }
            }
            catch (Exception exception) {}
            return thread;
        }
    }
}

