/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.transport.reactor.nio;

import cc.otavia.core.channel.Channel;
import cc.otavia.core.channel.message.ReadPlan;
import cc.otavia.core.reactor.IoExecutionContext;
import cc.otavia.core.reactor.IoHandler;
import cc.otavia.core.reactor.IoHandlerFactory;
import cc.otavia.core.reactor.Reactor;
import cc.otavia.core.reactor.Reactor$Command$Bind$;
import cc.otavia.core.reactor.Reactor$Command$Close$;
import cc.otavia.core.reactor.Reactor$Command$Connect$;
import cc.otavia.core.reactor.Reactor$Command$Disconnect$;
import cc.otavia.core.reactor.Reactor$Command$Flush$;
import cc.otavia.core.reactor.Reactor$Command$Open$;
import cc.otavia.core.reactor.Reactor$Command$Read$;
import cc.otavia.core.slf4a.Logger;
import cc.otavia.core.slf4a.Logger$;
import cc.otavia.core.system.ActorSystem;
import cc.otavia.core.transport.reactor.nio.NioReactorWorker$;
import cc.otavia.core.util.SpinLockQueue;
import java.net.SocketAddress;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.Seq;
import scala.runtime.Scala3RunTime$;

public class NioReactorWorker
extends AtomicInteger {
    private final Executor executor;
    private final ActorSystem system;
    private final int maxTasksPerRun;
    private final IoHandlerFactory ioHandlerFactory;
    private final Logger logger;
    public final SpinLockQueue<Reactor.Command> cc$otavia$core$transport$reactor$nio$NioReactorWorker$$commandQueue;
    private Thread thread;
    private final IoExecutionContext context;
    private IoHandler ioHandler;

    public NioReactorWorker(Executor executor, ActorSystem system, int maxTasksPerRun, IoHandlerFactory ioHandlerFactory) {
        this.executor = executor;
        this.system = system;
        this.maxTasksPerRun = maxTasksPerRun;
        this.ioHandlerFactory = ioHandlerFactory;
        this.logger = Logger$.MODULE$.getLogger(this.getClass(), system);
        this.cc$otavia$core$transport$reactor$nio$NioReactorWorker$$commandQueue = new SpinLockQueue();
        this.context = new IoExecutionContext(this){
            private final /* synthetic */ NioReactorWorker $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public boolean canBlock() {
                return this.$outer.cc$otavia$core$transport$reactor$nio$NioReactorWorker$$commandQueue.isEmpty();
            }

            public long delayNanos(long currentTimeNanos) {
                if (this.$outer.cc$otavia$core$transport$reactor$nio$NioReactorWorker$$commandQueue.isEmpty()) {
                    return 10000000L;
                }
                return 0L;
            }

            public long deadlineNanos() {
                throw Predef$.MODULE$.$qmark$qmark$qmark();
            }
        };
        this.set(NioReactorWorker$.cc$otavia$core$transport$reactor$nio$NioReactorWorker$$$ST_NOT_STARTED);
    }

    public Executor executor() {
        return this.executor;
    }

    public ActorSystem system() {
        return this.system;
    }

    public int maxTasksPerRun() {
        return this.maxTasksPerRun;
    }

    public IoHandlerFactory ioHandlerFactory() {
        return this.ioHandlerFactory;
    }

    public void submitCommand(Reactor.Command command) {
        this.cc$otavia$core$transport$reactor$nio$NioReactorWorker$$commandQueue.enqueue(command);
        this.startThread();
    }

    private void startThread() {
        if (this.get() == NioReactorWorker$.cc$otavia$core$transport$reactor$nio$NioReactorWorker$$$ST_NOT_STARTED && this.compareAndSet(NioReactorWorker$.cc$otavia$core$transport$reactor$nio$NioReactorWorker$$$ST_NOT_STARTED, NioReactorWorker$.cc$otavia$core$transport$reactor$nio$NioReactorWorker$$$ST_STARTED)) {
            boolean success = false;
            try {
                this.doStartThread();
                success = true;
            }
            finally {
                if (!success) {
                    this.compareAndSet(NioReactorWorker$.cc$otavia$core$transport$reactor$nio$NioReactorWorker$$$ST_STARTED, NioReactorWorker$.cc$otavia$core$transport$reactor$nio$NioReactorWorker$$$ST_NOT_STARTED);
                }
            }
            return;
        }
        if (this.get() == NioReactorWorker$.cc$otavia$core$transport$reactor$nio$NioReactorWorker$$$ST_STARTED) {
            this.ioHandler.wakeup();
            return;
        }
    }

    private void doStartThread() {
        if (this.thread != null) {
            throw Scala3RunTime$.MODULE$.assertFailed();
        }
        this.executor().execute(() -> {
            this.thread = Thread.currentThread();
            this.ioHandler = this.ioHandlerFactory().newHandler();
            try {
                this.run();
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.logger.warn("Unexpected exception from an event executor:", t);
            }
        });
    }

    private void run() {
        while (!this.confirmShutdown()) {
            this.runIO();
            this.runCommands(this.maxTasksPerRun());
        }
    }

    private void runIO() {
        this.ioHandler.run(this.context);
    }

    private boolean hasTask() {
        return this.cc$otavia$core$transport$reactor$nio$NioReactorWorker$$commandQueue.nonEmpty();
    }

    private int runCommands(int maxTasks) {
        int processedTasks;
        for (processedTasks = 0; processedTasks < maxTasks && this.cc$otavia$core$transport$reactor$nio$NioReactorWorker$$commandQueue.nonEmpty(); ++processedTasks) {
            this.runCommand((Reactor.Command)this.cc$otavia$core$transport$reactor$nio$NioReactorWorker$$commandQueue.dequeue());
        }
        if (processedTasks > 0 && this.logger.isDebugEnabled()) {
            this.logger.debug(new StringBuilder(26).append("processed ").append(processedTasks).append(" reactor command").toString());
        }
        return processedTasks;
    }

    private void runCommand(Reactor.Command command) {
        Reactor.Command command2 = command;
        if (command2 instanceof Reactor.Command.Register) {
            Reactor.Command.Register register = (Reactor.Command.Register)command2;
            this.ioHandler.register(register.channel());
            return;
        }
        if (command2 instanceof Reactor.Command.Deregister) {
            Reactor.Command.Deregister deregister = (Reactor.Command.Deregister)command2;
            this.ioHandler.deregister(deregister.channel());
            return;
        }
        if (command2 instanceof Reactor.Command.Bind) {
            Reactor.Command.Bind bind = Reactor$Command$Bind$.MODULE$.unapply((Reactor.Command.Bind)command2);
            Channel channel = bind._1();
            SocketAddress socketAddress = bind._2();
            Channel channel2 = channel;
            SocketAddress local = socketAddress;
            this.ioHandler.bind(channel2, local);
            return;
        }
        if (command2 instanceof Reactor.Command.Open) {
            Reactor.Command.Open open = Reactor$Command$Open$.MODULE$.unapply((Reactor.Command.Open)command2);
            Channel channel = open._1();
            Path path = open._2();
            Seq<OpenOption> seq = open._3();
            Seq<FileAttribute<?>> seq2 = open._4();
            Channel channel3 = channel;
            Path path2 = path;
            Seq<OpenOption> options = seq;
            Seq<FileAttribute<?>> attrs = seq2;
            this.ioHandler.open(channel3, path2, options, attrs);
            return;
        }
        if (command2 instanceof Reactor.Command.Connect) {
            Reactor.Command.Connect connect = Reactor$Command$Connect$.MODULE$.unapply((Reactor.Command.Connect)command2);
            Channel channel = connect._1();
            SocketAddress socketAddress = connect._2();
            Option<SocketAddress> option = connect._3();
            boolean bl = connect._4();
            Channel channel4 = channel;
            SocketAddress remote = socketAddress;
            Option<SocketAddress> local = option;
            boolean fastOpen = bl;
            this.ioHandler.connect(channel4, remote, local, fastOpen);
            return;
        }
        if (command2 instanceof Reactor.Command.Read) {
            Reactor.Command.Read read = Reactor$Command$Read$.MODULE$.unapply((Reactor.Command.Read)command2);
            Channel channel = read._1();
            ReadPlan readPlan = read._2();
            Channel channel5 = channel;
            ReadPlan plan = readPlan;
            this.ioHandler.read(channel5, plan);
            return;
        }
        if (command2 instanceof Reactor.Command.Flush) {
            Reactor.Command.Flush flush = Reactor$Command$Flush$.MODULE$.unapply((Reactor.Command.Flush)command2);
            Channel channel = flush._1();
            Object object = flush._2();
            Channel channel6 = channel;
            Object payload = object;
            this.ioHandler.flush(channel6, payload);
            return;
        }
        if (command2 instanceof Reactor.Command.Disconnect) {
            Channel channel;
            Reactor.Command.Disconnect disconnect = Reactor$Command$Disconnect$.MODULE$.unapply((Reactor.Command.Disconnect)command2);
            Channel channel7 = channel = disconnect._1();
            this.ioHandler.disconnect(channel7);
            return;
        }
        if (command2 instanceof Reactor.Command.Close) {
            Channel channel;
            Reactor.Command.Close close = Reactor$Command$Close$.MODULE$.unapply((Reactor.Command.Close)command2);
            Channel channel8 = channel = close._1();
            this.ioHandler.close(channel8);
            return;
        }
        throw new MatchError((Object)command2);
    }

    private boolean confirmShutdown() {
        return false;
    }
}

