/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.util;

import cc.otavia.core.util.Nextable;

public class Queue<T extends Nextable> {
    private int size = 0;
    private volatile Nextable head;
    private volatile Nextable tail;

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean nonEmpty() {
        return this.size > 0;
    }

    public int length() {
        return this.size;
    }

    public final void enqueue(T value) {
        if (this.size == 0) {
            this.head = value;
            this.tail = value;
            ++this.size;
            return;
        }
        this.tail.next_$eq((Nextable)value);
        ++this.size;
    }

    public final Nextable dequeue() {
        if (this.size == 0) {
            return null;
        }
        if (this.size == 1) {
            Nextable value = this.head;
            this.head = null;
            this.tail = null;
            --this.size;
            return value;
        }
        Nextable value = this.head;
        this.head = value.next();
        value.dechain();
        --this.size;
        return value;
    }
}

