/*
 * Decompiled with CFR 0.152.
 */
package cc.otavia.core.util;

import cc.otavia.core.util.Nextable;
import cc.otavia.core.util.SpinLock;
import java.util.concurrent.atomic.AtomicInteger;

public class SpinLockQueue<T extends Nextable> {
    private final SpinLock readLock = new SpinLock();
    private final SpinLock writeLock = new SpinLock();
    private final AtomicInteger size = new AtomicInteger(0);
    private volatile Nextable head;
    private volatile Nextable tail;

    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    public boolean nonEmpty() {
        return this.size.get() > 0;
    }

    public int length() {
        return this.size.get();
    }

    public void enqueue(T instance) {
        this.writeLock.lock();
        if (this.size.get() == 0) {
            this.readLock.lock();
            this.head = instance;
            this.tail = instance;
            this.size.incrementAndGet();
            this.writeLock.unlock();
            this.readLock.unlock();
            return;
        }
        this.tail.next_$eq((Nextable)instance);
        this.tail = instance;
        this.size.incrementAndGet();
        this.writeLock.unlock();
    }

    public final Nextable dequeue() {
        if (this.size.get() == 0) {
            return null;
        }
        return this.dequeue0();
    }

    private final Nextable dequeue0() {
        if (this.size.get() == 0) {
            return null;
        }
        if (this.size.get() == 1) {
            this.writeLock.lock();
            this.readLock.lock();
            if (this.size.get() == 1) {
                Nextable value = this.head;
                this.head = null;
                this.tail = null;
                this.size.decrementAndGet();
                this.writeLock.unlock();
                this.readLock.unlock();
                return value;
            }
            this.writeLock.unlock();
            Nextable value = this.cc$otavia$core$util$SpinLockQueue$$inline$head();
            this.cc$otavia$core$util$SpinLockQueue$$inline$head_$eq(value.next());
            this.cc$otavia$core$util$SpinLockQueue$$inline$size().decrementAndGet();
            this.cc$otavia$core$util$SpinLockQueue$$inline$readLock().unlock();
            value.dechain();
            return value;
        }
        this.readLock.lock();
        Nextable value = this.cc$otavia$core$util$SpinLockQueue$$inline$head();
        this.cc$otavia$core$util$SpinLockQueue$$inline$head_$eq(value.next());
        this.cc$otavia$core$util$SpinLockQueue$$inline$size().decrementAndGet();
        this.cc$otavia$core$util$SpinLockQueue$$inline$readLock().unlock();
        value.dechain();
        return value;
    }

    public final Nextable cc$otavia$core$util$SpinLockQueue$$inline$head() {
        return this.head;
    }

    public final void cc$otavia$core$util$SpinLockQueue$$inline$head_$eq(Nextable x$0) {
        this.head = x$0;
    }

    public final AtomicInteger cc$otavia$core$util$SpinLockQueue$$inline$size() {
        return this.size;
    }

    public final SpinLock cc$otavia$core$util$SpinLockQueue$$inline$readLock() {
        return this.readLock;
    }
}

