/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings;

import cc.redberry.rings.FactorDecomposition;
import cc.redberry.rings.Ring;
import cc.redberry.rings.bigint.BigInteger;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import org.apache.commons.math3.random.RandomGenerator;

public class ImageRing<F, I>
implements Ring<I> {
    public final Ring<F> ring;
    public final Function<F, I> imageFunc;
    public final Function<I, F> inverseFunc;

    public ImageRing(Ring<F> ring, Function<I, F> inverseFunc, Function<F, I> imageFunc) {
        this.ring = ring;
        this.inverseFunc = inverseFunc;
        this.imageFunc = imageFunc;
    }

    public I image(F el) {
        return this.imageFunc.apply(el);
    }

    public I[] image(F[] el) {
        int[] array = this.createArray(el.length);
        for (int i = 0; i < array.length; ++i) {
            array[i] = (int)this.image(el[i]);
        }
        return array;
    }

    public F inverse(I el) {
        return this.inverseFunc.apply(el);
    }

    public F[] inverse(I[] el) {
        int[] array = this.ring.createArray((F)el.length);
        for (int i = 0; i < array.length; ++i) {
            array[i] = (int)this.inverse(el[i]);
        }
        return array;
    }

    @Override
    public boolean isField() {
        return this.ring.isField();
    }

    @Override
    public boolean isEuclideanRing() {
        return this.ring.isEuclideanRing();
    }

    @Override
    public BigInteger cardinality() {
        return this.ring.cardinality();
    }

    @Override
    public BigInteger characteristic() {
        return this.ring.characteristic();
    }

    @Override
    public boolean isPerfectPower() {
        return this.ring.isPerfectPower();
    }

    @Override
    public BigInteger perfectPowerBase() {
        return this.ring.perfectPowerBase();
    }

    @Override
    public BigInteger perfectPowerExponent() {
        return this.ring.perfectPowerExponent();
    }

    @Override
    public I add(I a, I b) {
        return this.image(this.ring.add(this.inverse(a), this.inverse(b)));
    }

    @Override
    public I subtract(I a, I b) {
        return this.image(this.ring.subtract(this.inverse(a), this.inverse(b)));
    }

    @Override
    public I multiply(I a, I b) {
        return this.image(this.ring.multiply(this.inverse(a), this.inverse(b)));
    }

    @Override
    public I negate(I element) {
        return this.image(this.ring.negate(this.inverse(element)));
    }

    @Override
    public I increment(I element) {
        return this.image(this.ring.increment(this.inverse(element)));
    }

    @Override
    public I decrement(I element) {
        return this.image(this.ring.decrement(this.inverse(element)));
    }

    @Override
    public I add(I ... elements) {
        return this.image(this.ring.add(this.inverse(elements)));
    }

    @Override
    public I multiply(I ... elements) {
        return this.image(this.ring.multiply(this.inverse(elements)));
    }

    @Override
    public I abs(I el) {
        return this.image(this.ring.abs(this.inverse(el)));
    }

    @Override
    public I copy(I element) {
        return element;
    }

    @Override
    public I[] divideAndRemainder(I dividend, I divider) {
        return this.image(this.ring.divideAndRemainder(this.inverse(dividend), this.inverse(divider)));
    }

    @Override
    public I quotient(I dividend, I divider) {
        return this.image(this.ring.quotient(this.inverse(dividend), this.inverse(divider)));
    }

    @Override
    public I remainder(I dividend, I divider) {
        return this.image(this.ring.remainder(this.inverse(dividend), this.inverse(divider)));
    }

    @Override
    public I reciprocal(I element) {
        return this.image(this.ring.reciprocal(this.inverse(element)));
    }

    @Override
    public I getZero() {
        return this.image(this.ring.getZero());
    }

    @Override
    public I getOne() {
        return this.image(this.ring.getOne());
    }

    @Override
    public boolean isZero(I element) {
        return this.ring.isZero(this.inverse(element));
    }

    @Override
    public boolean isOne(I element) {
        return this.ring.isOne(this.inverse(element));
    }

    @Override
    public boolean isUnit(I element) {
        return this.ring.isUnit(this.inverse(element));
    }

    @Override
    public I valueOf(long val) {
        return this.image(this.ring.valueOf((F)val));
    }

    @Override
    public I valueOfBigInteger(BigInteger val) {
        return this.image(this.ring.valueOfBigInteger(val));
    }

    @Override
    public I valueOf(I val) {
        return this.image(this.ring.valueOf(this.inverse(val)));
    }

    @Override
    public Iterator<I> iterator() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.ring.iterator(), 16), false).map(this::image).iterator();
    }

    @Override
    public I gcd(I a, I b) {
        return this.image(this.ring.gcd(this.inverse(a), this.inverse(b)));
    }

    @Override
    public I[] extendedGCD(I a, I b) {
        return this.image(this.ring.extendedGCD(this.inverse(a), this.inverse(b)));
    }

    @Override
    public I lcm(I a, I b) {
        return this.image(this.ring.lcm(this.inverse(a), this.inverse(b)));
    }

    @Override
    public I gcd(I ... elements) {
        return this.image(this.ring.gcd(this.inverse(elements)));
    }

    @Override
    public I gcd(Iterable<I> elements) {
        return this.image(this.ring.gcd(() -> StreamSupport.stream(elements.spliterator(), false).map(this::inverse).iterator()));
    }

    @Override
    public int signum(I element) {
        return this.ring.signum(this.inverse(element));
    }

    @Override
    public FactorDecomposition<I> factorSquareFree(I element) {
        return this.ring.factorSquareFree(this.inverse(element)).mapTo(this, this::image);
    }

    @Override
    public FactorDecomposition<I> factor(I element) {
        return this.ring.factor(this.inverse(element)).mapTo(this, this::image);
    }

    @Override
    public I parse(String string) {
        return this.image(this.ring.parse(string));
    }

    @Override
    public I pow(I base, int exponent) {
        return this.image(this.ring.pow(this.inverse(base), exponent));
    }

    @Override
    public I pow(I base, long exponent) {
        return this.image(this.ring.pow(this.inverse(base), exponent));
    }

    @Override
    public I pow(I base, BigInteger exponent) {
        return this.image(this.ring.pow(this.inverse(base), exponent));
    }

    @Override
    public I factorial(long num) {
        return this.image(this.ring.factorial(num));
    }

    @Override
    public I randomElement(RandomGenerator rnd) {
        return this.image(this.ring.randomElement(rnd));
    }

    @Override
    public int compare(I o1, I o2) {
        return this.ring.compare(this.inverse(o1), this.inverse(o2));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImageRing that = (ImageRing)o;
        if (!this.ring.equals(that.ring)) {
            return false;
        }
        if (!this.inverseFunc.equals(that.inverseFunc)) {
            return false;
        }
        return this.imageFunc.equals(that.imageFunc);
    }

    public int hashCode() {
        int result = this.ring.hashCode();
        result = 31 * result + this.inverseFunc.hashCode();
        result = 31 * result + this.imageFunc.hashCode();
        return result;
    }
}

