/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings;

import cc.redberry.libdivide4j.FastDivision;
import cc.redberry.rings.IntegersZp;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.poly.MachineArithmetic;
import java.io.Serializable;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well44497b;

public final class IntegersZp64
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final long modulus;
    public final FastDivision.Magic magic;
    public final FastDivision.Magic magic32MulMod;
    public final boolean modulusFits32;
    private volatile int[] cachedReciprocals = null;
    private final long[] perfectPowerDecomposition = new long[]{-1L, -1L};
    private IntegersZp64 ppBaseDomain = null;

    public IntegersZp64(long modulus, FastDivision.Magic magic, FastDivision.Magic magic32MulMod, boolean modulusFits32) {
        this.modulus = modulus;
        this.magic = magic;
        this.magic32MulMod = magic32MulMod;
        this.modulusFits32 = modulusFits32;
    }

    public IntegersZp64(long modulus) {
        this(modulus, FastDivision.magicSigned((long)modulus), FastDivision.magic32ForMultiplyMod((long)modulus), MachineArithmetic.fits31bitWord(modulus));
    }

    public long modulus(long val) {
        return FastDivision.modSignedFast((long)val, (FastDivision.Magic)this.magic);
    }

    public long modulus(BigInteger val) {
        return val.isLong() ? FastDivision.modSignedFast((long)val.longValue(), (FastDivision.Magic)this.magic) : val.mod(BigInteger.valueOf(this.modulus)).longValue();
    }

    public void modulus(long[] data) {
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.modulus(data[i]);
        }
    }

    public long multiply(long a, long b) {
        return this.modulusFits32 ? this.modulus(a * b) : FastDivision.multiplyMod128Unsigned((long)a, (long)b, (long)this.modulus, (FastDivision.Magic)this.magic32MulMod);
    }

    public long add(long a, long b) {
        long r = a + b;
        return r - this.modulus >= 0L ? r - this.modulus : r;
    }

    public long subtract(long a, long b) {
        long r = a - b;
        return r + (r >> 63 & this.modulus);
    }

    public long divide(long a, long b) {
        return this.multiply(a, this.reciprocal(b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildCachedReciprocals() {
        if (this.cachedReciprocals != null) {
            return;
        }
        IntegersZp64 integersZp64 = this;
        synchronized (integersZp64) {
            if (this.cachedReciprocals == null) {
                int[] cachedReciprocals = new int[MachineArithmetic.safeToInt(this.modulus)];
                for (int val = 1; val < cachedReciprocals.length; ++val) {
                    cachedReciprocals[val] = (int)MachineArithmetic.modInverse(val, this.modulus);
                }
                this.cachedReciprocals = cachedReciprocals;
            }
        }
    }

    public long reciprocal(long val) {
        return this.cachedReciprocals == null ? MachineArithmetic.modInverse(val, this.modulus) : (val < (long)this.cachedReciprocals.length ? (long)this.cachedReciprocals[(int)val] : MachineArithmetic.modInverse(val, this.modulus));
    }

    public long negate(long val) {
        return val == 0L ? val : this.modulus - val;
    }

    public long symmetricForm(long value) {
        return value <= this.modulus / 2L ? value : value - this.modulus;
    }

    public IntegersZp asGenericRing() {
        return new IntegersZp(this.modulus);
    }

    public long powMod(long base, long exponent) {
        if (exponent < 0L) {
            throw new IllegalArgumentException();
        }
        if (exponent == 0L) {
            return 1L;
        }
        long result = 1L;
        long k2p = base;
        while (true) {
            if ((exponent & 1L) != 0L) {
                result = this.multiply(result, k2p);
            }
            if ((exponent >>= 1) == 0L) {
                return result;
            }
            k2p = this.multiply(k2p, k2p);
        }
    }

    public long randomElement(RandomGenerator rnd) {
        return this.modulus(rnd.nextLong());
    }

    public long randomElement() {
        return this.randomElement((RandomGenerator)new Well44497b(System.nanoTime()));
    }

    public long randomNonZeroElement(RandomGenerator rnd) {
        long el;
        while ((el = this.randomElement(rnd)) == 0L) {
        }
        return el;
    }

    public long factorial(int value) {
        long result = 1L;
        for (int i = 2; i <= value; ++i) {
            result = this.multiply(result, i);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkPerfectPower() {
        if (this.perfectPowerDecomposition[0] != -1L) return;
        long[] lArray = this.perfectPowerDecomposition;
        synchronized (this.perfectPowerDecomposition) {
            if (this.perfectPowerDecomposition[0] != -1L) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            long[] ipp = MachineArithmetic.perfectPowerDecomposition(this.modulus);
            if (ipp == null) {
                this.perfectPowerDecomposition[0] = this.modulus;
                this.perfectPowerDecomposition[1] = 1L;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.perfectPowerDecomposition[0] = ipp[0];
            this.perfectPowerDecomposition[1] = ipp[1];
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public boolean isPerfectPower() {
        return this.perfectPowerExponent() > 1L;
    }

    public long perfectPowerBase() {
        this.checkPerfectPower();
        return this.perfectPowerDecomposition[0];
    }

    public long perfectPowerExponent() {
        this.checkPerfectPower();
        return this.perfectPowerDecomposition[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntegersZp64 perfectPowerBaseDomain() {
        if (this.ppBaseDomain == null) {
            IntegersZp64 integersZp64 = this;
            synchronized (integersZp64) {
                if (this.ppBaseDomain == null) {
                    long base = this.perfectPowerBase();
                    this.ppBaseDomain = base == -1L ? this : new IntegersZp64(base);
                }
            }
        }
        return this.ppBaseDomain;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntegersZp64 that = (IntegersZp64)o;
        return this.modulus == that.modulus;
    }

    public String toString() {
        return "Z/" + this.modulus;
    }

    public int hashCode() {
        return (int)(this.modulus ^ this.modulus >>> 32);
    }
}

