/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings;

import cc.redberry.rings.AIntegers;
import cc.redberry.rings.FactorDecomposition;
import cc.redberry.rings.Ring;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.io.Stringifiable;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.UnivariateRing;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Rational<E>
implements Comparable<Rational<E>>,
Stringifiable<Rational<E>>,
Serializable {
    private static final long serialVersionUID = 1L;
    public final Ring<E> ring;
    final Operand numerator;
    final Operand denominator;
    private final Predicate<E> simplicityCriteria;
    private static final int SIMPLE_UPOLY_SIZE = 8;
    private static final int SIMPLE_MPOLY_DENSE_SIZE = 3;
    private static final int SIMPLE_MPOLY_SPARSE_SIZE = 16;
    private static final double SIMPLE_POLY_SPARSITY2 = 0.001;
    private static final int SIMPLE_INTEGER_N_BITS = 512;
    private static final Predicate<BigInteger> intSimplicityCriteria = (Predicate<BigInteger> & Serializable)p -> p.bitLength() <= 512;
    private static final Predicate<IUnivariatePolynomial> upolySimplicityCriteria = (Predicate<IUnivariatePolynomial> & Serializable)p -> p.size() <= 8;
    private static final Predicate<AMultivariatePolynomial> mpolySimplicityCriteria = (Predicate<AMultivariatePolynomial> & Serializable)p -> p.size() <= 3 || p.size() < 16 && p.sparsity2() < 0.001;
    private static final Predicate defaultFalse = (Predicate<Object> & Serializable)__ -> false;

    public Rational(Ring<E> ring, E numerator) {
        this.ring = ring;
        this.simplicityCriteria = Rational.simplicityCriteria(ring);
        this.numerator = new Operand(numerator);
        this.denominator = new Operand(ring.getOne());
    }

    public Rational(Ring<E> ring, E numerator, E denominator) {
        E gcd;
        if (ring.isZero(denominator)) {
            throw new ArithmeticException("division by zero");
        }
        if (!ring.isZero(numerator) && !ring.isUnit(gcd = ring.gcd(numerator, denominator))) {
            numerator = ring.divideExact(numerator, gcd);
            denominator = ring.divideExact(denominator, gcd);
        }
        this.ring = ring;
        this.simplicityCriteria = Rational.simplicityCriteria(ring);
        Operand[] numden = new Operand[]{new Operand(numerator), new Operand(denominator)};
        this.normalize(numden);
        this.numerator = numden[0];
        this.denominator = numden[1];
    }

    Rational(Ring<E> ring, Operand numerator, Operand denominator) {
        if (denominator.isZero()) {
            throw new ArithmeticException("division by zero");
        }
        this.ring = ring;
        this.simplicityCriteria = Rational.simplicityCriteria(ring);
        Operand[] numden = new Operand[]{numerator, denominator};
        this.normalize(numden);
        this.numerator = numden[0];
        this.denominator = numden[1];
    }

    Rational(boolean skipNormalize, Ring<E> ring, Operand numerator, Operand denominator) {
        if (denominator.isZero()) {
            throw new ArithmeticException("division by zero");
        }
        this.ring = ring;
        this.simplicityCriteria = Rational.simplicityCriteria(ring);
        this.numerator = numerator;
        this.denominator = denominator;
    }

    private static <E> Predicate<E> simplicityCriteria(Ring<E> ring) {
        if (ring instanceof UnivariateRing) {
            return upolySimplicityCriteria;
        }
        if (ring instanceof MultivariateRing) {
            return mpolySimplicityCriteria;
        }
        if (ring instanceof AIntegers) {
            return intSimplicityCriteria;
        }
        return defaultFalse;
    }

    public static <E> Rational<E> zero(Ring<E> ring) {
        return new Rational<E>(ring, ring.getZero());
    }

    public static <E> Rational<E> one(Ring<E> ring) {
        return new Rational<E>(ring, ring.getOne());
    }

    private void normalize(Operand[] numden) {
        Operand numerator = numden[0].shallowCopy();
        Operand denominator = numerator.isZero() ? new Operand(this.ring.getOne()) : numden[1].shallowCopy();
        numerator.normalize();
        denominator.normalize();
        if (!numerator.isZero()) {
            if (denominator.isUnit()) {
                numerator = numerator.multiply(this.ring.reciprocal(denominator.expand()));
                denominator = new Operand(this.ring.getOne());
            } else if (denominator.unitOrNull() != null) {
                Object du = this.ring.reciprocal(denominator.unitOrNull());
                denominator = denominator.multiply(du);
                numerator = numerator.multiply(du);
            }
        }
        numden[0] = numerator;
        numden[1] = denominator;
    }

    private Operand[] reduceGcd(Operand a, Operand b) {
        if (a.isUnit() || b.isUnit()) {
            return new Operand[]{a, b, new Operand(this.ring.getOne())};
        }
        Operand aReduced = a.shallowCopy();
        Operand bReduced = b.shallowCopy();
        Operand gcd = new Operand();
        for (int ia = 0; ia < aReduced.size(); ++ia) {
            for (int ib = 0; ib < bReduced.size(); ++ib) {
                E gf;
                Object af = aReduced.get(ia);
                Object bf = bReduced.get(ib);
                if (this.ring.isUnit(af) || this.ring.isUnit(bf) || this.ring.isUnit(gf = this.ring.gcd(af, bf))) continue;
                gcd.add(gf);
                aReduced.divide(ia, gf);
                bReduced.divide(ib, gf);
            }
        }
        if (gcd.isEmpty()) {
            return new Operand[]{a, b, new Operand(this.ring.getOne())};
        }
        aReduced.normalize();
        bReduced.normalize();
        gcd.normalize();
        return new Operand[]{aReduced, bReduced, gcd};
    }

    public boolean isZero() {
        return this.numerator.isZero();
    }

    public boolean isOne() {
        return this.denominator.isOne() && this.numerator.isOne();
    }

    public boolean isIntegral() {
        return this.denominator.isOne();
    }

    public E numerator() {
        return (E)this.numerator.expand();
    }

    public E numeratorExact() {
        if (!this.isIntegral()) {
            throw new IllegalArgumentException("not integral fraction");
        }
        return this.numerator();
    }

    public E denominator() {
        return (E)this.denominator.expand();
    }

    public FactorDecomposition<E> factorDenominator() {
        return this.denominator.stream().map(this.ring::factor).reduce(FactorDecomposition.empty(this.ring), FactorDecomposition::addAll);
    }

    public FactorDecomposition<E> factorNumerator() {
        return this.numerator.stream().map(this.ring::factor).reduce(FactorDecomposition.empty(this.ring), FactorDecomposition::addAll);
    }

    public Rational<E>[] normal() {
        if (this.isIntegral()) {
            return new Rational[]{this};
        }
        E[] qd = this.ring.divideAndRemainder(this.numerator(), this.denominator());
        if (qd[0] == null) {
            throw new RuntimeException("division with remainder is not supported.");
        }
        if (this.ring.isZero(qd[0]) || this.ring.isZero(qd[1])) {
            return new Rational[]{this};
        }
        return new Rational[]{new Rational<E>(this.ring, qd[0]), new Rational<E>(this.ring, qd[1], this.denominator())};
    }

    public int signum() {
        return this.ring.signum(this.numerator()) * this.ring.signum(this.denominator());
    }

    public Rational<E> abs() {
        return this.signum() >= 0 ? this : this.negate();
    }

    public Rational<E> reciprocal() {
        return new Rational<E>(this.ring, this.denominator, this.numerator);
    }

    public Rational<E> multiply(Rational<E> oth) {
        if (this.isOne()) {
            return oth;
        }
        if (this.isZero()) {
            return this;
        }
        if (oth.isOne()) {
            return this;
        }
        if (oth.isZero()) {
            return oth;
        }
        Operand[] numden = this.reduceGcd(this.numerator, oth.denominator);
        Operand thisNum = numden[0];
        Operand thatDen = numden[1];
        numden = this.reduceGcd(oth.numerator, this.denominator);
        Operand thatNum = numden[0];
        Operand thisDen = numden[1];
        return new Rational<E>(this.ring, thisNum.multiply(thatNum), thisDen.multiply(thatDen));
    }

    public Rational<E> divide(Rational<E> oth) {
        return this.multiply((E)oth.reciprocal());
    }

    public Rational<E> multiply(E oth) {
        return this.multiply((E)new Rational<E>(this.ring, oth));
    }

    public Rational<E> divide(E oth) {
        return this.divide((E)new Rational<E>(this.ring, oth));
    }

    public Rational<E> negate() {
        return new Rational<E>(this.ring, this.numerator.multiply(this.ring.getNegativeOne()), this.denominator);
    }

    public Rational<E> add(Rational<E> that) {
        if (this.isZero()) {
            return that;
        }
        if (that.isZero()) {
            return this;
        }
        if (this.denominator.expand().equals(that.denominator.expand())) {
            Operand num = new Operand(this.ring.add(this.numerator.expand(), that.numerator.expand()));
            Operand den = (this.denominator.size() > that.denominator.size() ? this.denominator : that.denominator).shallowCopy();
            Operand[] numden = this.reduceGcd(num, den);
            num = numden[0];
            den = numden[1];
            return new Rational<E>(this.ring, num, den);
        }
        Operand[] dens = this.reduceGcd(this.denominator, that.denominator);
        Operand thisDen = dens[0];
        Operand thatDen = dens[1];
        Operand thisNum = this.numerator;
        Operand thatNum = that.numerator;
        Operand gcdDen = dens[2];
        Operand num = new Operand(this.ring.addMutable(this.ring.multiply(thisNum.expand(), thatDen.expand()), this.ring.multiply(thatNum.expand(), thisDen.expand())));
        Operand den = thisDen.multiply(thatDen).multiply(gcdDen);
        Operand[] numden = this.reduceGcd(num, den);
        num = numden[0];
        den = numden[1];
        return new Rational<E>(this.ring, num, den);
    }

    public Rational<E> subtract(Rational<E> that) {
        if (this.isZero()) {
            return that.negate();
        }
        if (that.isZero()) {
            return this;
        }
        if (this.denominator.expand().equals(that.denominator.expand())) {
            Operand num = new Operand(this.ring.subtract(this.numerator.expand(), that.numerator.expand()));
            Operand den = (this.denominator.size() > that.denominator.size() ? this.denominator : that.denominator).shallowCopy();
            Operand[] numden = this.reduceGcd(num, den);
            num = numden[0];
            den = numden[1];
            return new Rational<E>(this.ring, num, den);
        }
        Operand[] dens = this.reduceGcd(this.denominator, that.denominator);
        Operand thisDen = dens[0];
        Operand thatDen = dens[1];
        Operand thisNum = this.numerator;
        Operand thatNum = that.numerator;
        Operand gcdDen = dens[2];
        Operand num = new Operand(this.ring.subtractMutable(this.ring.multiply(thisNum.expand(), thatDen.expand()), this.ring.multiply(thatNum.expand(), thisDen.expand())));
        Operand den = thisDen.multiply(thatDen).multiply(gcdDen);
        Operand[] numden = this.reduceGcd(num, den);
        num = numden[0];
        den = numden[1];
        return new Rational<E>(this.ring, num, den);
    }

    public Rational<E> add(E that) {
        return this.add((E)new Rational<E>(this.ring, that));
    }

    public Rational<E> subtract(E that) {
        return this.subtract((E)new Rational<E>(this.ring, that));
    }

    @Override
    public int compareTo(Rational<E> object) {
        Object nOd = this.ring.multiply(this.numerator.expand(), object.denominator.expand());
        Object dOn = this.ring.multiply(this.denominator.expand(), object.numerator.expand());
        return this.ring.compare(nOd, dOn);
    }

    public Rational<E> pow(int exponent) {
        return exponent >= 0 ? new Rational<E>(true, this.ring, this.numerator.pow(exponent), this.denominator.pow(exponent)) : this.reciprocal().pow(-exponent);
    }

    public Rational<E> pow(long exponent) {
        return exponent >= 0L ? new Rational<E>(true, this.ring, this.numerator.pow(exponent), this.denominator.pow(exponent)) : this.reciprocal().pow(-exponent);
    }

    public Rational<E> pow(BigInteger exponent) {
        return exponent.signum() >= 0 ? new Rational<E>(true, this.ring, this.numerator.pow(exponent), this.denominator.pow(exponent)) : this.reciprocal().pow(exponent.negate());
    }

    public <O> Rational<O> map(Ring<O> ring, Function<E, O> function) {
        return new Rational<O>(ring, function.apply(this.numerator.expand()), function.apply(this.denominator.expand()));
    }

    public Rational<E> map(Function<E, E> function) {
        Operand num = this.numerator.map(function);
        Operand den = this.denominator.map(function);
        Operand[] nd = this.reduceGcd(num, den);
        return new Rational<E>(this.ring, nd[0], nd[1]);
    }

    public Stream<E> stream() {
        return Stream.of(this.numerator.expand(), this.denominator.expand());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Rational that = (Rational)o;
        if (!this.numerator.expand().equals(that.numerator.expand())) {
            return false;
        }
        return this.denominator.expand().equals(that.denominator.expand());
    }

    public int hashCode() {
        int result = this.numerator.expand().hashCode();
        result = 31 * result + this.denominator.expand().hashCode();
        return result;
    }

    @Override
    public String toString(IStringifier<Rational<E>> stringifier) {
        IStringifier<E> str = stringifier.substringifier(this.ring);
        if (this.isIntegral()) {
            return str.stringify(this.numerator.expand());
        }
        String num = str.stringify(this.numerator.expand());
        String den = str.stringify(this.denominator.expand());
        return IStringifier.encloseMathParenthesisInSumIfNeeded(num) + "/" + (IStringifier.hasMulDivPlusMinus(0, den) ? "(" + den + ")" : den);
    }

    public String toStringFactors(IStringifier<Rational<E>> stringifier) {
        IStringifier str = stringifier.substringifier(this.ring);
        if (this.isIntegral()) {
            return str.stringify(this.numerator.expand());
        }
        String num = this.numerator.stream().map((? super T s) -> "(" + str.stringify(s) + ")").collect(Collectors.joining("*"));
        String den = this.denominator.stream().map((? super T s) -> "(" + str.stringify(s) + ")").collect(Collectors.joining("*"));
        return IStringifier.encloseMathParenthesisInSumIfNeeded(num) + "/" + (IStringifier.hasMulDivPlusMinus(0, den) ? "(" + den + ")" : den);
    }

    public String toString() {
        return this.toString(IStringifier.dummy());
    }

    final class Operand
    extends ArrayList<E> {
        private E expandForm;
        private List<E> toExpand;

        Operand() {
            this.expandForm = null;
            this.toExpand = this;
        }

        Operand(Collection<? extends E> c) {
            super(c);
            this.expandForm = null;
            this.toExpand = this;
            if (this.size() == 1) {
                this.setExpandForm(this.get(0));
            }
        }

        Operand(E el) {
            this.expandForm = null;
            this.toExpand = this;
            this.add(el);
            this.setExpandForm(el);
        }

        private void setExpandForm(E e) {
            this.expandForm = e;
            this.toExpand = Collections.singletonList(e);
        }

        private void normalize() {
            if (this.isEmpty()) {
                this.set(Rational.this.ring.getOne());
                return;
            }
            if (this.size() == 1) {
                if (Rational.this.ring.signum(this.first()) < 0) {
                    this.set(0, Rational.this.ring.negate(this.first()));
                    this.add(0, Rational.this.ring.getNegativeOne());
                }
                return;
            }
            Object unit = Rational.this.ring.getOne();
            Object simple = Rational.this.ring.getOne();
            for (int i = this.size() - 1; i >= 0; --i) {
                if (Rational.this.ring.isUnitOrZero(this.get(i))) {
                    unit = Rational.this.ring.multiplyMutable(unit, this.remove(i));
                    continue;
                }
                if (Rational.this.ring.signum(this.get(i)) < 0) {
                    this.set(i, Rational.this.ring.negate(this.get(i)));
                    unit = Rational.this.ring.negate(unit);
                }
                if (!Rational.this.simplicityCriteria.test(this.get(i))) continue;
                if (!Rational.this.simplicityCriteria.test(simple)) {
                    this.add(simple);
                    simple = this.remove(i);
                    continue;
                }
                simple = Rational.this.ring.multiplyMutable(simple, this.remove(i));
            }
            if (!Rational.this.ring.isOne(simple)) {
                this.add(simple);
            }
            if (Rational.this.ring.isZero(unit)) {
                this.clear();
            }
            if (!Rational.this.ring.isOne(unit) || this.isEmpty()) {
                this.add(0, unit);
            }
        }

        private E expand() {
            if (this.expandForm != null) {
                return this.expandForm;
            }
            this.expandForm = this.size() == 1 ? this.get(0) : Rational.this.ring.multiply(this.toExpand);
            this.toExpand = Collections.singletonList(this.expandForm);
            return this.expandForm;
        }

        private boolean isZero() {
            return this.size() == 1 && Rational.this.ring.isZero(this.get(0));
        }

        private boolean isUnit() {
            return this.size() == 1 && Rational.this.ring.isUnit(this.get(0));
        }

        private boolean isOne() {
            return this.isUnit() && Rational.this.ring.isOne(this.get(0));
        }

        private E first() {
            return this.get(0);
        }

        private E last() {
            return this.get(this.size() - 1);
        }

        private E unitOrNull() {
            Object u = this.first();
            if (Rational.this.ring.isUnit(u)) {
                return u;
            }
            return null;
        }

        private E unitOrOne() {
            Object u = this.unitOrNull();
            return u == null ? Rational.this.ring.getOne() : u;
        }

        Operand multiply(Operand oth) {
            if (this.isOne()) {
                return oth;
            }
            if (oth.isOne()) {
                return this;
            }
            if (this.isZero()) {
                return this;
            }
            if (oth.isZero()) {
                return oth;
            }
            Operand r = new Operand();
            r.addAll(this);
            r.addAll(oth);
            if (this.expandForm != null && oth.expandForm != null) {
                r.setExpandForm(Rational.this.ring.multiply(this.expandForm, oth.expandForm));
            } else if (this.toExpand != this || oth.toExpand != oth) {
                r.toExpand = new ArrayList();
                r.toExpand.addAll(this.toExpand);
                r.toExpand.addAll(oth.toExpand);
            }
            r.normalize();
            return r;
        }

        Operand multiply(E oth) {
            if (this.isOne()) {
                return new Operand(oth);
            }
            if (Rational.this.ring.isOne(oth)) {
                return this;
            }
            if (this.isZero()) {
                return this;
            }
            if (Rational.this.ring.isZero(oth)) {
                return new Operand(oth);
            }
            Operand r = new Operand(this);
            r.add(oth);
            if (this.expandForm != null) {
                r.setExpandForm(Rational.this.ring.multiply(this.expandForm, oth));
            }
            if (this.toExpand != this) {
                r.toExpand = new ArrayList(this.toExpand);
                r.toExpand.add(oth);
            }
            if (Rational.this.ring.isUnit(oth) || Rational.this.ring.signum(oth) < 0 || Rational.this.simplicityCriteria.test(oth)) {
                r.normalize();
            }
            return r;
        }

        void divide(int i, E divider) {
            Object div = Rational.this.ring.divideExact(this.get(i), divider);
            this.set(i, div);
            if (this.expandForm != null) {
                this.expandForm = this.size() == 1 && this.toExpand == this ? this.get(0) : Rational.this.ring.divideExact(this.expandForm, divider);
                this.toExpand = Collections.singletonList(this.expandForm);
            } else {
                this.expandForm = null;
                this.toExpand = this;
            }
        }

        @Override
        public void clear() {
            super.clear();
            this.toExpand = this;
        }

        private void set(E value) {
            this.clear();
            this.add(value);
            this.setExpandForm(value);
        }

        Operand shallowCopy() {
            Operand op = new Operand(this);
            if (this.expandForm != null) {
                op.setExpandForm(this.expandForm);
            } else if (this.toExpand != this) {
                op.toExpand = new ArrayList(this.toExpand);
            }
            return op;
        }

        Operand deepCopy() {
            return this.map(Rational.this.ring::copy);
        }

        Operand map(Function<E, E> mapper) {
            Operand op = this.stream().map(mapper).collect(Collectors.toCollection(() -> new Operand()));
            if (this.toExpand != this) {
                op.toExpand = this.toExpand.stream().map(mapper).collect(Collectors.toList());
            }
            if (this.expandForm != null) {
                op.setExpandForm(mapper.apply(this.expandForm));
            }
            return op;
        }

        Operand pow(long exponent) {
            return this.pow(BigInteger.valueOf(exponent));
        }

        Operand pow(BigInteger exponent) {
            if (exponent.isOne()) {
                return this.deepCopy();
            }
            Operand pow = this.stream().map((? super T f) -> Rational.this.ring.pow(f, exponent)).collect(Collectors.toCollection(() -> new Operand()));
            if (this.expandForm != null) {
                pow.expandForm = this.size() == 1 ? pow.first() : Rational.this.ring.pow(this.expandForm, exponent);
                pow.toExpand = Collections.singletonList(pow.expandForm);
            } else if (this.toExpand != this) {
                pow.toExpand = this.toExpand.stream().map((? super T f) -> Rational.this.ring.pow(f, exponent)).collect(Collectors.toList());
            }
            return pow;
        }
    }
}

