/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings;

import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.bigint.BigIntegerUtil;
import cc.redberry.rings.poly.MachineArithmetic;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariateGCD;

public final class RationalReconstruction {
    private RationalReconstruction() {
    }

    public static long[] reconstruct(long n, long modulus, long numeratorBound, long denominatorBound) {
        long[] v = new long[]{modulus, 0L};
        long[] w = new long[]{n, 1L};
        while (w[0] > numeratorBound) {
            long q = v[0] / w[0];
            long[] z = new long[]{v[0] - q * w[0], v[1] - q * w[1]};
            v = w;
            w = z;
        }
        if (w[1] < 0L) {
            w[0] = -w[0];
            w[1] = -w[1];
        }
        if (w[1] <= denominatorBound && MachineArithmetic.gcd(w[0], w[1]) == 1L) {
            return w;
        }
        return null;
    }

    public static BigInteger[] reconstruct(BigInteger n, BigInteger modulus, BigInteger numeratorBound, BigInteger denominatorBound) {
        BigInteger[] v = new BigInteger[]{modulus, BigInteger.ZERO};
        BigInteger[] w = new BigInteger[]{n, BigInteger.ONE};
        while (w[0].compareTo(numeratorBound) > 0) {
            BigInteger q = v[0].divide(w[0]);
            BigInteger[] z = new BigInteger[]{v[0].subtract(q.multiply(w[0])), v[1].subtract(q.multiply(w[1]))};
            v = w;
            w = z;
        }
        if (w[1].signum() < 0) {
            w[0] = w[0].negate();
            w[1] = w[1].negate();
        }
        if (w[1].compareTo(denominatorBound) <= 0 && BigIntegerUtil.gcd(w[0], w[1]).isOne()) {
            return w;
        }
        return null;
    }

    public static BigInteger[] reconstructFarey(BigInteger n, BigInteger modulus) {
        BigInteger[] v = new BigInteger[]{modulus, BigInteger.ZERO};
        BigInteger[] w = new BigInteger[]{n, BigInteger.ONE};
        while (w[0].pow(2).shiftLeft(1).increment().compareTo(modulus) > 0) {
            BigInteger q = v[0].divide(w[0]);
            BigInteger[] z = new BigInteger[]{v[0].subtract(q.multiply(w[0])), v[1].subtract(q.multiply(w[1]))};
            v = w;
            w = z;
        }
        if (w[1].signum() < 0) {
            w[0] = w[0].negate();
            w[1] = w[1].negate();
        }
        if (w[1].pow(2).multiply(BigInteger.TWO).compareTo(modulus) <= 0 && BigIntegerUtil.gcd(w[0], w[1]).isOne()) {
            return w;
        }
        return null;
    }

    public static BigInteger[] reconstructFareyErrorTolerant(BigInteger n, BigInteger modulus) {
        BigInteger vqDen;
        BigInteger[] z;
        BigInteger[] v = new BigInteger[]{modulus, BigInteger.ZERO};
        BigInteger[] w = new BigInteger[]{n, BigInteger.ONE};
        BigInteger wqDen = w[0].pow(2).add(w[1].pow(2));
        do {
            BigInteger qNum;
            BigInteger q = (qNum = w[0].multiply(v[0]).add(w[1].multiply(v[1]))).signum() == wqDen.signum() ? qNum.abs().add(wqDen.abs()).decrement().divide(wqDen.abs()) : qNum.divide(wqDen);
            z = new BigInteger[]{v[0].subtract(q.multiply(w[0])), v[1].subtract(q.multiply(w[1]))};
            v = w;
            vqDen = wqDen;
            w = z;
        } while ((wqDen = z[0].pow(2).add(z[1].pow(2))).compareTo(vqDen) < 0);
        if (vqDen.compareTo(modulus) < 0) {
            if (v[1].signum() < 0) {
                v[0] = v[0].negate();
                v[1] = v[1].negate();
            }
            return v;
        }
        return null;
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Poly[] reconstruct(Poly n, Poly modulus, int numeratorBound, int denominatorBound) {
        IUnivariatePolynomial[] v = (IUnivariatePolynomial[])n.createArray(modulus, (IUnivariatePolynomial)n.createZero());
        IUnivariatePolynomial[] w = (IUnivariatePolynomial[])n.createArray(n, (IUnivariatePolynomial)n.createOne());
        while (w[0].degree() > numeratorBound) {
            IUnivariatePolynomial q = UnivariateDivision.quotient(v[0], w[0], true);
            IUnivariatePolynomial[] z = (IUnivariatePolynomial[])n.createArray(v[0].clone().subtract(q.clone().multiply(w[0])), v[1].clone().subtract(q.clone().multiply(w[1])));
            v = w;
            w = z;
        }
        if (w[1].signumOfLC() < 0) {
            w[0].negate();
            w[1].negate();
        }
        if (w[1].degree() <= denominatorBound && UnivariateGCD.PolynomialGCD(w[0], w[1]).isConstant()) {
            return w;
        }
        return null;
    }
}

