/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.io;

import cc.redberry.rings.Rational;
import cc.redberry.rings.Rationals;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.io.IParser;
import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.io.Tokenizer;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.IPolynomialRing;
import cc.redberry.rings.poly.MultipleFieldExtension;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.UnivariateRing;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.IMonomialAlgebra;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.util.SerializableFunction;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Coder<Element, Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>>
implements IParser<Element>,
IStringifier<Element>,
Serializable {
    protected final Ring<Element> baseRing;
    protected final Map<String, Element> eVariables;
    protected final MultivariateRing<Poly> polyRing;
    protected final Map<String, Integer> pVariables;
    protected final SerializableFunction<Poly, Element> polyToElement;
    protected final Map<Element, String> bindings;
    protected final Map<Ring<?>, Coder<?, ?, ?>> subcoders;
    private final NumberOperand Zero = new NumberOperand(BigInteger.ZERO);
    private static final Operator[] tokenToOp = new Operator[Tokenizer.TokenType.values().length];

    private Coder(Ring<Element> baseRing, Map<String, Element> eVariables, MultivariateRing<Poly> polyRing, Map<String, Integer> pVariables, SerializableFunction<Poly, Element> polyToElement) {
        this.baseRing = baseRing;
        this.eVariables = eVariables;
        this.polyRing = polyRing;
        this.pVariables = pVariables;
        this.polyToElement = polyToElement;
        if (pVariables != null) {
            pVariables.forEach((k, v) -> eVariables.computeIfAbsent((String)k, __ -> polyToElement.apply(polyRing.variable((int)v))));
        }
        this.bindings = eVariables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (prev, n) -> n));
        this.subcoders = new HashMap();
    }

    public Coder<Element, Term, Poly> bind(String var, Element el) {
        this.bindings.put(el, var);
        this.eVariables.put(var, el);
        return this;
    }

    public Coder<Element, Term, Poly> bindAlias(String var, Element el) {
        this.eVariables.put(var, el);
        return this;
    }

    public Coder<Element, Term, Poly> bindPolynomialVariable(String var, int index) {
        if (this.pVariables != null) {
            this.pVariables.put(var, index);
        }
        if (this.polyToElement != null) {
            this.eVariables.put(var, this.polyToElement.apply(this.polyRing.variable(index)));
        }
        return this;
    }

    public Coder<Element, Term, Poly> withEncoder(Coder<?, ?, ?> subencoder) {
        this.subcoders.put(subencoder.baseRing, subencoder);
        return this;
    }

    @Override
    public <K> IStringifier<K> substringifier(Ring<K> ring) {
        IStringifier s = this.subcoders.get(ring);
        if (s == null) {
            return IStringifier.dummy();
        }
        return s;
    }

    @Override
    public Map<Element, String> getBindings() {
        return this.bindings;
    }

    public Element decode(String string) {
        return this.parse(string);
    }

    public String encode(Element element) {
        return this.stringify(element);
    }

    public <Oth> Coder<Oth, ?, ?> map(Ring<Oth> ring, final Function<Element, Oth> func) {
        Map<String, Object> _eVariables = this.eVariables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> func.apply(e.getValue())));
        final Map<Object, String> _bindings = this.bindings.entrySet().stream().collect(Collectors.toMap(e -> func.apply(e.getKey()), Map.Entry::getValue));
        final Coder _this = this;
        return new Coder<Oth, Term, Poly>(ring, _eVariables, null, null, null){
            {
                super(baseRing, eVariables, polyRing, pVariables, polyToElement);
                this.subcoders.putAll(_this.subcoders);
                this.bindings.putAll(_bindings);
            }

            @Override
            public Oth parse(Tokenizer tokenizer) {
                return func.apply(_this.parse(tokenizer));
            }
        };
    }

    public static <Element, Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Coder<Element, Term, Poly> mkCoder(Ring<Element> baseRing, Map<String, Element> eVariables, MultivariateRing<Poly> polyRing, Map<String, Poly> pVariables, SerializableFunction<Poly, Element> polyToElement) {
        HashMap<String, Integer> iVariables = new HashMap<String, Integer>();
        if (pVariables != null) {
            for (Map.Entry<String, Poly> v : pVariables.entrySet()) {
                AMultivariatePolynomial p = (AMultivariatePolynomial)v.getValue();
                if (p.isEffectiveUnivariate() && !p.isConstant() && p.degreeSum() == 1) {
                    iVariables.put(v.getKey(), ((AMultivariatePolynomial)v.getValue()).univariateVariable());
                    continue;
                }
                eVariables.put(v.getKey(), polyToElement.apply(p));
            }
        }
        return new Coder<Element, Term, Poly>(baseRing, eVariables, polyRing, iVariables, polyToElement);
    }

    public static <E> Coder<E, ?, ?> mkCoder(Ring<E> ring) {
        return Coder.mkCoder(ring, new HashMap());
    }

    public static <E> Coder<E, ?, ?> mkCoder(Ring<E> ring, Map<String, E> variables) {
        if (ring instanceof MultivariateRing) {
            return Coder.mkMultivariateCoder((MultivariateRing)ring, variables);
        }
        if (ring instanceof IPolynomialRing && ((IPolynomialRing)ring).factory() instanceof IUnivariatePolynomial) {
            return Coder.mkUnivariateCoder((IPolynomialRing)ring, variables);
        }
        if (ring instanceof MultipleFieldExtension) {
            return Coder.mkMultipleExtensionCoder((MultipleFieldExtension)ring, variables);
        }
        return new Coder(ring, variables, null, null, null);
    }

    public static <Poly extends IPolynomial<Poly>> Coder<Poly, ?, ?> mkPolynomialCoder(IPolynomialRing<Poly> ring, String ... variables) {
        return Coder.mkCoder(ring, Coder.mkVarsMap(ring, variables));
    }

    public static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>> Coder<mPoly, ?, ?> mkMultipleExtensionCoder(MultipleFieldExtension<Term, mPoly, sPoly> field, String ... variables) {
        return Coder.mkMultipleExtensionCoder(field, Coder.mkVarsMap(field, variables));
    }

    private static <E extends IPolynomial<E>> Map<String, E> mkVarsMap(IPolynomialRing<E> ring, String ... variables) {
        HashMap<String, E> pVariables = new HashMap<String, E>();
        for (int i = 0; i < variables.length; ++i) {
            pVariables.put(variables[i], ring.variable(i));
        }
        return pVariables;
    }

    public static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>> Coder<mPoly, ?, ?> mkMultipleExtensionCoder(MultipleFieldExtension<Term, mPoly, sPoly> field, Map<String, mPoly> variables) {
        HashMap<String, IUnivariatePolynomial> sVars = new HashMap<String, IUnivariatePolynomial>();
        for (Map.Entry<String, mPoly> v : variables.entrySet()) {
            sVars.put(v.getKey(), (IUnivariatePolynomial)field.inverse((AMultivariatePolynomial)v.getValue()));
        }
        Coder coder = Coder.mkUnivariateCoder(field.getSimpleExtension(), sVars).map(field, field.imageFunc);
        coder.bindings.putAll(variables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (prev, n) -> n)));
        return coder;
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Coder<Poly, Term, Poly> mkMultivariateCoder(MultivariateRing<Poly> ring, Map<String, Poly> variables) {
        return Coder.mkCoder(ring, variables, ring, variables, SerializableFunction.identity());
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Coder<Poly, Term, Poly> mkMultivariateCoder(MultivariateRing<Poly> ring, String ... variables) {
        HashMap<String, IPolynomial> pVariables = new HashMap<String, IPolynomial>();
        for (int i = 0; i < variables.length; ++i) {
            pVariables.put(variables[i], ring.variable(i));
        }
        return Coder.mkMultivariateCoder(ring, pVariables);
    }

    public static <E> Coder<MultivariatePolynomial<E>, Monomial<E>, MultivariatePolynomial<E>> mkMultivariateCoder(MultivariateRing<MultivariatePolynomial<E>> ring, Coder<E, ?, ?> cfCoder, Map<String, MultivariatePolynomial<E>> variables) {
        cfCoder.eVariables.forEach((k, v) -> variables.put((String)k, ((MultivariatePolynomial)ring.factory()).createConstant(v)));
        return Coder.mkMultivariateCoder(ring, variables).withEncoder(cfCoder);
    }

    public static <E> Coder<MultivariatePolynomial<E>, Monomial<E>, MultivariatePolynomial<E>> mkMultivariateCoder(MultivariateRing<MultivariatePolynomial<E>> ring, Coder<E, ?, ?> cfCoder, String ... variables) {
        HashMap<String, MultivariatePolynomial<E>> eVariables = new HashMap<String, MultivariatePolynomial<E>>();
        for (int i = 0; i < variables.length; ++i) {
            eVariables.put(variables[i], (MultivariatePolynomial)ring.variable(i));
        }
        return Coder.mkMultivariateCoder(ring, cfCoder, eVariables);
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Coder<Poly, ?, ?> mkUnivariateCoder(IPolynomialRing<Poly> ring, Map<String, Poly> variables) {
        MultivariateRing<AMultivariatePolynomial> mRing = Rings.MultivariateRing(((IUnivariatePolynomial)ring.factory()).asMultivariate());
        Map<String, AMultivariatePolynomial> pVariables = variables.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((IUnivariatePolynomial)e.getValue()).asMultivariate()));
        return Coder.mkCoder(ring, variables, mRing, pVariables, p -> p.asUnivariate());
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Coder<Poly, ?, ?> mkUnivariateCoder(final IPolynomialRing<Poly> ring, final String variable) {
        return Coder.mkUnivariateCoder(ring, new HashMap<String, Poly>(){
            {
                this.put(variable, (IUnivariatePolynomial)ring.variable(0));
            }
        });
    }

    public static <E> Coder<UnivariatePolynomial<E>, ?, ?> mkUnivariateCoder(IPolynomialRing<UnivariatePolynomial<E>> ring, Coder<E, ?, ?> cfCoder, Map<String, UnivariatePolynomial<E>> variables) {
        cfCoder.eVariables.forEach((k, v) -> variables.put((String)k, ((UnivariatePolynomial)ring.factory()).createConstant(v)));
        return Coder.mkUnivariateCoder(ring, variables).withEncoder(cfCoder);
    }

    public static <E> Coder<UnivariatePolynomial<E>, ?, ?> mkUnivariateCoder(IPolynomialRing<UnivariatePolynomial<E>> ring, Coder<E, ?, ?> cfCoder, String variable) {
        HashMap<String, UnivariatePolynomial<E>> eVariables = new HashMap<String, UnivariatePolynomial<E>>();
        eVariables.put(variable, ring.variable(0));
        return Coder.mkUnivariateCoder(ring, cfCoder, eVariables);
    }

    public static <E> Coder<Rational<E>, ?, ?> mkRationalsCoder(Rationals<E> ring, Coder<E, ?, ?> elementsCoder) {
        return Coder.mkNestedCoder(ring, new HashMap(), elementsCoder, e -> new Rational<Object>(ring.ring, e));
    }

    public static <E, I> Coder<E, ?, ?> mkNestedCoder(Ring<E> ring, Map<String, E> variables, Coder<I, ?, ?> innerCoder, SerializableFunction<I, E> imageFunc) {
        if (ring instanceof MultivariateRing && ((MultivariateRing)ring).factory() instanceof MultivariatePolynomial) {
            return Coder.mkMultivariateCoder((MultivariateRing)ring, innerCoder, variables);
        }
        if (ring instanceof UnivariateRing && ((UnivariateRing)ring).factory() instanceof UnivariatePolynomial) {
            return Coder.mkUnivariateCoder((UnivariateRing)ring, innerCoder, variables);
        }
        innerCoder.eVariables.forEach((k, v) -> variables.put((String)k, (MultivariatePolynomial)imageFunc.apply(v)));
        return new Coder(ring, variables, innerCoder.polyRing, innerCoder.pVariables, innerCoder.polyToElement == null ? null : innerCoder.polyToElement.andThen(imageFunc)).withEncoder(innerCoder);
    }

    @Override
    public Element parse(String string) {
        return this.parse(Tokenizer.mkTokenizer(string));
    }

    public Element parse(Tokenizer tokenizer) {
        Tokenizer.Token token;
        ArrayDeque<Operator> operators = new ArrayDeque<Operator>();
        ArrayDeque<IOperand<Poly, Element>> operands = new ArrayDeque<IOperand<Poly, Element>>();
        Tokenizer.TokenType previousToken = null;
        while ((token = tokenizer.nextToken()) != Tokenizer.END) {
            Tokenizer.TokenType tType = token.tokenType;
            assert (previousToken != null || tType == Tokenizer.TokenType.T_BRACKET_OPEN);
            if (tType == Tokenizer.TokenType.T_VARIABLE) {
                operands.push(this.mkOperand(token));
            } else {
                Operator op = Coder.tokenToOp(token.tokenType);
                assert (op != null);
                if (Operator.isPlusMinus(op) && previousToken == Tokenizer.TokenType.T_BRACKET_OPEN) {
                    operands.push(this.Zero);
                }
                if (Operator.isPlusMinus(op) && Operator.isPlusMinus(Coder.tokenToOp(previousToken))) {
                    if (op == Operator.PLUS && previousToken == Tokenizer.TokenType.T_MINUS) {
                        tType = Tokenizer.TokenType.T_MINUS;
                        op = Operator.MINUS;
                    } else if (op == Operator.MINUS && previousToken == Tokenizer.TokenType.T_MINUS) {
                        tType = Tokenizer.TokenType.T_PLUS;
                        op = Operator.PLUS;
                    }
                    operands.push(this.Zero);
                }
                if (op == Operator.BRACKET_CLOSE) {
                    while (!operators.isEmpty() && operators.peek() != Operator.BRACKET_OPEN) {
                        this.popEvaluate(operators, operands);
                    }
                    operators.pop();
                } else {
                    while (this.canPop(op, operators)) {
                        this.popEvaluate(operators, operands);
                    }
                    operators.push(op);
                }
            }
            previousToken = tType;
        }
        if (operands.size() > 1 || operators.size() > 1) {
            throw new IllegalArgumentException("Can't parse");
        }
        return this.baseRing.valueOf(((IOperand)operands.pop()).toElement());
    }

    private IOperand<Poly, Element> mkOperand(Tokenizer.Token operand) {
        Integer iVar;
        if (Coder.isInteger(operand.content)) {
            return new NumberOperand(new BigInteger(operand.content));
        }
        if (operand.tokenType != Tokenizer.TokenType.T_VARIABLE) {
            throw new RuntimeException("illegal operand: " + operand);
        }
        Integer n = iVar = this.pVariables == null ? null : this.pVariables.get(operand.content);
        if (iVar != null) {
            return new VarOperand(this.pVariables.get(operand.content));
        }
        Element eVar = this.eVariables.get(operand.content);
        if (eVar != null) {
            return new ElementOperand(this.baseRing.copy(eVar));
        }
        throw new RuntimeException("illegal operand: " + operand);
    }

    private boolean canPop(Operator op, ArrayDeque<Operator> opsStack) {
        if (opsStack.isEmpty()) {
            return false;
        }
        int pOp = op.priority;
        int pOpPrev = opsStack.peek().priority;
        if (pOp < 0 || pOpPrev < 0) {
            return false;
        }
        return op.associativity == Associativity.LeftToRight && pOp >= pOpPrev || op.associativity == Associativity.RightToLeft && pOp > pOpPrev;
    }

    private void popEvaluate(ArrayDeque<Operator> opsStack, ArrayDeque<IOperand<Poly, Element>> exprStack) {
        IOperand<Poly, Element> result;
        IOperand<Poly, Element> right = exprStack.pop();
        IOperand<Poly, Element> left = exprStack.pop();
        Operator op = opsStack.pop();
        switch (op) {
            case PLUS: {
                result = left.plus(right);
                break;
            }
            case MINUS: {
                result = left.minus(right);
                break;
            }
            case MULTIPLY: {
                result = left.multiply(right);
                break;
            }
            case DIVIDE: {
                result = left.divide(right);
                break;
            }
            case POWER: {
                if (!(right instanceof NumberOperand)) {
                    throw new IllegalArgumentException("Exponents must be positive integers, but got " + right.toElement());
                }
                result = left.pow(((NumberOperand)right).number);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        exprStack.push(result);
    }

    private static Operator tokenToOp(Tokenizer.TokenType tType) {
        return tokenToOp[tType.ordinal()];
    }

    private static boolean isInteger(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        int i = 0;
        if (str.charAt(0) == '-') {
            if (length == 1) {
                return false;
            }
            i = 1;
        }
        while (i < length) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    static {
        Coder.tokenToOp[Tokenizer.TokenType.T_BRACKET_OPEN.ordinal()] = Operator.BRACKET_OPEN;
        Coder.tokenToOp[Tokenizer.TokenType.T_BRACKET_CLOSE.ordinal()] = Operator.BRACKET_CLOSE;
        Coder.tokenToOp[Tokenizer.TokenType.T_MULTIPLY.ordinal()] = Operator.MULTIPLY;
        Coder.tokenToOp[Tokenizer.TokenType.T_DIVIDE.ordinal()] = Operator.DIVIDE;
        Coder.tokenToOp[Tokenizer.TokenType.T_PLUS.ordinal()] = Operator.PLUS;
        Coder.tokenToOp[Tokenizer.TokenType.T_MINUS.ordinal()] = Operator.MINUS;
        Coder.tokenToOp[Tokenizer.TokenType.T_EXPONENT.ordinal()] = Operator.POWER;
    }

    private static enum Operator {
        BRACKET_OPEN(null, -1),
        BRACKET_CLOSE(null, -1),
        POWER(Associativity.LeftToRight, 20),
        UNARY_PLUS(Associativity.RightToLeft, 30),
        UNARY_MINUS(Associativity.RightToLeft, 30),
        MULTIPLY(Associativity.LeftToRight, 50),
        DIVIDE(Associativity.LeftToRight, 50),
        PLUS(Associativity.LeftToRight, 60),
        MINUS(Associativity.LeftToRight, 60);

        final Associativity associativity;
        final int priority;

        private Operator(Associativity associativity, int priority) {
            this.associativity = associativity;
            this.priority = priority;
        }

        static boolean isPlusMinus(Operator op) {
            return PLUS == op || MINUS == op;
        }

        static Operator toUnaryPlusMinus(Operator op) {
            return op == PLUS ? UNARY_PLUS : (op == MINUS ? UNARY_MINUS : null);
        }
    }

    private static enum Associativity {
        LeftToRight,
        RightToLeft;

    }

    private class ElementOperand
    extends DefaultOperandOps
    implements IOperand<Poly, Element> {
        final Element element;

        ElementOperand(Element element) {
            this.element = element;
        }

        @Override
        public Poly toPoly() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Element toElement() {
            return this.element;
        }
    }

    private static class PolyOperand
    extends DefaultOperandOps
    implements IOperand<Poly, Element> {
        final Poly poly;
        final /* synthetic */ Coder this$0;

        PolyOperand(Poly poly) {
            this.this$0 = var1_1;
            this.poly = poly;
        }

        @Override
        public Poly toPoly() {
            return this.poly;
        }
    }

    private static class MonomialOperand
    extends DefaultOperandOps
    implements IOperand<Poly, Element> {
        Term term;
        final /* synthetic */ Coder this$0;

        MonomialOperand(Term term) {
            this.this$0 = var1_1;
            this.term = term;
        }

        @Override
        public Poly toPoly() {
            return ((AMultivariatePolynomial)this.this$0.polyRing.factory()).create(this.term);
        }

        @Override
        public IOperand<Poly, Element> multiply(IOperand<Poly, Element> oth) {
            IMonomialAlgebra monomialAlgebra = this.this$0.polyRing.monomialAlgebra();
            if (oth instanceof NumberOperand) {
                return new MonomialOperand(this.this$0, monomialAlgebra.multiply(this.term, ((NumberOperand)oth).number));
            }
            if (oth instanceof VarOperand) {
                int[] exponents = ((AMonomial)this.term).exponents;
                int n = ((VarOperand)oth).variable;
                exponents[n] = exponents[n] + 1;
                return new MonomialOperand(this.this$0, ((AMonomial)this.term).forceSetDegreeVector(exponents, ((AMonomial)this.term).totalDegree + 1));
            }
            if (oth instanceof MonomialOperand) {
                Object othTerm = ((MonomialOperand)oth).term;
                if ((long)((AMonomial)othTerm).totalDegree + (long)((AMonomial)this.term).totalDegree > 32767L) {
                    return super.multiply(oth);
                }
                return new MonomialOperand(this.this$0, monomialAlgebra.multiply(this.term, othTerm));
            }
            return oth.multiply(this);
        }

        @Override
        public IOperand<Poly, Element> pow(BigInteger exponent) {
            if (exponent.isInt()) {
                int e = exponent.intValue();
                if ((long)((AMonomial)this.term).totalDegree * (long)e > 32767L) {
                    return super.pow(exponent);
                }
                IMonomialAlgebra ma = this.this$0.polyRing.monomialAlgebra();
                return new MonomialOperand(this.this$0, ma.pow(this.term, e));
            }
            return super.pow(exponent);
        }
    }

    private final class VarOperand
    extends DefaultOperandOps
    implements IOperand<Poly, Element> {
        final int variable;

        VarOperand(int variable) {
            this.variable = variable;
        }

        @Override
        public Poly toPoly() {
            return Coder.this.polyRing.variable(this.variable);
        }

        @Override
        public IOperand<Poly, Element> multiply(IOperand<Poly, Element> oth) {
            if (oth instanceof NumberOperand) {
                return new MonomialOperand(Coder.this, ((AMultivariatePolynomial)Coder.this.polyRing.multiplyMutable((IPolynomial)this.toPoly(), (AMultivariatePolynomial)oth.toPoly())).lt());
            }
            if (oth instanceof VarOperand) {
                int[] exponents = new int[Coder.this.polyRing.nVariables()];
                int n = this.variable;
                exponents[n] = exponents[n] + 1;
                int n2 = ((VarOperand)oth).variable;
                exponents[n2] = exponents[n2] + 1;
                return new MonomialOperand(Coder.this, ((AMultivariatePolynomial)Coder.this.polyRing.factory()).monomialAlgebra.create(exponents));
            }
            return oth.multiply(this);
        }

        @Override
        public IOperand<Poly, Element> pow(BigInteger exponent) {
            if (!exponent.isInt()) {
                return super.pow(exponent);
            }
            int[] exponents = new int[Coder.this.polyRing.nVariables()];
            int n = this.variable;
            exponents[n] = exponents[n] + exponent.intValue();
            return new MonomialOperand(Coder.this, ((AMultivariatePolynomial)Coder.this.polyRing.factory()).monomialAlgebra.create(exponents));
        }
    }

    private final class NumberOperand
    extends DefaultOperandOps
    implements IOperand<Poly, Element> {
        final BigInteger number;

        NumberOperand(BigInteger number) {
            this.number = number;
        }

        @Override
        public Poly toPoly() {
            return (AMultivariatePolynomial)Coder.this.polyRing.valueOfBigInteger(this.number);
        }

        @Override
        public Element toElement() {
            return Coder.this.baseRing.valueOfBigInteger(this.number);
        }

        @Override
        public IOperand<Poly, Element> plus(IOperand<Poly, Element> oth) {
            if (oth instanceof NumberOperand) {
                return new NumberOperand(this.number.add(((NumberOperand)oth).number));
            }
            return super.plus(oth);
        }

        @Override
        public IOperand<Poly, Element> minus(IOperand<Poly, Element> oth) {
            if (oth instanceof NumberOperand) {
                return new NumberOperand(this.number.subtract(((NumberOperand)oth).number));
            }
            return super.minus(oth);
        }

        @Override
        public IOperand<Poly, Element> multiply(IOperand<Poly, Element> oth) {
            if (oth instanceof NumberOperand) {
                return new NumberOperand(this.number.multiply(((NumberOperand)oth).number));
            }
            return oth.multiply(this);
        }

        @Override
        public IOperand<Poly, Element> divide(IOperand<Poly, Element> oth) {
            if (oth instanceof NumberOperand) {
                BigInteger[] divRem = this.number.divideAndRemainder(((NumberOperand)oth).number);
                if (divRem[1].isZero()) {
                    return new NumberOperand(divRem[0]);
                }
                return super.divide(oth);
            }
            return super.divide(oth);
        }

        @Override
        public IOperand<Poly, Element> pow(BigInteger exponent) {
            return new NumberOperand(Rings.Z.pow(this.number, exponent));
        }
    }

    private abstract class DefaultOperandOps
    implements IOperand<Poly, Element> {
        private DefaultOperandOps() {
        }

        @Override
        public Element toElement() {
            return Coder.this.polyToElement.apply((AMultivariatePolynomial)this.toPoly());
        }

        @Override
        public IOperand<Poly, Element> plus(IOperand<Poly, Element> oth) {
            if (this.inBaseRing() || oth.inBaseRing()) {
                return new ElementOperand(Coder.this.baseRing.addMutable(this.toElement(), oth.toElement()));
            }
            return new PolyOperand(Coder.this, (AMultivariatePolynomial)Coder.this.polyRing.addMutable((AMultivariatePolynomial)this.toPoly(), (AMultivariatePolynomial)oth.toPoly()));
        }

        @Override
        public IOperand<Poly, Element> minus(IOperand<Poly, Element> oth) {
            if (this.inBaseRing() || oth.inBaseRing()) {
                return new ElementOperand(Coder.this.baseRing.subtractMutable(this.toElement(), oth.toElement()));
            }
            return new PolyOperand(Coder.this, (AMultivariatePolynomial)Coder.this.polyRing.subtractMutable((AMultivariatePolynomial)this.toPoly(), (AMultivariatePolynomial)oth.toPoly()));
        }

        @Override
        public IOperand<Poly, Element> divide(IOperand<Poly, Element> oth) {
            return new ElementOperand(Coder.this.baseRing.divideExactMutable(this.toElement(), oth.toElement()));
        }

        @Override
        public IOperand<Poly, Element> multiply(IOperand<Poly, Element> oth) {
            if (this.inBaseRing() || oth.inBaseRing()) {
                return new ElementOperand(Coder.this.baseRing.multiplyMutable(this.toElement(), oth.toElement()));
            }
            return new PolyOperand(Coder.this, (AMultivariatePolynomial)Coder.this.polyRing.multiplyMutable((AMultivariatePolynomial)this.toPoly(), (AMultivariatePolynomial)oth.toPoly()));
        }

        @Override
        public IOperand<Poly, Element> pow(BigInteger exponent) {
            if (this.inBaseRing()) {
                return new ElementOperand(Coder.this.baseRing.pow(this.toElement(), exponent));
            }
            return new PolyOperand(Coder.this, (AMultivariatePolynomial)Coder.this.polyRing.pow((AMultivariatePolynomial)this.toPoly(), exponent));
        }
    }

    private static interface IOperand<P, E>
    extends Serializable {
        public P toPoly();

        public E toElement();

        default public boolean inBaseRing() {
            return this instanceof ElementOperand;
        }

        public IOperand<P, E> plus(IOperand<P, E> var1);

        public IOperand<P, E> minus(IOperand<P, E> var1);

        public IOperand<P, E> multiply(IOperand<P, E> var1);

        public IOperand<P, E> divide(IOperand<P, E> var1);

        public IOperand<P, E> pow(BigInteger var1);
    }
}

