/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.io;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public final class Tokenizer
implements Serializable {
    private final CharacterStream stream;
    private boolean bufferedCharDefined;
    private char bufferedChar;
    private boolean first = true;
    private boolean last = true;
    public static final Token END = new Token(TokenType.T_END, "");
    public static final Token PLUS = new Token(TokenType.T_PLUS, "+");
    public static final Token MINUS = new Token(TokenType.T_MINUS, "-");
    public static final Token MULTIPLY = new Token(TokenType.T_MULTIPLY, "*");
    public static final Token DIVIDE = new Token(TokenType.T_DIVIDE, "/");
    public static final Token EXPONENT = new Token(TokenType.T_EXPONENT, "^");
    public static final Token BRACKET_OPEN = new Token(TokenType.T_BRACKET_OPEN, "(");
    public static final Token BRACKET_CLOSE = new Token(TokenType.T_BRACKET_CLOSE, ")");
    public static final Token SPACE = new Token(TokenType.T_SPACE, " ");

    public Tokenizer(CharacterStream stream) {
        this.stream = stream;
    }

    private boolean hasNextChar() {
        return this.bufferedCharDefined || this.stream.hasNext();
    }

    private char nextChar() {
        char c;
        if (this.bufferedCharDefined) {
            this.bufferedCharDefined = false;
            c = this.bufferedChar;
        } else {
            c = this.stream.next();
        }
        Tokenizer.checkChar(c);
        return c;
    }

    private static void checkChar(char c) {
        switch (c) {
            case '!': 
            case '%': 
            case '&': 
            case '=': 
            case '~': {
                throw new IllegalArgumentException(String.format("Illegal character %s", Character.valueOf(c)));
            }
        }
    }

    private Token firstToken() {
        this.first = false;
        return BRACKET_OPEN;
    }

    private Token lastToken() {
        if (!this.last) {
            return END;
        }
        this.last = false;
        return BRACKET_CLOSE;
    }

    public Token nextToken() {
        if (this.first) {
            return this.firstToken();
        }
        if (!this.hasNextChar()) {
            return this.lastToken();
        }
        char seed = this.nextChar();
        Token token = Tokenizer.primitiveToken(seed);
        if (token == SPACE) {
            do {
                if (this.hasNextChar()) continue;
                return this.lastToken();
            } while ((token = Tokenizer.primitiveToken(seed = this.nextChar())) == SPACE);
        }
        if (token != null) {
            return token;
        }
        String sBegin = this.stream.currentString();
        int pBegin = this.stream.indexInCurrentString();
        if (!this.hasNextChar()) {
            return new Token(TokenType.T_VARIABLE, sBegin.substring(pBegin, pBegin + 1));
        }
        char c = '\u0000';
        int nSpaces = 0;
        boolean needBuffer = false;
        while (this.hasNextChar()) {
            c = this.stream.next();
            Token t = Tokenizer.primitiveToken(c);
            if (t == SPACE) {
                ++nSpaces;
                continue;
            }
            if (t == null) {
                if (nSpaces <= 0) continue;
                throw new IllegalArgumentException("spaces in variable name are forbidden");
            }
            needBuffer = true;
            break;
        }
        String sEnd = this.stream.currentString();
        int pEnd = this.stream.indexInCurrentString() + 1;
        if (needBuffer) {
            this.bufferedChar = c;
            this.bufferedCharDefined = true;
            --pEnd;
        }
        String variable = sBegin == sEnd ? sBegin.substring(pBegin, pEnd - nSpaces) : (nSpaces < pEnd ? sBegin.substring(pBegin) + sEnd.substring(0, pEnd) : sBegin.substring(pBegin, sBegin.length() - (pEnd - nSpaces)));
        return new Token(TokenType.T_VARIABLE, variable);
    }

    private static Token primitiveToken(char character) {
        switch (character) {
            case '+': {
                return PLUS;
            }
            case '-': {
                return MINUS;
            }
            case '*': {
                return MULTIPLY;
            }
            case '/': {
                return DIVIDE;
            }
            case '^': {
                return EXPONENT;
            }
            case '(': {
                return BRACKET_OPEN;
            }
            case ')': {
                return BRACKET_CLOSE;
            }
            case '\t': 
            case '\n': 
            case ' ': {
                return SPACE;
            }
        }
        return null;
    }

    public static CharacterStream concat(CharacterStream a, CharacterStream b) {
        ArrayList<CharacterStream> streams = new ArrayList<CharacterStream>();
        streams.add(a);
        streams.add(b);
        return new ConcatStreams(streams);
    }

    public static CharacterStream mkCharacterStream(final String string, final Character terminateChar) {
        return new CharacterStream(){
            int index = 0;
            int currentIndex = 0;

            @Override
            public boolean hasNext() {
                return this.index < string.length() && (terminateChar == null || string.charAt(this.index) != terminateChar.charValue());
            }

            @Override
            public char next() {
                this.currentIndex = this.index;
                return string.charAt(this.index++);
            }

            @Override
            public String currentString() {
                return string;
            }

            @Override
            public int indexInCurrentString() {
                return this.currentIndex;
            }
        };
    }

    public static Tokenizer mkTokenizer(String string, Character terminateChar) {
        return new Tokenizer(Tokenizer.mkCharacterStream(string, terminateChar));
    }

    public static Tokenizer mkTokenizer(String string) {
        return new Tokenizer(Tokenizer.mkCharacterStream(string, null));
    }

    private static final class ConcatStreams
    implements CharacterStream {
        final List<CharacterStream> streams;
        int currentStream;

        ConcatStreams(List<CharacterStream> streams) {
            this(streams, 0);
        }

        ConcatStreams(List<CharacterStream> streams, int currentStream) {
            this.streams = streams;
            this.currentStream = currentStream;
        }

        @Override
        public boolean hasNext() {
            for (int cs = this.currentStream; cs < this.streams.size(); ++cs) {
                if (!this.streams.get(cs).hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public char next() {
            for (int cs = this.currentStream; cs < this.streams.size(); ++cs) {
                if (!this.streams.get(cs).hasNext()) continue;
                this.currentStream = cs;
                return this.streams.get(cs).next();
            }
            throw new IllegalArgumentException("no more elements in this stream");
        }

        @Override
        public String currentString() {
            return this.streams.get(this.currentStream).currentString();
        }

        @Override
        public int indexInCurrentString() {
            return this.streams.get(this.currentStream).indexInCurrentString();
        }
    }

    public static interface CharacterStream
    extends Serializable {
        public boolean hasNext();

        public char next();

        public String currentString();

        public int indexInCurrentString();

        default public boolean seek(char c) {
            while (this.hasNext()) {
                char n = this.next();
                if (n != c) continue;
                return true;
            }
            return false;
        }
    }

    public static final class Token
    implements Serializable {
        public final TokenType tokenType;
        public final String content;

        Token(TokenType tokenType, String content) {
            this.tokenType = tokenType;
            this.content = content;
        }

        public String toString() {
            return (Object)((Object)this.tokenType) + "(" + this.content + ")";
        }
    }

    public static enum TokenType {
        T_VARIABLE,
        T_PLUS,
        T_MINUS,
        T_MULTIPLY,
        T_DIVIDE,
        T_EXPONENT,
        T_SPACE,
        T_NEWLINE,
        T_BRACKET_OPEN,
        T_BRACKET_CLOSE,
        T_END;

    }
}

