/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly;

import cc.redberry.rings.FactorDecomposition;
import cc.redberry.rings.Rings;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.PolynomialMethods;
import cc.redberry.rings.util.ArraysUtil;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class PolynomialFactorDecomposition<Poly extends IPolynomial<Poly>>
extends FactorDecomposition<Poly>
implements Serializable {
    private static final long serialVersionUID = 1L;

    private PolynomialFactorDecomposition(Poly unit, List<Poly> factors, TIntArrayList exponents) {
        super(Rings.PolynomialRing(unit), unit, factors, exponents);
    }

    private PolynomialFactorDecomposition(FactorDecomposition<Poly> factors) {
        super(factors.ring, (IPolynomial)factors.unit, factors.factors, factors.exponents);
    }

    @Override
    public boolean isUnit(Poly element) {
        return element.isConstant();
    }

    @Override
    public PolynomialFactorDecomposition<Poly> setUnit(Poly unit) {
        super.setUnit(unit);
        return this;
    }

    @Override
    public PolynomialFactorDecomposition<Poly> addUnit(Poly unit) {
        super.addUnit(unit);
        return this;
    }

    @Override
    public PolynomialFactorDecomposition<Poly> addFactor(Poly factor, int exponent) {
        super.addFactor(factor, exponent);
        return this;
    }

    @Override
    public PolynomialFactorDecomposition<Poly> addAll(FactorDecomposition<Poly> other) {
        super.addAll(other);
        return this;
    }

    @Override
    public PolynomialFactorDecomposition<Poly> canonical() {
        int i;
        if (this.factors.size() == 0) {
            return this;
        }
        this.reduceUnitContent();
        Comparable[] fTmp = this.factors.toArray(((IPolynomial)this.factors.get(0)).createArray(this.factors.size()));
        int[] eTmp = this.exponents.toArray();
        for (i = fTmp.length - 1; i >= 0; --i) {
            IPolynomial poly = fTmp[i];
            if (poly.isMonomial() && eTmp[i] != 1) {
                poly = PolynomialMethods.polyPow(poly, eTmp[i], false);
                assert (poly.isMonomial());
            }
            if (poly.signumOfLC() >= 0) continue;
            poly.negate();
            if (eTmp[i] % 2 != 1) continue;
            ((IPolynomial)this.unit).negate();
        }
        ArraysUtil.quickSort((Comparable[])fTmp, (int[])eTmp);
        for (i = 0; i < fTmp.length; ++i) {
            this.factors.set(i, fTmp[i]);
            this.exponents.set(i, eTmp[i]);
        }
        return this;
    }

    public PolynomialFactorDecomposition<Poly> setLcFrom(Poly poly) {
        IPolynomial u = (IPolynomial)this.ring.getOne();
        for (int i = 0; i < this.size(); ++i) {
            u = u.multiply(PolynomialMethods.polyPow(((IPolynomial)this.get(i)).lcAsPoly(), this.getExponent(i)));
        }
        return this.setUnit((Poly)PolynomialMethods.divideExact(poly.lcAsPoly(), u));
    }

    public Poly lc() {
        Object u = ((IPolynomial)this.unit).clone();
        for (int i = 0; i < this.size(); ++i) {
            u = u.multiply(PolynomialMethods.polyPow(((IPolynomial)this.get(i)).lcAsPoly(), this.getExponent(i)));
        }
        return u;
    }

    public int signum() {
        int signum = ((IPolynomial)this.unit).signumOfLC();
        for (int i = 0; i < this.factors.size(); ++i) {
            signum *= this.exponents.get(i) % 2 == 0 ? 1 : ((IPolynomial)this.factors.get(i)).signumOfLC();
        }
        return signum;
    }

    public PolynomialFactorDecomposition<Poly> monic() {
        for (int i = 0; i < this.factors.size(); ++i) {
            IPolynomial factor = (IPolynomial)this.factors.get(i);
            this.addUnit((Poly)PolynomialMethods.polyPow(factor.lcAsPoly(), this.exponents.get(i), false));
            factor = factor.monic();
            assert (factor != null);
        }
        return this;
    }

    public PolynomialFactorDecomposition<Poly> primitive() {
        for (int i = 0; i < this.factors.size(); ++i) {
            IPolynomial factor = (IPolynomial)this.factors.get(i);
            Object content = factor.contentAsPoly();
            this.addUnit((Poly)PolynomialMethods.polyPow(content, this.exponents.get(i), false));
            factor = factor.divideByLC(content);
            assert (factor != null);
            if (factor.signumOfLC() >= 0) continue;
            factor.negate();
            if (this.exponents.get(i) % 2 != 1) continue;
            ((IPolynomial)this.unit).negate();
        }
        return this;
    }

    public <OthPoly extends IPolynomial<OthPoly>> PolynomialFactorDecomposition<OthPoly> mapTo(Function<Poly, OthPoly> mapper) {
        return PolynomialFactorDecomposition.of((IPolynomial)mapper.apply((IPolynomial)this.unit), this.factors.stream().map(mapper).collect(Collectors.toList()), this.exponents);
    }

    public PolynomialFactorDecomposition<Poly> reduceUnitContent() {
        return ((IPolynomial)this.unit).isOverField() ? this.monic() : this.primitive();
    }

    @Override
    public PolynomialFactorDecomposition<Poly> clone() {
        return new PolynomialFactorDecomposition(((IPolynomial)this.unit).clone(), this.factors.stream().map(IPolynomial::clone).collect(Collectors.toList()), new TIntArrayList((TIntCollection)this.exponents));
    }

    public static <Poly extends IPolynomial<Poly>> PolynomialFactorDecomposition<Poly> unit(Poly unit) {
        if (!unit.isConstant()) {
            throw new IllegalArgumentException();
        }
        return PolynomialFactorDecomposition.empty(unit).addUnit(unit);
    }

    public static <Poly extends IPolynomial<Poly>> PolynomialFactorDecomposition<Poly> empty(Poly factory) {
        return new PolynomialFactorDecomposition<Poly>(factory.createOne(), new ArrayList(), new TIntArrayList());
    }

    public static <Poly extends IPolynomial<Poly>> PolynomialFactorDecomposition<Poly> of(Poly unit, List<Poly> factors, TIntArrayList exponents) {
        if (factors.size() != exponents.size()) {
            throw new IllegalArgumentException();
        }
        PolynomialFactorDecomposition<IPolynomial> r = PolynomialFactorDecomposition.empty(unit).addUnit(unit);
        for (int i = 0; i < factors.size(); ++i) {
            r.addFactor((IPolynomial)factors.get(i), exponents.get(i));
        }
        return r;
    }

    public static <Poly extends IPolynomial<Poly>> PolynomialFactorDecomposition<Poly> of(Poly ... factors) {
        if (factors.length == 0) {
            throw new IllegalArgumentException();
        }
        return PolynomialFactorDecomposition.of(Arrays.asList(factors));
    }

    public static <Poly extends IPolynomial<Poly>> PolynomialFactorDecomposition<Poly> of(Poly a) {
        IPolynomial[] array = a.createArray(1);
        array[0] = a;
        return PolynomialFactorDecomposition.of(array);
    }

    public static <Poly extends IPolynomial<Poly>> PolynomialFactorDecomposition<Poly> of(Poly a, Poly b) {
        return PolynomialFactorDecomposition.of(a.createArray(a, b));
    }

    public static <Poly extends IPolynomial<Poly>> PolynomialFactorDecomposition<Poly> of(Poly a, Poly b, Poly c) {
        return PolynomialFactorDecomposition.of(a.createArray(a, b, c));
    }

    public static <Poly extends IPolynomial<Poly>> PolynomialFactorDecomposition<Poly> of(Collection<Poly> factors) {
        IPolynomial e2;
        TObjectIntHashMap map = new TObjectIntHashMap();
        for (IPolynomial e2 : factors) {
            map.adjustOrPutValue((Object)e2, 1, 1);
        }
        ArrayList l = new ArrayList();
        e2 = new TIntArrayList();
        map.forEachEntry((arg_0, arg_1) -> PolynomialFactorDecomposition.lambda$of$0(l, (TIntArrayList)e2, arg_0, arg_1));
        return PolynomialFactorDecomposition.of(((IPolynomial)factors.iterator().next()).createOne(), l, e2);
    }

    private static /* synthetic */ boolean lambda$of$0(List l, TIntArrayList e, IPolynomial a, int b) {
        l.add(a);
        e.add(b);
        return true;
    }
}

