/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigIntegerUtil;
import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.IMonomialAlgebra;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MonomialSet;
import cc.redberry.rings.poly.multivar.MonomialSetView;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import cc.redberry.rings.util.ArraysUtil;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.set.hash.TIntHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.math3.random.RandomGenerator;

public abstract class AMultivariatePolynomial<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>>
implements IPolynomial<Poly>,
MonomialSetView<Term>,
Iterable<Term> {
    private static final long serialVersionUID = 1L;
    public final int nVariables;
    public final Comparator<DegreeVector> ordering;
    public final IMonomialAlgebra<Term> monomialAlgebra;
    final MonomialSet<Term> terms;
    private final Poly self = this;
    private int cachedDegree = -1;
    private int[] cachedDegrees = null;
    static int KRONECKER_THRESHOLD = 256;

    AMultivariatePolynomial(int nVariables, Comparator<DegreeVector> ordering, IMonomialAlgebra<Term> monomialAlgebra, MonomialSet<Term> terms) {
        this.nVariables = nVariables;
        this.ordering = ordering;
        this.monomialAlgebra = monomialAlgebra;
        this.terms = terms;
    }

    public static <T extends AMonomial<T>, P extends AMultivariatePolynomial<T, P>> P swapVariables(P poly, int i, int j) {
        if (i == j) {
            return (P)poly.clone();
        }
        int[] newVariables = ArraysUtil.sequence(poly.nVariables);
        newVariables[i] = j;
        newVariables[j] = i;
        return AMultivariatePolynomial.renameVariables(poly, newVariables, poly.ordering);
    }

    public static <T extends AMonomial<T>, P extends AMultivariatePolynomial<T, P>> P renameVariables(P poly, int[] newVariables) {
        return AMultivariatePolynomial.renameVariables(poly, newVariables, poly.ordering);
    }

    public static <T extends AMonomial<T>> T renameVariables(T e, int[] newVariables) {
        return e.setDegreeVector(AMultivariatePolynomial.map(e.exponents, newVariables), e.totalDegree);
    }

    public static <T extends AMonomial<T>, P extends AMultivariatePolynomial<T, P>> P renameVariables(P poly, int[] newVariables, Comparator<DegreeVector> newOrdering) {
        MonomialSet<AMonomial> data = new MonomialSet<AMonomial>(newOrdering);
        for (AMonomial e : poly.terms) {
            data.add(AMultivariatePolynomial.renameVariables(e, newVariables));
        }
        return poly.create((Term)data);
    }

    private static int[] map(int[] degrees, int[] mapping) {
        int[] newDegrees = new int[degrees.length];
        for (int i = 0; i < degrees.length; ++i) {
            newDegrees[i] = degrees[mapping[i]];
        }
        return newDegrees;
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly asMultivariate(IUnivariatePolynomial poly, int nVariables, int variable, Comparator<DegreeVector> ordering) {
        if (poly instanceof UnivariatePolynomial) {
            return (Poly)MultivariatePolynomial.asMultivariate((UnivariatePolynomial)poly, nVariables, variable, ordering);
        }
        if (poly instanceof UnivariatePolynomialZp64) {
            return (Poly)MultivariatePolynomialZp64.asMultivariate((UnivariatePolynomialZp64)poly, nVariables, variable, ordering);
        }
        throw new RuntimeException();
    }

    public abstract IUnivariatePolynomial asUnivariate();

    final Poly create(MonomialSet<Term> terms) {
        return this.create(this.nVariables, this.ordering, terms);
    }

    final Poly create(int nVariables, MonomialSet<Term> terms) {
        return this.create(nVariables, this.ordering, terms);
    }

    abstract Poly create(int var1, Comparator<DegreeVector> var2, MonomialSet<Term> var3);

    public final Poly create(Term ... terms) {
        return this.create((Term)Arrays.asList(terms));
    }

    public final Poly create(Iterable<Term> terms) {
        MonomialSet monomials = new MonomialSet((Comparator<? super DegreeVector>)this.ordering);
        for (AMonomial term : terms) {
            if (term.exponents.length != this.nVariables) {
                throw new IllegalArgumentException();
            }
            this.add(monomials, (Term)term);
        }
        return this.create((Term)monomials);
    }

    public final Poly create(Term term) {
        if (((AMonomial)term).exponents.length != this.nVariables) {
            throw new IllegalArgumentException();
        }
        MonomialSet monomials = new MonomialSet((Comparator<? super DegreeVector>)this.ordering);
        this.add(monomials, term);
        return this.create((Term)monomials);
    }

    public abstract Poly createConstantFromTerm(Term var1);

    public final Poly create(DegreeVector term) {
        return this.create(this.monomialAlgebra.create(term));
    }

    public final Poly createMonomial(int variable, int degree) {
        int[] degreeVector = new int[this.nVariables];
        degreeVector[variable] = degree;
        return this.create(this.monomialAlgebra.create(degreeVector));
    }

    public final Poly setOrdering(Comparator<DegreeVector> newOrdering) {
        if (this.ordering.equals(newOrdering)) {
            return (Poly)this.clone();
        }
        MonomialSet newData = new MonomialSet((Comparator<? super DegreeVector>)newOrdering);
        newData.putAll(this.terms);
        return this.create(this.nVariables, newOrdering, newData);
    }

    final Poly setOrderingUnsafe(Comparator<DegreeVector> newOrdering) {
        if (this.ordering.equals(newOrdering)) {
            return this.self;
        }
        return this.setOrdering(newOrdering);
    }

    protected void release() {
        this.cachedDegrees = null;
        this.cachedDegree = -1;
    }

    @Override
    public final int size() {
        return this.terms.size();
    }

    @Override
    public final boolean isZero() {
        return this.terms.isEmpty();
    }

    @Override
    public boolean isLinearOrConstant() {
        if (this.size() > 2) {
            return false;
        }
        if (this.isConstant()) {
            return true;
        }
        if (this.isZeroCC()) {
            return this.size() == 1;
        }
        return this.size() == 2;
    }

    @Override
    public boolean isLinearExactly() {
        if (this.size() > 2) {
            return false;
        }
        if (this.isConstant()) {
            return false;
        }
        if (this.isZeroCC()) {
            return this.size() == 1;
        }
        return this.size() == 2;
    }

    @Override
    public boolean isZeroCC() {
        return !this.terms.containsKey(new DegreeVector(new int[this.nVariables], 0));
    }

    @Override
    public final Iterator<Term> iterator() {
        return this.terms.iterator();
    }

    @Override
    public Iterator<Term> ascendingIterator() {
        return this.terms.values().iterator();
    }

    @Override
    public Iterator<Term> descendingIterator() {
        return this.terms.descendingMap().values().iterator();
    }

    @Override
    public Term first() {
        return this.terms.first();
    }

    @Override
    public Term last() {
        return this.terms.last();
    }

    @Override
    public final Collection<Term> collection() {
        return this.terms.values();
    }

    public final Term[] toArray() {
        return this.terms.values().toArray(this.monomialAlgebra.createArray(this.terms.size()));
    }

    @Override
    public final boolean isMonomial() {
        return this.size() <= 1;
    }

    public final boolean isVariable() {
        return this.isMonomial() && this.isEffectiveUnivariate() && ((AMultivariatePolynomial)this.lcAsPoly()).isOne() && !this.isConstant();
    }

    @Override
    public final Poly toZero() {
        this.terms.clear();
        this.release();
        return this.self;
    }

    @Override
    public final Poly set(Poly oth) {
        if (oth == this) {
            return this.self;
        }
        this.assertSameCoefficientRingWith(oth);
        return this.loadFrom(((AMultivariatePolynomial)oth).terms);
    }

    final Poly loadFrom(MonomialSet<Term> map) {
        this.terms.clear();
        this.terms.putAll(map);
        this.release();
        return this.self;
    }

    public final Poly dropVariable(int variable) {
        MonomialSet newData = new MonomialSet((Comparator<? super DegreeVector>)this.ordering);
        for (AMonomial term : this.terms) {
            newData.add(term.without(variable));
        }
        return this.create(this.nVariables - 1, newData);
    }

    public final Poly dropVariables(int[] variables) {
        MonomialSet newData = new MonomialSet((Comparator<? super DegreeVector>)this.ordering);
        for (AMonomial term : this.terms) {
            newData.add(term.without(variables));
        }
        assert (this.nVariables >= variables.length);
        return this.create(this.nVariables - variables.length, newData);
    }

    public final Poly dropSelectVariables(int ... variables) {
        MonomialSet newData = new MonomialSet((Comparator<? super DegreeVector>)this.ordering);
        for (AMonomial term : this.terms) {
            newData.add(term.dropSelect(variables));
        }
        return this.create(variables.length, newData);
    }

    public final Poly insertVariable(int variable) {
        MonomialSet newData = new MonomialSet((Comparator<? super DegreeVector>)this.ordering);
        for (AMonomial term : this.terms) {
            newData.add(term.insert(variable));
        }
        return this.create(this.nVariables + 1, newData);
    }

    public final Poly insertVariable(int variable, int count) {
        MonomialSet newData = new MonomialSet((Comparator<? super DegreeVector>)this.ordering);
        for (AMonomial term : this.terms) {
            newData.add(term.insert(variable, count));
        }
        return this.create(this.nVariables + count, newData);
    }

    public final Poly setNVariables(int newNVariables) {
        if (newNVariables == this.nVariables) {
            return this.self;
        }
        MonomialSet newData = new MonomialSet((Comparator<? super DegreeVector>)this.ordering);
        for (AMonomial term : this.terms) {
            newData.add(term.setNVariables(newNVariables));
        }
        return this.create(newNVariables, newData);
    }

    public final Poly mapVariables(int[] mapping) {
        int newNVars = ArraysUtil.max(mapping) + 1;
        MonomialSet newData = new MonomialSet((Comparator<? super DegreeVector>)this.ordering);
        for (AMonomial term : this.terms) {
            newData.add(term.map(newNVars, mapping));
        }
        return this.create(newNVars, newData);
    }

    public final Poly joinNewVariable() {
        return this.joinNewVariables(1);
    }

    public final Poly joinNewVariables(int n) {
        MonomialSet newData = new MonomialSet((Comparator<? super DegreeVector>)this.ordering);
        for (AMonomial term : this.terms) {
            newData.add(term.joinNewVariables(n));
        }
        return this.create(this.nVariables + n, newData);
    }

    final Poly joinNewVariables(int newNVariables, int[] mapping) {
        MonomialSet newData = new MonomialSet((Comparator<? super DegreeVector>)this.ordering);
        for (AMonomial term : this.terms) {
            newData.add(term.joinNewVariables(newNVariables, mapping));
        }
        return this.create(newNVariables, newData);
    }

    public final int nUsedVariables() {
        int[] degrees = this.degreesRef();
        int r = 0;
        for (int d : degrees) {
            if (d == 0) continue;
            ++r;
        }
        return r;
    }

    @Override
    public int degree() {
        if (this.cachedDegree == -1) {
            int max = 0;
            for (AMonomial db : this.terms) {
                max = Math.max(max, db.totalDegree);
            }
            this.cachedDegree = max;
        }
        return this.cachedDegree;
    }

    public int degree(int ... variables) {
        int max = 0;
        for (AMonomial db : this.terms) {
            max = Math.max(max, db.dvTotalDegree(variables));
        }
        return max;
    }

    public int degreeMax() {
        return ArraysUtil.max(this.degreesRef());
    }

    public final int degree(int variable) {
        return this.degreesRef()[variable];
    }

    protected int[] degreesRef() {
        if (this.cachedDegrees == null) {
            int[] degrees = new int[this.nVariables];
            for (AMonomial db : this.terms) {
                for (int i = 0; i < this.nVariables; ++i) {
                    if (db.exponents[i] <= degrees[i]) continue;
                    degrees[i] = db.exponents[i];
                }
            }
            this.cachedDegrees = degrees;
            return degrees;
        }
        return this.cachedDegrees;
    }

    @Override
    public final int[] degrees() {
        return (int[])this.degreesRef().clone();
    }

    public final int[] multidegree() {
        return ((AMonomial)this.lt()).exponents;
    }

    public final int[] degrees(int variable) {
        TIntHashSet degrees = new TIntHashSet();
        for (AMonomial db : this.terms) {
            degrees.add(db.exponents[variable]);
        }
        return degrees.toArray();
    }

    @Override
    public final int degreeSum() {
        return ArraysUtil.sum(this.degreesRef());
    }

    public final int totalDegree() {
        return this.degreeSum();
    }

    public double sparsity() {
        double sparsity = this.size();
        for (int d : this.degreesRef()) {
            if (d == 0) continue;
            sparsity /= (double)(d + 1);
        }
        return sparsity;
    }

    public double sparsity2() {
        TIntHashSet distinctTotalDegrees = new TIntHashSet();
        this.terms.keySet().stream().mapToInt(dv -> dv.totalDegree).forEach(arg_0 -> ((TIntHashSet)distinctTotalDegrees).add(arg_0));
        TIntIterator it = distinctTotalDegrees.iterator();
        double nDenseTerms = 0.0;
        while (it.hasNext()) {
            int deg = it.next();
            double d = BigIntegerUtil.binomial(deg + this.nVariables - 1, deg).doubleValue();
            nDenseTerms += d;
            if (d != Double.MAX_VALUE) continue;
            return (double)this.size() / d;
        }
        return (double)this.size() / nDenseTerms;
    }

    public final int ecart() {
        return this.degreeSum() - ((AMonomial)this.lt()).totalDegree;
    }

    public final boolean isHomogeneous() {
        int deg = -1;
        for (AMonomial term : this.terms) {
            if (deg == -1) {
                deg = term.totalDegree;
                continue;
            }
            if (term.totalDegree == deg) continue;
            return false;
        }
        return true;
    }

    public final Poly homogenize(int variable) {
        int deg = this.totalDegree();
        MonomialSet result = new MonomialSet((Comparator<? super DegreeVector>)this.ordering);
        for (AMonomial term : this.terms) {
            DegreeVector dv = term.dvInsert(variable);
            dv = dv.dvSet(variable, deg - dv.totalDegree);
            result.add(term.setDegreeVector(dv));
        }
        return this.create(this.nVariables + 1, result);
    }

    public final boolean isEffectiveUnivariate() {
        return this.univariateVariable() != -1;
    }

    public final int univariateVariable() {
        if (this.isConstant()) {
            return 0;
        }
        if (this.nVariables == 1) {
            return 0;
        }
        int[] degrees = this.degreesRef();
        int var = -1;
        for (int i = 0; i < this.nVariables; ++i) {
            if (degrees[i] == 0) continue;
            if (var != -1) {
                return -1;
            }
            var = i;
        }
        return var;
    }

    public final Poly coefficientOf(int variable, int exponent) {
        AMultivariatePolynomial result = (AMultivariatePolynomial)this.createZero();
        for (AMonomial e : this.terms) {
            if (e.exponents[variable] != exponent) continue;
            result.add((Term)e.setZero(variable));
        }
        return (Poly)result;
    }

    public final Poly coefficientOf(int[] variables, int[] exponents) {
        if (variables.length != exponents.length) {
            throw new IllegalArgumentException();
        }
        AMultivariatePolynomial result = (AMultivariatePolynomial)this.createZero();
        block0: for (AMonomial e : this.terms) {
            for (int i = 0; i < variables.length; ++i) {
                if (e.exponents[variables[i]] != exponents[i]) continue block0;
            }
            result.add((Term)e.setZero(variables));
        }
        return (Poly)result;
    }

    public final Poly dropCoefficientOf(int[] variables, int[] exponents) {
        if (variables.length != exponents.length) {
            throw new IllegalArgumentException();
        }
        AMultivariatePolynomial result = (AMultivariatePolynomial)this.createZero();
        Iterator<Term> it = this.terms.iterator();
        block0: while (it.hasNext()) {
            AMonomial e = (AMonomial)it.next();
            for (int i = 0; i < variables.length; ++i) {
                if (e.exponents[variables[i]] != exponents[i]) continue block0;
            }
            result.add((Term)e.setZero(variables));
            it.remove();
        }
        return (Poly)result;
    }

    public final UnivariatePolynomial<Poly> asUnivariate(int variable) {
        MultivariateRing<Poly> ring = new MultivariateRing<Poly>(this.self);
        AMultivariatePolynomial[] univarData = (AMultivariatePolynomial[])ring.createZeroesArray(this.degree(variable) + 1);
        for (AMonomial e : this.terms) {
            univarData[e.exponents[variable]].add((Term)e.set(variable, 0));
        }
        return UnivariatePolynomial.createUnsafe(ring, univarData);
    }

    public final UnivariatePolynomial<Poly> asUnivariateEliminate(int variable) {
        MultivariateRing<Poly> ring = new MultivariateRing<Poly>(((AMultivariatePolynomial)this.createZero()).dropVariable(variable));
        AMultivariatePolynomial[] univarData = (AMultivariatePolynomial[])ring.createZeroesArray(this.degree(variable) + 1);
        for (AMonomial e : this.terms) {
            univarData[e.exponents[variable]].add((Term)e.without(variable));
        }
        return UnivariatePolynomial.createUnsafe(ring, univarData);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly asMultivariate(UnivariatePolynomial<Poly> univariate, int uVariable, boolean join) {
        AMultivariatePolynomial<Term, Poly> factory = (AMultivariatePolynomial)univariate.get(0);
        if (join) {
            factory = factory.insertVariable(uVariable);
        }
        AMultivariatePolynomial result = (AMultivariatePolynomial)factory.createZero();
        for (int i = 0; i <= univariate.degree(); ++i) {
            AMultivariatePolynomial<Term, Poly> cf = (AMultivariatePolynomial)univariate.get(i);
            if (join) {
                cf = cf.insertVariable(uVariable);
            }
            result.add((Term)((AMultivariatePolynomial)cf.multiply((Term)factory.createMonomial(uVariable, i))));
        }
        return (Poly)result;
    }

    public abstract MultivariatePolynomial<? extends IUnivariatePolynomial> asOverUnivariate(int var1);

    public abstract MultivariatePolynomial<? extends IUnivariatePolynomial> asOverUnivariateEliminate(int var1);

    public abstract MultivariatePolynomial<Poly> asOverMultivariate(int ... var1);

    public final MultivariatePolynomial<Poly> asOverMultivariateEliminate(int ... variables) {
        return this.asOverMultivariateEliminate(variables, this.ordering);
    }

    public abstract MultivariatePolynomial<Poly> asOverMultivariateEliminate(int[] var1, Comparator<DegreeVector> var2);

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly asMultivariate(UnivariatePolynomial<Poly> uPoly, int variable) {
        AMultivariatePolynomial result = (AMultivariatePolynomial)uPoly.ring.getZero();
        for (int i = uPoly.degree(); i >= 0; --i) {
            if (uPoly.isZeroAt(i)) continue;
            result.add((Term)((AMultivariatePolynomial)((AMultivariatePolynomial)result.createMonomial(variable, i)).multiply((Term)((AMultivariatePolynomial)uPoly.get(i)))));
        }
        return (Poly)result;
    }

    public abstract Poly primitivePart(int var1);

    public abstract IUnivariatePolynomial contentUnivariate(int var1);

    public abstract Poly monic(Comparator<DegreeVector> var1);

    public abstract Poly monicWithLC(Comparator<DegreeVector> var1, Poly var2);

    public final Poly content(int variable) {
        return AMultivariatePolynomial.asMultivariate(this.contentUnivariate(variable), this.nVariables, variable, this.ordering);
    }

    public final Poly contentExcept(int variable) {
        return (Poly)((AMultivariatePolynomial)this.asUnivariate(variable).content());
    }

    public final Poly multiplyByMonomial(int variable, int exponent) {
        if (exponent == 0) {
            return this.self;
        }
        ArrayList oldData = new ArrayList(this.terms.values());
        this.terms.clear();
        for (AMonomial term : oldData) {
            this.terms.add(term.set(variable, term.exponents[variable] + exponent));
        }
        this.release();
        return this.self;
    }

    public final Poly lc(int variable) {
        int degree = this.degree(variable);
        AMultivariatePolynomial result = (AMultivariatePolynomial)this.createZero();
        for (AMonomial term : this) {
            if (term.exponents[variable] != degree) continue;
            result.add((Term)term.set(variable, 0));
        }
        return (Poly)result;
    }

    public final Poly setLC(int variable, Poly lc) {
        int degree = this.degree(variable);
        lc = ((AMultivariatePolynomial)((AMultivariatePolynomial)lc).clone()).multiplyByMonomial(variable, degree);
        Iterator it = this.terms.entrySet().iterator();
        while (it.hasNext()) {
            AMonomial term = (AMonomial)it.next().getValue();
            if (term.exponents[variable] != degree) continue;
            it.remove();
        }
        this.terms.putAll(((AMultivariatePolynomial)lc).terms);
        this.release();
        return this.self;
    }

    public final Term lt(Comparator<DegreeVector> ordering) {
        if (ordering.equals(this.ordering)) {
            return this.lt();
        }
        if (this.size() == 0) {
            return this.monomialAlgebra.getZeroTerm(this.nVariables);
        }
        return (Term)((AMonomial)this.terms.values().stream().max(ordering).get());
    }

    @Override
    public final Term lt() {
        return this.size() == 0 ? this.monomialAlgebra.getZeroTerm(this.nVariables) : this.terms.last();
    }

    public final Term mt() {
        return this.size() == 0 ? this.monomialAlgebra.getZeroTerm(this.nVariables) : this.terms.first();
    }

    public abstract Poly lcAsPoly(Comparator<DegreeVector> var1);

    public final Poly ltAsPoly() {
        return this.create(this.lt());
    }

    public final Term monomialContent() {
        return this.commonContent(null);
    }

    final Term commonContent(Term monomial) {
        if (!((AMultivariatePolynomial)this.ccAsPoly()).isZero()) {
            return this.monomialAlgebra.getUnitTerm(this.nVariables);
        }
        int[] exponents = monomial == null ? null : (int[])((AMonomial)monomial).exponents.clone();
        int totalDegree = -1;
        for (AMonomial degreeVector : this.terms) {
            if (exponents == null) {
                exponents = (int[])degreeVector.exponents.clone();
                continue;
            }
            totalDegree = AMultivariatePolynomial.setMin(degreeVector.exponents, exponents);
            if (totalDegree != 0) continue;
            break;
        }
        if (exponents == null) {
            return this.monomialAlgebra.getUnitTerm(this.nVariables);
        }
        return this.monomialAlgebra.create(new DegreeVector(exponents, totalDegree));
    }

    static int setMin(int[] dv, int[] exponents) {
        int sum = 0;
        for (int i = 0; i < exponents.length; ++i) {
            if (dv[i] < exponents[i]) {
                exponents[i] = dv[i];
            }
            sum += exponents[i];
        }
        return sum;
    }

    public final Poly divideDegreeVectorOrNull(DegreeVector monomial) {
        if (monomial.isZeroVector()) {
            return this.self;
        }
        MonomialSet map = new MonomialSet((Comparator<? super DegreeVector>)this.ordering);
        for (AMonomial term : this.terms) {
            Object dv = term.divideOrNull(monomial);
            if (dv == null) {
                return null;
            }
            map.add(dv);
        }
        return this.loadFrom(map);
    }

    final void checkSameDomainWith(Term oth) {
        if (this.nVariables != ((AMonomial)oth).exponents.length) {
            throw new IllegalArgumentException("Combining multivariate polynomials from different fields: this.nVariables = " + this.nVariables + " oth.nVariables = " + ((DegreeVector)oth).nVariables());
        }
    }

    public abstract Poly divideOrNull(Term var1);

    abstract void add(MonomialSet<Term> var1, Term var2);

    abstract void subtract(MonomialSet<Term> var1, Term var2);

    @Override
    public final Poly add(Poly oth) {
        if (this.terms == ((AMultivariatePolynomial)oth).terms) {
            return (Poly)((AMultivariatePolynomial)this.multiply((Term)2L));
        }
        this.assertSameCoefficientRingWith(oth);
        if (((AMultivariatePolynomial)oth).isZero()) {
            return this.self;
        }
        for (AMonomial term : ((AMultivariatePolynomial)oth).terms) {
            this.add(this.terms, (Term)term);
        }
        this.release();
        return this.self;
    }

    @Override
    public final Poly subtract(Poly oth) {
        if (this.terms == ((AMultivariatePolynomial)oth).terms) {
            return (Poly)this.toZero();
        }
        this.assertSameCoefficientRingWith(oth);
        if (((AMultivariatePolynomial)oth).isZero()) {
            return this.self;
        }
        for (AMonomial term : ((AMultivariatePolynomial)oth).terms) {
            this.subtract((Term)this.terms, (Poly)term);
        }
        this.release();
        return this.self;
    }

    public final Poly subtract(Term cf, Poly oth) {
        if (this.monomialAlgebra.isZero(cf)) {
            return this.self;
        }
        if (this.terms == ((AMultivariatePolynomial)oth).terms && this.monomialAlgebra.isOne(cf)) {
            return (Poly)this.toZero();
        }
        this.assertSameCoefficientRingWith(oth);
        if (((AMultivariatePolynomial)oth).isZero()) {
            return this.self;
        }
        for (AMonomial term : ((AMultivariatePolynomial)oth).terms) {
            this.subtract((Term)this.terms, (Poly)this.monomialAlgebra.multiply((AMonomial)cf, term));
        }
        this.release();
        return this.self;
    }

    @Override
    public final Poly add(Term monomial) {
        this.checkSameDomainWith(monomial);
        this.add(this.terms, monomial);
        this.release();
        return this.self;
    }

    public final Poly put(Term monomial) {
        this.checkSameDomainWith(monomial);
        this.terms.add(monomial);
        this.release();
        return this.self;
    }

    @Override
    public final Poly subtract(Term monomial) {
        this.checkSameDomainWith(monomial);
        this.subtract((Term)this.terms, (Poly)monomial);
        this.release();
        return this.self;
    }

    @Override
    public final Poly negate() {
        for (Map.Entry entry : this.terms.entrySet()) {
            AMonomial term = (AMonomial)entry.getValue();
            entry.setValue(this.monomialAlgebra.negate(term));
        }
        this.release();
        return this.self;
    }

    @Override
    public final Poly add(Iterable<Term> monomials) {
        for (AMonomial term : monomials) {
            this.add((Term)term);
        }
        return this.self;
    }

    @Override
    public final Poly add(Term ... monomials) {
        return this.add((Iterable<Term>)Arrays.asList(monomials));
    }

    public final Poly subtractLt() {
        this.terms.pollLastEntry();
        this.release();
        return this.self;
    }

    @Override
    public abstract Poly multiply(Term var1);

    public final Poly multiplyByDegreeVector(DegreeVector dv) {
        if (dv.isZeroVector()) {
            return this.self;
        }
        return this.multiply(this.monomialAlgebra.create(dv));
    }

    public final Set<DegreeVector> getSkeleton() {
        return Collections.unmodifiableSet(this.terms.keySet());
    }

    public final Poly setAllCoefficientsToUnit() {
        Term unit = this.monomialAlgebra.getUnitTerm(this.nVariables);
        for (Map.Entry entry : this.terms.entrySet()) {
            entry.setValue(((AMonomial)unit).setDegreeVector((DegreeVector)entry.getKey()));
        }
        this.release();
        return this.self;
    }

    public final Set<DegreeVector> getSkeleton(int ... variables) {
        return this.terms.keySet().stream().map(dv -> dv.dvSelect(variables)).collect(Collectors.toCollection(() -> new TreeSet<DegreeVector>(this.ordering)));
    }

    public final Set<DegreeVector> getSkeletonDrop(int ... variables) {
        int[] variablesSorted = (int[])variables.clone();
        Arrays.sort(variablesSorted);
        return this.terms.keySet().stream().map(dv -> dv.dvDropSelect(variablesSorted)).collect(Collectors.toCollection(() -> new TreeSet<DegreeVector>(this.ordering)));
    }

    public final Set<DegreeVector> getSkeletonExcept(int ... variables) {
        return this.terms.keySet().stream().map(dv -> dv.dvSetZero(variables)).collect(Collectors.toCollection(() -> new TreeSet<DegreeVector>(this.ordering)));
    }

    public final boolean sameSkeletonQ(AMultivariatePolynomial oth) {
        return this.getSkeleton().equals(oth.getSkeleton());
    }

    public final boolean sameSkeletonQ(AMultivariatePolynomial oth, int ... variables) {
        return this.getSkeleton(variables).equals(oth.getSkeleton(variables));
    }

    public final boolean sameSkeletonExceptQ(AMultivariatePolynomial oth, int ... variables) {
        return this.getSkeletonExcept(variables).equals(oth.getSkeletonExcept(variables));
    }

    public final Poly derivative(int variable) {
        return this.derivative(variable, 1);
    }

    public abstract Poly derivative(int var1, int var2);

    public abstract Poly seriesCoefficient(int var1, int var2);

    public final Poly evaluateAtZero(int variable) {
        MonomialSet<AMonomial> newData = new MonomialSet<AMonomial>(this.ordering);
        for (AMonomial el : this.terms) {
            if (el.exponents[variable] != 0) continue;
            newData.add(el);
        }
        return this.create((Term)newData);
    }

    public final Poly evaluateAtZero(int[] variables) {
        if (variables.length == 0) {
            return (Poly)this.clone();
        }
        MonomialSet<AMonomial> newData = new MonomialSet<AMonomial>(this.ordering);
        block0: for (AMonomial el : this.terms) {
            for (int variable : variables) {
                if (el.exponents[variable] != 0) continue block0;
            }
            newData.add(el);
        }
        return this.create((Term)newData);
    }

    public final Poly[] derivative() {
        AMultivariatePolynomial[] result = (AMultivariatePolynomial[])this.createArray(this.nVariables);
        for (int i = 0; i < this.nVariables; ++i) {
            result[i] = this.derivative(i);
        }
        return result;
    }

    public final MultivariatePolynomial<Poly> asOverPoly(Poly factory) {
        MonomialSet newTerms = new MonomialSet((Comparator<? super DegreeVector>)this.ordering);
        for (AMonomial term : this.terms) {
            newTerms.add(new Monomial<Poly>(term, ((AMultivariatePolynomial)factory).createConstantFromTerm((AMonomial)term)));
        }
        return new MultivariatePolynomial<Poly>(this.nVariables, Rings.MultivariateRing(factory), this.ordering, newTerms);
    }

    public final Poly composition(Poly ... values) {
        if (values.length != this.nVariables) {
            throw new IllegalArgumentException();
        }
        Poly factory = values[0];
        return (Poly)((AMultivariatePolynomial)this.asOverPoly(factory).evaluate(values));
    }

    public final <sPoly extends IUnivariatePolynomial<sPoly>> sPoly composition(sPoly ... values) {
        if (values.length != this.nVariables) {
            throw new IllegalArgumentException();
        }
        return (sPoly)this.composition(Rings.UnivariateRing(values[0]), (IUnivariatePolynomial[])values);
    }

    public final <sPoly extends IUnivariatePolynomial<sPoly>> sPoly composition(Ring<sPoly> uRing, sPoly ... values) {
        if (values.length != this.nVariables) {
            throw new IllegalArgumentException();
        }
        Object factory = values[0];
        if (this instanceof MultivariatePolynomialZp64) {
            return (sPoly)((MultivariatePolynomialZp64)this).mapCoefficients(uRing, uRing::valueOf).evaluate(values);
        }
        return (sPoly)((IUnivariatePolynomial)((MultivariatePolynomial)this).mapCoefficients(uRing, cf -> ((UnivariatePolynomial)factory).createConstant(cf)).evaluate(values));
    }

    public final Poly composition(List<Poly> values) {
        if (this.nVariables == 0) {
            return this.self;
        }
        return (Poly)this.composition(values.toArray((AMultivariatePolynomial[])((AMultivariatePolynomial)values.get(0)).createArray(values.size())));
    }

    public final Poly composition(int variable, Poly value) {
        this.assertSameCoefficientRingWith(value);
        return (Poly)((AMultivariatePolynomial)this.asUnivariate(variable).evaluate(value));
    }

    public final Poly composition(int[] variables, Poly[] values) {
        if (variables.length == 0) {
            throw new IllegalArgumentException();
        }
        if (variables.length != values.length) {
            throw new IllegalArgumentException();
        }
        this.assertSameCoefficientRingWith(values[0]);
        variables = (int[])variables.clone();
        values = (AMultivariatePolynomial[])values.clone();
        ArraysUtil.quickSort(variables, values);
        int[] mainVariables = ArraysUtil.intSetDifference(ArraysUtil.sequence(0, this.nVariables), variables);
        MultivariatePolynomial<Object> r = this.asOverMultivariate(mainVariables).evaluate(variables, values);
        assert (r.isConstant());
        return (Poly)((AMultivariatePolynomial)r.cc());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AMultivariatePolynomial that = (AMultivariatePolynomial)o;
        if (this.nVariables != that.nVariables) {
            return false;
        }
        return this.terms.equals(that.terms);
    }

    public int hashCode() {
        return this.terms.hashCode();
    }

    public int skeletonHashCode() {
        return this.terms.skeletonHashCode();
    }

    @Override
    public abstract Poly clone();

    public abstract Poly evaluateAtRandom(int var1, RandomGenerator var2);

    public abstract Poly evaluateAtRandomPreservingSkeleton(int var1, RandomGenerator var2);

    public abstract <E> MultivariatePolynomial<E> mapCoefficientsAsPolys(Ring<E> var1, Function<Poly, E> var2);

    public final String toString() {
        return this.toString(IStringifier.dummy());
    }

    static long[] KroneckerMap(int[] degrees) {
        long[] result = new long[degrees.length];
        result[0] = 1L;
        for (int i = 1; i < degrees.length; ++i) {
            result[i] = 1L;
            double check = 1.0;
            for (int j = 0; j < i; ++j) {
                long b = 2L * (long)degrees[j] + 1L;
                int n = i;
                result[n] = result[n] * b;
                check *= (double)b;
            }
            if (!(check > 9.223372036854776E18)) continue;
            return null;
        }
        return result;
    }

    public static final class PolynomialCollector<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>>
    implements Collector<Term, Poly, Poly> {
        final Supplier<Poly> supplier;
        final BiConsumer<Poly, Term> accumulator = AMultivariatePolynomial::add;
        final BinaryOperator<Poly> combiner = (l, r) -> {
            l.add(r);
            return l;
        };
        final Function<Poly, Poly> finisher = Function.identity();

        public PolynomialCollector(Supplier<Poly> supplier) {
            this.supplier = supplier;
        }

        @Override
        public Supplier<Poly> supplier() {
            return this.supplier;
        }

        @Override
        public BiConsumer<Poly, Term> accumulator() {
            return this.accumulator;
        }

        @Override
        public BinaryOperator<Poly> combiner() {
            return this.combiner;
        }

        @Override
        public Function<Poly, Poly> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return EnumSet.of(Collector.Characteristics.IDENTITY_FINISH);
        }
    }
}

