/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Rational;
import cc.redberry.rings.Rationals;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.linear.LinearSolver;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.IPolynomialRing;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.PolynomialMethods;
import cc.redberry.rings.poly.UnivariateRing;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MonomialZp64;
import cc.redberry.rings.poly.multivar.MultivariateDivision;
import cc.redberry.rings.poly.multivar.MultivariateGCD;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariateGCD;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZ64;
import cc.redberry.rings.util.ArraysUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;
import java.util.stream.Collectors;

public final class HenselLifting {
    private static final double SPARSITY_THRESHOLD = 0.1;
    private static final long MAX_TERMS_IN_EXPAND_FORM = 0x800000L;

    private HenselLifting() {
    }

    private static <PolyZp extends IUnivariatePolynomial<PolyZp>> PolyZp[] monicExtendedEuclid(PolyZp a, PolyZp b) {
        Object[] xgcd = UnivariateGCD.PolynomialExtendedGCD(a, b);
        if (xgcd[0].isOne()) {
            return xgcd;
        }
        assert (xgcd[0].isConstant()) : "bad xgcd: " + Arrays.toString(xgcd) + " for xgcd(" + a + ", " + b + ")";
        xgcd[2].divideByLC(xgcd[0]);
        xgcd[1].divideByLC(xgcd[0]);
        xgcd[0].monic();
        return xgcd;
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly primitivePart(Poly poly) {
        return AMultivariatePolynomial.asMultivariate(poly.asUnivariate(0).primitivePart(), 0);
    }

    static MultivariatePolynomialZp64 modImage(MultivariatePolynomialZp64 poly, int degree) {
        if (degree == 0) {
            return poly.ccAsPoly();
        }
        Iterator it = poly.terms.entrySet().iterator();
        while (it.hasNext()) {
            MonomialZp64 term = (MonomialZp64)it.next().getValue();
            if (ArraysUtil.sum(term.exponents, 1) < degree) continue;
            it.remove();
            poly.release();
        }
        poly.release();
        return poly;
    }

    private static long[] map(long[] oldArray, int[] mapping) {
        long[] newArray = new long[oldArray.length];
        for (int i = 0; i < oldArray.length; ++i) {
            newArray[i] = oldArray[mapping[i]];
        }
        return newArray;
    }

    private static <E> E[] map(Ring<E> ring, E[] oldArray, int[] mapping) {
        int[] newArray = ring.createArray(oldArray.length);
        for (int i = 0; i < oldArray.length; ++i) {
            newArray[i] = (int)oldArray[mapping[i]];
        }
        return newArray;
    }

    static <uPoly extends IUnivariatePolynomial<uPoly>> UnivariatePolynomial<uPoly>[] bivariateLiftDense(UnivariatePolynomial<uPoly> baseSeries, uPoly[] factors, int degreeBound) {
        AllProductsCache uFactors = new AllProductsCache(factors);
        UMultiDiophantineSolver<IUnivariatePolynomial> uSolver = new UMultiDiophantineSolver<IUnivariatePolynomial>(uFactors);
        UnivariatePolynomial[] solution = new UnivariatePolynomial[factors.length];
        for (int i = 0; i < solution.length; ++i) {
            solution[i] = UnivariatePolynomial.constant(baseSeries.ring, ((IUnivariatePolynomial[])uFactors.factors)[i]);
            solution[i].ensureInternalCapacity(degreeBound + 1);
        }
        BernardinsTrickWithoutLCCorrection factorsProduct = new BernardinsTrickWithoutLCCorrection(solution);
        for (int degree = 1; degree <= degreeBound; ++degree) {
            IUnivariatePolynomial rhsDelta = ((IUnivariatePolynomial)baseSeries.get(degree)).clone().subtract((IUnivariatePolynomial)factorsProduct.fullProduct().get(degree));
            uSolver.solve(rhsDelta);
            factorsProduct.update((IPolynomial[])uSolver.solution);
        }
        return solution;
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>, uPoly extends IUnivariatePolynomial<uPoly>> void bivariateLiftNoLCCorrection0(Poly base, Poly[] factors, IEvaluation<Term, Poly> evaluation, int degreeBound) {
        UnivariateRing<IUnivariatePolynomial> uRing = new UnivariateRing<IUnivariatePolynomial>(((AMultivariatePolynomial)factors[0]).asUnivariate());
        UnivariatePolynomial[] res = HenselLifting.bivariateLiftDense(HenselLifting.seriesExpansionDense(uRing, base, 1, evaluation), (IUnivariatePolynomial[])HenselLifting.asUnivariate(factors, evaluation), (int)degreeBound);
        for (int i = 0; i < res.length; ++i) {
            factors[i].set(HenselLifting.denseSeriesToPoly(base, res[i], 1, evaluation));
        }
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void imposeLeadingCoefficients(Poly[] factors, Poly[] factorsLC) {
        if (factorsLC != null) {
            for (int i = 0; i < factors.length; ++i) {
                if (factorsLC[i] == null) continue;
                ((AMultivariatePolynomial)factors[i]).setLC(0, factorsLC[i]);
            }
        }
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>, uPoly extends IUnivariatePolynomial<uPoly>> void bivariateLift0(Poly base, Poly[] factors, Poly[] factorsLC, IEvaluation<Term, Poly> evaluation, int degreeBound) {
        HenselLifting.imposeLeadingCoefficients(factors, factorsLC);
        AllProductsCache uFactors = new AllProductsCache((IPolynomial[])HenselLifting.asUnivariate(factors, evaluation));
        UMultiDiophantineSolver<IUnivariatePolynomial> uSolver = new UMultiDiophantineSolver<IUnivariatePolynomial>(uFactors);
        UnivariateRing<IUnivariatePolynomial> uRing = new UnivariateRing<IUnivariatePolynomial>((IUnivariatePolynomial)uFactors.get(0));
        UnivariatePolynomial<IUnivariatePolynomial> baseSeries = HenselLifting.seriesExpansionDense(uRing, base, 1, evaluation);
        UnivariatePolynomial[] solution = new UnivariatePolynomial[factors.length];
        for (int i = 0; i < solution.length; ++i) {
            solution[i] = HenselLifting.seriesExpansionDense(uRing, factors[i], 1, evaluation);
            solution[i].ensureInternalCapacity(degreeBound + 1);
        }
        BernardinsTrick<Poly> product = HenselLifting.createBernardinsTrick(solution, degreeBound);
        for (int degree = 1; degree <= degreeBound; ++degree) {
            IUnivariatePolynomial rhsDelta = baseSeries.get(degree).clone().subtract((IUnivariatePolynomial)product.fullProduct().get(degree));
            uSolver.solve(rhsDelta);
            product.update((IPolynomial[])uSolver.solution);
        }
        for (int i = 0; i < solution.length; ++i) {
            factors[i].set(HenselLifting.denseSeriesToPoly(base, solution[i], 1, evaluation));
        }
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>, uPoly extends IUnivariatePolynomial<uPoly>> uPoly[] asUnivariate(Poly[] array, IEvaluation<Term, Poly> evaluation) {
        IUnivariatePolynomial u0 = ((AMultivariatePolynomial)evaluation.evaluateFrom(array[0], 1)).asUnivariate();
        IUnivariatePolynomial[] res = (IUnivariatePolynomial[])u0.createArray(array.length);
        res[0] = u0;
        for (int i = 1; i < array.length; ++i) {
            res[i] = ((AMultivariatePolynomial)evaluation.evaluateFrom(array[i], 1)).asUnivariate();
        }
        return res;
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>, uPoly extends IUnivariatePolynomial<uPoly>> Poly[] asMultivariate(uPoly[] array, int nVariables, int variable, Comparator<DegreeVector> ordering) {
        Object u0 = AMultivariatePolynomial.asMultivariate(array[0], nVariables, variable, ordering);
        AMultivariatePolynomial[] res = (AMultivariatePolynomial[])u0.createArray(array.length);
        res[0] = u0;
        for (int i = 1; i < array.length; ++i) {
            res[i] = AMultivariatePolynomial.asMultivariate(array[i], nVariables, variable, ordering);
        }
        return res;
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>, uPoly extends IUnivariatePolynomial<uPoly>> UnivariatePolynomial<uPoly> seriesExpansionDense(Ring<uPoly> ring, Poly poly, int variable, IEvaluation<Term, Poly> evaluate) {
        int degree = poly.degree(variable);
        IUnivariatePolynomial[] coefficients = (IUnivariatePolynomial[])ring.createArray((uPoly)(degree + 1));
        for (int i = 0; i <= degree; ++i) {
            coefficients[i] = ((AMultivariatePolynomial)evaluate.taylorCoefficient(poly, variable, i)).asUnivariate();
        }
        return UnivariatePolynomial.createUnsafe(ring, coefficients);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>, uPoly extends IUnivariatePolynomial<uPoly>> Poly denseSeriesToPoly(Poly factory, UnivariatePolynomial<uPoly> series, int seriesVariable, IEvaluation<Term, Poly> evaluation) {
        AMultivariatePolynomial result = (AMultivariatePolynomial)factory.createZero();
        for (int i = 0; i <= series.degree(); ++i) {
            Object mPoly = AMultivariatePolynomial.asMultivariate((IUnivariatePolynomial)series.get(i), factory.nVariables, 0, factory.ordering);
            result = result.add((AMultivariatePolynomial)((AMultivariatePolynomial)mPoly).multiply(evaluation.linearPower(seriesVariable, i)));
        }
        return (Poly)result;
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void multivariateLiftAutomaticLC(Poly base, Poly[] factors, IEvaluation<Term, Poly> evaluation) {
        Poly lc = ((AMultivariatePolynomial)base).lc(0);
        if (lc.isConstant()) {
            HenselLifting.multivariateLift0(base, factors, null, evaluation, (int[])((AMultivariatePolynomial)base).degrees());
        } else {
            Poly lcCorrection = evaluation.evaluateFrom(lc, 1);
            assert (lcCorrection.isConstant());
            for (AMultivariatePolynomial factor : factors) {
                assert (((AMonomial)factor.lt()).exponents[0] == factor.degree(0));
                factor.monicWithLC((AMultivariatePolynomial)((AMultivariatePolynomial)lcCorrection.lcAsPoly()));
            }
            base = (AMultivariatePolynomial)((AMultivariatePolynomial)((AMultivariatePolynomial)base).clone()).multiply((AMultivariatePolynomial)PolynomialMethods.polyPow(lc, factors.length - 1, true));
            HenselLifting.multivariateLift0((AMultivariatePolynomial)base, factors, (AMultivariatePolynomial[])((AMultivariatePolynomial[])ArraysUtil.arrayOf(lc, factors.length)), evaluation, (int[])((AMultivariatePolynomial)base).degrees());
            for (AMultivariatePolynomial factor : factors) {
                factor.set(HenselLifting.primitivePart(factor));
            }
        }
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void multivariateLiftAutomaticLC(Poly base, Poly[] factors, IEvaluation<Term, Poly> evaluation, int from) {
        Poly lc = ((AMultivariatePolynomial)base).lc(0);
        if (lc.isConstant()) {
            HenselLifting.multivariateLift0(base, factors, null, evaluation, (int[])((AMultivariatePolynomial)base).degrees());
        } else {
            Poly lcCorrection = evaluation.evaluateFrom(lc, from);
            for (Poly factor : factors) {
                assert (((AMonomial)((AMultivariatePolynomial)factor).lt()).exponents[0] == ((AMultivariatePolynomial)factor).degree(0));
                ((AMultivariatePolynomial)factor).multiply(MultivariateDivision.divideExact(lcCorrection, ((AMultivariatePolynomial)factor).lc(0)));
            }
            base = (AMultivariatePolynomial)((AMultivariatePolynomial)((AMultivariatePolynomial)base).clone()).multiply((AMultivariatePolynomial)PolynomialMethods.polyPow(lc, factors.length - 1, true));
            HenselLifting.multivariateLift0((AMultivariatePolynomial)base, factors, (AMultivariatePolynomial[])((AMultivariatePolynomial[])ArraysUtil.arrayOf(lc, factors.length)), evaluation, (int[])((AMultivariatePolynomial)base).degrees(), (int)from);
            for (Poly factor : factors) {
                ((AMultivariatePolynomial)factor).set(HenselLifting.primitivePart(factor));
            }
        }
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void multivariateLift0(Poly base, Poly[] factors, Poly[] factorsLC, IEvaluation<Term, Poly> evaluation, int[] degreeBounds) {
        HenselLifting.multivariateLift0(base, factors, factorsLC, evaluation, (int[])degreeBounds, (int)1);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>, uPoly extends IUnivariatePolynomial<uPoly>> void multivariateLift0(Poly base, Poly[] factors, Poly[] factorsLC, IEvaluation<Term, Poly> evaluation, int[] degreeBounds, int from) {
        if (base.nVariables == 2) {
            HenselLifting.bivariateLift0(base, factors, factorsLC, evaluation, (int)degreeBounds[1]);
            return;
        }
        if (from == 2 && base.sparsity() < 0.1) {
            AMultivariatePolynomial[] sparseFactors = null;
            try {
                sparseFactors = HenselLifting.sparseLifting(base, factors, factorsLC);
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            if (sparseFactors != null) {
                System.arraycopy(sparseFactors, 0, factors, 0, factors.length);
                return;
            }
        }
        HenselLifting.imposeLeadingCoefficients(factors, factorsLC);
        AllProductsCache uFactors = new AllProductsCache((IPolynomial[])HenselLifting.asUnivariate(factors, evaluation));
        UMultiDiophantineSolver uSolver = new UMultiDiophantineSolver(uFactors);
        MultiDiophantineSolver dSolver = new MultiDiophantineSolver(evaluation, from == 1 ? HenselLifting.asMultivariate((IUnivariatePolynomial[])((IUnivariatePolynomial[])uFactors.exceptArray()), (int)base.nVariables, (int)0, base.ordering) : (AMultivariatePolynomial[])new AllProductsCache(factors).exceptArray(), uSolver, degreeBounds, from);
        MultivariateRing<Poly> mRing = new MultivariateRing<Poly>(factors[0]);
        for (int liftingVariable = from; liftingVariable < base.nVariables; ++liftingVariable) {
            Poly baseImage = evaluation.evaluateFrom((Poly[])base, liftingVariable + 1);
            UnivariatePolynomial<Poly> baseSeries = HenselLifting.seriesExpansion(mRing, baseImage, liftingVariable, evaluation);
            UnivariatePolynomial[] solution = new UnivariatePolynomial[factors.length];
            for (int i = 0; i < solution.length; ++i) {
                solution[i] = HenselLifting.seriesExpansion(mRing, factors[i], liftingVariable, evaluation);
                solution[i].ensureInternalCapacity(degreeBounds[liftingVariable] + 1);
            }
            BernardinsTrick<Poly> product = HenselLifting.createBernardinsTrick(solution, degreeBounds[liftingVariable]);
            for (int degree = 1; degree <= degreeBounds[liftingVariable]; ++degree) {
                Object rhsDelta = ((AMultivariatePolynomial)((AMultivariatePolynomial)baseSeries.get(degree)).clone()).subtract((AMultivariatePolynomial)product.fullProduct().get(degree));
                dSolver.solve(rhsDelta, liftingVariable - 1);
                product.update((IPolynomial[])dSolver.solution);
            }
            for (int i = 0; i < solution.length; ++i) {
                factors[i].set(HenselLifting.seriesToPoly(base, solution[i], liftingVariable, evaluation));
            }
            if (liftingVariable >= base.nVariables) continue;
            dSolver.updateImageSeries(liftingVariable, (AMultivariatePolynomial[])new AllProductsCache(evaluation.evaluateFrom(factors, liftingVariable + 1)).exceptArray());
        }
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> UnivariatePolynomial<Poly> seriesExpansion(Ring<Poly> ring, Poly poly, int variable, IEvaluation<Term, Poly> evaluate) {
        int degree = poly.degree(variable);
        AMultivariatePolynomial[] coefficients = (AMultivariatePolynomial[])ring.createArray((Poly)(degree + 1));
        for (int i = 0; i <= degree; ++i) {
            coefficients[i] = evaluate.taylorCoefficient(poly, variable, i);
        }
        return UnivariatePolynomial.createUnsafe(ring, coefficients);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly seriesToPoly(Poly factory, UnivariatePolynomial<Poly> series, int seriesVariable, IEvaluation<Term, Poly> evaluation) {
        AMultivariatePolynomial result = (AMultivariatePolynomial)factory.createZero();
        for (int i = 0; i <= series.degree(); ++i) {
            AMultivariatePolynomial mPoly = (AMultivariatePolynomial)series.get(i);
            result = result.add((AMultivariatePolynomial)mPoly.multiply(evaluation.linearPower(seriesVariable, i)));
        }
        return (Poly)result;
    }

    static <Poly extends IPolynomial<Poly>> BernardinsTrick<Poly> createBernardinsTrick(UnivariatePolynomial<Poly>[] factors, int degreeBound) {
        if (Arrays.stream(factors).allMatch(UnivariatePolynomial::isConstant)) {
            return new BernardinsTrickWithoutLCCorrection<Poly>(factors);
        }
        return new BernardinsTrickWithLCCorrection<Poly>(factors, degreeBound);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly[] sparseLifting(Poly base, Poly[] biFactors, Poly[] lc) {
        Equation eq2;
        ArrayList determinedTerms = new ArrayList();
        ArrayList undeterminedTerms = new ArrayList();
        int nUnknowns = 0;
        long estimatedExpandedSize = 1L;
        for (int i = 0; i < biFactors.length; ++i) {
            ArrayList fixed = new ArrayList();
            ArrayList unknown = new ArrayList();
            determinedTerms.add(fixed);
            undeterminedTerms.add(unknown);
            HenselLifting.populateUnknownTerms(biFactors[i], lc == null ? (AMultivariatePolynomial)base.createOne() : lc[i], fixed, unknown);
            nUnknowns += unknown.size();
            estimatedExpandedSize *= (long)unknown.size();
        }
        if (estimatedExpandedSize > 1024L * (long)base.size() || estimatedExpandedSize > 0x800000L) {
            return null;
        }
        ArrayList trueFactors = new ArrayList();
        int unkCounter = base.nVariables;
        for (int i = 0; i < biFactors.length; ++i) {
            Object trueFactor = ((AMultivariatePolynomial)base.createZero()).joinNewVariables(nUnknowns);
            for (Object f : (List)determinedTerms.get(i)) {
                ((AMultivariatePolynomial)trueFactor).add(((AMonomial)f).joinNewVariables(nUnknowns));
            }
            for (int j = 0; j < ((List)undeterminedTerms.get(i)).size(); ++j) {
                ((AMultivariatePolynomial)trueFactor).add(((AMonomial)((AMonomial)((List)undeterminedTerms.get(i)).get(j)).joinNewVariables(nUnknowns)).set(unkCounter, 1));
                ++unkCounter;
            }
            trueFactors.add(trueFactor);
        }
        AMultivariatePolynomial lhsBase = trueFactors.stream().reduce((AMultivariatePolynomial)((AMultivariatePolynomial)trueFactors.get(0)).createOne(), (a, b) -> (AMultivariatePolynomial)a.multiply(b));
        MultivariatePolynomial<Poly> biBase = base.asOverMultivariate(ArraysUtil.sequence(2, base.nVariables));
        ArrayList<Equation<Term, Poly>> equations = new ArrayList<Equation<Term, Poly>>();
        for (Monomial monomial : biBase) {
            Object cf = lhsBase.dropCoefficientOf(new int[]{0, 1}, Arrays.copyOf(monomial.exponents, 2));
            Equation eq3 = new Equation((AMultivariatePolynomial)cf, (AMultivariatePolynomial)monomial.coefficient);
            if (!eq3.isConsistent()) {
                return null;
            }
            if (eq3.isIdentity()) continue;
            equations.add(eq3.canonical());
        }
        if (!lhsBase.isZero() && !(eq2 = new Equation(lhsBase, (AMultivariatePolynomial)biBase.ring.getZero())).isIdentity()) {
            equations.add(eq2.canonical());
        }
        ArrayList<BlockSolution<Term, Poly>> solutions = new ArrayList<BlockSolution<Term, Poly>>();
        block5: while (!equations.isEmpty()) {
            equations = new ArrayList(equations.stream().map(Equation::canonical).collect(Collectors.toSet()));
            equations.sort(Comparator.comparingInt(eq -> eq.nUnknowns));
            assert (equations.stream().allMatch(Equation::isConsistent));
            List list = equations.stream().filter(Equation::isLinear).collect(Collectors.toList());
            if (list.isEmpty()) {
                return null;
            }
            ArrayList<Equation<Term, Poly>> block = new ArrayList<Equation<Term, Poly>>();
            for (int i = 0; i < list.size(); ++i) {
                BlockSolution<Term, Poly> blockSolution;
                Equation baseEq = (Equation)list.get(i);
                block.add(baseEq);
                if (block.size() < baseEq.nUnknowns) {
                    for (int j = 0; j < list.size(); ++j) {
                        Equation eq22;
                        if (i == j || (eq22 = (Equation)list.get(j)).hasOtherUnknownsThan(baseEq)) continue;
                        block.add(eq22);
                    }
                }
                if (block.size() >= baseEq.nUnknowns && (blockSolution = HenselLifting.solveBlock(block)) != null) {
                    solutions.add(blockSolution);
                    equations.removeAll(block);
                    for (int k = 0; k < equations.size(); ++k) {
                        Equation<Term, Poly> eq4 = ((Equation)equations.get(k)).substituteSolutions(blockSolution);
                        if (!eq4.isConsistent()) {
                            return null;
                        }
                        equations.set(k, eq4);
                    }
                    assert (equations.stream().allMatch(Equation::isConsistent));
                    equations.removeAll(equations.stream().filter(Equation::isIdentity).collect(Collectors.toList()));
                    continue block5;
                }
                block.clear();
            }
            return null;
        }
        return (AMultivariatePolynomial[])trueFactors.stream().map(factor -> {
            MultivariatePolynomial result = factor.asOverMultivariateEliminate(ArraysUtil.sequence(0, base.nVariables));
            for (BlockSolution solution : solutions) {
                result = result.evaluate(solution.unknowns, solution.solutions);
            }
            assert (result.isConstant());
            return (AMultivariatePolynomial)result.cc();
        }).toArray((IntFunction<AMultivariatePolynomial[]>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createArray(int ), (I)[Lcc/redberry/rings/poly/multivar/AMultivariatePolynomial;)(base));
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> BlockSolution<Term, Poly> solveBlock(List<Equation<Term, Poly>> block) {
        Rational[] rhsColumn;
        Rational[][] lhsMatrix;
        LinearSolver.SystemInfo info;
        Equation<Term, Poly> baseEq = block.get(0);
        int[] unknowns = baseEq.getUnknowns();
        Object factory = baseEq.rhs;
        IPolynomialRing polyRing = Rings.PolynomialRing(factory);
        Rationals fracRing = Rings.Frac(polyRing);
        block.sort(Comparator.comparing(eq -> -eq.nUnknowns));
        ArrayList<Rational<Poly>[]> lhs = new ArrayList<Rational<Poly>[]>();
        ArrayList<Rational<Poly>> rhs = new ArrayList<Rational<Poly>>();
        for (int i = 0; i < unknowns.length; ++i) {
            HenselLifting.addRow(polyRing, block.get(i), lhs, rhs, unknowns);
        }
        Rational[] rSolution = new Rational[unknowns.length];
        while ((info = LinearSolver.solve(fracRing, lhsMatrix = (Rational[][])lhs.toArray((T[])new Rational[lhs.size()][]), rhsColumn = rhs.toArray(new Rational[rhs.size()]), rSolution)) != LinearSolver.SystemInfo.Consistent) {
            if (info == LinearSolver.SystemInfo.Inconsistent) {
                return null;
            }
            if (info != LinearSolver.SystemInfo.UnderDetermined) continue;
            lhs.clear();
            lhs.addAll(Arrays.asList(lhsMatrix));
            rhs.clear();
            rhs.addAll(Arrays.asList(rhsColumn));
            if (block.size() <= rhs.size()) {
                return null;
            }
            HenselLifting.addRow(polyRing, block.get(rhs.size()), lhs, rhs, unknowns);
        }
        AMultivariatePolynomial[] solution = (AMultivariatePolynomial[])factory.createArray(rSolution.length);
        for (int i = 0; i < rSolution.length; ++i) {
            Rational r = rSolution[i];
            if (!((AMultivariatePolynomial)r.denominator()).isOne()) {
                return null;
            }
            solution[i] = (AMultivariatePolynomial)r.numerator();
        }
        BlockSolution blockSolution = new BlockSolution(unknowns, solution);
        if (rhs.size() < block.size()) {
            for (int i = rhs.size(); i < block.size(); ++i) {
                if (block.get(i).substituteSolutions(blockSolution).isConsistent()) continue;
                return null;
            }
        }
        return blockSolution;
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void addRow(IPolynomialRing<Poly> polyRing, Equation<Term, Poly> eq, List<Rational<Poly>[]> lhs, List<Rational<Poly>> rhs, int[] unknowns) {
        Rational[] row = new Rational[unknowns.length];
        for (int j = 0; j < row.length; ++j) {
            MultivariatePolynomial el = (MultivariatePolynomial)eq.lhs.coefficientOf(unknowns[j], 1);
            assert (el.size() <= 1);
            row[j] = new Rational<AMultivariatePolynomial>(polyRing, (AMultivariatePolynomial)el.cc());
        }
        lhs.add(0, row);
        rhs.add(0, new Rational<Poly>(polyRing, eq.rhs));
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void populateUnknownTerms(Poly biPoly, Poly lc, List<Term> fixed, List<Term> unknown) {
        int xDeg = biPoly.degree(0);
        for (AMonomial term : biPoly) {
            if (term.exponents[0] == xDeg) {
                Poly cf = lc.coefficientOf(1, term.exponents[1]);
                term = term.setCoefficientFrom(((AMultivariatePolynomial)cf).monomialAlgebra.getUnitTerm(((AMultivariatePolynomial)cf).nVariables));
                fixed.addAll(((AMultivariatePolynomial)((AMultivariatePolynomial)cf).multiply((AMonomial)term)).collection());
                continue;
            }
            unknown.add(term);
        }
    }

    static final class Equation<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> {
        final MultivariatePolynomial<Poly> lhs;
        final Poly rhs;
        final int[] lhsDegrees;
        final boolean isLinear;
        final int nUnknowns;

        Equation(Poly lhs, Poly rhs) {
            this(((AMultivariatePolynomial)lhs).asOverMultivariateEliminate(ArraysUtil.sequence(0, ((AMultivariatePolynomial)rhs).nVariables)), rhs);
        }

        Equation(MultivariatePolynomial<Poly> lhs, Poly rhs) {
            ((AMultivariatePolynomial)rhs).subtract((AMultivariatePolynomial)((AMultivariatePolynomial)lhs.cc()));
            lhs.subtract((Poly)((AMultivariatePolynomial)lhs.cc()));
            this.lhs = lhs;
            this.rhs = rhs;
            this.lhsDegrees = this.lhs.degrees();
            this.isLinear = lhs.getSkeleton().stream().allMatch(__ -> __.totalDegree <= 1);
            int nUnknowns = 0;
            for (int lhsDegree : this.lhsDegrees) {
                nUnknowns += lhsDegree == 0 ? 0 : 1;
            }
            this.nUnknowns = nUnknowns;
        }

        boolean isConsistent() {
            return !this.isIdentity() || ((AMultivariatePolynomial)this.lhs.cc()).equals(this.rhs);
        }

        boolean hasOtherUnknownsThan(Equation<Term, Poly> other) {
            for (int i = 0; i < this.lhsDegrees.length; ++i) {
                if (this.lhsDegrees[i] <= other.lhsDegrees[i]) continue;
                return true;
            }
            return false;
        }

        boolean isIdentity() {
            return ArraysUtil.sum(this.lhsDegrees) == 0;
        }

        boolean isLinear() {
            return this.isLinear;
        }

        int[] getUnknowns() {
            int[] unknowns = new int[this.nUnknowns];
            int i = -1;
            for (int j = 0; j < this.lhsDegrees.length; ++j) {
                if (this.lhsDegrees[j] == 0) continue;
                unknowns[++i] = j;
            }
            return unknowns;
        }

        Equation<Term, Poly> substituteSolutions(BlockSolution<Term, Poly> solution) {
            return new Equation<Term, Object>(this.lhs.evaluate(solution.unknowns, solution.solutions), ((AMultivariatePolynomial)this.rhs).clone());
        }

        Equation<Term, Poly> canonical() {
            AMultivariatePolynomial gcd = MultivariateGCD.PolynomialGCD((AMultivariatePolynomial)this.lhs.content(), this.rhs);
            if (this.rhs.isOverField() && !((AMultivariatePolynomial)this.rhs).isZero()) {
                this.lhs.divideExact((AMultivariatePolynomial)this.rhs.lcAsPoly());
                this.rhs.monic();
            }
            return new Equation<Term, AMultivariatePolynomial>(this.lhs.divideExact(gcd), MultivariateDivision.divideExact(this.rhs, gcd));
        }

        public String toString() {
            return this.lhs.toString() + " = " + this.rhs;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Equation equation = (Equation)o;
            if (!this.lhs.equals(equation.lhs)) {
                return false;
            }
            return ((AMultivariatePolynomial)this.rhs).equals(equation.rhs);
        }

        public int hashCode() {
            int result = this.lhs.hashCode();
            result = 31 * result + ((AMultivariatePolynomial)this.rhs).hashCode();
            return result;
        }
    }

    static final class BlockSolution<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> {
        final int[] unknowns;
        final Poly[] solutions;

        BlockSolution(int[] unknowns, Poly[] solutions) {
            this.unknowns = unknowns;
            this.solutions = solutions;
        }

        public String toString() {
            return "solution: " + Arrays.toString(this.solutions);
        }
    }

    static final class BernardinsTrickWithLCCorrection<Poly extends IPolynomial<Poly>>
    extends BernardinsTrick<Poly> {
        final int degreeBound;
        private int pDegree = 0;

        BernardinsTrickWithLCCorrection(UnivariatePolynomial<Poly>[] factors, int degreeBound) {
            super(factors);
            this.degreeBound = degreeBound;
        }

        private void updatePair(int iFactor, Poly leftUpdate, Poly rightUpdate, int degree) {
            int i;
            UnivariatePolynomial right;
            UnivariatePolynomial left = iFactor == 0 ? this.factors[0] : this.partialProducts[iFactor - 1];
            UnivariatePolynomial univariatePolynomial = right = iFactor + 1 < this.factors.length ? this.factors[iFactor + 1] : null;
            if (leftUpdate != null) {
                left.addMonomial(leftUpdate, degree);
                if (iFactor < this.factors.length - 1) {
                    for (i = degree; i <= Math.min(this.degreeBound, degree + right.degree()); ++i) {
                        this.updatePair(iFactor + 1, ((IPolynomial)right.get(i - degree)).clone().multiply(leftUpdate), null, i);
                    }
                }
            }
            if (rightUpdate != null) {
                right.addMonomial(rightUpdate, degree);
                if (iFactor < this.factors.length - 1) {
                    for (i = degree; i <= Math.min(this.degreeBound, degree + left.degree()); ++i) {
                        this.updatePair(iFactor + 1, ((IPolynomial)left.get(i - degree)).clone().multiply(rightUpdate), null, i);
                    }
                }
            }
        }

        @Override
        void update(Poly ... updates) {
            ++this.pDegree;
            this.updatePair(0, updates[0], updates[1], this.pDegree);
            for (int i = 0; i < this.factors.length - 2; ++i) {
                this.updatePair(i + 1, null, updates[i + 2], this.pDegree);
            }
        }
    }

    static final class BernardinsTrickWithoutLCCorrection<Poly extends IPolynomial<Poly>>
    extends BernardinsTrick<Poly> {
        private int pDegree = 0;

        public BernardinsTrickWithoutLCCorrection(UnivariatePolynomial<Poly>[] factors) {
            super(factors);
        }

        @Override
        void update(Poly ... updates) {
            ++this.pDegree;
            for (int i = 0; i < this.factors.length; ++i) {
                this.factors[i].set(this.pDegree, updates[i]);
            }
            IPolynomial updateValue = ((IPolynomial)this.factors[0].get(this.pDegree)).clone().multiply((IPolynomial)((IPolynomial)this.factors[1].get(0))).add(((IPolynomial)this.factors[1].get(this.pDegree)).clone().multiply((IPolynomial)((IPolynomial)this.factors[0].get(0))));
            this.partialProducts[0].addMonomial(updateValue, this.pDegree);
            IPolynomial newElement = (IPolynomial)this.ring.getZero();
            for (int i = 1; i <= this.pDegree; ++i) {
                newElement.add(((IPolynomial)this.factors[0].get(i)).clone().multiply((IPolynomial)((IPolynomial)this.factors[1].get(this.pDegree - i + 1))));
            }
            this.partialProducts[0].set(this.pDegree + 1, newElement);
            for (int j = 1; j < this.partialProducts.length; ++j) {
                IPolynomial currentUpdate = ((IPolynomial)this.partialProducts[j - 1].get(0)).clone().multiply((IPolynomial)((IPolynomial)this.factors[j + 1].get(this.pDegree))).add(updateValue.multiply((IPolynomial)this.factors[j + 1].get(0)));
                this.partialProducts[j].addMonomial(currentUpdate, this.pDegree);
                updateValue = currentUpdate;
                newElement = (IPolynomial)this.ring.getZero();
                for (int i = 1; i <= this.pDegree + 1; ++i) {
                    newElement.add(((IPolynomial)this.partialProducts[j - 1].get(i)).clone().multiply((IPolynomial)((IPolynomial)this.factors[j + 1].get(this.pDegree - i + 1))));
                }
                this.partialProducts[j].set(this.pDegree + 1, newElement);
            }
        }
    }

    static abstract class BernardinsTrick<Poly extends IPolynomial<Poly>> {
        final UnivariatePolynomial<Poly>[] factors;
        final UnivariatePolynomial<Poly>[] partialProducts;
        final Ring<Poly> ring;

        BernardinsTrick(UnivariatePolynomial<Poly> ... factors) {
            this.factors = factors;
            this.partialProducts = factors[0].createArray(factors.length - 1);
            this.ring = factors[0].ring;
            this.partialProducts[0] = ((UnivariatePolynomial)factors[0].clone()).multiply(factors[1]);
            for (int i = 1; i < this.partialProducts.length; ++i) {
                this.partialProducts[i] = ((UnivariatePolynomial)this.partialProducts[i - 1].clone()).multiply(factors[i + 1]);
            }
        }

        abstract void update(Poly ... var1);

        final UnivariatePolynomial<Poly> fullProduct() {
            return this.partialProducts[this.partialProducts.length - 1];
        }

        final UnivariatePolynomial<Poly> partialProduct(int i) {
            return this.partialProducts[i];
        }
    }

    static final class MultiDiophantineSolver<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>, uPoly extends IUnivariatePolynomial<uPoly>> {
        final IEvaluation<Term, Poly> evaluation;
        final UMultiDiophantineSolver<uPoly> uSolver;
        final Poly[] solution;
        final int[] degreeBounds;
        final Ring<Poly> mRing;
        final UnivariatePolynomial<Poly>[][] imageSeries;

        MultiDiophantineSolver(IEvaluation<Term, Poly> evaluation, Poly[] factors, UMultiDiophantineSolver<uPoly> uSolver, int[] degreeBounds, int from) {
            assert (from >= 1);
            this.evaluation = evaluation;
            this.uSolver = uSolver;
            this.degreeBounds = degreeBounds;
            Poly factory = factors[0];
            this.solution = (AMultivariatePolynomial[])factory.createArray(factors.length);
            this.mRing = new MultivariateRing<Poly>(factors[0]);
            this.imageSeries = new UnivariatePolynomial[((AMultivariatePolynomial)factory).nVariables][factors.length];
            for (int i = from - 1; i >= 1; --i) {
                for (int j = 0; j < factors.length; ++j) {
                    this.imageSeries[i][j] = HenselLifting.seriesExpansion(this.mRing, evaluation.evaluateFrom(factors[j], i + 1), i, evaluation);
                }
            }
        }

        void updateImageSeries(int liftingVariable, Poly[] factors) {
            for (int i = 0; i < factors.length; ++i) {
                this.imageSeries[liftingVariable][i] = HenselLifting.seriesExpansion(this.mRing, factors[i], liftingVariable, this.evaluation);
            }
        }

        void solve(Poly rhs, int liftingVariable) {
            int i;
            if (((AMultivariatePolynomial)rhs).isZero()) {
                for (int i2 = 0; i2 < this.solution.length; ++i2) {
                    this.solution[i2] = (AMultivariatePolynomial)rhs.createZero();
                }
                return;
            }
            rhs = this.evaluation.evaluateFrom(rhs, liftingVariable + 1);
            if (liftingVariable == 0) {
                this.uSolver.solve(((AMultivariatePolynomial)rhs).asUnivariate());
                for (int i3 = 0; i3 < this.solution.length; ++i3) {
                    this.solution[i3] = AMultivariatePolynomial.asMultivariate(this.uSolver.solution[i3], ((AMultivariatePolynomial)rhs).nVariables, 0, ((AMultivariatePolynomial)rhs).ordering);
                }
                return;
            }
            this.solve(rhs, liftingVariable - 1);
            UnivariatePolynomial<Poly> rhsSeries = HenselLifting.seriesExpansion(this.mRing, rhs, liftingVariable, this.evaluation);
            UnivariatePolynomial[] tmpSolution = new UnivariatePolynomial[this.solution.length];
            for (int i4 = 0; i4 < tmpSolution.length; ++i4) {
                tmpSolution[i4] = HenselLifting.seriesExpansion(this.mRing, this.solution[i4], liftingVariable, this.evaluation);
            }
            BernardinsTrick[] pProducts = new BernardinsTrick[this.solution.length];
            for (i = 0; i < this.solution.length; ++i) {
                pProducts[i] = HenselLifting.createBernardinsTrick(new UnivariatePolynomial[]{tmpSolution[i], this.imageSeries[liftingVariable][i]}, this.degreeBounds[liftingVariable]);
            }
            for (int degree = 1; degree <= this.degreeBounds[liftingVariable]; ++degree) {
                int i5;
                AMultivariatePolynomial rhsDelta = (AMultivariatePolynomial)rhsSeries.get(degree);
                for (i5 = 0; i5 < this.solution.length; ++i5) {
                    rhsDelta = rhsDelta.subtract((AMultivariatePolynomial)pProducts[i5].fullProduct().get(degree));
                }
                this.solve(rhsDelta, liftingVariable - 1);
                for (i5 = 0; i5 < this.solution.length; ++i5) {
                    pProducts[i5].update(new AMultivariatePolynomial[]{this.solution[i5], (AMultivariatePolynomial)rhs.createZero()});
                }
            }
            for (i = 0; i < this.solution.length; ++i) {
                this.solution[i] = HenselLifting.seriesToPoly(rhs, tmpSolution[i], liftingVariable, this.evaluation);
            }
        }
    }

    static final class UMultiDiophantineSolver<uPoly extends IUnivariatePolynomial<uPoly>> {
        final AllProductsCache<uPoly> factors;
        final UDiophantineSolver<uPoly>[] biSolvers;
        final uPoly[] solution;

        UMultiDiophantineSolver(AllProductsCache<uPoly> factors) {
            this.factors = factors;
            this.biSolvers = new UDiophantineSolver[factors.size() - 1];
            for (int i = 0; i < this.biSolvers.length; ++i) {
                this.biSolvers[i] = new UDiophantineSolver<IUnivariatePolynomial>((IUnivariatePolynomial)factors.get(i), (IUnivariatePolynomial)factors.from(i + 1));
            }
            this.solution = (IUnivariatePolynomial[])((IUnivariatePolynomial[])factors.factors)[0].createArray(((IUnivariatePolynomial[])factors.factors).length);
        }

        void solve(uPoly rhs) {
            IPolynomial<Object> tmp = rhs.clone();
            for (int i = 0; i < this.factors.size() - 1; ++i) {
                this.biSolvers[i].solve(tmp);
                this.solution[i] = this.biSolvers[i].y;
                tmp = this.biSolvers[i].x;
            }
            this.solution[this.factors.size() - 1] = tmp;
        }
    }

    static final class UDiophantineSolver<uPoly extends IUnivariatePolynomial<uPoly>> {
        final uPoly a;
        final uPoly b;
        final uPoly aCoFactor;
        final uPoly bCoFactor;
        uPoly x;
        uPoly y;

        UDiophantineSolver(uPoly a, uPoly b) {
            this.a = a;
            this.b = b;
            IUnivariatePolynomial[] xgcd = HenselLifting.monicExtendedEuclid((IUnivariatePolynomial)a, (IUnivariatePolynomial)b);
            this.aCoFactor = xgcd[1];
            this.bCoFactor = xgcd[2];
        }

        void solve(uPoly rhs) {
            this.x = (IUnivariatePolynomial)this.aCoFactor.clone().multiply(rhs);
            this.y = (IUnivariatePolynomial)this.bCoFactor.clone().multiply(rhs);
            IUnivariatePolynomial[] qd = UnivariateDivision.divideAndRemainder(this.x, this.b, (boolean)false);
            this.x = qd[1];
            this.y = this.y.add((IUnivariatePolynomial)((IUnivariatePolynomial)qd[0].multiply(this.a)));
        }
    }

    static final class AllProductsCache<Poly extends IPolynomial<Poly>> {
        final Poly[] factors;
        final HashMap<BitSet, Poly> products = new HashMap();

        AllProductsCache(Poly[] factors) {
            assert (factors.length >= 1);
            this.factors = factors;
        }

        private static BitSet clear(BitSet set, int from, int to) {
            set = (BitSet)set.clone();
            set.clear(from, to);
            return set;
        }

        Poly multiply(BitSet selector) {
            int cardinality = selector.cardinality();
            assert (cardinality > 0);
            if (cardinality == 1) {
                return this.factors[selector.nextSetBit(0)];
            }
            IPolynomial cached = (IPolynomial)this.products.get(selector);
            if (cached != null) {
                return (Poly)cached;
            }
            int half = cardinality / 2;
            int i = 0;
            while (true) {
                if (selector.get(i)) {
                    --half;
                }
                if (half == 0) {
                    cached = this.multiply(AllProductsCache.clear(selector, 0, i + 1)).clone().multiply(this.multiply(AllProductsCache.clear(selector, i + 1, this.factors.length)));
                    this.products.put(selector, cached);
                    return (Poly)cached;
                }
                ++i;
            }
        }

        Poly multiply(int[] selector) {
            BitSet bits = new BitSet(this.factors.length);
            for (int i = 0; i < selector.length; ++i) {
                bits.set(selector[i]);
            }
            return this.multiply(bits);
        }

        int size() {
            return this.factors.length;
        }

        Poly get(int var) {
            return this.factors[var];
        }

        Poly except(int var) {
            BitSet bits = new BitSet(this.factors.length);
            bits.set(0, this.factors.length);
            bits.clear(var);
            return this.multiply(bits);
        }

        Poly from(int var) {
            BitSet bits = new BitSet(this.factors.length);
            bits.set(var, this.factors.length);
            return this.multiply(bits);
        }

        Poly[] exceptArray() {
            IPolynomial[] arr = this.factors[0].createArray(this.factors.length);
            for (int i = 0; i < arr.length; ++i) {
                arr[i] = this.except(i);
            }
            return arr;
        }

        Poly multiplyAll() {
            BitSet bits = new BitSet(this.factors.length);
            bits.set(0, this.factors.length);
            return this.multiply(bits);
        }
    }

    static final class Evaluation<E>
    implements IEvaluation<Monomial<E>, MultivariatePolynomial<E>> {
        final E[] values;
        final int nVariables;
        final Ring<E> ring;
        final MultivariatePolynomial.PrecomputedPowersHolder<E> precomputedPowers;
        final MultivariatePolynomial.USubstitution<E>[] linearPowers;
        final Comparator<DegreeVector> ordering;

        Evaluation(int nVariables, E[] values, Ring<E> ring, Comparator<DegreeVector> ordering) {
            this.nVariables = nVariables;
            this.values = values;
            this.ring = ring;
            this.ordering = ordering;
            this.precomputedPowers = MultivariatePolynomial.mkPrecomputedPowers(nVariables, ring, ArraysUtil.sequence(1, nVariables), values);
            this.linearPowers = new MultivariatePolynomial.USubstitution[nVariables - 1];
            for (int i = 0; i < nVariables - 1; ++i) {
                this.linearPowers[i] = new MultivariatePolynomial.USubstitution<E>(UnivariatePolynomial.createUnsafe(ring, ring.createArray(ring.negate(values[i]), ring.getOne())), i + 1, nVariables, ordering);
            }
        }

        Evaluation<E> setRing(Ring<E> ring) {
            return new Evaluation<E>(this.nVariables, this.values, ring, this.ordering);
        }

        @Override
        public MultivariatePolynomial<E> evaluate(MultivariatePolynomial<E> poly, int variable) {
            return poly.evaluate(variable, this.precomputedPowers.powers[variable]);
        }

        @Override
        public MultivariatePolynomial<E> evaluateFrom(MultivariatePolynomial<E> poly, int variable) {
            if (variable >= poly.nVariables) {
                return poly.clone();
            }
            if (variable == 1 && poly.univariateVariable() == 0) {
                return poly.clone();
            }
            return poly.evaluate(this.precomputedPowers, ArraysUtil.sequence(variable, this.nVariables));
        }

        @Override
        public MultivariatePolynomial<E> evaluateFromExcept(MultivariatePolynomial<E> poly, int from, int except) {
            if (from >= poly.nVariables) {
                return poly.clone();
            }
            if (from == 1 && poly.univariateVariable() == 0) {
                return poly.clone();
            }
            int[] vars = new int[poly.nVariables - from - 1];
            int c = 0;
            int i = from;
            while (i < except) {
                vars[c++] = i++;
            }
            i = except + 1;
            while (i < this.nVariables) {
                vars[c++] = i++;
            }
            return poly.evaluate(this.precomputedPowers, vars);
        }

        @Override
        public MultivariatePolynomial<E> linearPower(int variable, int exponent) {
            return this.linearPowers[variable - 1].pow(exponent);
        }

        @Override
        public boolean isZeroSubstitution(int variable) {
            return this.ring.isZero(this.values[variable - 1]);
        }

        public Evaluation<E> dropVariable(int variable) {
            return new Evaluation<E>(this.nVariables - 1, ArraysUtil.remove(this.values, variable - 1), this.ring, this.ordering);
        }

        public Evaluation<E> renameVariables(int[] variablesExceptFirst) {
            return new Evaluation<Object>(this.nVariables, HenselLifting.map(this.ring, this.values, variablesExceptFirst), this.ring, this.ordering);
        }

        public String toString() {
            return Arrays.toString(this.values);
        }
    }

    static final class lEvaluation
    implements IEvaluation<MonomialZp64, MultivariatePolynomialZp64> {
        final long[] values;
        final int nVariables;
        final MultivariatePolynomialZp64.lPrecomputedPowersHolder precomputedPowers;
        final MultivariatePolynomialZp64.lUSubstitution[] linearPowers;
        final IntegersZp64 ring;
        final Comparator<DegreeVector> ordering;

        lEvaluation(int nVariables, long[] values, IntegersZp64 ring, Comparator<DegreeVector> ordering) {
            this.nVariables = nVariables;
            this.values = values;
            this.ring = ring;
            this.ordering = ordering;
            this.precomputedPowers = MultivariatePolynomialZp64.mkPrecomputedPowers(nVariables, ring, ArraysUtil.sequence(1, nVariables), values);
            this.linearPowers = new MultivariatePolynomialZp64.lUSubstitution[nVariables - 1];
            for (int i = 0; i < nVariables - 1; ++i) {
                this.linearPowers[i] = new MultivariatePolynomialZp64.lUSubstitution(UnivariatePolynomialZ64.create(-values[i], 1L).modulus(ring), i + 1, nVariables, ordering);
            }
        }

        @Override
        public MultivariatePolynomialZp64 evaluate(MultivariatePolynomialZp64 poly, int variable) {
            return poly.evaluate(variable, this.precomputedPowers.powers[variable]);
        }

        @Override
        public MultivariatePolynomialZp64 evaluateFrom(MultivariatePolynomialZp64 poly, int variable) {
            if (variable >= poly.nVariables) {
                return poly.clone();
            }
            if (variable == 1 && poly.univariateVariable() == 0) {
                return poly.clone();
            }
            return poly.evaluate(this.precomputedPowers, ArraysUtil.sequence(variable, this.nVariables));
        }

        @Override
        public MultivariatePolynomialZp64 evaluateFromExcept(MultivariatePolynomialZp64 poly, int from, int except) {
            if (from >= poly.nVariables) {
                return poly.clone();
            }
            if (from == 1 && poly.univariateVariable() == 0) {
                return poly.clone();
            }
            int[] vars = new int[poly.nVariables - from - 1];
            int c = 0;
            int i = from;
            while (i < except) {
                vars[c++] = i++;
            }
            i = except + 1;
            while (i < this.nVariables) {
                vars[c++] = i++;
            }
            return poly.evaluate(this.precomputedPowers, vars);
        }

        @Override
        public MultivariatePolynomialZp64 linearPower(int variable, int exponent) {
            return this.linearPowers[variable - 1].pow(exponent);
        }

        @Override
        public boolean isZeroSubstitution(int variable) {
            return this.values[variable - 1] == 0L;
        }

        public lEvaluation dropVariable(int variable) {
            return new lEvaluation(this.nVariables - 1, ArraysUtil.remove(this.values, variable - 1), this.ring, this.ordering);
        }

        public lEvaluation renameVariables(int[] variablesExceptFirst) {
            return new lEvaluation(this.nVariables, HenselLifting.map(this.values, variablesExceptFirst), this.ring, this.ordering);
        }

        public String toString() {
            return Arrays.toString(this.values);
        }
    }

    static interface IEvaluation<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> {
        public Poly evaluateFrom(Poly var1, int var2);

        public Poly evaluateFromExcept(Poly var1, int var2, int var3);

        public Poly evaluate(Poly var1, int var2);

        default public Poly[] evaluateFrom(Poly[] array, int variable) {
            AMultivariatePolynomial[] result = (AMultivariatePolynomial[])array[0].createArray(array.length);
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.evaluateFrom(array[i], variable);
            }
            return result;
        }

        public boolean isZeroSubstitution(int var1);

        default public Poly taylorCoefficient(Poly poly, int variable, int order) {
            if (this.isZeroSubstitution(variable)) {
                return ((AMultivariatePolynomial)poly).coefficientOf(variable, order);
            }
            return this.evaluate(((AMultivariatePolynomial)poly).seriesCoefficient(variable, order), variable);
        }

        public Poly linearPower(int var1, int var2);

        default public Poly modImage(Poly poly, int variable, int idealExponent) {
            if (idealExponent == 0) {
                return (Poly)((AMultivariatePolynomial)poly).clone();
            }
            int degree = ((AMultivariatePolynomial)poly).degree(variable);
            if (idealExponent < degree - idealExponent) {
                AMultivariatePolynomial result = (AMultivariatePolynomial)poly.createZero();
                for (int i = 0; i < idealExponent; ++i) {
                    AMultivariatePolynomial term = (AMultivariatePolynomial)((AMultivariatePolynomial)this.evaluate(((AMultivariatePolynomial)poly).seriesCoefficient(variable, i), variable)).multiply(this.linearPower(variable, i));
                    if (term.isZero()) continue;
                    result.add(term);
                }
                return (Poly)result;
            }
            poly = ((AMultivariatePolynomial)poly).clone();
            for (int i = idealExponent; i <= degree; ++i) {
                AMultivariatePolynomial term = (AMultivariatePolynomial)((AMultivariatePolynomial)this.evaluate(((AMultivariatePolynomial)poly).seriesCoefficient(variable, i), variable)).multiply(this.linearPower(variable, i));
                if (term.isZero()) continue;
                ((AMultivariatePolynomial)poly).subtract(term);
            }
            return (Poly)poly;
        }

        default public Poly modImage(Poly poly, int[] degreeBounds) {
            for (int i = 1; i < degreeBounds.length; ++i) {
                poly = this.modImage(poly, i, degreeBounds[i] + 1);
            }
            return poly;
        }

        public IEvaluation<Term, Poly> dropVariable(int var1);

        public IEvaluation<Term, Poly> renameVariables(int[] var1);
    }
}

