/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.poly.multivar.DegreeVector;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public final class MonomialOrder {
    public static final Comparator<DegreeVector> LEX = Lex.access$000();
    public static final Comparator<DegreeVector> GRLEX = Grlex.access$100();
    public static final Comparator<DegreeVector> ALEX = Alex.access$200();
    public static final Comparator<DegreeVector> GREVLEX = Grevlex.access$300();
    public static final Comparator<DegreeVector> DEFAULT = MonomialOrder.parse(System.getProperty("defaultMonomialOrder", "grevlex").toLowerCase());

    private MonomialOrder() {
    }

    static Comparator<DegreeVector> parse(String string) {
        switch (string.toLowerCase()) {
            case "lex": {
                return LEX;
            }
            case "grlex": {
                return GRLEX;
            }
            case "grevlex": {
                return GREVLEX;
            }
            case "alex": {
                return ALEX;
            }
        }
        throw new RuntimeException("unknown: " + string);
    }

    public static Comparator<DegreeVector> product(Comparator<DegreeVector>[] orderings, int[] nVariables) {
        return new ProductOrder(orderings, nVariables);
    }

    public static Comparator<DegreeVector> product(Comparator<DegreeVector> a, int anVariables, Comparator<DegreeVector> b, int bnVariable) {
        return new ProductOrder(new Comparator[]{a, b}, new int[]{anVariables, bnVariable});
    }

    public static boolean isGradedOrder(Comparator<DegreeVector> monomialOrder) {
        return monomialOrder == GREVLEX || monomialOrder == GRLEX || monomialOrder instanceof GrevLexWithPermutation;
    }

    public static final class EliminationOrder
    implements Comparator<DegreeVector>,
    Serializable {
        final Comparator<DegreeVector> baseOrder;
        final int variable;

        public EliminationOrder(Comparator<DegreeVector> baseOrder, int variable) {
            this.baseOrder = baseOrder;
            this.variable = variable;
        }

        @Override
        public int compare(DegreeVector o1, DegreeVector o2) {
            int c = Integer.compare(o1.exponents[this.variable], o2.exponents[this.variable]);
            if (c != 0) {
                return c;
            }
            return this.baseOrder.compare(o1, o2);
        }
    }

    public static final class GrevLexWithPermutation
    implements Comparator<DegreeVector>,
    Serializable {
        final int[] permutation;

        GrevLexWithPermutation(int[] permutation) {
            this.permutation = permutation;
        }

        @Override
        public int compare(DegreeVector a, DegreeVector b) {
            int c = Integer.compare(a.totalDegree, b.totalDegree);
            if (c != 0) {
                return c;
            }
            for (int i = a.exponents.length - 1; i >= 0; --i) {
                c = Integer.compare(b.exponents[this.permutation[i]], a.exponents[this.permutation[i]]);
                if (c == 0) continue;
                return c;
            }
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GrevLexWithPermutation that = (GrevLexWithPermutation)o;
            return Arrays.equals(this.permutation, that.permutation);
        }

        public int hashCode() {
            return Arrays.hashCode(this.permutation);
        }
    }

    static final class ProductOrder
    implements Comparator<DegreeVector>,
    Serializable {
        final Comparator<DegreeVector>[] orderings;
        final int[] nVariables;

        ProductOrder(Comparator<DegreeVector>[] orderings, int[] nVariables) {
            this.orderings = orderings;
            this.nVariables = nVariables;
        }

        @Override
        public int compare(DegreeVector a, DegreeVector b) {
            int prev = 0;
            for (int i = 0; i < this.nVariables.length; ++i) {
                DegreeVector bBlock;
                DegreeVector aBlock = a.dvRange(prev, prev + this.nVariables[i]);
                int c = this.orderings[i].compare(aBlock, bBlock = b.dvRange(prev, prev + this.nVariables[i]));
                if (c != 0) {
                    return c;
                }
                prev += this.nVariables[i];
            }
            return 0;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProductOrder that = (ProductOrder)o;
            if (!Arrays.equals(this.orderings, that.orderings)) {
                return false;
            }
            return Arrays.equals(this.nVariables, that.nVariables);
        }

        public int hashCode() {
            int result = Arrays.hashCode(this.orderings);
            result = 31 * result + Arrays.hashCode(this.nVariables);
            return result;
        }
    }

    private static final class Grevlex
    implements Comparator<DegreeVector>,
    Serializable {
        private static final Grevlex instance = new Grevlex();

        private Grevlex() {
        }

        @Override
        public int compare(DegreeVector a, DegreeVector b) {
            int c = Integer.compare(a.totalDegree, b.totalDegree);
            if (c != 0) {
                return c;
            }
            for (int i = a.exponents.length - 1; i >= 0; --i) {
                c = Integer.compare(b.exponents[i], a.exponents[i]);
                if (c == 0) continue;
                return c;
            }
            return 0;
        }

        protected Object readResolve() {
            return instance;
        }

        static /* synthetic */ Grevlex access$300() {
            return instance;
        }
    }

    private static final class Alex
    implements Comparator<DegreeVector>,
    Serializable {
        private static final Alex instance = new Alex();

        private Alex() {
        }

        @Override
        public int compare(DegreeVector a, DegreeVector b) {
            return LEX.compare(b, a);
        }

        protected Object readResolve() {
            return instance;
        }

        static /* synthetic */ Alex access$200() {
            return instance;
        }
    }

    private static final class Grlex
    implements Comparator<DegreeVector>,
    Serializable {
        private static final Grlex instance = new Grlex();

        private Grlex() {
        }

        @Override
        public int compare(DegreeVector a, DegreeVector b) {
            int c = Integer.compare(a.totalDegree, b.totalDegree);
            return c != 0 ? c : LEX.compare(a, b);
        }

        protected Object readResolve() {
            return instance;
        }

        static /* synthetic */ Grlex access$100() {
            return instance;
        }
    }

    private static final class Lex
    implements Comparator<DegreeVector>,
    Serializable {
        private static final Lex instance = new Lex();

        private Lex() {
        }

        @Override
        public int compare(DegreeVector a, DegreeVector b) {
            for (int i = 0; i < a.exponents.length; ++i) {
                int c = Integer.compare(a.exponents[i], b.exponents[i]);
                if (c == 0) continue;
                return c;
            }
            return 0;
        }

        protected Object readResolve() {
            return instance;
        }

        static /* synthetic */ Lex access$000() {
            return instance;
        }
    }
}

