/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.Rings;
import cc.redberry.rings.poly.IPolynomialRing;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.UnivariateRing;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.util.ArraysUtil;
import java.util.Arrays;

public final class MultivariateConversions {
    private MultivariateConversions() {
    }

    public static <Poly extends AMultivariatePolynomial<?, Poly>> MultivariatePolynomial<Poly> split(Poly poly, int ... variables) {
        return poly.asOverMultivariateEliminate(variables);
    }

    public static <Poly extends AMultivariatePolynomial<?, Poly>> Poly merge(MultivariatePolynomial<Poly> poly, int ... variables) {
        variables = (int[])variables.clone();
        Arrays.sort(variables);
        int[] mainVariables = ArraysUtil.intSetDifference(ArraysUtil.sequence(0, poly.nVariables + variables.length), variables);
        if (poly.cc() instanceof MultivariatePolynomial) {
            return (Poly)MultivariatePolynomial.asNormalMultivariate(poly, variables, mainVariables);
        }
        return (Poly)MultivariatePolynomialZp64.asNormalMultivariate(poly, variables, mainVariables);
    }

    public static <Poly extends AMultivariatePolynomial<?, Poly>> MultivariateRing<MultivariatePolynomial<Poly>> split(IPolynomialRing<Poly> ring, int ... variables) {
        return Rings.MultivariateRing(MultivariateConversions.split((AMultivariatePolynomial)ring.factory(), variables));
    }

    public static <Poly extends AMultivariatePolynomial<?, Poly>> MultivariateRing<Poly> merge(IPolynomialRing<MultivariatePolynomial<Poly>> ring, int ... variables) {
        return Rings.MultivariateRing(MultivariateConversions.merge(ring.factory(), variables));
    }

    public static <Poly extends AMultivariatePolynomial<?, Poly>> UnivariatePolynomial<Poly> asUnivariate(Poly poly, int variable) {
        return poly.asUnivariateEliminate(variable);
    }

    public static <Poly extends AMultivariatePolynomial<?, Poly>> Poly fromUnivariate(UnivariatePolynomial<Poly> poly, int variable) {
        if (poly.cc() instanceof MultivariatePolynomial) {
            return MultivariatePolynomial.asMultivariate(poly, variable, true);
        }
        return MultivariatePolynomialZp64.asMultivariate(poly, variable, true);
    }

    public static <Poly extends AMultivariatePolynomial<?, Poly>> UnivariateRing<UnivariatePolynomial<Poly>> asUnivariate(IPolynomialRing<Poly> ring, int variable) {
        return Rings.UnivariateRing(MultivariateConversions.asUnivariate((AMultivariatePolynomial)ring.factory(), variable));
    }

    public static <Poly extends AMultivariatePolynomial<?, Poly>> IPolynomialRing<Poly> fromUnivariate(IPolynomialRing<UnivariatePolynomial<Poly>> ring, int variable) {
        return Rings.MultivariateRing(MultivariateConversions.fromUnivariate(ring.factory(), variable));
    }
}

