/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.combinatorics.Combinatorics;
import cc.redberry.rings.FactorDecomposition;
import cc.redberry.rings.IntegersZp;
import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Rational;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.bigint.BigIntegerUtil;
import cc.redberry.rings.poly.AlgebraicNumberField;
import cc.redberry.rings.poly.FiniteField;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.MachineArithmetic;
import cc.redberry.rings.poly.MultipleFieldExtension;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.PolynomialFactorDecomposition;
import cc.redberry.rings.poly.PolynomialMethods;
import cc.redberry.rings.poly.SimpleFieldExtension;
import cc.redberry.rings.poly.UnivariateRing;
import cc.redberry.rings.poly.Util;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.Conversions64bit;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.HenselLifting;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MonomialOrder;
import cc.redberry.rings.poly.multivar.MonomialZp64;
import cc.redberry.rings.poly.multivar.MultivariateDivision;
import cc.redberry.rings.poly.multivar.MultivariateGCD;
import cc.redberry.rings.poly.multivar.MultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64;
import cc.redberry.rings.poly.multivar.MultivariateSquareFreeFactorization;
import cc.redberry.rings.poly.multivar.PrivateRandom;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.IrreduciblePolynomials;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariateFactorization;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import cc.redberry.rings.poly.univar.UnivariateSquareFreeFactorization;
import cc.redberry.rings.primes.SmallPrimes;
import cc.redberry.rings.util.ArraysUtil;
import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TLongHashSet;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.math3.random.RandomGenerator;

public final class MultivariateFactorization {
    private static final long UNIVARIATE_FACTORIZATION_ATTEMPTS = 3L;
    private static final int EXTENSION_FIELD_EXPONENT = 3;
    private static int[][] naturalSequenceRefCache = new int[32][];
    private static final int N_FAILS_BEFORE_SWITCH_TO_EXTENSION = 32;
    private static final int N_INCONSISTENT_BIFACTORS_BEFORE_SWITCH_TO_EXTENSION = 32;
    private static final int N_SUPERFLUOUS_FACTORS_BEFORE_TRY_OTHER_VAR = 8;
    private static final int N_DIFF_EVALUATIONS_FAIL = 32;

    private MultivariateFactorization() {
    }

    public static <Poly extends AMultivariatePolynomial<?, Poly>> PolynomialFactorDecomposition<Poly> Factor(Poly poly) {
        if (poly.isOverFiniteField()) {
            return MultivariateFactorization.FactorInGF(poly);
        }
        if (poly.isOverZ()) {
            return MultivariateFactorization.FactorInZ((MultivariatePolynomial)poly);
        }
        if (Util.isOverRationals(poly)) {
            return MultivariateFactorization.FactorInQ((MultivariatePolynomial)poly);
        }
        if (Util.isOverSimpleNumberField(poly)) {
            return MultivariateFactorization.FactorInNumberField((MultivariatePolynomial)poly);
        }
        if (Util.isOverMultipleFieldExtension(poly)) {
            return MultivariateFactorization.FactorInMultipleFieldExtension((MultivariatePolynomial)poly);
        }
        PolynomialFactorDecomposition<AMultivariatePolynomial> factors = MultivariateFactorization.tryNested(poly, MultivariateFactorization::Factor);
        if (factors != null) {
            return factors;
        }
        throw new RuntimeException("Unsupported ring: " + poly.coefficientRingToString());
    }

    static boolean isOverMultivariate(AMultivariatePolynomial poly) {
        return poly instanceof MultivariatePolynomial && ((MultivariatePolynomial)poly).ring instanceof MultivariateRing;
    }

    static boolean isOverUnivariate(AMultivariatePolynomial poly) {
        return poly instanceof MultivariatePolynomial && ((MultivariatePolynomial)poly).ring instanceof UnivariateRing;
    }

    static <Poly extends AMultivariatePolynomial<?, Poly>> PolynomialFactorDecomposition<Poly> tryNested(Poly poly, Function<Poly, PolynomialFactorDecomposition<Poly>> factorFunction) {
        if (MultivariateGCD.isOverUnivariate(poly)) {
            return MultivariateFactorization.FactorOverUnivariate((MultivariatePolynomial)poly, factorFunction);
        }
        if (MultivariateGCD.isOverUnivariateZp64(poly)) {
            return MultivariateFactorization.FactorOverUnivariateZp64((MultivariatePolynomial)poly, factorFunction);
        }
        if (MultivariateGCD.isOverMultivariate(poly)) {
            return MultivariateFactorization.FactorOverMultivariate((MultivariatePolynomial)poly, factorFunction);
        }
        if (MultivariateGCD.isOverMultivariateZp64(poly)) {
            return MultivariateFactorization.FactorOverMultivariateZp64((MultivariatePolynomial)poly, factorFunction);
        }
        return null;
    }

    private static <E> PolynomialFactorDecomposition<MultivariatePolynomial<UnivariatePolynomial<E>>> FactorOverUnivariate(MultivariatePolynomial<UnivariatePolynomial<E>> poly, Function<MultivariatePolynomial<E>, PolynomialFactorDecomposition<MultivariatePolynomial<E>>> factorFunction) {
        return factorFunction.apply(MultivariatePolynomial.asNormalMultivariate(poly, 0)).mapTo(p -> p.asOverUnivariateEliminate(0));
    }

    private static PolynomialFactorDecomposition<MultivariatePolynomial<UnivariatePolynomialZp64>> FactorOverUnivariateZp64(MultivariatePolynomial<UnivariatePolynomialZp64> poly, Function<MultivariatePolynomialZp64, PolynomialFactorDecomposition<MultivariatePolynomialZp64>> factorFunction) {
        return factorFunction.apply(MultivariatePolynomialZp64.asNormalMultivariate(poly, 0)).mapTo(p -> p.asOverUnivariateEliminate(0));
    }

    private static <E> PolynomialFactorDecomposition<MultivariatePolynomial<MultivariatePolynomial<E>>> FactorOverMultivariate(MultivariatePolynomial<MultivariatePolynomial<E>> poly, Function<MultivariatePolynomial<E>, PolynomialFactorDecomposition<MultivariatePolynomial<E>>> factorFunction) {
        int[] cfVars = ArraysUtil.sequence(poly.lc().nVariables);
        int[] mainVars = ArraysUtil.sequence(poly.lc().nVariables, poly.lc().nVariables + poly.nVariables);
        return factorFunction.apply(MultivariatePolynomial.asNormalMultivariate(poly, cfVars, mainVars)).mapTo(p -> p.asOverMultivariateEliminate(cfVars));
    }

    private static PolynomialFactorDecomposition<MultivariatePolynomial<MultivariatePolynomialZp64>> FactorOverMultivariateZp64(MultivariatePolynomial<MultivariatePolynomialZp64> poly, Function<MultivariatePolynomialZp64, PolynomialFactorDecomposition<MultivariatePolynomialZp64>> factorFunction) {
        int[] cfVars = ArraysUtil.sequence(poly.lc().nVariables);
        int[] mainVars = ArraysUtil.sequence(poly.lc().nVariables, poly.lc().nVariables + poly.nVariables);
        return factorFunction.apply(MultivariatePolynomialZp64.asNormalMultivariate(poly, cfVars, mainVars)).mapTo(p -> p.asOverMultivariateEliminate(cfVars));
    }

    public static <E> PolynomialFactorDecomposition<MultivariatePolynomial<Rational<E>>> FactorInQ(MultivariatePolynomial<Rational<E>> polynomial) {
        Util.Tuple2<MultivariatePolynomial<E>, E> cmd = Util.toCommonDenominator(polynomial);
        MultivariatePolynomial integral = (MultivariatePolynomial)cmd._1;
        Object denominator = cmd._2;
        return MultivariateFactorization.Factor(integral).mapTo(p -> Util.asOverRationals(polynomial.ring, p)).addUnit(polynomial.createConstant(new Rational(integral.ring, integral.ring.getOne(), denominator)));
    }

    private static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>> PolynomialFactorDecomposition<MultivariatePolynomial<mPoly>> FactorInMultipleFieldExtension(MultivariatePolynomial<mPoly> poly) {
        MultipleFieldExtension ring = (MultipleFieldExtension)poly.ring;
        SimpleFieldExtension simpleExtension = ring.getSimpleExtension();
        return MultivariateFactorization.Factor(poly.mapCoefficients(simpleExtension, ring::inverse)).mapTo(p -> p.mapCoefficients(ring, ring::image));
    }

    public static PolynomialFactorDecomposition<MultivariatePolynomial<BigInteger>> FactorInZ(MultivariatePolynomial<BigInteger> polynomial) {
        return MultivariateFactorization.Factor(polynomial, MultivariateFactorization::factorPrimitiveInZ);
    }

    public static PolynomialFactorDecomposition<MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>>> FactorInNumberField(MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> polynomial) {
        return MultivariateFactorization.Factor(polynomial, MultivariateFactorization::factorPrimitiveInNumberField);
    }

    public static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> FactorInGF(Poly polynomial) {
        if (Conversions64bit.canConvertToZp64(polynomial)) {
            return MultivariateFactorization.FactorInGF(Conversions64bit.asOverZp64(polynomial)).mapTo(Conversions64bit::convertFromZp64);
        }
        return MultivariateFactorization.Factor(polynomial, MultivariateFactorization::factorPrimitiveInGF);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> Factor(Poly polynomial, Function<Poly, PolynomialFactorDecomposition<Poly>> algorithm) {
        if (polynomial.isEffectiveUnivariate()) {
            return MultivariateFactorization.factorUnivariate(polynomial);
        }
        PolynomialFactorDecomposition<Poly> sqf = MultivariateSquareFreeFactorization.SquareFreeFactorization(polynomial);
        PolynomialFactorDecomposition<AMultivariatePolynomial> res = PolynomialFactorDecomposition.unit((AMultivariatePolynomial)sqf.unit);
        for (int i = 0; i < sqf.size(); ++i) {
            AMultivariatePolynomial factor = (AMultivariatePolynomial)sqf.get(i);
            PolynomialFactorDecomposition<AMultivariatePolynomial> primitiveFactors = MultivariateFactorization.factorToPrimitive(factor);
            res.addUnit((AMultivariatePolynomial)primitiveFactors.unit, sqf.getExponent(i));
            for (AMultivariatePolynomial primitiveFactor : primitiveFactors) {
                PolynomialFactorDecomposition<Poly> pFactors = algorithm.apply(primitiveFactor);
                res.addUnit((AMultivariatePolynomial)pFactors.unit, sqf.getExponent(i));
                for (AMultivariatePolynomial pFactor : pFactors) {
                    res.addFactor(pFactor, sqf.getExponent(i));
                }
            }
        }
        return res;
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> factorUnivariate(Poly poly) {
        int uVar = poly.univariateVariable();
        PolynomialFactorDecomposition<IUnivariatePolynomial> uFactors = UnivariateFactorization.Factor(poly.asUnivariate());
        return uFactors.mapTo(u -> AMultivariatePolynomial.asMultivariate(u, poly.nVariables, uVar, poly.ordering));
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> factorToPrimitive(Poly poly) {
        if (poly.isEffectiveUnivariate()) {
            return PolynomialFactorDecomposition.of(poly);
        }
        PolynomialFactorDecomposition<AMultivariatePolynomial> result = PolynomialFactorDecomposition.empty(poly);
        for (int i = 0; i < poly.nVariables; ++i) {
            if (poly.degree(i) == 0) continue;
            AMultivariatePolynomial factor = (AMultivariatePolynomial)poly.asUnivariate(i).content();
            result.addFactor(factor, 1);
            poly = MultivariateDivision.divideExact(poly, factor);
        }
        result.addFactor((AMultivariatePolynomial)poly, 1);
        return result;
    }

    private static int[] add(int[] array, int value) {
        int[] res = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            res[i] = array[i] = value;
        }
        return res;
    }

    private static PolynomialFactorDecomposition<MultivariatePolynomialZp64> factorInExtensionField(MultivariatePolynomialZp64 poly, FactorizationAlgorithm<Monomial<UnivariatePolynomialZp64>, MultivariatePolynomial<UnivariatePolynomialZp64>> algorithm) {
        FiniteField<UnivariatePolynomialZp64> extensionField;
        PolynomialFactorDecomposition<MultivariatePolynomialZp64> result;
        IntegersZp64 ring = poly.ring;
        int startingDegree = 3;
        while ((result = MultivariateFactorization.factorInExtensionField(poly, extensionField = new FiniteField<UnivariatePolynomialZp64>(IrreduciblePolynomials.randomIrreduciblePolynomial(ring.modulus, startingDegree++, PrivateRandom.getRandom())), algorithm)) == null) {
        }
        return result;
    }

    private static PolynomialFactorDecomposition<MultivariatePolynomialZp64> factorInExtensionField(MultivariatePolynomialZp64 poly, FiniteField<UnivariatePolynomialZp64> extensionField, FactorizationAlgorithm<Monomial<UnivariatePolynomialZp64>, MultivariatePolynomial<UnivariatePolynomialZp64>> algorithm) {
        PolynomialFactorDecomposition<MultivariatePolynomial<UnivariatePolynomialZp64>> factorization = algorithm.factor(poly.mapCoefficients(extensionField, extensionField::valueOf), false);
        if (factorization == null) {
            return null;
        }
        if (!((UnivariatePolynomialZp64)((MultivariatePolynomial)factorization.unit).cc()).isConstant()) {
            return null;
        }
        PolynomialFactorDecomposition<MultivariatePolynomialZp64> result = PolynomialFactorDecomposition.unit(poly.createConstant(((UnivariatePolynomialZp64)((MultivariatePolynomial)factorization.unit).cc()).cc()));
        for (int i = 0; i < factorization.size(); ++i) {
            if (!((MultivariatePolynomial)factorization.get(i)).stream().allMatch(p -> p.isConstant())) {
                return null;
            }
            result.addFactor(((MultivariatePolynomial)factorization.get(i)).mapCoefficients(poly.ring, rec$ -> ((UnivariatePolynomialZp64)rec$).cc()), factorization.getExponent(i));
        }
        return result;
    }

    private static <E> PolynomialFactorDecomposition<MultivariatePolynomial<E>> factorInExtensionField(MultivariatePolynomial<E> poly, FactorizationAlgorithm<Monomial<UnivariatePolynomial<E>>, MultivariatePolynomial<UnivariatePolynomial<E>>> algorithm) {
        FiniteField extensionField;
        PolynomialFactorDecomposition<MultivariatePolynomial<E>> result;
        Ring ring = poly.ring;
        int startingDegree = 3;
        while ((result = MultivariateFactorization.factorInExtensionField(poly, extensionField = new FiniteField(IrreduciblePolynomials.randomIrreduciblePolynomial(ring, startingDegree++, PrivateRandom.getRandom())), algorithm)) == null) {
        }
        return result;
    }

    private static <E> PolynomialFactorDecomposition<MultivariatePolynomial<E>> factorInExtensionField(MultivariatePolynomial<E> poly, FiniteField<UnivariatePolynomial<E>> extensionField, FactorizationAlgorithm<Monomial<UnivariatePolynomial<E>>, MultivariatePolynomial<UnivariatePolynomial<E>>> algorithm) {
        PolynomialFactorDecomposition<MultivariatePolynomial<UnivariatePolynomial>> factorization = algorithm.factor(poly.mapCoefficients(extensionField, c -> UnivariatePolynomial.constant(poly.ring, c)), false);
        if (factorization == null) {
            return null;
        }
        if (!((UnivariatePolynomial)((MultivariatePolynomial)factorization.unit).cc()).isConstant()) {
            return null;
        }
        PolynomialFactorDecomposition<MultivariatePolynomial<E>> result = PolynomialFactorDecomposition.unit(poly.createConstant(((UnivariatePolynomial)((MultivariatePolynomial)factorization.unit).cc()).cc()));
        for (int i = 0; i < factorization.size(); ++i) {
            if (!((MultivariatePolynomial)factorization.get(i)).stream().allMatch(UnivariatePolynomial::isConstant)) {
                return null;
            }
            result.addFactor(((MultivariatePolynomial)factorization.get(i)).mapCoefficients(poly.ring, UnivariatePolynomial::cc), factorization.getExponent(i));
        }
        return result;
    }

    static int[][] convexHul(int[][] points) {
        if (points.length <= 3) {
            return points;
        }
        int basePointIndex = 0;
        int minY = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        for (int i = 0; i < points.length; ++i) {
            int[] point = points[i];
            if (point[1] >= minY && (point[1] != minY || point[0] >= minX)) continue;
            minY = point[1];
            minX = point[0];
            basePointIndex = i;
        }
        int[] basePoint = points[basePointIndex];
        Arrays.sort(points, new PolarAngleComparator(basePoint));
        ArrayDeque<int[]> stack = new ArrayDeque<int[]>();
        stack.push(points[0]);
        stack.push(points[1]);
        for (int i = 2; i < points.length; ++i) {
            int[] head = points[i];
            int[] middle = (int[])stack.pop();
            int[] tail = (int[])stack.peek();
            int turn = MultivariateFactorization.ccw(tail, middle, head);
            if (turn > 0) {
                stack.push(middle);
                stack.push(head);
                continue;
            }
            if (turn < 0) {
                --i;
                continue;
            }
            stack.push(head);
        }
        return (int[][])stack.toArray((T[])new int[stack.size()][]);
    }

    private static int ccw(int[] p1, int[] p2, int[] p3) {
        return (p2[0] - p1[0]) * (p3[1] - p1[1]) - (p2[1] - p1[1]) * (p3[0] - p1[0]);
    }

    static int[][] NewtonPolygon(Iterable<DegreeVector> poly) {
        ArrayList<int[]> points = new ArrayList<int[]>();
        for (DegreeVector dv : poly) {
            points.add((int[])dv.exponents.clone());
        }
        return MultivariateFactorization.convexHul((int[][])points.toArray((T[])new int[points.size()][]));
    }

    static int[][] NewtonPolygon(AMultivariatePolynomial<? extends DegreeVector, ?> poly) {
        return MultivariateFactorization.NewtonPolygon(poly.getSkeleton());
    }

    static boolean isCertainlyIndecomposable(int[][] np) {
        if (np.length == 2) {
            int yDeg;
            int xDeg = Integer.max(np[0][0], np[1][0]);
            return MachineArithmetic.gcd(xDeg, yDeg = Integer.max(np[0][1], np[1][1])) == 1;
        }
        if (np.length == 3) {
            int n = -1;
            int m = -1;
            int u = -1;
            int v = -1;
            for (int[] xy : np) {
                if (xy[0] != 0 && xy[1] == 0) {
                    n = xy[0];
                    continue;
                }
                if (xy[1] != 0 && xy[0] == 0) {
                    m = xy[1];
                    continue;
                }
                u = xy[0];
                v = xy[1];
            }
            return n != -1 && m != -1 && u != -1 && v != -1 && MachineArithmetic.gcd(n, m, u, v) == 1L;
        }
        return false;
    }

    static boolean isBivariateCertainlyIrreducible(AMultivariatePolynomial<? extends DegreeVector, ?> poly) {
        return poly.nVariables == 2 && MultivariateFactorization.isCertainlyIndecomposable(MultivariateFactorization.NewtonPolygon(poly));
    }

    static PolynomialFactorDecomposition<MultivariatePolynomialZp64> bivariateDenseFactorSquareFreeInGF(MultivariatePolynomialZp64 poly) {
        return MultivariateFactorization.bivariateDenseFactorSquareFreeInGF(poly, true);
    }

    static PolynomialFactorDecomposition<MultivariatePolynomialZp64> bivariateDenseFactorSquareFreeInGF(MultivariatePolynomialZp64 poly, boolean switchToExtensionField, boolean doGCDTest) {
        MultivariatePolynomialZp64 xDerivative;
        assert (poly.nUsedVariables() <= 2 && IntStream.range(2, poly.nVariables).allMatch(i -> poly.degree(i) == 0)) : poly;
        if (poly.isEffectiveUnivariate()) {
            return MultivariateFactorization.factorUnivariate(poly);
        }
        MonomialZp64 mContent = (MonomialZp64)poly.monomialContent();
        if (mContent.totalDegree != 0) {
            return MultivariateFactorization.bivariateDenseFactorSquareFreeInGF(poly.divideOrNull(mContent)).addFactor((MultivariatePolynomialZp64)poly.create(mContent), 1);
        }
        if (MultivariateFactorization.isBivariateCertainlyIrreducible(poly)) {
            return PolynomialFactorDecomposition.of(poly);
        }
        MultivariatePolynomialZp64 reducedPoly = poly;
        int[] degreeBounds = reducedPoly.degrees();
        boolean swapVariables = false;
        if (degreeBounds[1] > degreeBounds[0]) {
            swapVariables = true;
            reducedPoly = AMultivariatePolynomial.swapVariables(reducedPoly, 0, 1);
            ArraysUtil.swap(degreeBounds, 0, 1);
        }
        if ((xDerivative = (MultivariatePolynomialZp64)reducedPoly.derivative(0)).isZero()) {
            reducedPoly = AMultivariatePolynomial.swapVariables(reducedPoly, 0, 1);
            swapVariables = !swapVariables;
            xDerivative = (MultivariatePolynomialZp64)reducedPoly.derivative(0);
        }
        if (doGCDTest) {
            MultivariatePolynomialZp64 yDerivative = (MultivariatePolynomialZp64)reducedPoly.derivative(1);
            for (MultivariatePolynomialZp64 derivative : Arrays.asList(yDerivative, xDerivative)) {
                MultivariatePolynomialZp64 dGCD;
                if (derivative.isZero() || (dGCD = MultivariateGCD.PolynomialGCD(derivative, reducedPoly)).isConstant()) continue;
                PolynomialFactorDecomposition<MultivariatePolynomialZp64> gcdFactorization = MultivariateFactorization.bivariateDenseFactorSquareFreeInGF(dGCD, switchToExtensionField, doGCDTest);
                PolynomialFactorDecomposition<MultivariatePolynomialZp64> restFactorization = MultivariateFactorization.bivariateDenseFactorSquareFreeInGF(MultivariateDivision.divideExact(reducedPoly, dGCD), switchToExtensionField, doGCDTest);
                if (gcdFactorization == null || restFactorization == null) {
                    assert (!switchToExtensionField);
                    return null;
                }
                gcdFactorization.addAll(restFactorization);
                if (swapVariables) {
                    MultivariateFactorization.swap(gcdFactorization);
                }
                return gcdFactorization;
            }
        }
        IntegersZp64 ring = reducedPoly.ring;
        int degree = reducedPoly.degree(0);
        long ySubstitution = -1L;
        PolynomialFactorDecomposition<UnivariatePolynomialZp64> uFactorization = null;
        int univariateFactorizations = 0;
        boolean tryZeroFirst = true;
        TLongHashSet evaluationStack = new TLongHashSet();
        RandomGenerator random = PrivateRandom.getRandom();
        while ((long)univariateFactorizations < 3L) {
            UnivariatePolynomialZp64 uImage;
            long substitution;
            if ((long)evaluationStack.size() == ring.modulus) {
                if (uFactorization != null) break;
                if (switchToExtensionField) {
                    return MultivariateFactorization.factorInExtensionField(poly, (MultivariatePolynomial<UnivariatePolynomialZp64> p, boolean toExtension) -> MultivariateFactorization.bivariateDenseFactorSquareFreeInGF(p, toExtension, false));
                }
                return null;
            }
            if (tryZeroFirst) {
                substitution = 0L;
                tryZeroFirst = false;
            } else {
                while (evaluationStack.contains(substitution = ring.randomElement(random))) {
                }
            }
            evaluationStack.add(substitution);
            MultivariatePolynomialZp64 image = reducedPoly.evaluate(1, substitution);
            if (image.degree() != degree || image.cc() == 0L || !UnivariateSquareFreeFactorization.isSquareFree(uImage = image.asUnivariate())) continue;
            PolynomialFactorDecomposition<UnivariatePolynomialZp64> factorization = UnivariateFactorization.FactorSquareFreeInGF(uImage);
            if (factorization.size() == 1) {
                return PolynomialFactorDecomposition.of(poly);
            }
            if (uFactorization == null || factorization.size() < uFactorization.size()) {
                uFactorization = factorization;
                ySubstitution = substitution;
            }
            ++univariateFactorizations;
        }
        assert (ySubstitution != -1L);
        assert (uFactorization.factors.stream().allMatch(rec$ -> ((UnivariatePolynomialZp64)rec$).isMonic()));
        List factorList = uFactorization.factors;
        long[] evals = new long[poly.nVariables - 1];
        evals[0] = ySubstitution;
        HenselLifting.lEvaluation evaluation = new HenselLifting.lEvaluation(poly.nVariables, evals, ring, reducedPoly.ordering);
        MultivariatePolynomialZp64 lc = (MultivariatePolynomialZp64)reducedPoly.lc(0);
        if (!lc.isConstant()) {
            UnivariatePolynomialZp64 ulc = evaluation.evaluateFrom(lc, 1).asUnivariate();
            assert (ulc.isConstant());
            factorList.add(0, ulc);
        } else {
            ((UnivariatePolynomialZp64)factorList.get(0)).multiply(lc.cc());
        }
        IUnivariatePolynomial[] factors = factorList.toArray(new UnivariatePolynomialZp64[factorList.size()]);
        int liftDegree = reducedPoly.degree(1) + 1;
        UnivariateRing<UnivariatePolynomialZp64> uRing = new UnivariateRing<UnivariatePolynomialZp64>(factors[0]);
        UnivariatePolynomial<UnivariatePolynomialZp64> baseSeries = HenselLifting.seriesExpansionDense(uRing, reducedPoly, 1, evaluation);
        UnivariatePolynomial[] lifted = HenselLifting.bivariateLiftDense(baseSeries, (IUnivariatePolynomial[])factors, (int)liftDegree);
        if (!lc.isConstant()) {
            lifted = Arrays.copyOfRange(lifted, 1, lifted.length);
        }
        PolynomialFactorDecomposition<MultivariatePolynomialZp64> result = MultivariateFactorization.denseBivariateRecombination(reducedPoly, baseSeries, lifted, evaluation, liftDegree);
        if (swapVariables) {
            MultivariateFactorization.swap(result);
        }
        return result;
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> void swap(PolynomialFactorDecomposition<Poly> factorDecomposition) {
        for (int i = 0; i < factorDecomposition.factors.size(); ++i) {
            factorDecomposition.factors.set(i, AMultivariatePolynomial.swapVariables((AMultivariatePolynomial)factorDecomposition.get(i), 0, 1));
        }
    }

    static <E> PolynomialFactorDecomposition<MultivariatePolynomial<E>> bivariateDenseFactorSquareFreeInGF(MultivariatePolynomial<E> poly) {
        return MultivariateFactorization.bivariateDenseFactorSquareFreeInGF(poly, true);
    }

    static <E> PolynomialFactorDecomposition<MultivariatePolynomial<E>> bivariateDenseFactorSquareFreeInGF(MultivariatePolynomial<E> poly, boolean switchToExtensionField, boolean doGCDTest) {
        MultivariatePolynomial xDerivative;
        assert (poly.nUsedVariables() <= 2 && IntStream.range(2, poly.nVariables).allMatch(i -> poly.degree(i) == 0));
        if (poly.isEffectiveUnivariate()) {
            return MultivariateFactorization.factorUnivariate(poly);
        }
        Monomial mContent = (Monomial)poly.monomialContent();
        if (mContent.totalDegree != 0) {
            return MultivariateFactorization.bivariateDenseFactorSquareFreeInGF(poly.divideOrNull(mContent)).addFactor((MultivariatePolynomial)poly.create(mContent), 1);
        }
        if (MultivariateFactorization.isBivariateCertainlyIrreducible(poly)) {
            return PolynomialFactorDecomposition.of(poly);
        }
        MultivariatePolynomial reducedPoly = poly;
        int[] degreeBounds = reducedPoly.degrees();
        boolean swapVariables = false;
        if (degreeBounds[1] > degreeBounds[0]) {
            swapVariables = true;
            reducedPoly = AMultivariatePolynomial.swapVariables(reducedPoly, 0, 1);
            ArraysUtil.swap(degreeBounds, 0, 1);
        }
        if ((xDerivative = (MultivariatePolynomial)reducedPoly.derivative(0)).isZero()) {
            reducedPoly = AMultivariatePolynomial.swapVariables(reducedPoly, 0, 1);
            swapVariables = !swapVariables;
            xDerivative = (MultivariatePolynomial)reducedPoly.derivative(0);
        }
        if (doGCDTest) {
            MultivariatePolynomial yDerivative = (MultivariatePolynomial)reducedPoly.derivative(1);
            for (MultivariatePolynomial derivative : Arrays.asList(yDerivative, xDerivative)) {
                MultivariatePolynomial<E> dGCD;
                if (derivative.isZero() || (dGCD = MultivariateGCD.PolynomialGCD(xDerivative, reducedPoly)).isConstant()) continue;
                PolynomialFactorDecomposition<MultivariatePolynomial<E>> gcdFactorization = MultivariateFactorization.bivariateDenseFactorSquareFreeInGF(dGCD, switchToExtensionField);
                PolynomialFactorDecomposition<MultivariatePolynomial<E>> restFactorization = MultivariateFactorization.bivariateDenseFactorSquareFreeInGF(MultivariateDivision.divideExact(reducedPoly, dGCD), switchToExtensionField);
                if (gcdFactorization == null || restFactorization == null) {
                    assert (!switchToExtensionField);
                    return null;
                }
                gcdFactorization.addAll(restFactorization);
                if (swapVariables) {
                    MultivariateFactorization.swap(gcdFactorization);
                }
                return gcdFactorization;
            }
        }
        Ring<E> ring = reducedPoly.ring;
        int degree = reducedPoly.degree(0);
        Object ySubstitution = null;
        PolynomialFactorDecomposition<IUnivariatePolynomial> uFactorization = null;
        int univariateFactorizations = 0;
        boolean tryZeroFirst = true;
        HashSet evaluationStack = new HashSet();
        while ((long)univariateFactorizations < 3L) {
            IUnivariatePolynomial uImage;
            Object substitution;
            if (ring.cardinality().isInt() && ring.cardinality().intValueExact() == evaluationStack.size()) {
                if (uFactorization != null) break;
                if (switchToExtensionField) {
                    return MultivariateFactorization.factorInExtensionField(poly, (MultivariatePolynomial<UnivariatePolynomial<E>> p, boolean toExtension) -> MultivariateFactorization.bivariateDenseFactorSquareFreeInGF(p, toExtension, false));
                }
                return null;
            }
            if (tryZeroFirst) {
                substitution = ring.getZero();
                tryZeroFirst = false;
            } else {
                while (evaluationStack.contains(substitution = ring.randomElement(PrivateRandom.getRandom()))) {
                }
            }
            evaluationStack.add(substitution);
            MultivariatePolynomial<E> image = reducedPoly.evaluate(1, substitution);
            if (image.degree() != degree || ring.isZero(image.cc()) || !UnivariateSquareFreeFactorization.isSquareFree(uImage = image.asUnivariate())) continue;
            PolynomialFactorDecomposition<IUnivariatePolynomial> factorization = UnivariateFactorization.FactorSquareFreeInGF(uImage);
            if (factorization.size() == 1) {
                return PolynomialFactorDecomposition.of(poly);
            }
            if (uFactorization == null || factorization.size() < uFactorization.size()) {
                uFactorization = factorization;
                ySubstitution = substitution;
            }
            ++univariateFactorizations;
        }
        assert (ySubstitution != null);
        List factorList = uFactorization.factors;
        E[] evals = ring.createZeroesArray(poly.nVariables - 1);
        evals[0] = ySubstitution;
        HenselLifting.Evaluation evaluation = new HenselLifting.Evaluation(poly.nVariables, evals, ring, reducedPoly.ordering);
        MultivariatePolynomial lc = (MultivariatePolynomial)reducedPoly.lc(0);
        if (!lc.isConstant()) {
            IUnivariatePolynomial ulc = evaluation.evaluateFrom(lc, 1).asUnivariate();
            assert (((UnivariatePolynomial)ulc).isConstant());
            factorList.add(0, ulc);
        } else {
            ((UnivariatePolynomial)factorList.get(0)).multiply(lc.cc());
        }
        IUnivariatePolynomial[] factors = factorList.toArray(new UnivariatePolynomial[factorList.size()]);
        int liftDegree = reducedPoly.degree(1) + 1;
        UnivariateRing<UnivariatePolynomial> uRing = new UnivariateRing<UnivariatePolynomial>(factors[0]);
        UnivariatePolynomial<UnivariatePolynomial> baseSeries = HenselLifting.seriesExpansionDense(uRing, reducedPoly, 1, evaluation);
        UnivariatePolynomial[] lifted = HenselLifting.bivariateLiftDense(baseSeries, (IUnivariatePolynomial[])factors, (int)liftDegree);
        if (!lc.isConstant()) {
            lifted = Arrays.copyOfRange(lifted, 1, factors.length);
        }
        PolynomialFactorDecomposition<MultivariatePolynomial<E>> result = MultivariateFactorization.denseBivariateRecombination(reducedPoly, baseSeries, lifted, evaluation, liftDegree);
        if (swapVariables) {
            for (int i2 = 0; i2 < result.factors.size(); ++i2) {
                result.factors.set(i2, AMultivariatePolynomial.swapVariables((MultivariatePolynomial)result.get(i2), 0, 1));
            }
        }
        return result;
    }

    private static int[] createSeq(int n) {
        int[] r = new int[n];
        for (int i = 0; i < n; ++i) {
            r[i] = i;
        }
        return r;
    }

    private static int[] naturalSequenceRef(int n) {
        if (n >= naturalSequenceRefCache.length) {
            return MultivariateFactorization.createSeq(n);
        }
        if (naturalSequenceRefCache[n] != null) {
            return naturalSequenceRefCache[n];
        }
        MultivariateFactorization.naturalSequenceRefCache[n] = MultivariateFactorization.createSeq(n);
        return MultivariateFactorization.naturalSequenceRefCache[n];
    }

    private static int[] select(int[] data, int[] positions) {
        int[] r = new int[positions.length];
        int i = 0;
        for (int p : positions) {
            r[i++] = data[p];
        }
        return r;
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>, uPoly extends IUnivariatePolynomial<uPoly>> PolynomialFactorDecomposition<Poly> denseBivariateRecombination(Poly factory, UnivariatePolynomial<uPoly> poly, UnivariatePolynomial<uPoly>[] modularFactors, HenselLifting.IEvaluation<Term, Poly> evaluation, int liftDegree) {
        int[] modIndexes = MultivariateFactorization.naturalSequenceRef(modularFactors.length);
        PolynomialFactorDecomposition<Poly> trueFactors = PolynomialFactorDecomposition.empty(factory);
        UnivariatePolynomial<uPoly> fRest = poly;
        int s = 1;
        block0: while (2 * s <= modIndexes.length) {
            for (int[] combination : Combinatorics.combinations((int)modIndexes.length, (int)s)) {
                int[] indexes = MultivariateFactorization.select(modIndexes, combination);
                IUnivariatePolynomial<UnivariatePolynomial<Object>> mFactor = MultivariateFactorization.lcInSeries(fRest);
                for (int i : indexes) {
                    mFactor = mFactor.multiply(modularFactors[i]).truncate(liftDegree - 1);
                }
                UnivariatePolynomial<uPoly> factor = MultivariateFactorization.changeDenseRepresentation(MultivariateFactorization.changeDenseRepresentation(mFactor).primitivePart());
                UnivariatePolynomial<uPoly>[] qd = UnivariateDivision.divideAndRemainder(fRest, factor, true);
                if (qd == null || !qd[1].isZero()) continue;
                modIndexes = ArraysUtil.intSetDifference(modIndexes, indexes);
                trueFactors.addFactor(HenselLifting.denseSeriesToPoly(factory, factor, 1, evaluation), 1);
                fRest = qd[0];
                continue block0;
            }
            ++s;
        }
        if (!fRest.isConstant() || !((IUnivariatePolynomial)fRest.cc()).isConstant()) {
            trueFactors.addFactor(HenselLifting.denseSeriesToPoly(factory, fRest, 1, evaluation), 1);
        }
        return trueFactors.monic();
    }

    static PolynomialFactorDecomposition<MultivariatePolynomial<BigInteger>> bivariateDenseFactorSquareFreeInZ(MultivariatePolynomial<BigInteger> poly) {
        UnivariatePolynomial[] liftedZp;
        BigInteger bBasePrime;
        assert (poly.nUsedVariables() <= 2 && IntStream.range(2, poly.nVariables).allMatch(i -> poly.degree(i) == 0));
        if (poly.isEffectiveUnivariate()) {
            return MultivariateFactorization.factorUnivariate(poly);
        }
        Monomial mContent = (Monomial)poly.monomialContent();
        if (mContent.totalDegree != 0) {
            return MultivariateFactorization.bivariateDenseFactorSquareFreeInZ(poly.divideOrNull(mContent)).addFactor((MultivariatePolynomial)poly.create(mContent), 1);
        }
        if (MultivariateFactorization.isBivariateCertainlyIrreducible(poly)) {
            return PolynomialFactorDecomposition.of(poly);
        }
        IPolynomial content = poly.contentAsPoly();
        MultivariatePolynomial<BigInteger> reducedPoly = ((MultivariatePolynomial)content).isOne() ? poly : ((MultivariatePolynomial)poly.clone()).divideByLC(content);
        int[] degreeBounds = reducedPoly.degrees();
        boolean swapVariables = false;
        if (degreeBounds[1] > degreeBounds[0]) {
            swapVariables = true;
            reducedPoly = AMultivariatePolynomial.swapVariables(reducedPoly, 0, 1);
            ArraysUtil.swap(degreeBounds, 0, 1);
        }
        MultivariatePolynomial xDerivative = (MultivariatePolynomial)reducedPoly.derivative(0);
        assert (!xDerivative.isZero());
        MultivariatePolynomial<BigInteger> dGCD = MultivariateGCD.PolynomialGCD(xDerivative, reducedPoly);
        if (!dGCD.isConstant()) {
            PolynomialFactorDecomposition<MultivariatePolynomial<BigInteger>> gcdFactorization = MultivariateFactorization.bivariateDenseFactorSquareFreeInZ(dGCD);
            PolynomialFactorDecomposition<MultivariatePolynomial<BigInteger>> restFactorization = MultivariateFactorization.bivariateDenseFactorSquareFreeInZ(MultivariateDivision.divideExact(reducedPoly, dGCD));
            gcdFactorization.addAll(restFactorization);
            if (swapVariables) {
                MultivariateFactorization.swap(gcdFactorization);
            }
            return gcdFactorization.addUnit((MultivariatePolynomial<BigInteger>)content);
        }
        int degree = reducedPoly.degree(0);
        BigInteger ySubstitution = null;
        PolynomialFactorDecomposition<UnivariatePolynomial> uFactorization = null;
        int univariateFactorizations = 0;
        boolean tryZeroFirst = true;
        IUnivariatePolynomial uImage = null;
        HashSet<BigInteger> usedSubstitutions = new HashSet<BigInteger>();
        while ((long)univariateFactorizations < 3L) {
            MultivariatePolynomial<BigInteger> image;
            BigInteger substitution;
            if (tryZeroFirst) {
                substitution = BigInteger.ZERO;
                tryZeroFirst = false;
            } else {
                int bound = 10 * (univariateFactorizations / 5 + 1);
                if (bound < usedSubstitutions.size()) {
                    bound = usedSubstitutions.size();
                }
                do {
                    if (usedSubstitutions.size() != bound) continue;
                    bound *= 2;
                } while (usedSubstitutions.contains(substitution = BigInteger.valueOf(PrivateRandom.getRandom().nextInt(bound))));
                usedSubstitutions.add(substitution);
            }
            if ((image = reducedPoly.evaluate(1, substitution)).degree() != degree || image.cc().isZero() || !UnivariateSquareFreeFactorization.isSquareFree(uImage = image.asUnivariate())) continue;
            PolynomialFactorDecomposition<UnivariatePolynomial> factorization = UnivariateFactorization.FactorSquareFreeInZ(uImage);
            if (factorization.size() == 1) {
                return PolynomialFactorDecomposition.of(poly);
            }
            if (uFactorization == null || factorization.size() < uFactorization.size()) {
                uFactorization = factorization;
                ySubstitution = substitution;
            }
            ++univariateFactorizations;
        }
        assert (ySubstitution != null);
        int basePrime = 0x400000;
        while (true) {
            if (!MultivariateFactorization.isGoodPrime(bBasePrime = BigInteger.valueOf(basePrime = SmallPrimes.nextPrime(basePrime)), (BigInteger)uImage.lc(), (BigInteger)uImage.cc())) {
                continue;
            }
            IntegersZp moduloDomain = new IntegersZp(bBasePrime);
            if (PolynomialMethods.coprimeQ(uFactorization.mapTo((Function<UnivariatePolynomial, UnivariatePolynomial>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$bivariateDenseFactorSquareFreeInZ$16(cc.redberry.rings.IntegersZp cc.redberry.rings.poly.univar.UnivariatePolynomial ), (Lcc/redberry/rings/poly/univar/UnivariatePolynomial;)Lcc/redberry/rings/poly/univar/UnivariatePolynomial;)((IntegersZp)moduloDomain)).factors)) break;
        }
        BigInteger bound2 = MultivariateFactorization.coefficientsBound(reducedPoly).multiply(MultivariateFactorization.coefficientsBound((MultivariatePolynomial)reducedPoly.lc(0))).shiftLeft(1);
        BigInteger modulus = bBasePrime;
        while (modulus.compareTo(bound2) < 0) {
            modulus = modulus.multiply(bBasePrime);
        }
        IntegersZp zpDomain = new IntegersZp(modulus);
        List factorsListZp = uFactorization.mapTo((Function<UnivariatePolynomial, UnivariatePolynomial>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$bivariateDenseFactorSquareFreeInZ$17(cc.redberry.rings.IntegersZp cc.redberry.rings.poly.univar.UnivariatePolynomial ), (Lcc/redberry/rings/poly/univar/UnivariatePolynomial;)Lcc/redberry/rings/poly/univar/UnivariatePolynomial;)((IntegersZp)zpDomain)).monic().factors;
        MultivariatePolynomial<BigInteger> baseZp = reducedPoly.setRing(zpDomain);
        MultivariatePolynomial lcZp = (MultivariatePolynomial)baseZp.lc(0);
        baseZp = baseZp.divideOrNull(lcZp.evaluate(1, ySubstitution).lc());
        assert (baseZp != null);
        BigInteger[] evals = (BigInteger[])Rings.Z.createZeroesArray(poly.nVariables - 1);
        evals[0] = ySubstitution;
        HenselLifting.Evaluation<BigInteger> evaluation = new HenselLifting.Evaluation<BigInteger>(poly.nVariables, evals, zpDomain, baseZp.ordering);
        if (!lcZp.isConstant()) {
            assert (evaluation.evaluateFrom(lcZp, 1).isConstant());
            factorsListZp.add(0, ((UnivariatePolynomial)factorsListZp.get(0)).createOne());
        }
        IUnivariatePolynomial[] factorsZp = factorsListZp.toArray(new UnivariatePolynomial[factorsListZp.size()]);
        int liftDegree = baseZp.degree(1) + 1;
        UnivariatePolynomial<UnivariatePolynomial<BigInteger>> baseSeriesZp = HenselLifting.seriesExpansionDense(Rings.UnivariateRingZp(modulus), baseZp, 1, evaluation);
        try {
            liftedZp = HenselLifting.bivariateLiftDense(baseSeriesZp, (IUnivariatePolynomial[])factorsZp, (int)liftDegree);
        }
        catch (ArithmeticException e) {
            return MultivariateFactorization.bivariateDenseFactorSquareFreeInZ(poly);
        }
        if (!lcZp.isConstant()) {
            liftedZp = Arrays.copyOfRange(liftedZp, 1, factorsZp.length);
        }
        UnivariatePolynomial<UnivariatePolynomial<BigInteger>> baseSeriesZ = MultivariateFactorization.seriesExpansionDenseZ(reducedPoly, ySubstitution);
        PolynomialFactorDecomposition<MultivariatePolynomial<BigInteger>> result = MultivariateFactorization.denseBivariateRecombinationZ(reducedPoly, baseZp, baseSeriesZ, liftedZp, evaluation, ySubstitution, zpDomain, liftDegree);
        if (swapVariables) {
            for (int i2 = 0; i2 < result.factors.size(); ++i2) {
                result.factors.set(i2, AMultivariatePolynomial.swapVariables((MultivariatePolynomial)result.get(i2), 0, 1));
            }
        }
        return result.addUnit((MultivariatePolynomial<BigInteger>)content);
    }

    private static boolean isGoodPrime(BigInteger prime, BigInteger ulc, BigInteger ucc) {
        ucc = ucc.abs();
        if (!(ulc = ulc.abs()).isOne() && (prime.compareTo(ulc) > 0 ? prime.remainder(ulc) : ulc.remainder(prime)).isZero()) {
            return false;
        }
        return ucc.isOne() || ucc.isZero() || !(prime.compareTo(ucc) > 0 ? prime.remainder(ucc) : ucc.remainder(prime)).isZero();
    }

    static BigInteger coefficientsBound(MultivariatePolynomial<BigInteger> poly) {
        BigInteger maxNorm = BigInteger.ZERO;
        for (BigInteger c : poly.coefficients()) {
            BigInteger abs = c.abs();
            if (abs.compareTo(maxNorm) <= 0) continue;
            maxNorm = abs;
        }
        assert (maxNorm.signum() > 0);
        int[] degrees = poly.degrees();
        int degreeSum = 0;
        BigInteger bound = BigInteger.ONE;
        for (int d : degrees) {
            degreeSum += d;
            bound = bound.multiply(BigInteger.valueOf(d).increment());
        }
        bound = bound.divide(BigInteger.ONE.shiftLeft(degrees.length)).increment();
        bound = BigIntegerUtil.sqrtCeil(bound);
        bound = bound.multiply(BigInteger.ONE.shiftLeft(degreeSum));
        bound = bound.multiply(maxNorm);
        assert (bound.signum() > 0);
        return bound;
    }

    static PolynomialFactorDecomposition<MultivariatePolynomial<BigInteger>> denseBivariateRecombinationZ(MultivariatePolynomial<BigInteger> baseZ, MultivariatePolynomial<BigInteger> factoryZp, UnivariatePolynomial<UnivariatePolynomial<BigInteger>> baseSeriesZ, UnivariatePolynomial<UnivariatePolynomial<BigInteger>>[] modularFactorsZp, HenselLifting.Evaluation<BigInteger> evaluation, BigInteger ySubstitution, Ring<BigInteger> modulus, int liftDegree) {
        int[] modIndexes = MultivariateFactorization.naturalSequenceRef(modularFactorsZp.length);
        PolynomialFactorDecomposition<MultivariatePolynomial<BigInteger>> trueFactors = PolynomialFactorDecomposition.empty(baseZ);
        UnivariatePolynomial fRest = baseSeriesZ;
        int s = 1;
        MultivariatePolynomial.USubstitution<BigInteger> lPowersZ = new MultivariatePolynomial.USubstitution<BigInteger>(UnivariatePolynomial.createUnsafe(Rings.Z, new BigInteger[]{ySubstitution.negate(), BigInteger.ONE}), 1, baseZ.nVariables, baseZ.ordering);
        UnivariateRing<Ring<BigInteger>> moduloDomain = Rings.UnivariateRing(modulus);
        assert (((MultivariatePolynomial)baseZ.lc(0)).equals(MultivariateFactorization.denseSeriesToPolyZ(baseZ, MultivariateFactorization.lcInSeries(fRest), lPowersZ)));
        assert (baseZ.equals(MultivariateFactorization.denseSeriesToPolyZ(baseZ, baseSeriesZ, lPowersZ)));
        block0: while (2 * s <= modIndexes.length) {
            for (int[] combination : Combinatorics.combinations((int)modIndexes.length, (int)s)) {
                int[] indexes = MultivariateFactorization.select(modIndexes, combination);
                IUnivariatePolynomial<UnivariatePolynomial<BigInteger>> factor = MultivariateFactorization.lcInSeries(fRest).setRing(moduloDomain);
                for (int i : indexes) {
                    factor = factor.multiply(modularFactorsZp[i]).truncate(liftDegree - 1);
                }
                UnivariatePolynomial<Ring<BigInteger>>[] qd = UnivariateDivision.divideAndRemainder(fRest, factor = MultivariateFactorization.seriesExpansionDenseZ((MultivariatePolynomial<BigInteger>)MultivariatePolynomial.asPolyZSymmetric(HenselLifting.denseSeriesToPoly(factoryZp, factor, 1, evaluation)).primitivePart(1), ySubstitution), true);
                if (qd == null || !qd[1].isZero()) continue;
                modIndexes = ArraysUtil.intSetDifference(modIndexes, indexes);
                trueFactors.addFactor(MultivariateFactorization.denseSeriesToPolyZ(baseZ, factor, lPowersZ), 1);
                fRest = qd[0];
                continue block0;
            }
            ++s;
        }
        if (!fRest.isConstant() || !fRest.cc().isConstant()) {
            if (trueFactors.size() == 0) {
                trueFactors.addFactor(baseZ, 1);
            } else {
                trueFactors.addFactor(MultivariateFactorization.denseSeriesToPolyZ(baseZ, fRest, lPowersZ), 1);
            }
        }
        return trueFactors;
    }

    private static UnivariatePolynomial<UnivariatePolynomial<BigInteger>> seriesExpansionDenseZ(MultivariatePolynomial<BigInteger> poly, BigInteger ySubstitution) {
        int degree = poly.degree(1);
        UnivariatePolynomial[] coefficients = (UnivariatePolynomial[])Rings.UnivariateRingZ.createArray(degree + 1);
        for (int i = 0; i <= degree; ++i) {
            coefficients[i] = ((MultivariatePolynomial)poly.seriesCoefficient(1, i)).evaluate(1, ySubstitution).asUnivariate();
        }
        return UnivariatePolynomial.createUnsafe(Rings.UnivariateRingZ, coefficients);
    }

    private static MultivariatePolynomial<BigInteger> denseSeriesToPolyZ(MultivariatePolynomial<BigInteger> factory, UnivariatePolynomial<UnivariatePolynomial<BigInteger>> series, MultivariatePolynomial.USubstitution<BigInteger> linearPowers) {
        IPolynomial result = factory.createZero();
        for (int i = 0; i <= series.degree(); ++i) {
            MultivariatePolynomial mPoly = (MultivariatePolynomial)AMultivariatePolynomial.asMultivariate(series.get(i), factory.nVariables, 0, factory.ordering);
            result = (MultivariatePolynomial)((AMultivariatePolynomial)result).add(mPoly.multiply(linearPowers.pow(i)));
        }
        return result;
    }

    private static <uPoly extends IUnivariatePolynomial<uPoly>> UnivariatePolynomial<uPoly> changeDenseRepresentation(UnivariatePolynomial<uPoly> poly) {
        int xDegree = -1;
        for (int i = 0; i <= poly.degree(); ++i) {
            xDegree = Math.max(xDegree, ((IUnivariatePolynomial)poly.get(i)).degree());
        }
        IPolynomial result = poly.createZero();
        for (int i = 0; i <= xDegree; ++i) {
            ((UnivariatePolynomial)result).set(i, MultivariateFactorization.coefficientInSeries(i, poly));
        }
        return result;
    }

    private static <uPoly extends IUnivariatePolynomial<uPoly>> uPoly coefficientInSeries(int xDegree, UnivariatePolynomial<uPoly> poly) {
        Ring ring = poly.ring;
        IUnivariatePolynomial result = (IUnivariatePolynomial)ring.getZero();
        for (int i = 0; i <= poly.degree(); ++i) {
            result.setFrom(i, (IUnivariatePolynomial)poly.get(i), xDegree);
        }
        return (uPoly)result;
    }

    private static <uPoly extends IUnivariatePolynomial<uPoly>> UnivariatePolynomial<uPoly> lcInSeries(UnivariatePolynomial<uPoly> poly) {
        int i;
        IPolynomial result = poly.createZero();
        int xDegree = -1;
        for (i = 0; i <= poly.degree(); ++i) {
            xDegree = Math.max(xDegree, ((IUnivariatePolynomial)poly.get(i)).degree());
        }
        for (i = 0; i <= poly.degree(); ++i) {
            ((UnivariatePolynomial)result).set(i, ((IUnivariatePolynomial)poly.get(i)).getAsPoly(xDegree));
        }
        return result;
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> bivariateDenseFactorSquareFreeInGF(Poly poly, boolean switchToExtensionField) {
        if (poly instanceof MultivariatePolynomialZp64) {
            return MultivariateFactorization.bivariateDenseFactorSquareFreeInGF((MultivariatePolynomialZp64)poly, switchToExtensionField, true);
        }
        return MultivariateFactorization.bivariateDenseFactorSquareFreeInGF((MultivariatePolynomial)poly, switchToExtensionField, true);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> factorInExtensionFieldGeneric(Poly poly, FactorizationAlgorithm<Term, Poly> algorithm) {
        if (poly instanceof MultivariatePolynomialZp64) {
            return MultivariateFactorization.factorInExtensionField((MultivariatePolynomialZp64)poly, algorithm);
        }
        if (poly instanceof MultivariatePolynomial) {
            return MultivariateFactorization.factorInExtensionField((MultivariatePolynomial)poly, algorithm);
        }
        throw new RuntimeException();
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> OrderByDegrees<Term, Poly> orderByDegrees(Poly poly, boolean reduceNVariables, int mainVariable) {
        int lastPresentVariable;
        int nVariables = poly.nVariables;
        int[] degreeBounds = poly.degrees();
        int[] variables = ArraysUtil.sequence(nVariables);
        if (mainVariable != -1) {
            int mainDegree = degreeBounds[mainVariable];
            degreeBounds[mainVariable] = Integer.MAX_VALUE;
            ArraysUtil.insertionSort(ArraysUtil.negate(degreeBounds), variables);
            ArraysUtil.negate(degreeBounds);
            degreeBounds[ArraysUtil.firstIndexOf((int)mainVariable, (int[])variables)] = mainDegree;
        } else {
            int i;
            ArraysUtil.insertionSort(ArraysUtil.negate(degreeBounds), variables);
            ArraysUtil.negate(degreeBounds);
            for (i = 0; i < variables.length && MultivariateFactorization.isPPower(poly, variables[i]); ++i) {
            }
            if (i > 0) {
                ArraysUtil.swap(variables, 0, i);
                ArraysUtil.swap(degreeBounds, 0, i);
            }
        }
        if (reduceNVariables) {
            for (lastPresentVariable = 0; lastPresentVariable < degreeBounds.length && degreeBounds[lastPresentVariable] != 0; ++lastPresentVariable) {
            }
            --lastPresentVariable;
        } else {
            lastPresentVariable = nVariables - 1;
        }
        poly = AMultivariatePolynomial.renameVariables(poly, variables).setNVariables(lastPresentVariable + 1);
        return new OrderByDegrees(poly, degreeBounds, variables, nVariables);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> factorPrimitiveInGF(Poly polynomial) {
        return MultivariateFactorization.factorPrimitiveInGF(polynomial, true);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> factorPrimitiveInGF(Poly polynomial, boolean switchToExtensionField) {
        if (polynomial.isEffectiveUnivariate()) {
            return MultivariateFactorization.factorUnivariate(polynomial);
        }
        OrderByDegrees<Term, Poly> input = MultivariateFactorization.orderByDegrees(polynomial, true, -1);
        PolynomialFactorDecomposition<AMultivariatePolynomial> decomposition = MultivariateFactorization.factorPrimitiveInGF0(input.ordered, switchToExtensionField);
        if (decomposition == null) {
            return null;
        }
        return decomposition.mapTo(input::restoreOrder);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> boolean isPPower(Poly p, int variable) {
        BigInteger characteristics = p.coefficientRingCharacteristic();
        if (characteristics.isZero()) {
            return false;
        }
        if (!characteristics.isInt()) {
            return false;
        }
        int modulus = characteristics.intValueExact();
        if (modulus > p.degree()) {
            return false;
        }
        for (AMonomial term : p) {
            if (term.exponents[variable] % modulus == 0) continue;
            return false;
        }
        return true;
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> boolean containsPPower(Poly p, int variable) {
        BigInteger characteristics = p.coefficientRingCharacteristic();
        return characteristics.isInt() && characteristics.intValueExact() <= p.degree() && !MultivariateGCD.PolynomialGCD(p, p.derivative(variable)).isConstant();
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> factorPrimitiveInGF0(Poly poly, boolean switchToExtensionField) {
        return MultivariateFactorization.factorPrimitiveInGF0(poly, -1, switchToExtensionField);
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> factorPrimitiveInGF0(Poly initialPoly, int fixSecondVar, boolean switchToExtensionField) {
        PolynomialFactorDecomposition<AMultivariatePolynomial> factorization;
        assert (initialPoly.nUsedVariables() >= 2);
        assert (initialPoly.degree(1) > 0 && initialPoly.degree(0) > 0);
        if (initialPoly.nUsedVariables() == 2) {
            return MultivariateFactorization.bivariateDenseFactorSquareFreeInGF(initialPoly, switchToExtensionField);
        }
        Poly poly = MultivariateFactorization.swapSecondVar(initialPoly, fixSecondVar);
        Poly xDerivative = poly.derivative(0);
        assert (!((AMultivariatePolynomial)xDerivative).isZero());
        Poly dGCD = MultivariateGCD.PolynomialGCD(xDerivative, poly);
        if (!dGCD.isConstant()) {
            PolynomialFactorDecomposition<Poly> gcdFactorization = MultivariateFactorization.factorPrimitiveInGF(dGCD, switchToExtensionField);
            PolynomialFactorDecomposition<Poly> restFactorization = MultivariateFactorization.factorPrimitiveInGF(MultivariateDivision.divideExact(poly, dGCD), switchToExtensionField);
            if (gcdFactorization == null || restFactorization == null) {
                assert (!switchToExtensionField);
                return null;
            }
            return MultivariateFactorization.swapSecondVar(gcdFactorization.addAll((FactorDecomposition)restFactorization), fixSecondVar);
        }
        boolean isSmallCardinality = poly.coefficientRingCardinality().bitLength() <= 10;
        Poly lc = poly.lc(0);
        LeadingCoefficientData lcData = new LeadingCoefficientData(lc);
        IEvaluationLoop<Term, Poly> evaluations = MultivariateFactorization.getEvaluationsGF(poly);
        int nAttempts = 0;
        int nBivariateFactors = Integer.MAX_VALUE;
        int[] nInconsistentBiFactorizations = new int[poly.nVariables];
        int nFailedWithSuperfluousFactors = 0;
        block0: while (true) {
            AMultivariatePolynomial[] biFactorsArrayMain;
            HenselLifting.IEvaluation evaluation;
            if ((evaluation = evaluations.next()) == null || nAttempts++ > 32 && isSmallCardinality) {
                if (switchToExtensionField) {
                    return MultivariateFactorization.factorInExtensionFieldGeneric(initialPoly, MultivariateFactorization::factorPrimitiveInGF0);
                }
                return null;
            }
            AMultivariatePolynomial[] images = (AMultivariatePolynomial[])poly.createArray(poly.nVariables - 1);
            for (int i2 = 0; i2 < images.length; ++i2) {
                int variable = poly.nVariables - i2 - 1;
                images[i2] = evaluation.evaluate(i2 == 0 ? poly : images[i2 - 1], variable);
                if (images[i2].degree(variable - 1) != poly.degree(variable - 1)) continue block0;
            }
            AMultivariatePolynomial bivariateImage = images[images.length - 2];
            AMultivariatePolynomial univariateImage = images[images.length - 1];
            assert (bivariateImage.degree(0) == poly.degree(0) && bivariateImage.degree(1) == poly.degree(1));
            if (((AMultivariatePolynomial)lc).degree(1) != ((AMultivariatePolynomial)bivariateImage.lc(0)).degree(1) || !UnivariateSquareFreeFactorization.isSquareFree(univariateImage.asUnivariate()) || !bivariateImage.contentUnivariate(1).isConstant()) continue;
            PolynomialFactorDecomposition<AMultivariatePolynomial> biFactorsMain = MultivariateFactorization.bivariateDenseFactorSquareFreeInGF(bivariateImage, false);
            if (biFactorsMain == null) {
                if (switchToExtensionField) {
                    return MultivariateFactorization.factorInExtensionFieldGeneric(initialPoly, MultivariateFactorization::factorPrimitiveInGF0);
                }
                return null;
            }
            if (biFactorsMain.size() == 1) {
                return PolynomialFactorDecomposition.of(initialPoly);
            }
            if (biFactorsMain.size() > nBivariateFactors) {
                if (++nFailedWithSuperfluousFactors <= 8) continue;
                return MultivariateFactorization.factorPrimitiveInGF0(initialPoly, fixSecondVar + 1, switchToExtensionField);
            }
            nFailedWithSuperfluousFactors = 0;
            nBivariateFactors = biFactorsMain.size();
            if (!lc.isConstant()) {
                Object base;
                int i3;
                MultivariateFactorization.toCanonicalSort(biFactorsMain, evaluation);
                biFactorsArrayMain = biFactorsMain.factors.toArray((AMultivariatePolynomial[])poly.createArray(biFactorsMain.size()));
                Object lcRest = ((AMultivariatePolynomial)lc).clone();
                AMultivariatePolynomial[] lcFactors = (AMultivariatePolynomial[])poly.createArray(biFactorsMain.size());
                for (i3 = 0; i3 < lcFactors.length; ++i3) {
                    lcFactors[i3] = evaluation.evaluateFrom(biFactorsArrayMain[i3].lc(0), 1);
                    lcRest = lcRest.divideByLC(lcFactors[i3]);
                }
                if (lcData.lcSplits.length == 0) {
                    for (int freeVariable = 2; freeVariable < poly.nVariables; ++freeVariable) {
                        PolynomialFactorDecomposition fct;
                        Poly biImage = evaluation.evaluateFromExcept(poly, 1, freeVariable);
                        if (biImage.degree(0) != poly.degree(0) || biImage.degree(freeVariable) != poly.degree(freeVariable) || ((AMultivariatePolynomial)biImage.lc(0)).degree(freeVariable) != ((AMultivariatePolynomial)lc).degree(freeVariable) || (fct = MultivariateFactorization.bivariateDenseFactorSquareFreeInGF(MultivariateFactorization.orderByDegrees(biImage, (boolean)true, (int)-1).ordered, false)) == null || fct.size() >= nBivariateFactors) continue;
                        nBivariateFactors = fct.size();
                        continue block0;
                    }
                }
                for (i3 = 0; i3 < lcData.lcSplits.length && !lcRest.isConstant(); ++i3) {
                    PolynomialFactorDecomposition biFactors;
                    Object ppPart;
                    SplitContent lcSplit = lcData.lcSplits[i3];
                    int freeVariable = 1 + lcSplit.variable;
                    HenselLifting.IEvaluation iEvaluation = evaluation.renameVariables(lcSplit.ppOrdered.variablesSorted);
                    HenselLifting.IEvaluation<Term, Poly> ilcEvaluation = iEvaluation.dropVariable(1);
                    if (!UnivariateSquareFreeFactorization.isSquareFree(ilcEvaluation.evaluateFrom(ppPart = lcSplit.ppOrdered.ordered, 1).asUnivariate())) {
                        assert (!MultivariateFactorization.containsPPower(lcSplit.primitivePart, lcSplit.variable));
                        continue block0;
                    }
                    if (freeVariable == 1) {
                        biFactors = biFactorsMain;
                    } else {
                        Poly biImage = evaluation.evaluateFromExcept(poly, 1, freeVariable);
                        if (biImage.degree(0) != poly.degree(0) || biImage.degree(freeVariable) != poly.degree(freeVariable) || ((AMultivariatePolynomial)biImage.lc(0)).degree(freeVariable) != ((AMultivariatePolynomial)lc).degree(freeVariable)) continue block0;
                        biFactors = MultivariateFactorization.bivariateDenseFactorSquareFreeInGF(MultivariateFactorization.orderByDegrees(biImage, (boolean)false, (int)-1).ordered, false);
                        if (biFactors == null) {
                            if (switchToExtensionField) {
                                return MultivariateFactorization.factorInExtensionFieldGeneric(initialPoly, MultivariateFactorization::factorPrimitiveInGF0);
                            }
                            return null;
                        }
                        MultivariateFactorization.toCanonicalSort(biFactors, iEvaluation);
                    }
                    if (biFactors.size() != biFactorsMain.size()) {
                        if (biFactors.size() > biFactorsMain.size()) {
                            int n = freeVariable;
                            nInconsistentBiFactorizations[n] = nInconsistentBiFactorizations[n] + 1;
                            if (nInconsistentBiFactorizations[freeVariable] <= 32) continue block0;
                            if (switchToExtensionField) {
                                return MultivariateFactorization.factorInExtensionFieldGeneric(initialPoly, MultivariateFactorization::factorPrimitiveInGF0);
                            }
                            return null;
                        }
                        nBivariateFactors = biFactors.size();
                        continue block0;
                    }
                    if (biFactors != biFactorsMain && !biFactors.mapTo(p -> iEvaluation.evaluateFrom(p, 1).asUnivariate()).monic().equals(biFactorsMain.mapTo(p -> evaluation.evaluateFrom(p, 1).asUnivariate()).monic())) {
                        int n = freeVariable;
                        nInconsistentBiFactorizations[n] = nInconsistentBiFactorizations[n] + 1;
                        if (nInconsistentBiFactorizations[freeVariable] <= 32) continue block0;
                        assert (MultivariateFactorization.isSmallCharacteristics(poly));
                        if (switchToExtensionField) {
                            return MultivariateFactorization.factorInExtensionFieldGeneric(initialPoly, MultivariateFactorization::factorPrimitiveInGF0);
                        }
                        return null;
                    }
                    PolynomialFactorDecomposition[] ulcFactors = (PolynomialFactorDecomposition[])biFactors.factors.stream().map(f -> UnivariateSquareFreeFactorization.SquareFreeFactorization(((AMultivariatePolynomial)f.lc(0)).asUnivariate())).toArray(PolynomialFactorDecomposition[]::new);
                    MultivariateFactorization.GCDFreeBasis(ulcFactors);
                    PolynomialFactorDecomposition[] ilcFactors = (PolynomialFactorDecomposition[])Arrays.stream(ulcFactors).map(decomposition -> decomposition.mapTo(p -> AMultivariatePolynomial.asMultivariate((IUnivariatePolynomial)p, poly.nVariables - 1, 0, poly.ordering))).toArray(PolynomialFactorDecomposition[]::new);
                    for (int l = 0; l < ilcFactors.length; ++l) {
                        for (int m = 0; m < ilcFactors[l].factors.size(); ++m) {
                            AMultivariatePolynomial p2 = (AMultivariatePolynomial)ilcFactors[l].factors.get(m);
                            for (int l1 = l; l1 < ilcFactors.length; ++l1) {
                                int m1Begin;
                                for (int m1 = m1Begin = l1 == l ? m + 1 : 0; m1 < ilcFactors[l1].factors.size(); ++m1) {
                                    if (!((AMultivariatePolynomial)ilcFactors[l1].factors.get(m1)).equals(p2)) continue;
                                    ilcFactors[l1].factors.set(m1, p2);
                                }
                            }
                        }
                    }
                    Set<AMultivariatePolynomial> ilcFactorsSet = Arrays.stream(ilcFactors).flatMap(FactorDecomposition::streamWithoutUnit).collect(Collectors.toSet());
                    AMultivariatePolynomial[] ilcFactorsSqFree = ilcFactorsSet.toArray((AMultivariatePolynomial[])poly.createArray(ilcFactorsSet.size()));
                    assert (ilcFactorsSqFree.length > 0);
                    assert (Arrays.stream(ilcFactorsSqFree).noneMatch(IPolynomial::isConstant));
                    assert (Arrays.stream(ilcFactorsSqFree).mapToInt(AMultivariatePolynomial::degree).reduce(0, (a, b) -> a + b) == ((AMultivariatePolynomial)ppPart).degree(0));
                    Poly ppPartLC = ilcEvaluation.evaluateFrom(((AMultivariatePolynomial)ppPart).lc(0), 1);
                    AMultivariatePolynomial realLC = Arrays.stream(ilcFactorsSqFree).map(IPolynomial::lcAsPoly).reduce((AMultivariatePolynomial)ilcFactorsSqFree[0].createOne(), IPolynomial::multiply);
                    assert (ppPartLC.isConstant());
                    assert (realLC.isConstant());
                    Poly base2 = ((AMultivariatePolynomial)ppPart).clone().multiplyByLC(realLC.divideByLC(ppPartLC));
                    if (ilcFactorsSqFree.length == 1) {
                        ilcFactorsSqFree[0].set(base2);
                    } else {
                        HenselLifting.multivariateLiftAutomaticLC(base2, (AMultivariatePolynomial[])ilcFactorsSqFree, ilcEvaluation);
                    }
                    for (int jFactor = 0; jFactor < lcFactors.length; ++jFactor) {
                        Object obtainedLcFactor = AMultivariatePolynomial.renameVariables((AMultivariatePolynomial)ilcFactors[jFactor].multiply(), lcSplit.ppOrdered.variablesMapping).insertVariable(0);
                        AMultivariatePolynomial commonPart = MultivariateGCD.PolynomialGCD(obtainedLcFactor, lcFactors[jFactor]);
                        Object addon = MultivariateDivision.divideExact(obtainedLcFactor, commonPart);
                        Object addonR = MultivariateGCD.PolynomialGCD(addon, lcRest);
                        assert (((AMultivariatePolynomial)((AMultivariatePolynomial)addon).clone().monic()).equals(((AMultivariatePolynomial)addonR).clone().monic()) || MultivariateFactorization.isSmallCharacteristics(poly));
                        addon = addonR;
                        addon = (AMultivariatePolynomial)addon.divideByLC(evaluation.evaluateFrom(addon, 1));
                        lcFactors[jFactor] = (AMultivariatePolynomial)lcFactors[jFactor].multiply(addon);
                        lcRest = MultivariateDivision.divideExact(lcRest, addon);
                    }
                }
                if (lcRest.isConstant()) {
                    if (lcRest.isOne()) {
                        base = poly.clone().divideByLC((AMultivariatePolynomial)biFactorsMain.unit);
                    } else {
                        base = poly.clone();
                        base.divideByLC(lcRest);
                    }
                    HenselLifting.multivariateLift0((AMultivariatePolynomial)base, (AMultivariatePolynomial[])biFactorsArrayMain, (AMultivariatePolynomial[])lcFactors, evaluation, (int[])((AMultivariatePolynomial)base).degrees(), (int)2);
                } else {
                    assert (!lcData.fullyReconstructable || MultivariateFactorization.isSmallCharacteristics(poly));
                    for (i3 = 0; i3 < biFactorsMain.size(); ++i3) {
                        assert (((AMonomial)biFactorsArrayMain[i3].lt(MonomialOrder.LEX)).exponents[0] == biFactorsArrayMain[i3].degree(0));
                        lcFactors[i3].multiply(lcRest);
                        AMultivariatePolynomial correction = MultivariateDivision.divideExact(evaluation.evaluateFrom(lcFactors[i3], 2), biFactorsArrayMain[i3].lc(0));
                        biFactorsArrayMain[i3].multiply(correction);
                    }
                    base = (AMultivariatePolynomial)((AMultivariatePolynomial)poly.clone()).multiply((AMultivariatePolynomial)PolynomialMethods.polyPow(lcRest, biFactorsMain.size() - 1, true));
                    assert (IntStream.range(0, biFactorsMain.size()).allMatch(i -> ((AMultivariatePolynomial)biFactorsArrayMain[i].lc(0)).equals(evaluation.evaluateFrom(lcFactors[i], 2))));
                    HenselLifting.multivariateLift0((AMultivariatePolynomial)base, (AMultivariatePolynomial[])biFactorsArrayMain, (AMultivariatePolynomial[])lcFactors, evaluation, (int[])((AMultivariatePolynomial)base).degrees(), (int)2);
                    for (AMultivariatePolynomial factor : biFactorsArrayMain) {
                        factor.set(HenselLifting.primitivePart(factor));
                    }
                }
            } else {
                Object base;
                if (((AMultivariatePolynomial)biFactorsMain.unit).isOne()) {
                    base = poly;
                } else {
                    base = poly.clone();
                    base.divideByLC((AMultivariatePolynomial)((AMultivariatePolynomial)biFactorsMain.unit));
                }
                biFactorsArrayMain = biFactorsMain.factors.toArray((AMultivariatePolynomial[])poly.createArray(biFactorsMain.size()));
                HenselLifting.multivariateLift0((AMultivariatePolynomial)base, (AMultivariatePolynomial[])biFactorsArrayMain, null, evaluation, (int[])poly.degrees(), (int)2);
            }
            factorization = PolynomialFactorDecomposition.of(Arrays.asList(biFactorsArrayMain)).monic().setUnit((AMultivariatePolynomial)poly.lcAsPoly());
            AMultivariatePolynomial lcNumeric = (AMultivariatePolynomial)factorization.factors.stream().reduce(((AMultivariatePolynomial)factorization.unit).clone(), (a, b) -> (AMultivariatePolynomial)((AMultivariatePolynomial)a.lcAsPoly()).multiply((AMultivariatePolynomial)b.lcAsPoly()));
            AMultivariatePolynomial ccNumeric = (AMultivariatePolynomial)factorization.factors.stream().reduce(((AMultivariatePolynomial)factorization.unit).clone(), (a, b) -> (AMultivariatePolynomial)((AMultivariatePolynomial)a.ccAsPoly()).multiply((AMultivariatePolynomial)b.ccAsPoly()));
            if (lcNumeric.equals(poly.lcAsPoly()) && ccNumeric.equals(poly.ccAsPoly()) && ((AMultivariatePolynomial)factorization.multiply()).equals(poly)) break;
            nBivariateFactors = factorization.size() - 1;
        }
        return MultivariateFactorization.swapSecondVar(factorization, fixSecondVar);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> Poly swapSecondVar(Poly initialPoly, int fixSecondVar) {
        if (fixSecondVar == -1) {
            return initialPoly;
        }
        return AMultivariatePolynomial.swapVariables(initialPoly, 1, fixSecondVar + 2);
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> PolynomialFactorDecomposition<Poly> swapSecondVar(PolynomialFactorDecomposition<Poly> factors, int fixSecondVar) {
        if (fixSecondVar == -1) {
            return factors;
        }
        return factors.mapTo(p -> AMultivariatePolynomial.swapVariables(p, 1, fixSecondVar + 2));
    }

    private static boolean isSmallCharacteristics(IPolynomial poly) {
        return poly.coefficientRingCharacteristic().bitLength() <= 5;
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>, uPoly extends IUnivariatePolynomial<uPoly>> void toCanonicalSort(PolynomialFactorDecomposition<Poly> biFactors, HenselLifting.IEvaluation<Term, Poly> evaluation) {
        Comparable[] uFactorsArray = (IUnivariatePolynomial[])biFactors.mapTo(p -> evaluation.evaluateFrom(p, 1).asUnivariate()).reduceUnitContent().toArrayWithoutUnit();
        Object[] biFactorsArray = (AMultivariatePolynomial[])biFactors.toArrayWithoutUnit();
        ArraysUtil.quickSort((Comparable[])uFactorsArray, (Object[])biFactorsArray);
        biFactors.factors.clear();
        biFactors.factors.addAll(Arrays.asList(biFactorsArray));
    }

    static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> IEvaluationLoop<Term, Poly> getEvaluationsGF(Poly factory) {
        if (factory instanceof MultivariatePolynomialZp64) {
            return new lEvaluationLoop((MultivariatePolynomialZp64)factory);
        }
        return new EvaluationLoop((MultivariatePolynomial)factory);
    }

    static <Poly extends IPolynomial<Poly>> void GCDFreeBasis(PolynomialFactorDecomposition<Poly>[] decompositions) {
        ArrayList allFactors = new ArrayList();
        for (PolynomialFactorDecomposition<Poly> decomposition : decompositions) {
            for (int j = 0; j < decomposition.size(); ++j) {
                allFactors.add(new FactorRef<Poly>(decomposition, j));
            }
        }
        for (int i = 0; i < allFactors.size() - 1; ++i) {
            for (int j = i + 1; j < allFactors.size(); ++j) {
                Object gcd;
                FactorRef a = (FactorRef)allFactors.get(i);
                FactorRef b = (FactorRef)allFactors.get(j);
                if (a == null || b == null || (gcd = PolynomialMethods.PolynomialGCD(a.factor(), b.factor())).isConstant()) continue;
                Object aReduced = PolynomialMethods.divideExact(a.factor(), gcd);
                Object bReduced = PolynomialMethods.divideExact(b.factor(), gcd);
                if (bReduced.isConstant()) {
                    allFactors.set(j, null);
                }
                TIntArrayList aGCDIndexes = a.update(aReduced, gcd);
                TIntArrayList bGCDIndexes = b.update(bReduced, gcd);
                FactorRef gcdRef = new FactorRef();
                gcdRef.decompositions.addAll(a.decompositions);
                gcdRef.indexes.addAll((TIntCollection)aGCDIndexes);
                gcdRef.decompositions.addAll(b.decompositions);
                gcdRef.indexes.addAll((TIntCollection)bGCDIndexes);
                allFactors.add(gcdRef);
            }
        }
        Arrays.stream(decompositions).forEach(MultivariateFactorization::normalizeGCDFreeDecomposition);
    }

    private static <Poly extends IPolynomial<Poly>> void normalizeGCDFreeDecomposition(PolynomialFactorDecomposition<Poly> decomposition) {
        block0: for (int i = decomposition.factors.size() - 1; i >= 0; --i) {
            Poly factor = ((IPolynomial)decomposition.get(i)).clone();
            Poly content = factor.isOverField() ? factor.lcAsPoly() : factor.contentAsPoly();
            decomposition.addUnit(PolynomialMethods.polyPow(content, decomposition.getExponent(i), false));
            factor = factor.divideByLC(content);
            assert (factor != null);
            if (factor.isOne()) {
                decomposition.factors.remove(i);
                decomposition.exponents.removeAt(i);
                continue;
            }
            decomposition.factors.set(i, factor);
            for (int j = i + 1; j < decomposition.size(); ++j) {
                if (!((IPolynomial)decomposition.get(j)).equals(factor)) continue;
                decomposition.exponents.set(i, decomposition.exponents.get(j) + decomposition.exponents.get(i));
                decomposition.factors.remove(j);
                decomposition.exponents.removeAt(j);
                continue block0;
            }
        }
    }

    static PolynomialFactorDecomposition<MultivariatePolynomial<BigInteger>> factorPrimitiveInZ(MultivariatePolynomial<BigInteger> polynomial) {
        if (polynomial.isEffectiveUnivariate()) {
            return MultivariateFactorization.factorUnivariate(polynomial);
        }
        OrderByDegrees input = MultivariateFactorization.orderByDegrees(polynomial, true, -1);
        PolynomialFactorDecomposition<MultivariatePolynomial<BigInteger>> decomposition = MultivariateFactorization.factorPrimitiveInZ0((MultivariatePolynomial)input.ordered);
        if (decomposition == null) {
            return null;
        }
        return decomposition.mapTo(input::restoreOrder);
    }

    static PolynomialFactorDecomposition<MultivariatePolynomial<BigInteger>> factorPrimitiveInZ0(MultivariatePolynomial<BigInteger> poly) {
        PolynomialFactorDecomposition<MultivariatePolynomial<BigInteger>> factorization;
        assert (poly.nUsedVariables() >= 2);
        assert (poly.degree(1) > 0 && poly.degree(0) > 0);
        assert (poly.content().isOne());
        if (poly.nUsedVariables() == 2) {
            return MultivariateFactorization.bivariateDenseFactorSquareFreeInZ(poly);
        }
        MultivariatePolynomial lc = (MultivariatePolynomial)poly.lc(0);
        BigInteger lcContent = (BigInteger)lc.content();
        MultivariatePolynomial<BigInteger> lcPrimitive = ((MultivariatePolynomial)lc.clone()).divideOrNull(lcContent);
        LeadingCoefficientData lcData = new LeadingCoefficientData(lcPrimitive);
        assert (lcData.fullyReconstructable);
        BigInteger bound2 = MultivariateFactorization.coefficientsBound(poly).multiply(MultivariateFactorization.coefficientsBound(lc)).shiftLeft(1);
        EvaluationLoopZ evaluations = new EvaluationLoopZ(poly);
        int nBivariateFactors = Integer.MAX_VALUE;
        block0: while (true) {
            MultivariatePolynomial<BigInteger>[] biFactorsArrayMainZ;
            BigInteger bBasePrime;
            HenselLifting.Evaluation evaluation;
            if ((evaluation = (HenselLifting.Evaluation)evaluations.next()) == null) {
                throw new RuntimeException();
            }
            MultivariatePolynomial<BigInteger>[] images = poly.createArray(poly.nVariables - 1);
            for (int i = 0; i < images.length; ++i) {
                int variable = poly.nVariables - i - 1;
                images[i] = evaluation.evaluate(i == 0 ? poly : images[i - 1], variable);
                if (images[i].degree(variable - 1) != poly.degree(variable - 1)) continue block0;
            }
            MultivariatePolynomial<BigInteger> bivariateImage = images[images.length - 2];
            MultivariatePolynomial<BigInteger> univariateImage = images[images.length - 1];
            assert (bivariateImage.degree(0) == poly.degree(0) && bivariateImage.degree(1) == poly.degree(1));
            if (lc.degree(1) != ((MultivariatePolynomial)bivariateImage.lc(0)).degree(1) || !UnivariateSquareFreeFactorization.isSquareFree(univariateImage.asUnivariate()) || !((UnivariatePolynomial)bivariateImage.contentUnivariate(1)).isConstant()) continue;
            PolynomialFactorDecomposition<MultivariatePolynomial<BigInteger>> biFactorsMain = MultivariateFactorization.bivariateDenseFactorSquareFreeInZ(bivariateImage);
            if (biFactorsMain.size() == 1) {
                return PolynomialFactorDecomposition.of(poly);
            }
            if (biFactorsMain.size() > nBivariateFactors) continue;
            nBivariateFactors = biFactorsMain.size();
            int basePrime = 0x400000;
            while (true) {
                if (!MultivariateFactorization.isGoodPrime(bBasePrime = BigInteger.valueOf(basePrime = SmallPrimes.nextPrime(basePrime)), univariateImage.lc(), univariateImage.cc())) {
                    continue;
                }
                IntegersZp moduloDomain = new IntegersZp(bBasePrime);
                if (PolynomialMethods.coprimeQ(biFactorsMain.mapTo((Function<MultivariatePolynomial, MultivariatePolynomial>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$factorPrimitiveInZ0$31(cc.redberry.rings.IntegersZp cc.redberry.rings.poly.multivar.MultivariatePolynomial ), (Lcc/redberry/rings/poly/multivar/MultivariatePolynomial;)Lcc/redberry/rings/poly/multivar/MultivariatePolynomial;)((IntegersZp)moduloDomain)).factors)) break;
            }
            BigInteger modulus = bBasePrime;
            while (modulus.compareTo(bound2) < 0) {
                modulus = modulus.multiply(bBasePrime);
            }
            IntegersZp zpDomain = new IntegersZp(modulus);
            HenselLifting.Evaluation<BigInteger> evaluationZp = evaluation.setRing(zpDomain);
            if (!lc.isConstant()) {
                int i;
                MultivariateFactorization.toCanonicalSort(biFactorsMain, evaluation);
                biFactorsArrayMainZ = biFactorsMain.factors.toArray(poly.createArray(biFactorsMain.size()));
                MultivariatePolynomial<BigInteger> lcRest = lc.clone();
                MultivariatePolynomial<BigInteger>[] lcFactors = poly.createArray(biFactorsMain.size());
                for (i = 0; i < lcFactors.length; ++i) {
                    lcFactors[i] = poly.createOne();
                }
                for (i = 0; i < lcData.lcSplits.length && !lcRest.isConstant(); ++i) {
                    PolynomialFactorDecomposition<MultivariatePolynomial<BigInteger>> biFactors;
                    MultivariatePolynomial ppPart;
                    SplitContent lcSplit = lcData.lcSplits[i];
                    int freeVariable = 1 + lcSplit.variable;
                    HenselLifting.IEvaluation iEvaluation = evaluation.renameVariables(lcSplit.ppOrdered.variablesSorted);
                    HenselLifting.IEvaluation ilcEvaluation = ((HenselLifting.Evaluation)iEvaluation).dropVariable(1);
                    if (!UnivariateSquareFreeFactorization.isSquareFree(((HenselLifting.Evaluation)ilcEvaluation).evaluateFrom(ppPart = (MultivariatePolynomial)lcSplit.ppOrdered.ordered, 1).asUnivariate())) continue block0;
                    if (freeVariable == 1) {
                        biFactors = biFactorsMain;
                    } else {
                        MultivariatePolynomial<BigInteger> biImage = evaluation.evaluateFromExcept(poly, 1, freeVariable);
                        if (biImage.degree(0) != poly.degree(0) || biImage.degree(freeVariable) != poly.degree(freeVariable) || ((MultivariatePolynomial)biImage.lc(0)).degree(freeVariable) != lc.degree(freeVariable)) continue block0;
                        biFactors = MultivariateFactorization.bivariateDenseFactorSquareFreeInZ((MultivariatePolynomial)MultivariateFactorization.orderByDegrees(biImage, (boolean)false, (int)-1).ordered);
                        MultivariateFactorization.toCanonicalSort(biFactors, iEvaluation);
                    }
                    if (biFactors.size() != biFactorsMain.size()) {
                        nBivariateFactors = Math.min(biFactors.size(), biFactorsMain.size());
                        continue block0;
                    }
                    assert (biFactors.mapTo(arg_0 -> MultivariateFactorization.lambda$factorPrimitiveInZ0$32((HenselLifting.Evaluation)iEvaluation, arg_0)).primitive().canonical().equals(biFactorsMain.mapTo(p -> evaluation.evaluateFrom(p, 1).asUnivariate()).primitive().canonical())) : poly.toString();
                    PolynomialFactorDecomposition[] ulcFactors = (PolynomialFactorDecomposition[])biFactors.factors.stream().map(f -> UnivariateSquareFreeFactorization.SquareFreeFactorization(((MultivariatePolynomial)f.lc(0)).asUnivariate())).toArray(PolynomialFactorDecomposition[]::new);
                    MultivariateFactorization.GCDFreeBasis(ulcFactors);
                    PolynomialFactorDecomposition[] ilcFactors = (PolynomialFactorDecomposition[])Arrays.stream(ulcFactors).map(decomposition -> decomposition.mapTo(p -> AMultivariatePolynomial.asMultivariate((IUnivariatePolynomial)p, poly.nVariables - 1, 0, poly.ordering))).toArray(PolynomialFactorDecomposition[]::new);
                    for (int l = 0; l < ilcFactors.length; ++l) {
                        for (int m = 0; m < ilcFactors[l].factors.size(); ++m) {
                            MultivariatePolynomial p2 = (MultivariatePolynomial)ilcFactors[l].factors.get(m);
                            for (int l1 = l; l1 < ilcFactors.length; ++l1) {
                                int m1Begin;
                                for (int m1 = m1Begin = l1 == l ? m + 1 : 0; m1 < ilcFactors[l1].factors.size(); ++m1) {
                                    if (!((MultivariatePolynomial)ilcFactors[l1].factors.get(m1)).equals(p2)) continue;
                                    ilcFactors[l1].factors.set(m1, p2);
                                }
                            }
                        }
                    }
                    Set<MultivariatePolynomial<BigInteger>> ilcFactorsSet = Arrays.stream(ilcFactors).flatMap(FactorDecomposition::streamWithoutUnit).collect(Collectors.toSet());
                    MultivariatePolynomial<BigInteger>[] ilcFactorsSqFree = ilcFactorsSet.toArray(poly.createArray(ilcFactorsSet.size()));
                    assert (ilcFactorsSqFree.length > 0);
                    assert (Arrays.stream(ilcFactorsSqFree).noneMatch(MultivariatePolynomial::isConstant));
                    assert (Arrays.stream(ilcFactorsSqFree).mapToInt(AMultivariatePolynomial::degree).reduce(0, (a, b) -> a + b) == ppPart.degree(0));
                    MultivariatePolynomial ppPartLC = ((HenselLifting.Evaluation)ilcEvaluation).evaluateFrom((MultivariatePolynomial)ppPart.lc(0), 1);
                    MultivariatePolynomial realLC = Arrays.stream(ilcFactorsSqFree).map(MultivariatePolynomial::lcAsPoly).reduce((MultivariatePolynomial)ilcFactorsSqFree[0].createOne(), MultivariatePolynomial::multiply);
                    assert (ppPartLC.isConstant());
                    assert (realLC.isConstant());
                    MultivariatePolynomial<BigInteger> base = ppPart.clone();
                    BigInteger baseDivide = BigInteger.ONE;
                    if (!((BigInteger)realLC.cc()).equals(ppPartLC.cc())) {
                        BigInteger lcm = Rings.Z.lcm((BigInteger)realLC.cc(), (BigInteger)ppPartLC.cc());
                        BigInteger factorCorrection = lcm.divideExact((BigInteger)realLC.cc());
                        BigInteger baseCorrection = lcm.divideExact((BigInteger)ppPartLC.cc());
                        base = base.multiply(baseCorrection);
                        baseDivide = baseDivide.multiply(factorCorrection);
                    }
                    if (!baseDivide.isOne()) {
                        MultivariateFactorization.adjustConstants(baseDivide, base, ilcFactorsSqFree, null);
                    }
                    if (ilcFactorsSqFree.length == 1) {
                        ilcFactorsSqFree[0].set(base);
                    } else {
                        AMultivariatePolynomial[] ilcFactorsSqFreeZp = (MultivariatePolynomial[])Arrays.stream(ilcFactorsSqFree).map(f -> f.setRing(zpDomain)).toArray(MultivariatePolynomial[]::new);
                        HenselLifting.multivariateLiftAutomaticLC(base.setRing(zpDomain), (AMultivariatePolynomial[])ilcFactorsSqFreeZp, ((HenselLifting.Evaluation)ilcEvaluation).setRing(zpDomain));
                        for (int j = 0; j < ilcFactorsSqFreeZp.length; ++j) {
                            ilcFactorsSqFree[j].set(MultivariatePolynomial.asPolyZSymmetric((MultivariatePolynomial<BigInteger>)ilcFactorsSqFreeZp[j]).primitivePart());
                        }
                    }
                    for (int jFactor = 0; jFactor < lcFactors.length; ++jFactor) {
                        MultivariatePolynomial obtainedLcFactor = (MultivariatePolynomial)AMultivariatePolynomial.renameVariables((MultivariatePolynomial)ilcFactors[jFactor].multiply(), lcSplit.ppOrdered.variablesMapping).insertVariable(0);
                        MultivariatePolynomial<BigInteger> commonPart = MultivariateGCD.PolynomialGCD(obtainedLcFactor, lcFactors[jFactor]);
                        IPolynomial addon = MultivariateDivision.divideExact(obtainedLcFactor, commonPart);
                        addon = addon.primitivePart();
                        lcFactors[jFactor] = lcFactors[jFactor].multiply((MultivariatePolynomial<BigInteger>)addon);
                        lcRest = MultivariateDivision.divideExact(lcRest, addon);
                    }
                }
                assert (lcRest.isConstant());
                for (i = 0; i < lcFactors.length; ++i) {
                    BigInteger lcTrue;
                    assert (evaluation.evaluateFrom((MultivariatePolynomial)biFactorsArrayMainZ[i].lc(0), 1).isConstant());
                    assert (evaluation.evaluateFrom(lcFactors[i], 1).isConstant());
                    BigInteger lcInMain = (BigInteger)evaluation.evaluateFrom((MultivariatePolynomial)biFactorsArrayMainZ[i].lc(0), 1).cc();
                    if (lcInMain.equals(lcTrue = evaluation.evaluateFrom(lcFactors[i], 1).cc())) continue;
                    BigInteger lcm = Rings.Z.lcm(lcInMain, lcTrue);
                    BigInteger factorCorrection = lcm.divideExact(lcInMain);
                    BigInteger lcCorrection = lcm.divideExact(lcTrue);
                    biFactorsArrayMainZ[i].multiply(factorCorrection);
                    lcFactors[i].multiply(lcCorrection);
                    lcRest = lcRest.divideOrNull(lcCorrection);
                    assert (lcRest != null);
                }
                MultivariatePolynomial<BigInteger> base = poly.clone();
                if (!lcRest.isOne()) {
                    MultivariateFactorization.adjustConstants((BigInteger)lcRest.cc(), base, biFactorsArrayMainZ, lcFactors);
                }
                base = base.setRing(zpDomain);
                biFactorsArrayMainZ = MultivariateFactorization.liftZ(base, zpDomain, evaluationZp, biFactorsArrayMainZ, lcFactors);
            } else {
                MultivariatePolynomial<BigInteger> base = poly.setRing(zpDomain);
                if (!((MultivariatePolynomial)biFactorsMain.unit).isOne()) {
                    BigInteger correction = (BigInteger)((MultivariatePolynomial)biFactorsMain.unit).lc();
                    base.multiply(zpDomain.pow(correction, biFactorsMain.size() - 1));
                    for (MultivariatePolynomial f2 : biFactorsMain.factors) {
                        f2.multiply(correction);
                    }
                }
                biFactorsArrayMainZ = MultivariateFactorization.liftZ(base, zpDomain, evaluationZp, biFactorsMain.factors.toArray(base.createArray(biFactorsMain.size())), null);
            }
            factorization = PolynomialFactorDecomposition.of(Arrays.asList(biFactorsArrayMainZ)).primitive();
            if (factorization.signum() != poly.signumOfLC()) {
                factorization = factorization.addUnit((MultivariatePolynomial)((AMultivariatePolynomial)poly.createOne()).negate());
            }
            MultivariatePolynomial lcNumeric = (MultivariatePolynomial)factorization.factors.stream().reduce(((MultivariatePolynomial)factorization.unit).clone(), (a, b) -> ((MultivariatePolynomial)a.lcAsPoly()).multiply(b.lcAsPoly()));
            MultivariatePolynomial ccNumeric = (MultivariatePolynomial)factorization.factors.stream().reduce(((MultivariatePolynomial)factorization.unit).clone(), (a, b) -> ((MultivariatePolynomial)a.ccAsPoly()).multiply(b.ccAsPoly()));
            if (lcNumeric.equals(poly.lcAsPoly()) && ccNumeric.equals(poly.ccAsPoly()) && ((MultivariatePolynomial)factorization.multiply()).equals(poly)) break;
            nBivariateFactors = factorization.size() - 1;
        }
        return factorization.primitive();
    }

    private static MultivariatePolynomial<BigInteger>[] liftZ(MultivariatePolynomial<BigInteger> base, IntegersZp zpDomain, HenselLifting.Evaluation<BigInteger> evaluationZp, MultivariatePolynomial<BigInteger>[] biFactorsArrayMainZ, MultivariatePolynomial<BigInteger>[] lcFactors) {
        biFactorsArrayMainZ = (MultivariatePolynomial[])Arrays.stream(biFactorsArrayMainZ).map(f -> f.setRing(zpDomain)).toArray(base::createArray);
        if (lcFactors != null) {
            lcFactors = (MultivariatePolynomial[])Arrays.stream(lcFactors).map(f -> f.setRing(zpDomain)).toArray(base::createArray);
        }
        HenselLifting.multivariateLift0(base, (AMultivariatePolynomial[])biFactorsArrayMainZ, (AMultivariatePolynomial[])lcFactors, evaluationZp, (int[])base.degrees(), (int)2);
        for (int i = 0; i < biFactorsArrayMainZ.length; ++i) {
            biFactorsArrayMainZ[i] = MultivariatePolynomial.asPolyZSymmetric(biFactorsArrayMainZ[i]).primitivePart();
        }
        return biFactorsArrayMainZ;
    }

    private static void adjustConstants(BigInteger constant, MultivariatePolynomial<BigInteger> base, MultivariatePolynomial<BigInteger>[] factors, MultivariatePolynomial<BigInteger>[] lcs) {
        base.multiply(Rings.Z.pow(constant, factors.length - 1));
        for (MultivariatePolynomial<BigInteger> factor : factors) {
            factor.multiply(constant);
        }
        if (lcs != null) {
            for (MultivariatePolynomial<BigInteger> factor : lcs) {
                factor.multiply(constant);
            }
        }
    }

    static PolynomialFactorDecomposition<MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>>> factorPrimitiveInNumberField(MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> poly) {
        AlgebraicNumberField numberField = (AlgebraicNumberField)poly.ring;
        int[] variables = ArraysUtil.sequence(0, poly.nVariables);
        ArraysUtil.quickSort(poly.degrees(), variables);
        int s = 0;
        while (true) {
            for (int variable : variables) {
                MultivariatePolynomial<IPolynomial<UnivariatePolynomial<BigInteger>>> sPoly;
                MultivariatePolynomial<IPolynomial> backSubstitution;
                if (poly.degree(variable) == 0) continue;
                if (s == 0) {
                    backSubstitution = null;
                    sPoly = poly;
                } else {
                    sPoly = poly.composition(variable, ((MultivariatePolynomial)poly.createMonomial(variable, 1)).subtract(((UnivariatePolynomial)numberField.generator()).multiply(s)));
                    backSubstitution = ((MultivariatePolynomial)poly.createMonomial(variable, 1)).add(((UnivariatePolynomial)numberField.generator()).multiply(s));
                }
                MultivariatePolynomial sPolyNorm = (MultivariatePolynomial)numberField.normOfPolynomial(sPoly);
                if (!MultivariateSquareFreeFactorization.isSquareFree(sPolyNorm)) continue;
                PolynomialFactorDecomposition<MultivariatePolynomial> normFactors = MultivariateFactorization.Factor(sPolyNorm);
                if (normFactors.isTrivial()) {
                    return PolynomialFactorDecomposition.of(poly);
                }
                PolynomialFactorDecomposition<MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>>> result = PolynomialFactorDecomposition.empty(poly);
                for (int i = 0; i < normFactors.size(); ++i) {
                    assert (normFactors.getExponent(i) == 1);
                    MultivariatePolynomial<IPolynomial<UnivariatePolynomial<BigInteger>>> factor = MultivariateGCD.PolynomialGCD(sPoly, MultivariateFactorization.toNumberField(numberField, (MultivariatePolynomial)normFactors.get(i)));
                    if (backSubstitution != null) {
                        factor = factor.composition(variable, backSubstitution);
                    }
                    result.addFactor(factor, 1);
                }
                if (result.isTrivial()) {
                    return PolynomialFactorDecomposition.of(poly);
                }
                return result.setLcFrom(poly);
            }
            ++s;
        }
    }

    private static MultivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> toNumberField(AlgebraicNumberField<UnivariatePolynomial<Rational<BigInteger>>> numberField, MultivariatePolynomial<Rational<BigInteger>> poly) {
        return poly.mapCoefficients(numberField, cf -> UnivariatePolynomial.constant(Rings.Q, cf));
    }

    private static /* synthetic */ UnivariatePolynomial lambda$factorPrimitiveInZ0$32(HenselLifting.Evaluation iEvaluation, MultivariatePolynomial p) {
        return iEvaluation.evaluateFrom(p, 1).asUnivariate();
    }

    private static /* synthetic */ MultivariatePolynomial lambda$factorPrimitiveInZ0$31(IntegersZp moduloDomain, MultivariatePolynomial f) {
        return f.setRing(moduloDomain);
    }

    private static /* synthetic */ UnivariatePolynomial lambda$bivariateDenseFactorSquareFreeInZ$17(IntegersZp zpDomain, UnivariatePolynomial f) {
        return f.setRing(zpDomain);
    }

    private static /* synthetic */ UnivariatePolynomial lambda$bivariateDenseFactorSquareFreeInZ$16(IntegersZp moduloDomain, UnivariatePolynomial f) {
        return f.setRing(moduloDomain);
    }

    static final class EvaluationLoopZ
    implements IEvaluationLoop<Monomial<BigInteger>, MultivariatePolynomial<BigInteger>> {
        final MultivariatePolynomial<BigInteger> factory;
        final RandomGenerator rnd = PrivateRandom.getRandom();
        final HashSet<ArrayRef<BigInteger>> tried = new HashSet();
        private int counter = 0;

        EvaluationLoopZ(MultivariatePolynomial<BigInteger> factory) {
            this.factory = factory;
        }

        public HenselLifting.Evaluation<BigInteger> next() {
            BigInteger[] point = (BigInteger[])this.factory.ring.createArray(this.factory.nVariables - 1);
            ArrayRef<BigInteger> array = new ArrayRef<BigInteger>(point);
            int tries = 0;
            do {
                if (tries > 32) {
                    this.counter += 5;
                    return this.next();
                }
                for (int i = 0; i < point.length; ++i) {
                    point[i] = BigInteger.valueOf(this.rnd.nextInt(10 * (this.counter / 5 + 1)));
                }
                ++tries;
            } while (this.tried.contains(array));
            this.tried.add(array);
            ++this.counter;
            return new HenselLifting.Evaluation<BigInteger>(this.factory.nVariables, point, this.factory.ring, this.factory.ordering);
        }
    }

    private static final class FactorRef<Poly extends IPolynomial<Poly>> {
        final List<PolynomialFactorDecomposition<Poly>> decompositions = new ArrayList<PolynomialFactorDecomposition<Poly>>();
        final TIntArrayList indexes = new TIntArrayList();

        FactorRef() {
        }

        FactorRef(PolynomialFactorDecomposition<Poly> decomposition, int index) {
            this.decompositions.add(decomposition);
            this.indexes.add(index);
        }

        Poly factor() {
            return (Poly)((IPolynomial)this.decompositions.get(0).get(this.indexes.get(0)));
        }

        TIntArrayList update(Poly reduced, Poly gcd) {
            TIntArrayList gcdIndexes = new TIntArrayList(this.indexes.size());
            for (int i = 0; i < this.decompositions.size(); ++i) {
                PolynomialFactorDecomposition<Poly> decomposition = this.decompositions.get(i);
                decomposition.factors.set(this.indexes.get(i), reduced);
                gcdIndexes.add(decomposition.size());
                decomposition.addFactor(gcd, decomposition.getExponent(this.indexes.get(i)));
            }
            return gcdIndexes;
        }
    }

    private static class ArrayRef<T> {
        final T[] data;

        ArrayRef(T[] data) {
            this.data = data;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass() && Arrays.equals(this.data, ((ArrayRef)o).data);
        }

        public int hashCode() {
            return Arrays.hashCode(this.data);
        }
    }

    static final class EvaluationLoop<E>
    implements IEvaluationLoop<Monomial<E>, MultivariatePolynomial<E>> {
        final MultivariatePolynomial<E> factory;
        final RandomGenerator rnd = PrivateRandom.getRandom();
        final HashSet<ArrayRef<E>> tried = new HashSet();

        EvaluationLoop(MultivariatePolynomial<E> factory) {
            this.factory = factory;
        }

        public HenselLifting.Evaluation<E> next() {
            int[] point = this.factory.ring.createArray(this.factory.nVariables - 1);
            ArrayRef<int> array = new ArrayRef<int>(point);
            int tries = 0;
            do {
                if (tries > 32) {
                    return null;
                }
                for (int i = 0; i < point.length; ++i) {
                    point[i] = (int)this.factory.ring.randomElement(this.rnd);
                }
                ++tries;
            } while (this.tried.contains(array));
            this.tried.add(array);
            return new HenselLifting.Evaluation<int>(this.factory.nVariables, point, this.factory.ring, this.factory.ordering);
        }
    }

    static final class lEvaluationLoop
    implements IEvaluationLoop<MonomialZp64, MultivariatePolynomialZp64> {
        final MultivariatePolynomialZp64 factory;
        final RandomGenerator rnd = PrivateRandom.getRandom();
        final TreeSet<long[]> tried = new TreeSet<long[]>(ArraysUtil.COMPARATOR_LONG);

        lEvaluationLoop(MultivariatePolynomialZp64 factory) {
            this.factory = factory;
        }

        public HenselLifting.lEvaluation next() {
            long[] point = new long[this.factory.nVariables - 1];
            int tries = 0;
            do {
                if (tries > 32) {
                    return null;
                }
                for (int i = 0; i < point.length; ++i) {
                    point[i] = this.factory.ring.randomElement(this.rnd);
                }
                ++tries;
            } while (this.tried.contains(point));
            this.tried.add(point);
            return new HenselLifting.lEvaluation(this.factory.nVariables, point, this.factory.ring, this.factory.ordering);
        }
    }

    static interface IEvaluationLoop<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> {
        public HenselLifting.IEvaluation<Term, Poly> next();
    }

    static final class SplitContent<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> {
        final int variable;
        final Poly content;
        final Poly primitivePart;
        final OrderByDegrees<Term, Poly> ppOrdered;

        SplitContent(int variable, Poly content, Poly primitivePart) {
            this.variable = variable;
            this.content = content;
            this.primitivePart = primitivePart;
            this.ppOrdered = MultivariateFactorization.orderByDegrees(primitivePart, false, variable);
            assert (!MultivariateFactorization.containsPPower(primitivePart, variable));
        }
    }

    static final class LeadingCoefficientData<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> {
        final Poly lc;
        final PolynomialFactorDecomposition<Poly> lcSqFreeDecomposition;
        final Poly lcSqFreePart;
        final SplitContent<Term, Poly>[] lcSplits;
        final boolean fullyReconstructable;

        LeadingCoefficientData(Poly lc) {
            lc = ((AMultivariatePolynomial)lc).dropVariable(0);
            this.lc = lc;
            this.lcSqFreeDecomposition = MultivariateSquareFreeFactorization.SquareFreeFactorization(lc);
            this.lcSqFreePart = (AMultivariatePolynomial)this.lcSqFreeDecomposition.squareFreePart();
            ArrayList splits = new ArrayList();
            Poly content = this.lcSqFreePart;
            block0: while (!content.isConstant()) {
                int[] cDegrees = ((AMultivariatePolynomial)content).degrees();
                int[] variables = ArraysUtil.sequence(0, cDegrees.length);
                ArraysUtil.insertionSort(ArraysUtil.negate(cDegrees), variables);
                for (int iMax = 0; iMax < variables.length; ++iMax) {
                    int maxDegreeVariable = variables[iMax];
                    if (cDegrees[iMax] == 0) break block0;
                    Object pContent = ((AMultivariatePolynomial)this.lcSqFreePart).contentExcept(maxDegreeVariable);
                    Poly primitivePart = MultivariateDivision.divideExact(this.lcSqFreePart, pContent);
                    if (MultivariateFactorization.containsPPower(primitivePart, maxDegreeVariable)) continue;
                    splits.add(new SplitContent(maxDegreeVariable, pContent, primitivePart));
                    content = ((AMultivariatePolynomial)content).contentExcept(maxDegreeVariable);
                    continue block0;
                }
            }
            this.lcSplits = splits.toArray(new SplitContent[splits.size()]);
            this.fullyReconstructable = content.isConstant();
            assert (this.fullyReconstructable || lc.coefficientRingCharacteristic().shiftRight(16).signum() == 0);
        }
    }

    static final class OrderByDegrees<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> {
        final Poly ordered;
        final int[] degreeBounds;
        final int[] variablesSorted;
        final int[] variablesMapping;
        final int nVariables;

        OrderByDegrees(Poly ordered, int[] degreeBounds, int[] variablesSorted, int nVariables) {
            this.ordered = ordered;
            this.degreeBounds = degreeBounds;
            this.variablesSorted = variablesSorted;
            this.variablesMapping = MultivariateGCD.inversePermutation(variablesSorted);
            this.nVariables = nVariables;
        }

        Poly restoreOrder(Poly factor) {
            return AMultivariatePolynomial.renameVariables(((AMultivariatePolynomial)factor).setNVariables(this.nVariables), this.variablesMapping);
        }

        Poly order(Poly factor) {
            return AMultivariatePolynomial.renameVariables(factor, this.variablesSorted);
        }
    }

    private static final class PolarAngleComparator
    implements Comparator<int[]> {
        private final int[] basePoint;

        PolarAngleComparator(int[] basePoint) {
            this.basePoint = basePoint;
        }

        @Override
        public int compare(int[] p1, int[] p2) {
            double cos1;
            if (Arrays.equals(p1, p2)) {
                return 0;
            }
            int p1x = p1[0] - this.basePoint[0];
            int p2x = p2[0] - this.basePoint[0];
            int p1y = p1[1] - this.basePoint[1];
            int p2y = p2[1] - this.basePoint[1];
            double d1 = Math.sqrt(p1x * p1x + p1y * p1y);
            double d2 = Math.sqrt(p2x * p2x + p2y * p2y);
            double cos2 = (double)p2x / d2;
            int c = Double.compare(cos2, cos1 = (double)p1x / d1);
            if (c != 0) {
                return c;
            }
            return Double.compare(d1, d2);
        }
    }

    private static interface FactorizationAlgorithm<Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> {
        public PolynomialFactorDecomposition<Poly> factor(Poly var1, boolean var2);
    }
}

