/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.multivar;

import cc.redberry.rings.IntegersZp;
import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.io.Coder;
import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.IPolynomialRing;
import cc.redberry.rings.poly.MachineArithmetic;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.PolynomialMethods;
import cc.redberry.rings.poly.UnivariateRing;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.IMonomialAlgebra;
import cc.redberry.rings.poly.multivar.Monomial;
import cc.redberry.rings.poly.multivar.MonomialOrder;
import cc.redberry.rings.poly.multivar.MonomialSet;
import cc.redberry.rings.poly.multivar.MonomialZp64;
import cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.util.ArraysUtil;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.math3.random.RandomGenerator;

public final class MultivariatePolynomial<E>
extends AMultivariatePolynomial<Monomial<E>, MultivariatePolynomial<E>> {
    private static final long serialVersionUID = 1L;
    public final Ring<E> ring;

    MultivariatePolynomial(int nVariables, Ring<E> ring, Comparator<DegreeVector> ordering, MonomialSet<Monomial<E>> terms) {
        super(nVariables, ordering, new IMonomialAlgebra.MonomialAlgebra<E>(ring), terms);
        this.ring = ring;
    }

    static <E> void add(Map<DegreeVector, Monomial<E>> polynomial, Monomial<E> term, Ring<E> ring) {
        if (ring.isZero(term.coefficient)) {
            return;
        }
        polynomial.merge(term, term, (o, n) -> {
            Object r = ring.add(o.coefficient, n.coefficient);
            if (ring.isZero(r)) {
                return null;
            }
            return o.setCoefficient(r);
        });
    }

    static <E> void subtract(Map<DegreeVector, Monomial<E>> polynomial, Monomial<E> term, Ring<E> ring) {
        MultivariatePolynomial.add(polynomial, term.setCoefficient(ring.negate(term.coefficient)), ring);
    }

    public static <E> MultivariatePolynomial<E> create(int nVariables, Ring<E> ring, Comparator<DegreeVector> ordering, Iterable<Monomial<E>> terms) {
        MonomialSet<Monomial<E>> map = new MonomialSet<Monomial<E>>(ordering);
        for (Monomial<E> term : terms) {
            MultivariatePolynomial.add(map, term.setCoefficient(ring.valueOf(term.coefficient)), ring);
        }
        return new MultivariatePolynomial<E>(nVariables, ring, ordering, map);
    }

    public static <E> MultivariatePolynomial<E> create(int nVariables, Ring<E> ring, Comparator<DegreeVector> ordering, Monomial<E> ... terms) {
        return MultivariatePolynomial.create(nVariables, ring, ordering, Arrays.asList(terms));
    }

    public static <E> MultivariatePolynomial<E> zero(int nVariables, Ring<E> ring, Comparator<DegreeVector> ordering) {
        return new MultivariatePolynomial<E>(nVariables, ring, ordering, new MonomialSet<Monomial<E>>(ordering));
    }

    public static <E> MultivariatePolynomial<E> one(int nVariables, Ring<E> ring, Comparator<DegreeVector> ordering) {
        return MultivariatePolynomial.create(nVariables, ring, ordering, new Monomial<E>(nVariables, ring.getOne()));
    }

    public static MultivariatePolynomial<BigInteger> parse(String string, String ... variables) {
        return MultivariatePolynomial.parse(string, Rings.Z, variables);
    }

    @Deprecated
    public static MultivariatePolynomial<BigInteger> parse(String string) {
        return MultivariatePolynomial.parse(string, MultivariatePolynomial.guessVariableStrings(string));
    }

    public static <E> MultivariatePolynomial<E> parse(String string, Ring<E> ring, String ... variables) {
        return MultivariatePolynomial.parse(string, ring, MonomialOrder.DEFAULT, variables);
    }

    @Deprecated
    public static <E> MultivariatePolynomial<E> parse(String string, Ring<E> ring) {
        return MultivariatePolynomial.parse(string, ring, MultivariatePolynomial.guessVariableStrings(string));
    }

    public static MultivariatePolynomial<BigInteger> parse(String string, Comparator<DegreeVector> ordering, String ... variables) {
        return MultivariatePolynomial.parse(string, Rings.Z, ordering, variables);
    }

    @Deprecated
    public static MultivariatePolynomial<BigInteger> parse(String string, Comparator<DegreeVector> ordering) {
        return MultivariatePolynomial.parse(string, Rings.Z, ordering, MultivariatePolynomial.guessVariableStrings(string));
    }

    public static <E> MultivariatePolynomial<E> parse(String string, Ring<E> ring, Comparator<DegreeVector> ordering, String ... variables) {
        return Coder.mkMultivariateCoder(Rings.MultivariateRing(variables.length, ring, ordering), variables).parse(string);
    }

    @Deprecated
    public static <E> MultivariatePolynomial<E> parse(String string, Ring<E> ring, Comparator<DegreeVector> ordering) {
        return MultivariatePolynomial.parse(string, ring, ordering, MultivariatePolynomial.guessVariableStrings(string));
    }

    private static String[] guessVariableStrings(String string) {
        Matcher matcher = Pattern.compile("[a-zA-Z]+[0-9]*").matcher(string);
        ArrayList<String> variables = new ArrayList<String>();
        HashSet<String> seen = new HashSet<String>();
        while (matcher.find()) {
            String var = matcher.group();
            if (seen.contains(var)) continue;
            seen.add(var);
            variables.add(var);
        }
        variables.sort(String::compareTo);
        return variables.toArray(new String[variables.size()]);
    }

    public static MultivariatePolynomialZp64 asOverZp64(MultivariatePolynomial<BigInteger> poly) {
        if (!(poly.ring instanceof IntegersZp)) {
            throw new IllegalArgumentException("Poly is not over modular ring: " + poly.ring);
        }
        IntegersZp ring = (IntegersZp)poly.ring;
        MonomialSet<MonomialZp64> terms = new MonomialSet<MonomialZp64>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)poly.ordering));
        for (Monomial term : poly.terms) {
            terms.add(new MonomialZp64(term.exponents, term.totalDegree, ((BigInteger)term.coefficient).longValueExact()));
        }
        return MultivariatePolynomialZp64.create(poly.nVariables, ring.asMachineRing(), (Comparator<DegreeVector>)poly.ordering, terms);
    }

    public static MultivariatePolynomialZp64 asOverZp64(MultivariatePolynomial<BigInteger> poly, IntegersZp64 ring) {
        MonomialSet<MonomialZp64> terms = new MonomialSet<MonomialZp64>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)poly.ordering));
        BigInteger modulus = BigInteger.valueOf(ring.modulus);
        for (Monomial term : poly.terms) {
            terms.add(new MonomialZp64(term.exponents, term.totalDegree, ((BigInteger)term.coefficient).mod(modulus).longValueExact()));
        }
        return MultivariatePolynomialZp64.create(poly.nVariables, ring, (Comparator<DegreeVector>)poly.ordering, terms);
    }

    public static <E> MultivariatePolynomial<E> asMultivariate(UnivariatePolynomial<E> poly, int nVariables, int variable, Comparator<DegreeVector> ordering) {
        MonomialSet<Monomial<E>> map = new MonomialSet<Monomial<E>>(ordering);
        for (int i = poly.degree(); i >= 0; --i) {
            if (poly.isZeroAt(i)) continue;
            int[] degreeVector = new int[nVariables];
            degreeVector[variable] = i;
            map.add(new Monomial<E>(degreeVector, i, poly.get(i)));
        }
        return new MultivariatePolynomial(nVariables, poly.ring, ordering, map);
    }

    @Override
    public UnivariatePolynomial<E> asUnivariate() {
        if (this.isConstant()) {
            return UnivariatePolynomial.constant(this.ring, this.lc());
        }
        int[] degrees = this.degreesRef();
        int theVar = -1;
        for (int i = 0; i < degrees.length; ++i) {
            if (degrees[i] == 0) continue;
            if (theVar != -1) {
                throw new IllegalArgumentException("not a univariate polynomial: " + this);
            }
            theVar = i;
        }
        if (theVar == -1) {
            throw new IllegalStateException("Not a univariate polynomial: " + this);
        }
        E[] univarData = this.ring.createZeroesArray(degrees[theVar] + 1);
        for (Monomial e : this.terms) {
            univarData[e.exponents[theVar]] = e.coefficient;
        }
        return UnivariatePolynomial.createUnsafe(this.ring, univarData);
    }

    @Override
    public MultivariatePolynomial<UnivariatePolynomial<E>> asOverUnivariate(int variable) {
        UnivariatePolynomial factory = UnivariatePolynomial.zero(this.ring);
        UnivariateRing<UnivariatePolynomial<E>> pDomain = new UnivariateRing<UnivariatePolynomial<E>>(factory);
        MonomialSet<Monomial<E>> newData = new MonomialSet<Monomial<E>>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (Monomial e : this.terms) {
            MultivariatePolynomial.add(newData, new Monomial<UnivariatePolynomial<E>>(e.dvSetZero(variable), factory.createMonomial(e.coefficient, e.exponents[variable])), pDomain);
        }
        return new MultivariatePolynomial<UnivariatePolynomial<E>>(this.nVariables - 1, pDomain, this.ordering, newData);
    }

    @Override
    public MultivariatePolynomial<UnivariatePolynomial<E>> asOverUnivariateEliminate(int variable) {
        UnivariatePolynomial factory = UnivariatePolynomial.zero(this.ring);
        UnivariateRing<UnivariatePolynomial<E>> pDomain = new UnivariateRing<UnivariatePolynomial<E>>(factory);
        MonomialSet<Monomial<E>> newData = new MonomialSet<Monomial<E>>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (Monomial e : this.terms) {
            MultivariatePolynomial.add(newData, new Monomial<UnivariatePolynomial<E>>(e.dvWithout(variable), factory.createMonomial(e.coefficient, e.exponents[variable])), pDomain);
        }
        return new MultivariatePolynomial<UnivariatePolynomial<E>>(this.nVariables - 1, pDomain, this.ordering, newData);
    }

    @Override
    public MultivariatePolynomial<MultivariatePolynomial<E>> asOverMultivariate(int ... variables) {
        MultivariateRing<MultivariatePolynomial> ring = new MultivariateRing<MultivariatePolynomial>(this);
        MonomialSet<Monomial<E>> terms = new MonomialSet<Monomial<E>>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (Monomial term : this) {
            int[] coeffExponents = new int[this.nVariables];
            for (int var : variables) {
                coeffExponents[var] = term.exponents[var];
            }
            Monomial<MultivariatePolynomial> newTerm = new Monomial<MultivariatePolynomial>(term.dvSetZero(variables), (MultivariatePolynomial)this.create(new Monomial(coeffExponents, ArraysUtil.sum(coeffExponents), term.coefficient)));
            MultivariatePolynomial.add(terms, newTerm, ring);
        }
        return new MultivariatePolynomial<MultivariatePolynomial<E>>(this.nVariables, ring, this.ordering, terms);
    }

    @Override
    public MultivariatePolynomial<MultivariatePolynomial<E>> asOverMultivariateEliminate(int[] variables, Comparator<DegreeVector> ordering) {
        variables = (int[])variables.clone();
        Arrays.sort(variables);
        int[] restVariables = ArraysUtil.intSetDifference(ArraysUtil.sequence(this.nVariables), variables);
        MultivariateRing<MultivariatePolynomial> ring = new MultivariateRing<MultivariatePolynomial>((MultivariatePolynomial)this.create(variables.length, new MonomialSet((Comparator<? super DegreeVector>)ordering)));
        MonomialSet<Monomial<E>> terms = new MonomialSet<Monomial<E>>(ordering);
        for (Monomial term : this) {
            int i = 0;
            int[] coeffExponents = new int[variables.length];
            for (int var : variables) {
                coeffExponents[i++] = term.exponents[var];
            }
            i = 0;
            int[] termExponents = new int[restVariables.length];
            for (int var : restVariables) {
                termExponents[i++] = term.exponents[var];
            }
            Monomial<MultivariatePolynomial<E>> newTerm = new Monomial<MultivariatePolynomial<E>>(termExponents, MultivariatePolynomial.create(variables.length, this.ring, (Comparator<DegreeVector>)this.ordering, new Monomial(coeffExponents, term.coefficient)));
            MultivariatePolynomial.add(terms, newTerm, ring);
        }
        return new MultivariatePolynomial<MultivariatePolynomial<E>>(restVariables.length, ring, ordering, terms);
    }

    public static <E> MultivariatePolynomial<E> asNormalMultivariate(MultivariatePolynomial<UnivariatePolynomial<E>> poly, int variable) {
        Ring ring = ((UnivariatePolynomial)poly.ring.getZero()).ring;
        int nVariables = poly.nVariables + 1;
        MultivariatePolynomial result = MultivariatePolynomial.zero(nVariables, ring, poly.ordering);
        for (Monomial entry : poly.terms) {
            UnivariatePolynomial uPoly = (UnivariatePolynomial)entry.coefficient;
            DegreeVector dv = entry.dvInsert(variable);
            for (int i = 0; i <= uPoly.degree(); ++i) {
                if (uPoly.isZeroAt(i)) continue;
                result.add(new Monomial(dv.dvSet(variable, i), uPoly.get(i)));
            }
        }
        return result;
    }

    public static <E> MultivariatePolynomial<E> asNormalMultivariate(MultivariatePolynomial<MultivariatePolynomial<E>> poly) {
        Ring<E> ring = ((MultivariatePolynomial)poly.ring.getZero()).ring;
        int nVariables = poly.nVariables;
        MultivariatePolynomial<E> result = MultivariatePolynomial.zero(nVariables, ring, poly.ordering);
        for (Monomial term : poly.terms) {
            MultivariatePolynomial uPoly = (MultivariatePolynomial)term.coefficient;
            result.add(((MultivariatePolynomial)uPoly.clone()).multiply(new Monomial<E>(term.exponents, term.totalDegree, ring.getOne())));
        }
        return result;
    }

    public static <E> MultivariatePolynomial<E> asNormalMultivariate(MultivariatePolynomial<MultivariatePolynomial<E>> poly, int[] coefficientVariables, int[] mainVariables) {
        Ring<E> ring = ((MultivariatePolynomial)poly.ring.getZero()).ring;
        int nVariables = coefficientVariables.length + mainVariables.length;
        MultivariatePolynomial<E> result = MultivariatePolynomial.zero(nVariables, ring, poly.ordering);
        for (Monomial term : poly.terms) {
            MultivariatePolynomial coefficient = (MultivariatePolynomial)((MultivariatePolynomial)term.coefficient).joinNewVariables(nVariables, coefficientVariables);
            Monomial t = (Monomial)term.joinNewVariables(nVariables, mainVariables);
            result.add(coefficient.multiply(new Monomial<E>(t.exponents, t.totalDegree, ring.getOne())));
        }
        return result;
    }

    public static MultivariatePolynomial<BigInteger> asPolyZ(MultivariatePolynomial<BigInteger> poly, boolean copy) {
        return new MultivariatePolynomial<BigInteger>(poly.nVariables, Rings.Z, poly.ordering, (MonomialSet<Monomial<BigInteger>>)(copy ? poly.terms.clone() : poly.terms));
    }

    public static MultivariatePolynomial<BigInteger> asPolyZSymmetric(MultivariatePolynomial<BigInteger> poly) {
        if (!(poly.ring instanceof IntegersZp)) {
            throw new IllegalArgumentException("Not a modular ring: " + poly.ring);
        }
        IntegersZp ring = (IntegersZp)poly.ring;
        MonomialSet newTerms = new MonomialSet((Comparator<? super DegreeVector>)((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)poly.ordering)));
        for (Monomial monomial : poly) {
            newTerms.add(monomial.setCoefficient(ring.symmetricForm((BigInteger)monomial.coefficient)));
        }
        return new MultivariatePolynomial<BigInteger>(poly.nVariables, Rings.Z, poly.ordering, newTerms);
    }

    @Override
    public MultivariatePolynomial<E> contentAsPoly() {
        return this.createConstant(this.content());
    }

    @Override
    public MultivariatePolynomial<E> lcAsPoly() {
        return this.createConstant(this.lc());
    }

    @Override
    public MultivariatePolynomial<E> lcAsPoly(Comparator<DegreeVector> ordering) {
        return this.createConstant(this.lc(ordering));
    }

    @Override
    public MultivariatePolynomial<E> ccAsPoly() {
        return this.createConstant(this.cc());
    }

    @Override
    MultivariatePolynomial<E> create(int nVariables, Comparator<DegreeVector> ordering, MonomialSet<Monomial<E>> monomialTerms) {
        return new MultivariatePolynomial<E>(nVariables, this.ring, ordering, monomialTerms);
    }

    @Override
    public boolean isOverField() {
        return this.ring.isField();
    }

    @Override
    public boolean isOverFiniteField() {
        return this.ring.isFiniteField();
    }

    @Override
    public boolean isOverZ() {
        return this.ring.equals(Rings.Z);
    }

    @Override
    public BigInteger coefficientRingCardinality() {
        return this.ring.cardinality();
    }

    @Override
    public BigInteger coefficientRingCharacteristic() {
        return this.ring.characteristic();
    }

    @Override
    public boolean isOverPerfectPower() {
        return this.ring.isPerfectPower();
    }

    @Override
    public BigInteger coefficientRingPerfectPowerBase() {
        return this.ring.perfectPowerBase();
    }

    @Override
    public BigInteger coefficientRingPerfectPowerExponent() {
        return this.ring.perfectPowerExponent();
    }

    public MultivariatePolynomial<E>[] createArray(int length) {
        return new MultivariatePolynomial[length];
    }

    public MultivariatePolynomial<E>[][] createArray2d(int length) {
        return new MultivariatePolynomial[length][];
    }

    public MultivariatePolynomial<E>[][] createArray2d(int length1, int length2) {
        return new MultivariatePolynomial[length1][length2];
    }

    @Override
    public boolean sameCoefficientRingWith(MultivariatePolynomial<E> oth) {
        return this.nVariables == oth.nVariables && this.ring.equals(oth.ring);
    }

    @Override
    public MultivariatePolynomial<E> setCoefficientRingFrom(MultivariatePolynomial<E> poly) {
        return this.setRing(poly.ring);
    }

    @Override
    protected void release() {
        super.release();
    }

    public MultivariatePolynomial<E> setRing(Ring<E> newRing) {
        if (this.ring == newRing) {
            return this.clone();
        }
        MonomialSet<Monomial<E>> newData = new MonomialSet<Monomial<E>>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (Monomial e : this.terms) {
            this.add(newData, e.setCoefficient(newRing.valueOf(e.coefficient)));
        }
        return new MultivariatePolynomial<E>(this.nVariables, newRing, this.ordering, newData);
    }

    public MultivariatePolynomial<E> setRingUnsafe(Ring<E> newRing) {
        return new MultivariatePolynomial<E>(this.nVariables, newRing, this.ordering, this.terms);
    }

    public MultivariatePolynomial<E> createConstant(E val) {
        MonomialSet<Monomial<E>> data = new MonomialSet<Monomial<E>>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        if (!this.ring.isZero(val)) {
            data.add(new Monomial<E>(this.nVariables, val));
        }
        return new MultivariatePolynomial<E>(this.nVariables, this.ring, this.ordering, data);
    }

    @Override
    public MultivariatePolynomial<E> createConstantFromTerm(Monomial<E> monomial) {
        return this.createConstant(monomial.coefficient);
    }

    @Override
    public MultivariatePolynomial<E> createZero() {
        return this.createConstant(this.ring.getZero());
    }

    @Override
    public MultivariatePolynomial<E> createOne() {
        return this.createConstant(this.ring.getOne());
    }

    public final MultivariatePolynomial<E> createLinear(int variable, E cc, E lc) {
        MonomialSet<Monomial<E>> data = new MonomialSet<Monomial<E>>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        if (!this.ring.isZero(cc)) {
            data.add(new Monomial<E>(this.nVariables, cc));
        }
        if (!this.ring.isZero(lc)) {
            int[] lcDegreeVector = new int[this.nVariables];
            lcDegreeVector[variable] = 1;
            data.add(new Monomial<E>(lcDegreeVector, 1, lc));
        }
        return new MultivariatePolynomial<E>(this.nVariables, this.ring, this.ordering, data);
    }

    @Override
    public boolean isMonic() {
        return this.ring.isOne(this.lc());
    }

    @Override
    public int signumOfLC() {
        return this.ring.signum(this.lc());
    }

    @Override
    public boolean isOne() {
        if (this.size() != 1) {
            return false;
        }
        Monomial lt = (Monomial)this.terms.first();
        return lt.isZeroVector() && this.ring.isOne(lt.coefficient);
    }

    @Override
    public boolean isUnitCC() {
        return this.ring.isOne(this.cc());
    }

    @Override
    public boolean isConstant() {
        return this.size() == 0 || this.size() == 1 && ((Monomial)this.terms.first()).isZeroVector();
    }

    public E maxAbsCoefficient() {
        return (E)this.stream().map(this.ring::abs).max(this.ring).orElseGet(this.ring::getZero);
    }

    public E lc() {
        return ((Monomial)this.lt()).coefficient;
    }

    public E lc(Comparator<DegreeVector> ordering) {
        return ((Monomial)this.lt(ordering)).coefficient;
    }

    public MultivariatePolynomial<E> setLC(E val) {
        if (this.isZero()) {
            return this.add(val);
        }
        this.terms.add(((Monomial)this.lt()).setCoefficient(this.ring.valueOf(val)));
        this.release();
        return this;
    }

    public E cc() {
        Monomial<E> zero = new Monomial<E>(this.nVariables, this.ring.getZero());
        return this.terms.getOrDefault(zero, zero).coefficient;
    }

    public E content() {
        return this.isOverField() ? this.lc() : this.ring.gcd(this.coefficients());
    }

    public Iterable<E> coefficients() {
        return () -> new It(this.terms.iterator());
    }

    public E[] coefficientsArray() {
        if (this.isZero()) {
            return this.ring.createZeroesArray(1);
        }
        int[] array = this.ring.createArray(this.size());
        int i = 0;
        for (Monomial term : this) {
            array[i++] = (int)term.coefficient;
        }
        return array;
    }

    @Override
    public MultivariatePolynomial<E> primitivePart(int variable) {
        return MultivariatePolynomial.asNormalMultivariate(this.asOverUnivariateEliminate(variable).primitivePart(), variable);
    }

    @Override
    public UnivariatePolynomial<E> contentUnivariate(int variable) {
        return this.asOverUnivariate(variable).content();
    }

    @Override
    public MultivariatePolynomial<E> primitivePart() {
        if (this.isZero()) {
            return this;
        }
        E content = this.content();
        if (this.signumOfLC() < 0 && this.ring.signum(content) > 0) {
            content = this.ring.negate(content);
        }
        MultivariatePolynomial<E> r = this.divideOrNull(content);
        assert (r != null);
        return r;
    }

    @Override
    public MultivariatePolynomial<E> primitivePartSameSign() {
        if (this.isZero()) {
            return this;
        }
        E c = this.content();
        if (this.signumOfLC() < 0) {
            c = this.ring.negate(c);
        }
        MultivariatePolynomial<E> r = this.divideOrNull(c);
        assert (r != null);
        return r;
    }

    @Override
    public MultivariatePolynomial<E> divideByLC(MultivariatePolynomial<E> other) {
        return this.divideOrNull(other.lc());
    }

    @Override
    public MultivariatePolynomial<E> divideOrNull(E factor) {
        if (this.ring.isOne(factor)) {
            return this;
        }
        if (this.ring.isMinusOne(factor)) {
            return (MultivariatePolynomial)this.negate();
        }
        if (this.ring.isField()) {
            return this.multiply(this.ring.reciprocal(factor));
        }
        for (Map.Entry entry : this.terms.entrySet()) {
            Monomial term = (Monomial)entry.getValue();
            E quot = this.ring.divideOrNull(term.coefficient, factor);
            if (quot == null) {
                return null;
            }
            entry.setValue(term.setCoefficient(quot));
        }
        this.release();
        return this;
    }

    public MultivariatePolynomial<E> divideExact(E factor) {
        MultivariatePolynomial<E> r = this.divideOrNull(factor);
        if (r == null) {
            throw new ArithmeticException("not divisible " + this + " / " + factor);
        }
        return r;
    }

    @Override
    public MultivariatePolynomial<E> divideOrNull(Monomial<E> monomial) {
        if (monomial.isZeroVector()) {
            return this.divideOrNull((E)monomial.coefficient);
        }
        MonomialSet<Monomial<E>> map = new MonomialSet<Monomial<E>>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (Monomial term : this.terms) {
            Monomial<E> dv = this.monomialAlgebra.divideOrNull(term, monomial);
            if (dv == null) {
                return null;
            }
            map.add(dv);
        }
        this.loadFrom(map);
        this.release();
        return this;
    }

    @Override
    public MultivariatePolynomial<E> monic() {
        if (this.isZero()) {
            return this;
        }
        return this.divideOrNull(this.lc());
    }

    @Override
    public MultivariatePolynomial<E> monic(Comparator<DegreeVector> ordering) {
        if (this.isZero()) {
            return this;
        }
        return this.divideOrNull(this.lc(ordering));
    }

    public MultivariatePolynomial<E> monic(E factor) {
        E lc = this.lc();
        return this.multiply(factor).divideOrNull(lc);
    }

    public MultivariatePolynomial<E> monic(Comparator<DegreeVector> ordering, E factor) {
        E lc = this.lc(ordering);
        return this.multiply(factor).divideOrNull(lc);
    }

    @Override
    public MultivariatePolynomial<E> monicWithLC(MultivariatePolynomial<E> other) {
        if (this.lc().equals(other.lc())) {
            return this;
        }
        return this.monic(other.lc());
    }

    @Override
    public MultivariatePolynomial<E> monicWithLC(Comparator<DegreeVector> ordering, MultivariatePolynomial<E> other) {
        E olc;
        E lc = this.lc(ordering);
        if (lc.equals(olc = other.lc(ordering))) {
            return this;
        }
        return this.monic(ordering, olc);
    }

    public UnivariatePolynomial toDenseRecursiveForm() {
        if (this.nVariables == 0) {
            throw new IllegalArgumentException("#variables = 0");
        }
        return this.toDenseRecursiveForm(this.nVariables - 1);
    }

    private UnivariatePolynomial toDenseRecursiveForm(int variable) {
        if (variable == 0) {
            return this.asUnivariate();
        }
        UnivariatePolynomial result = this.asUnivariateEliminate(variable);
        IUnivariatePolynomial[] data = new IUnivariatePolynomial[result.degree() + 1];
        for (int j = 0; j < data.length; ++j) {
            data[j] = ((MultivariatePolynomial)result.get(j)).toDenseRecursiveForm(variable - 1);
        }
        return UnivariatePolynomial.create(Rings.PolynomialRing(data[0]), data);
    }

    public static <E> MultivariatePolynomial<E> fromDenseRecursiveForm(UnivariatePolynomial recForm, int nVariables, Comparator<DegreeVector> ordering) {
        return MultivariatePolynomial.fromDenseRecursiveForm(recForm, nVariables, ordering, nVariables - 1);
    }

    private static <E> MultivariatePolynomial<E> fromDenseRecursiveForm(UnivariatePolynomial recForm, int nVariables, Comparator<DegreeVector> ordering, int variable) {
        if (variable == 0) {
            return MultivariatePolynomial.asMultivariate(recForm, nVariables, 0, ordering);
        }
        UnivariatePolynomial _recForm = recForm;
        MultivariatePolynomial[] data = new MultivariatePolynomial[_recForm.degree() + 1];
        for (int j = 0; j < data.length; ++j) {
            data[j] = MultivariatePolynomial.fromDenseRecursiveForm((UnivariatePolynomial)_recForm.get(j), nVariables, ordering, variable - 1);
        }
        return MultivariatePolynomial.asMultivariate(UnivariatePolynomial.create(Rings.MultivariateRing(data[0]), data), variable);
    }

    public static <E> E evaluateDenseRecursiveForm(UnivariatePolynomial recForm, int nVariables, E[] values) {
        UnivariatePolynomial p = recForm;
        for (int n = nVariables - 1; n > 0; --n) {
            p = (UnivariatePolynomial)p.cc();
        }
        if (nVariables != values.length) {
            throw new IllegalArgumentException();
        }
        return MultivariatePolynomial.evaluateDenseRecursiveForm(recForm, values, p.ring, nVariables - 1);
    }

    private static <E> E evaluateDenseRecursiveForm(UnivariatePolynomial recForm, E[] values, Ring<E> ring, int variable) {
        if (variable == 0) {
            return recForm.evaluate(values[0]);
        }
        UnivariatePolynomial _recForm = recForm;
        E result = ring.getZero();
        for (int i = _recForm.degree(); i >= 0; --i) {
            result = ring.add(ring.multiply(values[variable], result), MultivariatePolynomial.evaluateDenseRecursiveForm((UnivariatePolynomial)_recForm.get(i), values, ring, variable - 1));
        }
        return result;
    }

    public AMultivariatePolynomial toSparseRecursiveForm() {
        if (this.nVariables == 0) {
            throw new IllegalArgumentException("#variables = 0");
        }
        return this.toSparseRecursiveForm(this.nVariables - 1);
    }

    private AMultivariatePolynomial toSparseRecursiveForm(int variable) {
        if (variable == 0) {
            assert (MonomialOrder.isGradedOrder(this.ordering));
            return this.setNVariables(1);
        }
        MultivariatePolynomial<MultivariatePolynomial<E>> result = this.asOverMultivariateEliminate(ArraysUtil.sequence(0, variable), MonomialOrder.GRLEX);
        Monomial[] data = new Monomial[result.size() == 0 ? 1 : result.size()];
        int j = 0;
        for (Monomial monomial : result.size() == 0 ? Collections.singletonList((Monomial)result.lt()) : result) {
            data[j++] = new Monomial<AMultivariatePolynomial>(monomial, ((MultivariatePolynomial)monomial.coefficient).toSparseRecursiveForm(variable - 1));
        }
        return MultivariatePolynomial.create(1, Rings.MultivariateRing((AMultivariatePolynomial)data[0].coefficient), MonomialOrder.GRLEX, data);
    }

    public static <E> MultivariatePolynomial<E> fromSparseRecursiveForm(AMultivariatePolynomial recForm, int nVariables, Comparator<DegreeVector> ordering) {
        return MultivariatePolynomial.fromSparseRecursiveForm(recForm, nVariables, ordering, nVariables - 1);
    }

    private static <E> MultivariatePolynomial<E> fromSparseRecursiveForm(AMultivariatePolynomial recForm, int nVariables, Comparator<DegreeVector> ordering, int variable) {
        if (variable == 0) {
            assert (recForm.nVariables == 1);
            return (MultivariatePolynomial)((MultivariatePolynomial)((MultivariatePolynomial)recForm).setNVariables(nVariables)).setOrdering(ordering);
        }
        MultivariatePolynomial _recForm = (MultivariatePolynomial)recForm;
        Monomial[] data = new Monomial[_recForm.size() == 0 ? 1 : _recForm.size()];
        int j = 0;
        for (Monomial monomial : _recForm.size() == 0 ? Collections.singletonList((Monomial)_recForm.lt()) : _recForm) {
            int[] exponents = new int[nVariables];
            exponents[variable] = monomial.totalDegree;
            data[j++] = new Monomial<MultivariatePolynomial<E>>(exponents, monomial.totalDegree, MultivariatePolynomial.fromSparseRecursiveForm((AMultivariatePolynomial)monomial.coefficient, nVariables, ordering, variable - 1));
        }
        MultivariatePolynomial<MultivariatePolynomial<E>> result = MultivariatePolynomial.create(nVariables, Rings.MultivariateRing((MultivariatePolynomial)data[0].coefficient), ordering, data);
        return MultivariatePolynomial.asNormalMultivariate(result);
    }

    public static <E> E evaluateSparseRecursiveForm(AMultivariatePolynomial recForm, int nVariables, E[] values) {
        AMultivariatePolynomial p = recForm;
        TIntArrayList degrees = new TIntArrayList();
        for (int n = nVariables - 1; n > 0; --n) {
            p = (AMultivariatePolynomial)((MultivariatePolynomial)p).cc();
            degrees.add(p.degree());
        }
        degrees.add(p.degree());
        if (nVariables != values.length) {
            throw new IllegalArgumentException();
        }
        Ring<E> ring = ((MultivariatePolynomial)p).ring;
        PrecomputedPowers[] pp = new PrecomputedPowers[nVariables];
        for (int i = 0; i < nVariables; ++i) {
            pp[i] = new PrecomputedPowers<E>(Math.min(degrees.get(i), 1014), values[i], ring);
        }
        return MultivariatePolynomial.evaluateSparseRecursiveForm(recForm, new PrecomputedPowersHolder<E>(ring, pp), nVariables - 1);
    }

    static <E> E evaluateSparseRecursiveForm(AMultivariatePolynomial recForm, PrecomputedPowersHolder<E> ph, int variable) {
        Ring ring = ph.ring;
        if (variable == 0) {
            assert (MonomialOrder.isGradedOrder(recForm.ordering));
            MultivariatePolynomial _recForm = (MultivariatePolynomial)recForm;
            Iterator it = _recForm.terms.descendingIterator();
            int previousExponent = -1;
            Object result = ring.getZero();
            while (it.hasNext()) {
                Monomial m = (Monomial)it.next();
                assert (previousExponent == -1 || previousExponent > m.totalDegree);
                result = ring.add(ring.multiply(result, ph.pow(variable, previousExponent == -1 ? 1 : previousExponent - m.totalDegree)), m.coefficient);
                previousExponent = m.totalDegree;
            }
            if (previousExponent > 0) {
                result = ring.multiply(result, ph.pow(variable, previousExponent));
            }
            return result;
        }
        MultivariatePolynomial _recForm = (MultivariatePolynomial)recForm;
        Iterator it = _recForm.terms.descendingIterator();
        int previousExponent = -1;
        Object result = ring.getZero();
        while (it.hasNext()) {
            Monomial m = (Monomial)it.next();
            assert (previousExponent == -1 || previousExponent > m.totalDegree);
            result = ring.add(ring.multiply(result, ph.pow(variable, previousExponent == -1 ? 1 : previousExponent - m.totalDegree)), MultivariatePolynomial.evaluateSparseRecursiveForm((AMultivariatePolynomial)m.coefficient, ph, variable - 1));
            previousExponent = m.totalDegree;
        }
        if (previousExponent > 0) {
            result = ring.multiply(result, ph.pow(variable, previousExponent));
        }
        return result;
    }

    public HornerForm getHornerForm(int[] evaluationVariables) {
        int[] evalDegrees = ArraysUtil.select(this.degreesRef(), evaluationVariables);
        MultivariatePolynomial p = this.asOverMultivariateEliminate(evaluationVariables);
        IPolynomialRing<AMultivariatePolynomial> newRing = Rings.PolynomialRing(((MultivariatePolynomial)p.cc()).toSparseRecursiveForm());
        return new HornerForm(this.ring, evalDegrees, evaluationVariables.length, p.mapCoefficients(newRing, MultivariatePolynomial::toSparseRecursiveForm));
    }

    public MultivariatePolynomial<E> evaluate(int variable, E value) {
        if (this.ring.isZero(value = this.ring.valueOf(value))) {
            return (MultivariatePolynomial)this.evaluateAtZero(variable);
        }
        PrecomputedPowers<E> powers = new PrecomputedPowers<E>(value, this.ring);
        return this.evaluate(variable, powers);
    }

    MultivariatePolynomial<E> evaluate(int variable, PrecomputedPowers<E> powers) {
        if (this.degree(variable) == 0) {
            return this.clone();
        }
        if (this.ring.isZero(((PrecomputedPowers)powers).value)) {
            return (MultivariatePolynomial)this.evaluateAtZero(variable);
        }
        MonomialSet<Monomial<E>> newData = new MonomialSet<Monomial<E>>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (Monomial el : this.terms) {
            E val = this.ring.multiply(el.coefficient, powers.pow(el.exponents[variable]));
            this.add(newData, ((Monomial)el.setZero(variable)).setCoefficient(val));
        }
        return new MultivariatePolynomial<E>(this.nVariables, this.ring, this.ordering, newData);
    }

    UnivariatePolynomial<E> evaluateAtZeroAllExcept(int variable) {
        int[] uData = this.ring.createArray(this.degree(variable) + 1);
        block0: for (Monomial el : this.terms) {
            if (el.totalDegree != 0 && el.exponents[variable] == 0) continue;
            for (int i = 0; i < this.nVariables; ++i) {
                if (i != variable && el.exponents[i] != 0) continue block0;
            }
            int uExp = el.exponents[variable];
            uData[uExp] = this.ring.add(uData[uExp], (int)el.coefficient);
        }
        return UnivariatePolynomial.createUnsafe(this.ring, uData);
    }

    public E evaluate(E ... values) {
        if (values.length != this.nVariables) {
            throw new IllegalArgumentException();
        }
        return this.evaluate(ArraysUtil.sequence(0, this.nVariables), values).cc();
    }

    public MultivariatePolynomial<E> evaluate(int[] variables, E[] values) {
        for (E value : values) {
            if (this.ring.isZero(value)) continue;
            return this.evaluate(this.mkPrecomputedPowers(variables, values), variables);
        }
        return (MultivariatePolynomial)this.evaluateAtZero(variables);
    }

    MultivariatePolynomial<E> evaluate(PrecomputedPowersHolder<E> powers, int[] variables) {
        MonomialSet<Monomial<E>> newData = new MonomialSet<Monomial<E>>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        Iterator iterator = this.terms.iterator();
        while (iterator.hasNext()) {
            Monomial el;
            Monomial r = el = (Monomial)iterator.next();
            Object value = el.coefficient;
            for (int variable : variables) {
                value = this.ring.multiply(value, powers.pow(variable, el.exponents[variable]));
            }
            r = ((Monomial)r.setZero(variables)).setCoefficient(value);
            this.add(newData, r);
        }
        return new MultivariatePolynomial<E>(this.nVariables, this.ring, this.ordering, newData);
    }

    public MultivariatePolynomial<E>[] evaluate(int variable, E ... values) {
        return (MultivariatePolynomial[])Arrays.stream(values).map(p -> this.evaluate(variable, (E)p)).toArray(MultivariatePolynomial[]::new);
    }

    public MultivariatePolynomial<E> evaluate(int variable, long value) {
        return this.evaluate(variable, (E)this.ring.valueOf(value));
    }

    public MultivariatePolynomial<E> eliminate(int variable, E value) {
        value = this.ring.valueOf(value);
        MonomialSet<Monomial<E>> newData = new MonomialSet<Monomial<E>>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        PrecomputedPowers<E> powers = new PrecomputedPowers<E>(value, this.ring);
        for (Monomial el : this.terms) {
            E val = this.ring.multiply(el.coefficient, powers.pow(el.exponents[variable]));
            this.add(newData, ((Monomial)el.without(variable)).setCoefficient(val));
        }
        return new MultivariatePolynomial<E>(this.nVariables - 1, this.ring, this.ordering, newData);
    }

    public MultivariatePolynomial<E> eliminate(int variable, long value) {
        return this.eliminate(variable, (E)this.ring.valueOf(value));
    }

    public MultivariatePolynomial<E> eliminate(int[] variables, E[] values) {
        for (E value : values) {
            if (this.ring.isZero(value)) continue;
            return this.eliminate(this.mkPrecomputedPowers(variables, values), variables);
        }
        return (MultivariatePolynomial)((MultivariatePolynomial)this.evaluateAtZero(variables)).dropVariables(variables);
    }

    MultivariatePolynomial<E> eliminate(PrecomputedPowersHolder<E> powers, int[] variables) {
        MonomialSet<Monomial<E>> newData = new MonomialSet<Monomial<E>>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        Iterator iterator = this.terms.iterator();
        while (iterator.hasNext()) {
            Monomial el;
            Monomial r = el = (Monomial)iterator.next();
            Object value = el.coefficient;
            for (int variable : variables) {
                value = this.ring.multiply(value, powers.pow(variable, el.exponents[variable]));
            }
            r = ((Monomial)r.without(variables)).setCoefficient(value);
            this.add(newData, r);
        }
        return new MultivariatePolynomial<E>(this.nVariables - variables.length, this.ring, this.ordering, newData);
    }

    public PrecomputedPowersHolder<E> mkPrecomputedPowers(int variable, E value) {
        PrecomputedPowers[] pp = new PrecomputedPowers[this.nVariables];
        pp[variable] = new PrecomputedPowers<E>(Math.min(this.degree(variable), 1014), value, this.ring);
        return new PrecomputedPowersHolder<E>(this.ring, pp);
    }

    public PrecomputedPowersHolder<E> mkPrecomputedPowers(int[] variables, E[] values) {
        int[] degrees = this.degreesRef();
        PrecomputedPowers[] pp = new PrecomputedPowers[this.nVariables];
        for (int i = 0; i < variables.length; ++i) {
            pp[variables[i]] = new PrecomputedPowers<E>(Math.min(degrees[variables[i]], 1014), values[i], this.ring);
        }
        return new PrecomputedPowersHolder<E>(this.ring, pp);
    }

    public static <E> PrecomputedPowersHolder<E> mkPrecomputedPowers(int nVariables, Ring<E> ring, int[] variables, E[] values) {
        PrecomputedPowers[] pp = new PrecomputedPowers[nVariables];
        for (int i = 0; i < variables.length; ++i) {
            pp[variables[i]] = new PrecomputedPowers<E>(1014, values[i], ring);
        }
        return new PrecomputedPowersHolder<E>(ring, pp);
    }

    public PrecomputedPowersHolder<E> mkPrecomputedPowers(E[] values) {
        if (values.length != this.nVariables) {
            throw new IllegalArgumentException();
        }
        int[] degrees = this.degreesRef();
        PrecomputedPowers[] pp = new PrecomputedPowers[this.nVariables];
        for (int i = 0; i < this.nVariables; ++i) {
            pp[i] = new PrecomputedPowers<E>(Math.min(degrees[i], 1014), values[i], this.ring);
        }
        return new PrecomputedPowersHolder<E>(this.ring, pp);
    }

    public MultivariatePolynomial<E> substitute(int variable, MultivariatePolynomial<E> poly) {
        if (poly.isConstant()) {
            return this.evaluate(variable, poly.cc());
        }
        PrecomputedSubstitution<E> subsPowers = poly.isEffectiveUnivariate() ? new USubstitution(poly.asUnivariate(), poly.univariateVariable(), this.nVariables, this.ordering) : new MSubstitution<E>(poly);
        IPolynomial result = this.createZero();
        for (Monomial term : this) {
            int exponent = term.exponents[variable];
            if (exponent == 0) {
                ((AMultivariatePolynomial)result).add(term);
                continue;
            }
            ((AMultivariatePolynomial)result).add(subsPowers.pow(exponent).multiply((Monomial)term.setZero(variable)));
        }
        return result;
    }

    public MultivariatePolynomial<E> shift(int variable, long shift) {
        return this.shift(variable, (E)this.ring.valueOf(shift));
    }

    public MultivariatePolynomial<E> shift(int variable, E shift) {
        if (this.ring.isZero(shift)) {
            return this.clone();
        }
        shift = this.ring.valueOf(shift);
        USubstitution<E> shifts = new USubstitution<E>(UnivariatePolynomial.createUnsafe(this.ring, this.ring.createArray(shift, this.ring.getOne())), variable, this.nVariables, this.ordering);
        IPolynomial result = this.createZero();
        for (Monomial term : this) {
            int exponent = term.exponents[variable];
            if (exponent == 0) {
                ((AMultivariatePolynomial)result).add(term);
                continue;
            }
            ((AMultivariatePolynomial)result).add(shifts.pow(exponent).multiply((Monomial)term.setZero(variable)));
        }
        return result;
    }

    public MultivariatePolynomial<E> shift(int[] variables, E[] shifts) {
        PrecomputedSubstitution[] powers = new PrecomputedSubstitution[this.nVariables];
        boolean allShiftsAreZero = true;
        for (int i = 0; i < variables.length; ++i) {
            if (!this.ring.isZero(shifts[i])) {
                allShiftsAreZero = false;
            }
            powers[variables[i]] = new USubstitution<E>(UnivariatePolynomial.create(this.ring, this.ring.createArray(shifts[i], this.ring.getOne())), variables[i], this.nVariables, this.ordering);
        }
        if (allShiftsAreZero) {
            return this.clone();
        }
        PrecomputedSubstitutions calculatedShifts = new PrecomputedSubstitutions(powers);
        IPolynomial result = this.createZero();
        for (Monomial term : this) {
            MultivariatePolynomial temp = this.createOne();
            for (int variable : variables) {
                if (term.exponents[variable] == 0) continue;
                temp = temp.multiply(calculatedShifts.getSubstitutionPower(variable, term.exponents[variable]));
                term = (Monomial)term.setZero(variable);
            }
            if (temp.isOne()) {
                ((AMultivariatePolynomial)result).add(term);
                continue;
            }
            ((AMultivariatePolynomial)result).add(temp.multiply(term));
        }
        return result;
    }

    @Override
    void add(MonomialSet<Monomial<E>> terms, Monomial<E> term) {
        MultivariatePolynomial.add(terms, term, this.ring);
    }

    @Override
    void subtract(MonomialSet<Monomial<E>> terms, Monomial<E> term) {
        MultivariatePolynomial.subtract(terms, term, this.ring);
    }

    @Override
    public MultivariatePolynomial<E> add(E oth) {
        if (this.ring.isZero(oth = this.ring.valueOf(oth))) {
            return this;
        }
        this.add(this.terms, new Monomial<E>(this.nVariables, oth));
        this.release();
        return this;
    }

    @Override
    public MultivariatePolynomial<E> subtract(E oth) {
        return this.add(this.ring.negate(this.ring.valueOf(oth)));
    }

    @Override
    public MultivariatePolynomial<E> increment() {
        return this.add(this.ring.getOne());
    }

    @Override
    public MultivariatePolynomial<E> decrement() {
        return this.subtract(this.ring.getOne());
    }

    @Override
    public MultivariatePolynomial<E> multiply(E factor) {
        if (this.ring.isOne(factor = this.ring.valueOf(factor))) {
            return this;
        }
        if (this.ring.isZero(factor)) {
            return (MultivariatePolynomial)this.toZero();
        }
        Iterator it = this.terms.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Monomial term = (Monomial)entry.getValue();
            E val = this.ring.multiply(term.coefficient, factor);
            if (this.ring.isZero(val)) {
                it.remove();
                continue;
            }
            entry.setValue(term.setCoefficient(val));
        }
        this.release();
        return this;
    }

    @Override
    public MultivariatePolynomial<E> multiplyByLC(MultivariatePolynomial<E> other) {
        return this.multiply(other.lc());
    }

    @Override
    public MultivariatePolynomial<E> multiply(Monomial<E> monomial) {
        this.checkSameDomainWith(monomial);
        if (monomial.isZeroVector()) {
            return this.multiply((E)monomial.coefficient);
        }
        if (this.ring.isZero(monomial.coefficient)) {
            return (MultivariatePolynomial)this.toZero();
        }
        MonomialSet<Monomial<E>> newMap = new MonomialSet<Monomial<E>>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (Monomial thisElement : this.terms) {
            Monomial<E> mul = this.monomialAlgebra.multiply(thisElement, monomial);
            if (this.ring.isZero(mul.coefficient)) continue;
            newMap.add(mul);
        }
        return (MultivariatePolynomial)this.loadFrom(newMap);
    }

    @Override
    public MultivariatePolynomial<E> multiply(long factor) {
        return this.multiply((E)this.ring.valueOf(factor));
    }

    @Override
    public MultivariatePolynomial<E> multiplyByBigInteger(BigInteger factor) {
        return this.multiply(this.ring.valueOfBigInteger(factor));
    }

    @Override
    public MultivariatePolynomial<E> multiply(MultivariatePolynomial<E> oth) {
        this.assertSameCoefficientRingWith(oth);
        if (oth.isZero()) {
            return (MultivariatePolynomial)this.toZero();
        }
        if (this.isZero()) {
            return this;
        }
        if (oth.isConstant()) {
            return this.multiply(oth.cc());
        }
        if (oth.size() == 1) {
            return this.multiply((Monomial)oth.lt());
        }
        if (this.size() > KRONECKER_THRESHOLD && oth.size() > KRONECKER_THRESHOLD) {
            return this.multiplyKronecker(oth);
        }
        return this.multiplyClassic(oth);
    }

    private MultivariatePolynomial<E> multiplyClassic(MultivariatePolynomial<E> oth) {
        MonomialSet<Monomial<E>> newMap = new MonomialSet<Monomial<E>>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (Monomial othElement : oth.terms) {
            for (Monomial thisElement : this.terms) {
                this.add(newMap, this.monomialAlgebra.multiply(thisElement, othElement));
            }
        }
        return (MultivariatePolynomial)this.loadFrom(newMap);
    }

    private MultivariatePolynomial<E> multiplyKronecker(MultivariatePolynomial<E> oth) {
        int[] resultDegrees = new int[this.nVariables];
        int[] thisDegrees = this.degreesRef();
        int[] othDegrees = oth.degreesRef();
        for (int i = 0; i < resultDegrees.length; ++i) {
            resultDegrees[i] = thisDegrees[i] + othDegrees[i];
        }
        long[] map = MultivariatePolynomial.KroneckerMap(resultDegrees);
        if (map == null) {
            return this.multiplyClassic(oth);
        }
        double threshold = 0.0;
        for (int i = 0; i < this.nVariables; ++i) {
            threshold += 1.0 * (double)resultDegrees[i] * (double)map[i];
        }
        if ((threshold *= 2.0) > 9.223372036854776E18) {
            return this.multiplyClassic(oth);
        }
        return this.fromKronecker(MultivariatePolynomial.multiplySparseUnivariate(this.ring, this.toKronecker(map), super.toKronecker(map)), map);
    }

    private TLongObjectHashMap<E> toKronecker(long[] kroneckerMap) {
        TLongObjectHashMap result = new TLongObjectHashMap(this.size());
        for (Monomial term : this) {
            long exponent = term.exponents[0];
            for (int i = 1; i < term.exponents.length; ++i) {
                exponent += (long)term.exponents[i] * kroneckerMap[i];
            }
            assert (!result.contains(exponent));
            result.put(exponent, term.coefficient);
        }
        return result;
    }

    private static <E> TLongObjectHashMap<CfHolder<E>> multiplySparseUnivariate(Ring<E> ring, TLongObjectHashMap<E> a, TLongObjectHashMap<E> b) {
        TLongObjectHashMap result = new TLongObjectHashMap(a.size() + b.size());
        TLongObjectIterator ait = a.iterator();
        while (ait.hasNext()) {
            ait.advance();
            TLongObjectIterator bit = b.iterator();
            while (bit.hasNext()) {
                bit.advance();
                long deg = ait.key() + bit.key();
                Object av = ait.value();
                Object bv = bit.value();
                Object val = ring.multiply(av, bv);
                CfHolder r = (CfHolder)result.get(deg);
                if (r != null) {
                    r.coefficient = ring.add(r.coefficient, val);
                    continue;
                }
                result.put(deg, new CfHolder<Object>(val));
            }
        }
        return result;
    }

    private MultivariatePolynomial<E> fromKronecker(TLongObjectHashMap<CfHolder<E>> p, long[] kroneckerMap) {
        this.terms.clear();
        TLongObjectIterator it = p.iterator();
        while (it.hasNext()) {
            it.advance();
            if (this.ring.isZero(((CfHolder)it.value()).coefficient)) continue;
            long exponent = it.key();
            int[] exponents = new int[this.nVariables];
            for (int i = 0; i < this.nVariables; ++i) {
                long div = exponent / kroneckerMap[this.nVariables - i - 1];
                exponent -= div * kroneckerMap[this.nVariables - i - 1];
                exponents[this.nVariables - i - 1] = MachineArithmetic.safeToInt(div);
            }
            this.terms.add(new Monomial(exponents, ((CfHolder)it.value()).coefficient));
        }
        this.release();
        return this;
    }

    @Override
    public MultivariatePolynomial<E> square() {
        return this.multiply(this);
    }

    @Override
    public MultivariatePolynomial<E> evaluateAtRandom(int variable, RandomGenerator rnd) {
        return this.evaluate(variable, this.ring.randomElement(rnd));
    }

    @Override
    public MultivariatePolynomial<E> evaluateAtRandomPreservingSkeleton(int variable, RandomGenerator rnd) {
        E randomPoint;
        MultivariatePolynomial<E> tmp;
        if (this.degree(variable) == 0) {
            return this.clone();
        }
        Set<DegreeVector> skeleton = this.getSkeletonExcept(variable);
        while (!skeleton.equals((tmp = this.evaluate(variable, randomPoint = this.ring.randomElement(rnd))).getSkeleton())) {
        }
        return tmp;
    }

    @Override
    public MultivariatePolynomial<E> derivative(int variable, int order) {
        MonomialSet<Monomial<E>> newTerms = new MonomialSet<Monomial<E>>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (Monomial term : this) {
            int exponent = term.exponents[variable];
            if (exponent < order) continue;
            Object newCoefficient = term.coefficient;
            for (int i = 0; i < order; ++i) {
                newCoefficient = this.ring.multiply((long)newCoefficient, this.ring.valueOf((long)(exponent - i)));
            }
            int[] newExponents = (int[])term.exponents.clone();
            int n = variable;
            newExponents[n] = newExponents[n] - order;
            this.add(newTerms, new Monomial(newExponents, term.totalDegree - order, newCoefficient));
        }
        return new MultivariatePolynomial<E>(this.nVariables, this.ring, this.ordering, newTerms);
    }

    static BigInteger seriesCoefficientFactor0(int exponent, int order, IntegersZp ring) {
        if (!ring.modulus.isInt() || order < ring.modulus.intValueExact()) {
            return MultivariatePolynomial.seriesCoefficientFactor1(exponent, order, ring);
        }
        return BigInteger.valueOf(MultivariatePolynomialZp64.seriesCoefficientFactor(exponent, order, ring.asZp64()));
    }

    static <E> E seriesCoefficientFactor1(int exponent, int order, Ring<E> ring) {
        Object factor = ring.getOne();
        for (int i = 0; i < order; ++i) {
            factor = ring.multiply((long)factor, ring.valueOf((long)(exponent - i)));
        }
        factor = ring.divideExact((long)factor, (long)ring.factorial(order));
        return factor;
    }

    static <E> E seriesCoefficientFactor2(int exponent, int order, Ring<E> ring) {
        BigInteger factor = BigInteger.ONE;
        for (int i = 0; i < order; ++i) {
            factor = factor.multiply(BigInteger.valueOf(exponent - i));
        }
        factor = factor.divideExact((BigInteger)Rings.Z.factorial(order));
        return ring.valueOfBigInteger(factor);
    }

    static <E> E seriesCoefficientFactor(int exponent, int order, Ring<E> ring) {
        if (ring instanceof IntegersZp) {
            return (E)MultivariatePolynomial.seriesCoefficientFactor0(exponent, order, (IntegersZp)ring);
        }
        BigInteger characteristics = ring.characteristic();
        if (characteristics == null || !characteristics.isInt() || characteristics.intValueExact() > order) {
            return MultivariatePolynomial.seriesCoefficientFactor1(exponent, order, ring);
        }
        return MultivariatePolynomial.seriesCoefficientFactor2(exponent, order, ring);
    }

    @Override
    public MultivariatePolynomial<E> seriesCoefficient(int variable, int order) {
        if (order == 0) {
            return this.clone();
        }
        if (this.isConstant()) {
            return this.createZero();
        }
        MonomialSet<Monomial<E>> newTerms = new MonomialSet<Monomial<E>>((Comparator<DegreeVector>)((Comparator<? super DegreeVector>)this.ordering));
        for (Monomial term : this) {
            int exponent = term.exponents[variable];
            if (exponent < order) continue;
            int[] newExponents = (int[])term.exponents.clone();
            int n = variable;
            newExponents[n] = newExponents[n] - order;
            E newCoefficient = this.ring.multiply(term.coefficient, MultivariatePolynomial.seriesCoefficientFactor(exponent, order, this.ring));
            this.add(newTerms, new Monomial<E>(newExponents, term.totalDegree - order, newCoefficient));
        }
        return new MultivariatePolynomial<E>(this.nVariables, this.ring, this.ordering, newTerms);
    }

    public Stream<E> stream() {
        return this.terms.values().stream().map(e -> e.coefficient);
    }

    public <T> MultivariatePolynomial<T> mapTerms(Ring<T> newRing, Function<Monomial<E>, Monomial<T>> mapper) {
        return (MultivariatePolynomial)this.terms.values().stream().map(mapper).collect(new AMultivariatePolynomial.PolynomialCollector(() -> MultivariatePolynomial.zero(this.nVariables, newRing, this.ordering)));
    }

    public <T> MultivariatePolynomial<T> mapCoefficients(Ring<T> newRing, Function<E, T> mapper) {
        return this.mapTerms(newRing, t -> new Monomial(t.exponents, t.totalDegree, mapper.apply(t.coefficient)));
    }

    public MultivariatePolynomialZp64 mapCoefficients(IntegersZp64 newDomain, ToLongFunction<E> mapper) {
        return (MultivariatePolynomialZp64)this.terms.values().stream().map(t -> new MonomialZp64(t.exponents, t.totalDegree, mapper.applyAsLong(t.coefficient))).collect(new AMultivariatePolynomial.PolynomialCollector(() -> MultivariatePolynomialZp64.zero(this.nVariables, newDomain, this.ordering)));
    }

    @Override
    public <T> MultivariatePolynomial<T> mapCoefficientsAsPolys(Ring<T> ring, Function<MultivariatePolynomial<E>, T> mapper) {
        return this.mapCoefficients(ring, (E cf) -> mapper.apply(this.createConstant(cf)));
    }

    @Override
    public int compareTo(MultivariatePolynomial<E> oth) {
        int c = Integer.compare(this.size(), oth.size());
        if (c != 0) {
            return c;
        }
        Iterator thisIt = this.iterator();
        Iterator othIt = oth.iterator();
        while (thisIt.hasNext() && othIt.hasNext()) {
            Monomial b;
            Monomial a = (Monomial)thisIt.next();
            c = this.ordering.compare(a, b = (Monomial)othIt.next());
            if (c != 0) {
                return c;
            }
            c = this.ring.compare(a.coefficient, b.coefficient);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    @Override
    public MultivariatePolynomial<E> clone() {
        return new MultivariatePolynomial<E>(this.nVariables, this.ring, this.ordering, this.terms.clone());
    }

    @Override
    @Deprecated
    public MultivariatePolynomial<E> parsePoly(String string) {
        MultivariatePolynomial<E> r = MultivariatePolynomial.parse(string, this.ring, this.ordering);
        if (r.nVariables != this.nVariables) {
            return MultivariatePolynomial.parse(string, this.ring, this.ordering, IStringifier.defaultVars(this.nVariables));
        }
        return r;
    }

    @Override
    public String toString(IStringifier<MultivariatePolynomial<E>> stringifier) {
        IStringifier<E> cfStringifier = stringifier.substringifier(this.ring);
        if (this.isConstant()) {
            return cfStringifier.stringify(this.cc());
        }
        String[] varStrings = new String[this.nVariables];
        for (int i = 0; i < this.nVariables; ++i) {
            varStrings[i] = stringifier.getBindings().getOrDefault(this.createMonomial(i, 1), IStringifier.defaultVar(i, this.nVariables));
        }
        StringBuilder sb = new StringBuilder();
        for (Monomial term : this.terms) {
            Object cf = term.coefficient;
            String cfString = this.ring.isMinusOne(cf) && term.totalDegree != 0 ? "-" : (!this.ring.isOne(cf) || term.totalDegree == 0 ? cfStringifier.stringify(cf) : "");
            if (term.totalDegree != 0 && IStringifier.needParenthesisInSum(cfString)) {
                cfString = "(" + cfString + ")";
            }
            if (sb.length() != 0 && !cfString.startsWith("-")) {
                sb.append("+");
            }
            StringBuilder cfBuilder = new StringBuilder();
            cfBuilder.append(cfString);
            boolean appended = false;
            for (int i = 0; i < this.nVariables; ++i) {
                if (term.exponents[i] == 0) continue;
                if ((!cfString.equals("-") || appended) && cfBuilder.length() != 0) {
                    cfBuilder.append("*");
                }
                cfBuilder.append(varStrings[i]);
                if (term.exponents[i] > 1) {
                    cfBuilder.append("^").append(term.exponents[i]);
                }
                appended = true;
            }
            sb.append((CharSequence)cfBuilder);
        }
        return sb.toString();
    }

    @Override
    public String coefficientRingToString(IStringifier<MultivariatePolynomial<E>> stringifier) {
        return this.ring.toString(stringifier.substringifier(this.ring));
    }

    static final class CfHolder<E> {
        E coefficient;

        CfHolder(E coefficient) {
            this.coefficient = coefficient;
        }
    }

    static final class MSubstitution<E>
    implements PrecomputedSubstitution<E> {
        final MultivariatePolynomial<E> base;
        final TIntObjectHashMap<MultivariatePolynomial<E>> cache = new TIntObjectHashMap();

        MSubstitution(MultivariatePolynomial<E> base) {
            this.base = base;
        }

        @Override
        public MultivariatePolynomial<E> pow(int exponent) {
            return PolynomialMethods.polyPow(this.base, exponent, true, this.cache);
        }
    }

    static final class USubstitution<E>
    implements PrecomputedSubstitution<E> {
        final int variable;
        final int nVariables;
        final Comparator<DegreeVector> ordering;
        final UnivariatePolynomial<E> base;
        final TIntObjectHashMap<UnivariatePolynomial<E>> uCache = new TIntObjectHashMap();
        final TIntObjectHashMap<MultivariatePolynomial<E>> mCache = new TIntObjectHashMap();

        USubstitution(UnivariatePolynomial<E> base, int variable, int nVariables, Comparator<DegreeVector> ordering) {
            this.nVariables = nVariables;
            this.variable = variable;
            this.ordering = ordering;
            this.base = base;
        }

        @Override
        public MultivariatePolynomial<E> pow(int exponent) {
            MultivariatePolynomial<E> cached = (MultivariatePolynomial<E>)this.mCache.get(exponent);
            if (cached != null) {
                return cached.clone();
            }
            UnivariatePolynomial<E> r = PolynomialMethods.polyPow(this.base, exponent, true, this.uCache);
            cached = MultivariatePolynomial.asMultivariate(r, this.nVariables, this.variable, this.ordering);
            this.mCache.put(exponent, cached);
            return cached.clone();
        }
    }

    static interface PrecomputedSubstitution<E> {
        public MultivariatePolynomial<E> pow(int var1);
    }

    static final class PrecomputedSubstitutions<E> {
        final PrecomputedSubstitution<E>[] subs;

        public PrecomputedSubstitutions(PrecomputedSubstitution<E>[] subs) {
            this.subs = subs;
        }

        MultivariatePolynomial<E> getSubstitutionPower(int var, int exponent) {
            if (this.subs[var] == null) {
                throw new IllegalArgumentException();
            }
            return this.subs[var].pow(exponent);
        }
    }

    public static final class PrecomputedPowersHolder<E> {
        final Ring<E> ring;
        final PrecomputedPowers<E>[] powers;

        public PrecomputedPowersHolder(Ring<E> ring, PrecomputedPowers<E>[] powers) {
            this.ring = ring;
            this.powers = powers;
        }

        void set(int i, E point) {
            if (this.powers[i] == null || !((PrecomputedPowers)this.powers[i]).value.equals(point)) {
                this.powers[i] = new PrecomputedPowers<E>(this.powers[i] == null ? 64 : ((PrecomputedPowers)this.powers[i]).precomputedPowers.length, point, this.ring);
            }
        }

        E pow(int variable, int exponent) {
            return this.powers[variable].pow(exponent);
        }

        public PrecomputedPowersHolder<E> clone() {
            return new PrecomputedPowersHolder<E>(this.ring, (PrecomputedPowers[])this.powers.clone());
        }
    }

    static final class PrecomputedPowers<E> {
        private final E value;
        private final Ring<E> ring;
        private final E[] precomputedPowers;

        PrecomputedPowers(E value, Ring<E> ring) {
            this(64, value, ring);
        }

        PrecomputedPowers(int cacheSize, E value, Ring<E> ring) {
            this.value = ring.valueOf((int)value);
            this.ring = ring;
            this.precomputedPowers = ring.createArray(cacheSize);
        }

        E pow(int exponent) {
            if (exponent >= this.precomputedPowers.length) {
                return this.ring.pow(this.value, exponent);
            }
            if (this.precomputedPowers[exponent] != null) {
                return this.precomputedPowers[exponent];
            }
            E result = this.ring.getOne();
            E k2p = this.value;
            int rExp = 0;
            int kExp = 1;
            while (true) {
                if ((exponent & 1) != 0) {
                    result = this.ring.multiply(result, k2p);
                    this.precomputedPowers[rExp += kExp] = result;
                }
                if ((exponent >>= 1) == 0) {
                    this.precomputedPowers[rExp] = result;
                    return this.precomputedPowers[rExp];
                }
                k2p = this.ring.multiply(k2p, k2p);
                this.precomputedPowers[kExp *= 2] = k2p;
            }
        }
    }

    public static final class HornerForm<E> {
        private final Ring<E> ring;
        private final int nEvalVariables;
        private final int[] evalDegrees;
        private final MultivariatePolynomial<AMultivariatePolynomial> recForm;

        private HornerForm(Ring<E> ring, int[] evalDegrees, int nEvalVariables, MultivariatePolynomial<AMultivariatePolynomial> recForm) {
            this.ring = ring;
            this.evalDegrees = evalDegrees;
            this.nEvalVariables = nEvalVariables;
            this.recForm = recForm;
        }

        public MultivariatePolynomial<E> evaluate(E[] values) {
            if (values.length != this.nEvalVariables) {
                throw new IllegalArgumentException();
            }
            PrecomputedPowers[] pp = new PrecomputedPowers[this.nEvalVariables];
            for (int i = 0; i < this.nEvalVariables; ++i) {
                pp[i] = new PrecomputedPowers<E>(Math.min(this.evalDegrees[i], 1014), values[i], this.ring);
            }
            return this.recForm.mapCoefficients(this.ring, p -> MultivariatePolynomial.evaluateSparseRecursiveForm(p, new PrecomputedPowersHolder<E>(this.ring, pp), this.nEvalVariables - 1));
        }
    }

    private static class It<V>
    implements Iterator<V> {
        final Iterator<Monomial<V>> inner;

        public It(Iterator<Monomial<V>> inner) {
            this.inner = inner;
        }

        @Override
        public boolean hasNext() {
            return this.inner.hasNext();
        }

        @Override
        public V next() {
            return (V)this.inner.next().coefficient;
        }
    }
}

