/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.libdivide4j.FastDivision;
import cc.redberry.rings.Ring;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.util.ArraysUtil;
import java.util.Arrays;
import java.util.function.LongFunction;
import java.util.stream.LongStream;
import java.util.stream.Stream;

abstract class AUnivariatePolynomial64<lPoly extends AUnivariatePolynomial64<lPoly>>
implements IUnivariatePolynomial<lPoly> {
    private static final long serialVersionUID = 1L;
    long[] data;
    int degree;
    private final lPoly self = this;
    static final long KARATSUBA_THRESHOLD = 2048L;
    static final long MUL_CLASSICAL_THRESHOLD = 65536L;
    static final long MUL_MOD_CLASSICAL_THRESHOLD = 16384L;

    AUnivariatePolynomial64() {
    }

    @Override
    public final int degree() {
        return this.degree;
    }

    public final long get(int i) {
        return i > this.degree ? 0L : this.data[i];
    }

    public final lPoly set(int i, long el) {
        if ((el = this.valueOf(el)) == 0L) {
            if (i > this.degree) {
                return this.self;
            }
            this.data[i] = el;
            this.fixDegree();
            return this.self;
        }
        this.ensureCapacity(i);
        this.data[i] = el;
        this.fixDegree();
        return this.self;
    }

    public final lPoly setLC(long lc) {
        return this.set(this.degree, lc);
    }

    @Override
    public final int firstNonZeroCoefficientPosition() {
        if (this.isZero()) {
            return -1;
        }
        int i = 0;
        while (this.data[i] == 0L) {
            ++i;
        }
        return i;
    }

    public final long lc() {
        return this.data[this.degree];
    }

    @Override
    public final lPoly lcAsPoly() {
        return (lPoly)this.createConstant(this.lc());
    }

    @Override
    public final lPoly ccAsPoly() {
        return (lPoly)this.createConstant(this.cc());
    }

    @Override
    public lPoly getAsPoly(int i) {
        return (lPoly)this.createConstant(this.get(i));
    }

    public final long cc() {
        return this.data[0];
    }

    @Override
    public final void ensureInternalCapacity(int desiredCapacity) {
        if (this.data.length < desiredCapacity) {
            this.data = Arrays.copyOf(this.data, desiredCapacity);
        }
    }

    final void ensureCapacity(int desiredDegree) {
        if (this.degree < desiredDegree) {
            this.degree = desiredDegree;
        }
        if (this.data.length < desiredDegree + 1) {
            this.data = Arrays.copyOf(this.data, desiredDegree + 1);
        }
    }

    final void fixDegree() {
        int i;
        for (i = this.degree; i >= 0 && this.data[i] == 0L; --i) {
        }
        if (i < 0) {
            i = 0;
        }
        if (i != this.degree) {
            this.degree = i;
        }
    }

    public abstract UnivariatePolynomial<BigInteger> toBigPoly();

    public abstract lPoly createFromArray(long[] var1);

    @Override
    public final lPoly createMonomial(int degree) {
        return this.createMonomial(1L, degree);
    }

    public final lPoly createLinear(long cc, long lc) {
        return this.createFromArray(new long[]{cc, lc});
    }

    public abstract lPoly createMonomial(long var1, int var3);

    @Override
    public final lPoly createConstant(long val) {
        return this.createFromArray(new long[]{val});
    }

    @Override
    public final lPoly createZero() {
        return (lPoly)this.createConstant(0L);
    }

    @Override
    public final lPoly createOne() {
        return (lPoly)this.createConstant(1L);
    }

    @Override
    public final boolean isZeroAt(int i) {
        return i >= this.data.length || this.data[i] == 0L;
    }

    @Override
    public final lPoly setZero(int i) {
        if (i < this.data.length) {
            this.data[i] = 0L;
        }
        return this.self;
    }

    @Override
    public final lPoly setFrom(int indexInThis, lPoly poly, int indexInPoly) {
        this.ensureCapacity(indexInThis);
        this.data[indexInThis] = ((AUnivariatePolynomial64)poly).get(indexInPoly);
        this.fixDegree();
        return this.self;
    }

    @Override
    public final boolean isZero() {
        return this.data[this.degree] == 0L;
    }

    @Override
    public final boolean isOne() {
        return this.degree == 0 && this.data[0] == 1L;
    }

    @Override
    public final boolean isMonic() {
        return this.lc() == 1L;
    }

    @Override
    public final boolean isUnitCC() {
        return this.cc() == 1L;
    }

    @Override
    public final boolean isConstant() {
        return this.degree == 0;
    }

    @Override
    public final boolean isMonomial() {
        for (int i = this.degree - 1; i >= 0; --i) {
            if (this.data[i] == 0L) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int signumOfLC() {
        return Long.signum(this.lc());
    }

    public final double norm1() {
        double norm = 0.0;
        for (int i = 0; i <= this.degree; ++i) {
            norm += (double)Math.abs(this.data[i]);
        }
        return norm;
    }

    public final double norm2() {
        double norm = 0.0;
        for (int i = 0; i <= this.degree; ++i) {
            norm += (double)this.data[i] * (double)this.data[i];
        }
        return Math.ceil(Math.sqrt(norm));
    }

    public final double normMax() {
        return this.maxAbsCoefficient();
    }

    public final long maxAbsCoefficient() {
        long max = Math.abs(this.data[0]);
        for (int i = 1; i <= this.degree; ++i) {
            max = Math.max(Math.abs(this.data[i]), max);
        }
        return max;
    }

    @Override
    public final lPoly toZero() {
        Arrays.fill(this.data, 0, this.degree + 1, 0L);
        this.degree = 0;
        return this.self;
    }

    @Override
    public final lPoly set(lPoly oth) {
        if (oth == this) {
            return this.self;
        }
        this.data = (long[])((AUnivariatePolynomial64)oth).data.clone();
        this.degree = ((AUnivariatePolynomial64)oth).degree;
        assert (this.data.length > 0);
        return this.self;
    }

    @Override
    public final lPoly setAndDestroy(lPoly oth) {
        this.data = ((AUnivariatePolynomial64)oth).data;
        ((AUnivariatePolynomial64)oth).data = null;
        this.degree = ((AUnivariatePolynomial64)oth).degree;
        assert (this.data.length > 0);
        return this.self;
    }

    @Override
    public final lPoly shiftLeft(int offset) {
        if (offset == 0) {
            return this.self;
        }
        if (offset > this.degree) {
            return (lPoly)this.toZero();
        }
        System.arraycopy(this.data, offset, this.data, 0, this.degree - offset + 1);
        Arrays.fill(this.data, this.degree - offset + 1, this.degree + 1, 0L);
        this.degree -= offset;
        return this.self;
    }

    @Override
    public final lPoly shiftRight(int offset) {
        if (offset == 0) {
            return this.self;
        }
        int degree = this.degree;
        this.ensureCapacity(offset + degree);
        System.arraycopy(this.data, 0, this.data, offset, degree + 1);
        Arrays.fill(this.data, 0, offset, 0L);
        return this.self;
    }

    @Override
    public final lPoly truncate(int newDegree) {
        if (newDegree >= this.degree) {
            return this.self;
        }
        Arrays.fill(this.data, newDegree + 1, this.degree + 1, 0L);
        this.degree = newDegree;
        this.fixDegree();
        return this.self;
    }

    @Override
    public final lPoly reverse() {
        ArraysUtil.reverse(this.data, 0, this.degree + 1);
        this.fixDegree();
        return this.self;
    }

    public abstract long content();

    @Override
    public final lPoly contentAsPoly() {
        return (lPoly)this.createConstant(this.content());
    }

    @Override
    public final lPoly primitivePart() {
        if (this.isZero()) {
            return this.self;
        }
        long content = this.content();
        if (this.lc() < 0L) {
            content = -content;
        }
        if (content == -1L) {
            return (lPoly)this.negate();
        }
        return this.primitivePart0(content);
    }

    @Override
    public final lPoly primitivePartSameSign() {
        return this.primitivePart0(this.content());
    }

    private lPoly primitivePart0(long content) {
        if (content == 1L) {
            return this.self;
        }
        FastDivision.Magic magic = FastDivision.magicSigned((long)content);
        for (int i = this.degree; i >= 0; --i) {
            this.data[i] = FastDivision.divideSignedFast((long)this.data[i], (FastDivision.Magic)magic);
        }
        return this.self;
    }

    abstract long add(long var1, long var3);

    abstract long subtract(long var1, long var3);

    abstract long multiply(long var1, long var3);

    abstract long negate(long var1);

    abstract long valueOf(long var1);

    public final long evaluate(long point) {
        if (point == 0L) {
            return this.cc();
        }
        point = this.valueOf(point);
        long res = 0L;
        for (int i = this.degree; i >= 0; --i) {
            res = this.add(this.multiply(res, point), this.data[i]);
        }
        return res;
    }

    @Override
    public final lPoly composition(lPoly value) {
        if (((AUnivariatePolynomial64)value).isOne()) {
            return (lPoly)this.clone();
        }
        if (((AUnivariatePolynomial64)value).isZero()) {
            return (lPoly)this.ccAsPoly();
        }
        Object result = this.createZero();
        for (int i = this.degree; i >= 0; --i) {
            result = ((AUnivariatePolynomial64)result.multiply(value)).add((lPoly)this.data[i]);
        }
        return (lPoly)result;
    }

    public final lPoly shift(long value) {
        return this.composition(this.createLinear(value, 1L));
    }

    public abstract lPoly monic(long var1);

    @Override
    public lPoly monicWithLC(lPoly other) {
        if (this.lc() == ((AUnivariatePolynomial64)other).lc()) {
            return this.self;
        }
        return this.monic(((AUnivariatePolynomial64)other).lc());
    }

    @Override
    public final lPoly add(long val) {
        this.data[0] = this.add(this.data[0], this.valueOf(val));
        this.fixDegree();
        return this.self;
    }

    @Override
    public final lPoly subtract(long val) {
        this.data[0] = this.subtract(this.data[0], this.valueOf(val));
        this.fixDegree();
        return this.self;
    }

    @Override
    public final lPoly decrement() {
        return (lPoly)this.subtract((lPoly)this.createOne());
    }

    @Override
    public final lPoly increment() {
        return (lPoly)this.add((lPoly)this.createOne());
    }

    @Override
    public final lPoly add(lPoly oth) {
        this.assertSameCoefficientRingWith(oth);
        if (((AUnivariatePolynomial64)oth).isZero()) {
            return this.self;
        }
        if (this.isZero()) {
            return this.set(oth);
        }
        this.assertSameCoefficientRingWith(oth);
        this.ensureCapacity(((AUnivariatePolynomial64)oth).degree);
        for (int i = ((AUnivariatePolynomial64)oth).degree; i >= 0; --i) {
            this.data[i] = this.add(this.data[i], ((AUnivariatePolynomial64)oth).data[i]);
        }
        this.fixDegree();
        return this.self;
    }

    public final lPoly addMonomial(long coefficient, int exponent) {
        if (coefficient == 0L) {
            return this.self;
        }
        this.ensureCapacity(exponent);
        this.data[exponent] = this.add(this.data[exponent], this.valueOf(coefficient));
        this.fixDegree();
        return this.self;
    }

    public final lPoly addMul(lPoly oth, long factor) {
        this.assertSameCoefficientRingWith(oth);
        if (((AUnivariatePolynomial64)oth).isZero()) {
            return this.self;
        }
        if ((factor = this.valueOf(factor)) == 0L) {
            return this.self;
        }
        this.assertSameCoefficientRingWith(oth);
        this.ensureCapacity(((AUnivariatePolynomial64)oth).degree);
        for (int i = ((AUnivariatePolynomial64)oth).degree; i >= 0; --i) {
            this.data[i] = this.add(this.data[i], this.multiply(factor, ((AUnivariatePolynomial64)oth).data[i]));
        }
        this.fixDegree();
        return this.self;
    }

    @Override
    public final lPoly subtract(lPoly oth) {
        this.assertSameCoefficientRingWith(oth);
        if (((AUnivariatePolynomial64)oth).isZero()) {
            return this.self;
        }
        if (this.isZero()) {
            return (lPoly)((AUnivariatePolynomial64)this.set(oth)).negate();
        }
        this.assertSameCoefficientRingWith(oth);
        this.ensureCapacity(((AUnivariatePolynomial64)oth).degree);
        for (int i = ((AUnivariatePolynomial64)oth).degree; i >= 0; --i) {
            this.data[i] = this.subtract(this.data[i], ((AUnivariatePolynomial64)oth).data[i]);
        }
        this.fixDegree();
        return this.self;
    }

    public final lPoly subtract(lPoly oth, long factor, int exponent) {
        this.assertSameCoefficientRingWith(oth);
        if (((AUnivariatePolynomial64)oth).isZero()) {
            return this.self;
        }
        if ((factor = this.valueOf(factor)) == 0L) {
            return this.self;
        }
        this.assertSameCoefficientRingWith(oth);
        for (int i = ((AUnivariatePolynomial64)oth).degree + exponent; i >= exponent; --i) {
            this.data[i] = this.subtract(this.data[i], this.multiply(factor, ((AUnivariatePolynomial64)oth).data[i - exponent]));
        }
        this.fixDegree();
        return this.self;
    }

    @Override
    public final lPoly negate() {
        for (int i = this.degree; i >= 0; --i) {
            this.data[i] = this.negate(this.data[i]);
        }
        return this.self;
    }

    @Override
    public lPoly multiplyByLC(lPoly other) {
        return (lPoly)this.multiply(((AUnivariatePolynomial64)other).lc());
    }

    @Override
    public final lPoly multiply(long factor) {
        if ((factor = this.valueOf(factor)) == 1L) {
            return this.self;
        }
        if (factor == 0L) {
            return (lPoly)this.toZero();
        }
        for (int i = this.degree; i >= 0; --i) {
            this.data[i] = this.multiply(this.data[i], factor);
        }
        return this.self;
    }

    @Override
    public abstract lPoly clone();

    final BigInteger[] dataToBigIntegers() {
        BigInteger[] bData = new BigInteger[this.degree + 1];
        for (int i = this.degree; i >= 0; --i) {
            bData[i] = BigInteger.valueOf(this.data[i]);
        }
        return bData;
    }

    public final long[] getDataReferenceUnsafe() {
        return this.data;
    }

    @Override
    public final int compareTo(lPoly o) {
        int c = Integer.compare(this.degree, ((AUnivariatePolynomial64)o).degree);
        if (c != 0) {
            return c;
        }
        for (int i = this.degree; i >= 0; --i) {
            c = Long.compare(this.data[i], ((AUnivariatePolynomial64)o).data[i]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public String toString() {
        return this.toString(IStringifier.dummy());
    }

    @Override
    public String toString(IStringifier<lPoly> stringifier) {
        if (this.isConstant()) {
            return Long.toString(this.cc());
        }
        String varString = stringifier.getBindings().getOrDefault(this.createMonomial(1), IStringifier.defaultVar());
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= this.degree; ++i) {
            long el = this.data[i];
            if (el == 0L) continue;
            String cfString = el != 1L || i == 0 ? Long.toString(el) : "";
            if (sb.length() != 0 && !cfString.startsWith("-")) {
                sb.append("+");
            }
            sb.append(cfString);
            if (i == 0) continue;
            if (!cfString.isEmpty()) {
                sb.append("*");
            }
            sb.append(varString);
            if (i <= 1) continue;
            sb.append("^").append(i);
        }
        return sb.toString();
    }

    public String toStringForCopy() {
        String s = ArraysUtil.toString(this.data, 0, this.degree + 1);
        return "of(" + s.substring(1, s.length() - 1) + ")";
    }

    @Override
    public Stream<lPoly> streamAsPolys() {
        return this.stream().mapToObj(l -> this.createConstant(l));
    }

    public final LongStream stream() {
        return Arrays.stream(this.data, 0, this.degree + 1);
    }

    public final <T> UnivariatePolynomial<T> mapCoefficients(Ring<T> ring, LongFunction<T> mapper) {
        return (UnivariatePolynomial)this.stream().mapToObj(mapper).collect(new UnivariatePolynomial.PolynomialCollector<T>(ring));
    }

    public final boolean equals(Object obj) {
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        AUnivariatePolynomial64 oth = (AUnivariatePolynomial64)obj;
        if (this.degree != oth.degree) {
            return false;
        }
        for (int i = 0; i <= this.degree; ++i) {
            if (this.data[i] == oth.data[i]) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int result = 1;
        for (int i = this.degree; i >= 0; --i) {
            long element = this.data[i];
            int elementHash = (int)(element ^ element >>> 32);
            result = 31 * result + elementHash;
        }
        return result;
    }

    final long[] multiplyUnsafe0(lPoly oth) {
        if (1L * (long)(this.degree + 1) * (long)(this.degree + 1) <= 65536L) {
            return AUnivariatePolynomial64.multiplyClassicalUnsafe(this.data, 0, this.degree + 1, ((AUnivariatePolynomial64)oth).data, 0, ((AUnivariatePolynomial64)oth).degree + 1);
        }
        return AUnivariatePolynomial64.multiplyKaratsubaUnsafe(this.data, 0, this.degree + 1, ((AUnivariatePolynomial64)oth).data, 0, ((AUnivariatePolynomial64)oth).degree + 1);
    }

    final long[] multiplySafe0(lPoly oth) {
        if (1L * (long)(this.degree + 1) * (long)(this.degree + 1) <= 65536L) {
            return this.multiplyClassicalSafe(this.data, 0, this.degree + 1, ((AUnivariatePolynomial64)oth).data, 0, ((AUnivariatePolynomial64)oth).degree + 1);
        }
        return this.multiplyKaratsubaSafe(this.data, 0, this.degree + 1, ((AUnivariatePolynomial64)oth).data, 0, ((AUnivariatePolynomial64)oth).degree + 1);
    }

    final long[] squareUnsafe0() {
        if (1L * (long)(this.degree + 1) * (long)(this.degree + 1) <= 65536L) {
            return AUnivariatePolynomial64.squareClassicalUnsafe(this.data, 0, this.degree + 1);
        }
        return AUnivariatePolynomial64.squareKaratsubaUnsafe(this.data, 0, this.degree + 1);
    }

    final long[] squareSafe0() {
        if (1L * (long)(this.degree + 1) * (long)(this.degree + 1) <= 65536L) {
            return this.squareClassicalSafe(this.data, 0, this.degree + 1);
        }
        return this.squareKaratsubaSafe(this.data, 0, this.degree + 1);
    }

    final long[] multiplyClassicalSafe(long[] a, int aFrom, int aTo, long[] b, int bFrom, int bTo) {
        long[] result = new long[aTo - aFrom + bTo - bFrom - 1];
        this.multiplyClassicalSafe(result, a, aFrom, aTo, b, bFrom, bTo);
        return result;
    }

    void multiplyClassicalSafe(long[] result, long[] a, int aFrom, int aTo, long[] b, int bFrom, int bTo) {
        if (aTo - aFrom > bTo - bFrom) {
            this.multiplyClassicalSafe(result, b, bFrom, bTo, a, aFrom, aTo);
            return;
        }
        for (int i = 0; i < aTo - aFrom; ++i) {
            long c = a[aFrom + i];
            if (c == 0L) continue;
            for (int j = 0; j < bTo - bFrom; ++j) {
                result[i + j] = this.add(result[i + j], this.multiply(c, b[bFrom + j]));
            }
        }
    }

    long[] multiplyKaratsubaSafe(long[] f, int fFrom, int fTo, long[] g, int gFrom, int gTo) {
        int i;
        int i2;
        if (fFrom >= fTo || gFrom >= gTo) {
            return new long[0];
        }
        if (fTo - fFrom == 1) {
            long[] result = new long[gTo - gFrom];
            for (int i3 = gFrom; i3 < gTo; ++i3) {
                result[i3 - gFrom] = this.multiply(f[fFrom], g[i3]);
            }
            return result;
        }
        if (gTo - gFrom == 1) {
            long[] result = new long[fTo - fFrom];
            for (int i4 = fFrom; i4 < fTo; ++i4) {
                result[i4 - fFrom] = this.multiply(g[gFrom], f[i4]);
            }
            return result;
        }
        if (fTo - fFrom == 2 && gTo - gFrom == 2) {
            long[] result = new long[]{this.multiply(f[fFrom], g[gFrom]), this.add(this.multiply(f[fFrom], g[gFrom + 1]), this.multiply(f[fFrom + 1], g[gFrom])), this.multiply(f[fFrom + 1], g[gFrom + 1])};
            return result;
        }
        if (1L * (long)(fTo - fFrom) * (long)(gTo - gFrom) < 2048L) {
            return this.multiplyClassicalSafe(g, gFrom, gTo, f, fFrom, fTo);
        }
        if (fTo - fFrom < gTo - gFrom) {
            return this.multiplyKaratsubaSafe(g, gFrom, gTo, f, fFrom, fTo);
        }
        int split = (fTo - fFrom + 1) / 2;
        if (gFrom + split >= gTo) {
            long[] f0g = this.multiplyKaratsubaSafe(f, fFrom, fFrom + split, g, gFrom, gTo);
            long[] f1g = this.multiplyKaratsubaSafe(f, fFrom + split, fTo, g, gFrom, gTo);
            long[] result = Arrays.copyOf(f0g, fTo - fFrom + gTo - gFrom - 1);
            for (int i5 = 0; i5 < f1g.length; ++i5) {
                result[i5 + split] = this.add(result[i5 + split], f1g[i5]);
            }
            return result;
        }
        int fMid = fFrom + split;
        int gMid = gFrom + split;
        long[] f0g0 = this.multiplyKaratsubaSafe(f, fFrom, fMid, g, gFrom, gMid);
        long[] f1g1 = this.multiplyKaratsubaSafe(f, fMid, fTo, g, gMid, gTo);
        long[] f0_plus_f1 = new long[Math.max(fMid - fFrom, fTo - fMid)];
        System.arraycopy(f, fFrom, f0_plus_f1, 0, fMid - fFrom);
        for (int i6 = fMid; i6 < fTo; ++i6) {
            f0_plus_f1[i6 - fMid] = this.add(f0_plus_f1[i6 - fMid], f[i6]);
        }
        long[] g0_plus_g1 = new long[Math.max(gMid - gFrom, gTo - gMid)];
        System.arraycopy(g, gFrom, g0_plus_g1, 0, gMid - gFrom);
        for (int i7 = gMid; i7 < gTo; ++i7) {
            g0_plus_g1[i7 - gMid] = this.add(g0_plus_g1[i7 - gMid], g[i7]);
        }
        long[] mid = this.multiplyKaratsubaSafe(f0_plus_f1, 0, f0_plus_f1.length, g0_plus_g1, 0, g0_plus_g1.length);
        if (mid.length < f0g0.length) {
            mid = Arrays.copyOf(mid, f0g0.length);
        }
        if (mid.length < f1g1.length) {
            mid = Arrays.copyOf(mid, f1g1.length);
        }
        for (i2 = 0; i2 < f0g0.length; ++i2) {
            mid[i2] = this.subtract(mid[i2], f0g0[i2]);
        }
        for (i2 = 0; i2 < f1g1.length; ++i2) {
            mid[i2] = this.subtract(mid[i2], f1g1[i2]);
        }
        long[] result = Arrays.copyOf(f0g0, fTo - fFrom + (gTo - gFrom) - 1);
        for (i = 0; i < mid.length; ++i) {
            result[i + split] = this.add(result[i + split], mid[i]);
        }
        for (i = 0; i < f1g1.length; ++i) {
            result[i + 2 * split] = this.add(result[i + 2 * split], f1g1[i]);
        }
        return result;
    }

    long[] squareClassicalSafe(long[] a, int from, int to) {
        long[] x = new long[(to - from) * 2 - 1];
        this.squareClassicalSafe(x, a, from, to);
        return x;
    }

    void squareClassicalSafe(long[] result, long[] data, int from, int to) {
        int len = to - from;
        for (int i = 0; i < len; ++i) {
            long c = data[from + i];
            if (c == 0L) continue;
            for (int j = 0; j < len; ++j) {
                result[i + j] = this.add(result[i + j], this.multiply(c, data[from + j]));
            }
        }
    }

    long[] squareKaratsubaSafe(long[] f, int fFrom, int fTo) {
        int i;
        int i2;
        if (fFrom >= fTo) {
            return new long[0];
        }
        if (fTo - fFrom == 1) {
            return new long[]{this.multiply(f[fFrom], f[fFrom])};
        }
        if (fTo - fFrom == 2) {
            long[] result = new long[]{this.multiply(f[fFrom], f[fFrom]), this.multiply(this.multiply(this.valueOf(2L), f[fFrom]), f[fFrom + 1]), this.multiply(f[fFrom + 1], f[fFrom + 1])};
            return result;
        }
        if (1L * (long)(fTo - fFrom) * (long)(fTo - fFrom) < 2048L) {
            return this.squareClassicalSafe(f, fFrom, fTo);
        }
        int split = (fTo - fFrom + 1) / 2;
        int fMid = fFrom + split;
        long[] f0g0 = this.squareKaratsubaSafe(f, fFrom, fMid);
        long[] f1g1 = this.squareKaratsubaSafe(f, fMid, fTo);
        long[] f0_plus_f1 = new long[Math.max(fMid - fFrom, fTo - fMid)];
        System.arraycopy(f, fFrom, f0_plus_f1, 0, fMid - fFrom);
        for (int i3 = fMid; i3 < fTo; ++i3) {
            f0_plus_f1[i3 - fMid] = this.add(f0_plus_f1[i3 - fMid], f[i3]);
        }
        long[] mid = this.squareKaratsubaSafe(f0_plus_f1, 0, f0_plus_f1.length);
        if (mid.length < f0g0.length) {
            mid = Arrays.copyOf(mid, f0g0.length);
        }
        if (mid.length < f1g1.length) {
            mid = Arrays.copyOf(mid, f1g1.length);
        }
        for (i2 = 0; i2 < f0g0.length; ++i2) {
            mid[i2] = this.subtract(mid[i2], f0g0[i2]);
        }
        for (i2 = 0; i2 < f1g1.length; ++i2) {
            mid[i2] = this.subtract(mid[i2], f1g1[i2]);
        }
        long[] result = Arrays.copyOf(f0g0, 2 * (fTo - fFrom) - 1);
        for (i = 0; i < mid.length; ++i) {
            result[i + split] = this.add(result[i + split], mid[i]);
        }
        for (i = 0; i < f1g1.length; ++i) {
            result[i + 2 * split] = this.add(result[i + 2 * split], f1g1[i]);
        }
        return result;
    }

    static void multiplyClassicalUnsafe(long[] result, long[] a, int aFrom, int aTo, long[] b, int bFrom, int bTo) {
        if (aTo - aFrom > bTo - bFrom) {
            AUnivariatePolynomial64.multiplyClassicalUnsafe(result, b, bFrom, bTo, a, aFrom, aTo);
            return;
        }
        for (int i = 0; i < aTo - aFrom; ++i) {
            long c = a[aFrom + i];
            if (c == 0L) continue;
            for (int j = 0; j < bTo - bFrom; ++j) {
                result[i + j] = result[i + j] + c * b[bFrom + j];
            }
        }
    }

    static long[] multiplyClassicalUnsafe(long[] a, int aFrom, int aTo, long[] b, int bFrom, int bTo) {
        long[] result = new long[aTo - aFrom + bTo - bFrom - 1];
        AUnivariatePolynomial64.multiplyClassicalUnsafe(result, a, aFrom, aTo, b, bFrom, bTo);
        return result;
    }

    static long[] multiplyKaratsubaUnsafe(long[] f, int fFrom, int fTo, long[] g, int gFrom, int gTo) {
        int i;
        int i2;
        if (fFrom >= fTo || gFrom >= gTo) {
            return new long[0];
        }
        if (fTo - fFrom == 1) {
            long[] result = new long[gTo - gFrom];
            for (int i3 = gFrom; i3 < gTo; ++i3) {
                result[i3 - gFrom] = f[fFrom] * g[i3];
            }
            return result;
        }
        if (gTo - gFrom == 1) {
            long[] result = new long[fTo - fFrom];
            for (int i4 = fFrom; i4 < fTo; ++i4) {
                result[i4 - fFrom] = g[gFrom] * f[i4];
            }
            return result;
        }
        if (fTo - fFrom == 2 && gTo - gFrom == 2) {
            long[] result = new long[]{f[fFrom] * g[gFrom], f[fFrom] * g[gFrom + 1] + f[fFrom + 1] * g[gFrom], f[fFrom + 1] * g[gFrom + 1]};
            return result;
        }
        if (1L * (long)(fTo - fFrom) * (long)(gTo - gFrom) < 2048L) {
            return AUnivariatePolynomial64.multiplyClassicalUnsafe(g, gFrom, gTo, f, fFrom, fTo);
        }
        if (fTo - fFrom < gTo - gFrom) {
            return AUnivariatePolynomial64.multiplyKaratsubaUnsafe(g, gFrom, gTo, f, fFrom, fTo);
        }
        int split = (fTo - fFrom + 1) / 2;
        if (gFrom + split >= gTo) {
            long[] f0g = AUnivariatePolynomial64.multiplyKaratsubaUnsafe(f, fFrom, fFrom + split, g, gFrom, gTo);
            long[] f1g = AUnivariatePolynomial64.multiplyKaratsubaUnsafe(f, fFrom + split, fTo, g, gFrom, gTo);
            long[] result = Arrays.copyOf(f0g, fTo - fFrom + gTo - gFrom - 1);
            for (int i5 = 0; i5 < f1g.length; ++i5) {
                result[i5 + split] = result[i5 + split] + f1g[i5];
            }
            return result;
        }
        int fMid = fFrom + split;
        int gMid = gFrom + split;
        long[] f0g0 = AUnivariatePolynomial64.multiplyKaratsubaUnsafe(f, fFrom, fMid, g, gFrom, gMid);
        long[] f1g1 = AUnivariatePolynomial64.multiplyKaratsubaUnsafe(f, fMid, fTo, g, gMid, gTo);
        long[] f0_plus_f1 = new long[Math.max(fMid - fFrom, fTo - fMid)];
        System.arraycopy(f, fFrom, f0_plus_f1, 0, fMid - fFrom);
        for (int i6 = fMid; i6 < fTo; ++i6) {
            f0_plus_f1[i6 - fMid] = f0_plus_f1[i6 - fMid] + f[i6];
        }
        long[] g0_plus_g1 = new long[Math.max(gMid - gFrom, gTo - gMid)];
        System.arraycopy(g, gFrom, g0_plus_g1, 0, gMid - gFrom);
        for (int i7 = gMid; i7 < gTo; ++i7) {
            g0_plus_g1[i7 - gMid] = g0_plus_g1[i7 - gMid] + g[i7];
        }
        long[] mid = AUnivariatePolynomial64.multiplyKaratsubaUnsafe(f0_plus_f1, 0, f0_plus_f1.length, g0_plus_g1, 0, g0_plus_g1.length);
        if (mid.length < f0g0.length) {
            mid = Arrays.copyOf(mid, f0g0.length);
        }
        if (mid.length < f1g1.length) {
            mid = Arrays.copyOf(mid, f1g1.length);
        }
        for (i2 = 0; i2 < f0g0.length; ++i2) {
            mid[i2] = mid[i2] - f0g0[i2];
        }
        for (i2 = 0; i2 < f1g1.length; ++i2) {
            mid[i2] = mid[i2] - f1g1[i2];
        }
        long[] result = Arrays.copyOf(f0g0, fTo - fFrom + (gTo - gFrom) - 1);
        for (i = 0; i < mid.length; ++i) {
            result[i + split] = result[i + split] + mid[i];
        }
        for (i = 0; i < f1g1.length; ++i) {
            result[i + 2 * split] = result[i + 2 * split] + f1g1[i];
        }
        return result;
    }

    static long[] squareClassicalUnsafe(long[] a, int from, int to) {
        long[] x = new long[(to - from) * 2 - 1];
        AUnivariatePolynomial64.squareClassicalUnsafe(x, a, from, to);
        return x;
    }

    static void squareClassicalUnsafe(long[] result, long[] data, int from, int to) {
        int len = to - from;
        for (int i = 0; i < len; ++i) {
            long c = data[from + i];
            if (c == 0L) continue;
            for (int j = 0; j < len; ++j) {
                result[i + j] = result[i + j] + c * data[from + j];
            }
        }
    }

    static long[] squareKaratsubaUnsafe(long[] f, int fFrom, int fTo) {
        int i;
        int i2;
        if (fFrom >= fTo) {
            return new long[0];
        }
        if (fTo - fFrom == 1) {
            return new long[]{f[fFrom] * f[fFrom]};
        }
        if (fTo - fFrom == 2) {
            long[] result = new long[]{f[fFrom] * f[fFrom], 2L * f[fFrom] * f[fFrom + 1], f[fFrom + 1] * f[fFrom + 1]};
            return result;
        }
        if (1L * (long)(fTo - fFrom) * (long)(fTo - fFrom) < 2048L) {
            return AUnivariatePolynomial64.squareClassicalUnsafe(f, fFrom, fTo);
        }
        int split = (fTo - fFrom + 1) / 2;
        int fMid = fFrom + split;
        long[] f0g0 = AUnivariatePolynomial64.squareKaratsubaUnsafe(f, fFrom, fMid);
        long[] f1g1 = AUnivariatePolynomial64.squareKaratsubaUnsafe(f, fMid, fTo);
        long[] f0_plus_f1 = new long[Math.max(fMid - fFrom, fTo - fMid)];
        System.arraycopy(f, fFrom, f0_plus_f1, 0, fMid - fFrom);
        for (int i3 = fMid; i3 < fTo; ++i3) {
            f0_plus_f1[i3 - fMid] = f0_plus_f1[i3 - fMid] + f[i3];
        }
        long[] mid = AUnivariatePolynomial64.squareKaratsubaUnsafe(f0_plus_f1, 0, f0_plus_f1.length);
        if (mid.length < f0g0.length) {
            mid = Arrays.copyOf(mid, f0g0.length);
        }
        if (mid.length < f1g1.length) {
            mid = Arrays.copyOf(mid, f1g1.length);
        }
        for (i2 = 0; i2 < f0g0.length; ++i2) {
            mid[i2] = mid[i2] - f0g0[i2];
        }
        for (i2 = 0; i2 < f1g1.length; ++i2) {
            mid[i2] = mid[i2] - f1g1[i2];
        }
        long[] result = Arrays.copyOf(f0g0, 2 * (fTo - fFrom) - 1);
        for (i = 0; i < mid.length; ++i) {
            result[i + split] = result[i + split] + mid[i];
        }
        for (i = 0; i < f1g1.length; ++i) {
            result[i + 2 * split] = result[i + 2 * split] + f1g1[i];
        }
        return result;
    }
}

