/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariateGCD;

public final class DiophantineEquations {
    private DiophantineEquations() {
    }

    public static <Poly extends IUnivariatePolynomial<Poly>> Poly[] monicExtendedEuclid(Poly a, Poly b) {
        IUnivariatePolynomial[] xgcd = UnivariateGCD.PolynomialExtendedGCD(a, b);
        if (xgcd[0].isOne()) {
            return xgcd;
        }
        xgcd[2].divideByLC(xgcd[0]);
        xgcd[1].divideByLC(xgcd[0]);
        xgcd[0].monic();
        return xgcd;
    }

    public static final class DiophantineSolver<Poly extends IUnivariatePolynomial<Poly>> {
        final Poly[] factors;
        final Poly[] solution;
        final Poly gcd;

        public DiophantineSolver(Poly[] factors) {
            this.factors = factors;
            this.solution = (IUnivariatePolynomial[])factors[0].createArray(factors.length);
            Object prev = factors[0];
            this.solution[0] = (IUnivariatePolynomial)factors[0].createOne();
            for (int i = 1; i < factors.length; ++i) {
                IUnivariatePolynomial[] xgcd = DiophantineEquations.monicExtendedEuclid(prev, factors[i]);
                for (int j = 0; j < i; ++j) {
                    this.solution[j].multiply((IUnivariatePolynomial)xgcd[1]);
                }
                this.solution[i] = xgcd[2];
                prev = xgcd[0];
            }
            this.gcd = prev;
        }

        public Poly[] solve(Poly rhs) {
            if ((rhs = UnivariateDivision.divideOrNull(rhs, this.gcd, true)) == null) {
                throw new IllegalArgumentException("Not solvable.");
            }
            IUnivariatePolynomial[] solution = (IUnivariatePolynomial[])rhs.createArray(this.solution.length);
            for (int i = 0; i < solution.length; ++i) {
                solution[i] = (IUnivariatePolynomial)this.solution[i].clone().multiply(rhs);
            }
            return solution;
        }
    }
}

