/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.rings.IntegersZp;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.poly.MachineArithmetic;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariateGCD;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialArithmetic;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZ64;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class HenselLifting {
    private static final int SWITCH_TO_QUADRATIC_LIFT = 64;

    private HenselLifting() {
    }

    public static lQuadraticLift createQuadraticLift(long modulus, UnivariatePolynomialZ64 poly, UnivariatePolynomialZp64 aFactor, UnivariatePolynomialZp64 bFactor) {
        bFactor = HenselLifting.ensureMonic(bFactor);
        if (aFactor.ring.modulus(poly.lc()) != aFactor.lc()) {
            aFactor = aFactor.clone().monic(poly.lc());
        }
        UnivariatePolynomialZp64[] xgcd = (UnivariatePolynomialZp64[])HenselLifting.monicExtendedEuclid((IUnivariatePolynomial)aFactor, (IUnivariatePolynomial)bFactor);
        return new lQuadraticLift(modulus, poly, aFactor, bFactor, xgcd[1], xgcd[2]);
    }

    private static void ensureIntegersDomain(UnivariatePolynomial<BigInteger> poly) {
        if (!poly.ring.equals(Rings.Z)) {
            throw new IllegalArgumentException("Not an integers ring ring: " + poly.ring);
        }
    }

    private static void ensureModularDomain(UnivariatePolynomial<BigInteger> poly) {
        if (!(poly.ring instanceof IntegersZp)) {
            throw new IllegalArgumentException("Not a modular ring");
        }
    }

    private static void ensureInputCorrect(UnivariatePolynomial<BigInteger> poly, UnivariatePolynomial<BigInteger> aFactor, UnivariatePolynomial<BigInteger> bFactor) {
        HenselLifting.ensureIntegersDomain(poly);
        HenselLifting.ensureModularDomain(aFactor);
        HenselLifting.ensureModularDomain(bFactor);
    }

    public static bQuadraticLift createQuadraticLift(BigInteger modulus, UnivariatePolynomial<BigInteger> poly, UnivariatePolynomial<BigInteger> aFactor, UnivariatePolynomial<BigInteger> bFactor) {
        HenselLifting.ensureInputCorrect(poly, aFactor, bFactor);
        bFactor = HenselLifting.ensureMonic(bFactor);
        IntegersZp ring = (IntegersZp)aFactor.ring;
        if (!ring.valueOf(poly.lc()).equals(aFactor.lc())) {
            aFactor = ((UnivariatePolynomial)aFactor.clone()).monic(poly.lc());
        }
        UnivariatePolynomial[] xgcd = (UnivariatePolynomial[])HenselLifting.monicExtendedEuclid(aFactor, bFactor);
        return new bQuadraticLift(modulus, poly, aFactor, bFactor, xgcd[1], xgcd[2]);
    }

    public static bQuadraticLift createQuadraticLift(BigInteger modulus, UnivariatePolynomial<BigInteger> poly, UnivariatePolynomialZp64 aFactor, UnivariatePolynomialZp64 bFactor) {
        HenselLifting.ensureIntegersDomain(poly);
        bFactor = HenselLifting.ensureMonic(bFactor);
        long lc = poly.lc().mod(modulus).longValueExact();
        if (lc != aFactor.lc()) {
            aFactor = aFactor.clone().monic(lc);
        }
        UnivariatePolynomialZp64[] xgcd = (UnivariatePolynomialZp64[])HenselLifting.monicExtendedEuclid((IUnivariatePolynomial)aFactor, (IUnivariatePolynomial)bFactor);
        return new bQuadraticLift(modulus, poly, aFactor.toBigPoly(), bFactor.toBigPoly(), xgcd[1].toBigPoly(), xgcd[2].toBigPoly());
    }

    public static lLinearLift createLinearLift(BigInteger modulus, UnivariatePolynomialZ64 poly, UnivariatePolynomialZp64 aFactor, UnivariatePolynomialZp64 bFactor) {
        return HenselLifting.createLinearLift(modulus.longValueExact(), poly, aFactor, bFactor);
    }

    public static bLinearLift createLinearLift(BigInteger modulus, UnivariatePolynomial<BigInteger> poly, UnivariatePolynomialZp64 aFactor, UnivariatePolynomialZp64 bFactor) {
        return HenselLifting.createLinearLift(modulus.longValueExact(), poly, aFactor, bFactor);
    }

    public static lLinearLift createLinearLift(long modulus, UnivariatePolynomialZ64 poly, UnivariatePolynomialZp64 aFactor, UnivariatePolynomialZp64 bFactor) {
        bFactor = HenselLifting.ensureMonic(bFactor);
        if (aFactor.ring.modulus(poly.lc()) != aFactor.lc()) {
            aFactor = aFactor.clone().monic(poly.lc());
        }
        UnivariatePolynomialZp64[] xgcd = (UnivariatePolynomialZp64[])HenselLifting.monicExtendedEuclid((IUnivariatePolynomial)aFactor, (IUnivariatePolynomial)bFactor);
        return new lLinearLift(modulus, poly, aFactor, bFactor, xgcd[1], xgcd[2]);
    }

    public static bLinearLift createLinearLift(long modulus, UnivariatePolynomial<BigInteger> poly, UnivariatePolynomialZp64 aFactor, UnivariatePolynomialZp64 bFactor) {
        HenselLifting.ensureIntegersDomain(poly);
        BigInteger bModulus = BigInteger.valueOf(modulus);
        bFactor = HenselLifting.ensureMonic(bFactor);
        long lc = poly.lc().mod(bModulus).longValueExact();
        if (lc != aFactor.lc()) {
            aFactor = aFactor.clone().monic(lc);
        }
        UnivariatePolynomialZp64[] xgcd = (UnivariatePolynomialZp64[])HenselLifting.monicExtendedEuclid((IUnivariatePolynomial)aFactor, (IUnivariatePolynomial)bFactor);
        return new bLinearLift(bModulus, (UnivariatePolynomial)poly, aFactor, bFactor, xgcd[1], xgcd[2]);
    }

    private static <PolyZp extends IUnivariatePolynomial<PolyZp>> PolyZp[] monicExtendedEuclid(PolyZp a, PolyZp b) {
        Object[] xgcd = UnivariateGCD.PolynomialExtendedGCD(a, b);
        if (xgcd[0].isOne()) {
            return xgcd;
        }
        assert (xgcd[0].isConstant()) : "bad xgcd: " + Arrays.toString(xgcd) + " for xgcd(" + a + ", " + b + ")";
        xgcd[2].divideByLC(xgcd[0]);
        xgcd[1].divideByLC(xgcd[0]);
        xgcd[0].monic();
        return xgcd;
    }

    private static <PolyZp extends IUnivariatePolynomial<PolyZp>> PolyZp ensureMonic(PolyZp p) {
        return (PolyZp)(p.isMonic() ? p : (IUnivariatePolynomial)p.clone().monic());
    }

    private static long[] nIterations(long modulus, long desiredBound, boolean quadratic) {
        int nIterations = 0;
        long tmp = modulus;
        while (tmp < desiredBound) {
            tmp = MachineArithmetic.safeMultiply(tmp, quadratic ? tmp : modulus);
            ++nIterations;
        }
        return new long[]{nIterations, tmp};
    }

    public static List<UnivariatePolynomialZp64> liftFactorization(long modulus, long desiredBound, UnivariatePolynomialZ64 poly, List<UnivariatePolynomialZp64> modularFactors, boolean quadratic) {
        long[] im = HenselLifting.nIterations(modulus, desiredBound, quadratic);
        return HenselLifting.liftFactorization(modulus, im[1], (int)im[0], poly, modularFactors, quadratic);
    }

    public static List<UnivariatePolynomialZp64> liftFactorization(long modulus, long finalModulus, int nIterations, UnivariatePolynomialZ64 poly, List<UnivariatePolynomialZp64> modularFactors, boolean quadratic) {
        int i;
        assert (nIterations > 0);
        if (modularFactors.size() == 1) {
            return Collections.singletonList(poly.modulus(finalModulus, true).monic());
        }
        UnivariatePolynomialZp64 factory = modularFactors.get(0);
        UnivariatePolynomialZp64 aFactor = (UnivariatePolynomialZp64)factory.createConstant(poly.lc());
        UnivariatePolynomialZp64 bFactor = (UnivariatePolynomialZp64)factory.createOne();
        int nHalf = modularFactors.size() / 2;
        for (i = 0; i < nHalf; ++i) {
            aFactor = aFactor.multiply(modularFactors.get(i));
        }
        while (i < modularFactors.size()) {
            bFactor = bFactor.multiply(modularFactors.get(i));
            ++i;
        }
        LiftableQuintet<UnivariatePolynomialZp64> hensel = quadratic ? HenselLifting.createQuadraticLift(modulus, poly, aFactor, bFactor) : HenselLifting.createLinearLift(modulus, poly, aFactor, bFactor);
        hensel.lift(nIterations);
        UnivariatePolynomialZp64 aFactorRaised = hensel.aFactorMod();
        UnivariatePolynomialZp64 bFactorRaised = hensel.bFactorMod();
        ArrayList<UnivariatePolynomialZp64> result = new ArrayList<UnivariatePolynomialZp64>();
        result.addAll(HenselLifting.liftFactorization(modulus, finalModulus, nIterations, aFactorRaised.asPolyZSymmetric(), modularFactors.subList(0, nHalf), quadratic));
        result.addAll(HenselLifting.liftFactorization(modulus, finalModulus, nIterations, bFactorRaised.asPolyZSymmetric(), modularFactors.subList(nHalf, modularFactors.size()), quadratic));
        return result;
    }

    static <PolyZp extends IUnivariatePolynomial<PolyZp>> List<UnivariatePolynomial<BigInteger>> liftFactorization0(BigInteger modulus, BigInteger finalModulus, int nIterations, UnivariatePolynomial<BigInteger> poly, List<PolyZp> modularFactors, LiftFactory<PolyZp> liftFactory) {
        int i;
        assert (nIterations > 0);
        if (modularFactors.size() == 1) {
            return Collections.singletonList(poly.setRing(new IntegersZp(finalModulus)).monic());
        }
        IUnivariatePolynomial factory = (IUnivariatePolynomial)modularFactors.get(0);
        IUnivariatePolynomial aFactor = (IUnivariatePolynomial)factory.createOne();
        IUnivariatePolynomial bFactor = (IUnivariatePolynomial)factory.createOne();
        int nHalf = modularFactors.size() / 2;
        for (i = 0; i < nHalf; ++i) {
            aFactor = aFactor.multiply((IUnivariatePolynomial)modularFactors.get(i));
        }
        while (i < modularFactors.size()) {
            bFactor = bFactor.multiply((IUnivariatePolynomial)modularFactors.get(i));
            ++i;
        }
        LiftableQuintet<UnivariatePolynomial<BigInteger>> hensel = liftFactory.createLift(modulus, poly, aFactor, bFactor);
        hensel.lift(nIterations);
        UnivariatePolynomial<BigInteger> aFactorRaised = hensel.aFactorMod();
        UnivariatePolynomial<BigInteger> bFactorRaised = hensel.bFactorMod();
        ArrayList<UnivariatePolynomial<BigInteger>> result = new ArrayList<UnivariatePolynomial<BigInteger>>();
        result.addAll(HenselLifting.liftFactorization0(modulus, finalModulus, nIterations, UnivariatePolynomial.asPolyZSymmetric(aFactorRaised), modularFactors.subList(0, nHalf), liftFactory));
        result.addAll(HenselLifting.liftFactorization0(modulus, finalModulus, nIterations, UnivariatePolynomial.asPolyZSymmetric(bFactorRaised), modularFactors.subList(nHalf, modularFactors.size()), liftFactory));
        return result;
    }

    static LiftingInfo nIterations(BigInteger modulus, BigInteger desiredBound, boolean quadratic) {
        int nIterations = 0;
        BigInteger finalModulus = modulus;
        while (finalModulus.compareTo(desiredBound) < 0) {
            finalModulus = finalModulus.multiply(quadratic ? finalModulus : modulus);
            ++nIterations;
        }
        return new LiftingInfo(nIterations, finalModulus);
    }

    public static List<UnivariatePolynomial<BigInteger>> liftFactorization(BigInteger modulus, BigInteger desiredBound, UnivariatePolynomial<BigInteger> poly, List<UnivariatePolynomialZp64> modularFactors, boolean quadratic) {
        if (!quadratic && !modulus.isLong()) {
            throw new IllegalArgumentException("Only max 64-bit modulus for linear lift allowed.");
        }
        LiftingInfo im = HenselLifting.nIterations(modulus, desiredBound, quadratic);
        if (im.nIterations == 0) {
            return modularFactors.stream().map(UnivariatePolynomialZp64::toBigPoly).collect(Collectors.toList());
        }
        LiftFactory<UnivariatePolynomialZp64> factory = quadratic ? HenselLifting::createQuadraticLift : HenselLifting::createLinearLift;
        return HenselLifting.liftFactorization0(modulus, im.finalModulus, im.nIterations, poly, modularFactors, factory);
    }

    public static List<UnivariatePolynomial<BigInteger>> liftFactorizationQuadratic(BigInteger modulus, BigInteger desiredBound, UnivariatePolynomial<BigInteger> poly, List<UnivariatePolynomial<BigInteger>> modularFactors) {
        LiftingInfo im = HenselLifting.nIterations(modulus, desiredBound, true);
        return HenselLifting.liftFactorization0(modulus, im.finalModulus, im.nIterations, poly, modularFactors, HenselLifting::createQuadraticLift);
    }

    public static List<UnivariatePolynomial<BigInteger>> liftFactorization(BigInteger modulus, BigInteger desiredBound, UnivariatePolynomial<BigInteger> poly, List<UnivariatePolynomialZp64> modularFactors) {
        return HenselLifting.liftFactorization(poly, modularFactors, new AdaptiveLift(modulus, desiredBound));
    }

    private static List<UnivariatePolynomial<BigInteger>> liftFactorization(UnivariatePolynomial<BigInteger> poly, List<UnivariatePolynomialZp64> modularFactors, AdaptiveLift lifter) {
        int i;
        if (modularFactors.size() == 1) {
            return Collections.singletonList(poly.setRing(new IntegersZp(lifter.finalModulus)).monic());
        }
        UnivariatePolynomialZp64 factory = modularFactors.get(0);
        UnivariatePolynomialZp64 aFactor = (UnivariatePolynomialZp64)factory.createOne();
        UnivariatePolynomialZp64 bFactor = (UnivariatePolynomialZp64)factory.createOne();
        int nHalf = modularFactors.size() / 2;
        for (i = 0; i < nHalf; ++i) {
            aFactor = aFactor.multiply(modularFactors.get(i));
        }
        while (i < modularFactors.size()) {
            bFactor = bFactor.multiply(modularFactors.get(i));
            ++i;
        }
        UnivariatePolynomial<BigInteger>[] lifted = lifter.lift(poly, aFactor, bFactor);
        UnivariatePolynomial<BigInteger> aFactorRaised = lifted[0];
        UnivariatePolynomial<BigInteger> bFactorRaised = lifted[1];
        ArrayList<UnivariatePolynomial<BigInteger>> result = new ArrayList<UnivariatePolynomial<BigInteger>>();
        result.addAll(HenselLifting.liftFactorization(UnivariatePolynomial.asPolyZSymmetric(aFactorRaised), modularFactors.subList(0, nHalf), lifter));
        result.addAll(HenselLifting.liftFactorization(UnivariatePolynomial.asPolyZSymmetric(bFactorRaised), modularFactors.subList(nHalf, modularFactors.size()), lifter));
        return result;
    }

    private static <T extends IUnivariatePolynomial<T>> void assertHenselLift(LiftableQuintet<T> lift) {
        assert (lift.polyMod().equals(lift.aFactorMod().clone().multiply(lift.bFactorMod()))) : lift.toString();
        assert (lift.aCoFactorMod() == null && lift.bCoFactorMod() == null || ((IUnivariatePolynomial)lift.aFactorMod().clone().multiply(lift.aCoFactorMod())).add((IUnivariatePolynomial)lift.bFactorMod().clone().multiply(lift.bCoFactorMod())).isOne()) : ((IUnivariatePolynomial)lift.aFactorMod().clone().multiply(lift.aCoFactorMod())).add((IUnivariatePolynomial)lift.bFactorMod().clone().multiply(lift.bCoFactorMod())) + "  --- " + ((UnivariatePolynomial)lift.aFactorMod()).ring;
    }

    public static final class bLinearLift
    extends LinearLiftAbstract<UnivariatePolynomial<BigInteger>>
    implements LiftableQuintet<UnivariatePolynomial<BigInteger>> {
        public final IntegersZp initialDomain;
        public IntegersZp ring;

        private bLinearLift(BigInteger modulus, UnivariatePolynomial<BigInteger> poly, UnivariatePolynomialZp64 aFactor, UnivariatePolynomialZp64 aFactorMonic, UnivariatePolynomialZp64 bFactor, UnivariatePolynomialZp64 aCoFactor, UnivariatePolynomialZp64 bCoFactor) {
            super(poly, ((UnivariatePolynomialZp64)HenselLifting.ensureMonic(aFactor)).asPolyZ(true).toBigPoly().multiply(poly.lc()), bFactor.asPolyZ(false).toBigPoly(), aCoFactor.asPolyZ(false).toBigPoly(), bCoFactor.asPolyZ(false).toBigPoly(), aFactor, aFactorMonic, bFactor, aCoFactor, bCoFactor);
            this.initialDomain = new IntegersZp(modulus);
            this.ring = new IntegersZp(modulus);
            assert (modulus.isLong());
        }

        private bLinearLift(BigInteger modulus, UnivariatePolynomial<BigInteger> poly, UnivariatePolynomialZp64 aFactor, UnivariatePolynomialZp64 bFactor, UnivariatePolynomialZp64 aCoFactor, UnivariatePolynomialZp64 bCoFactor) {
            this(modulus, poly, aFactor, aFactor.clone().monic(), bFactor, aCoFactor, bCoFactor);
        }

        @Override
        public UnivariatePolynomial<BigInteger> polyMod() {
            return ((UnivariatePolynomial)this.poly).setRing(this.ring);
        }

        @Override
        public UnivariatePolynomial<BigInteger> aFactorMod() {
            return ((UnivariatePolynomial)this.aFactor).setRing(this.ring);
        }

        @Override
        public UnivariatePolynomial<BigInteger> bFactorMod() {
            return ((UnivariatePolynomial)this.bFactor).setRing(this.ring);
        }

        @Override
        public UnivariatePolynomial<BigInteger> aCoFactorMod() {
            return this.aCoFactor == null ? null : ((UnivariatePolynomial)this.aCoFactor).setRing(this.ring);
        }

        @Override
        public UnivariatePolynomial<BigInteger> bCoFactorMod() {
            return this.bCoFactor == null ? null : ((UnivariatePolynomial)this.bCoFactor).setRing(this.ring);
        }

        private void liftFactors() {
            UnivariatePolynomialZp64 factorsDiff = UnivariatePolynomial.asOverZp64(((UnivariatePolynomial)((UnivariatePolynomial)this.poly).clone()).subtract(((UnivariatePolynomial)((UnivariatePolynomial)this.aFactor).clone()).multiply((UnivariatePolynomial)this.bFactor)).divideOrNull(this.ring.modulus).setRing(this.initialDomain));
            this.calculateFactorsDiff(factorsDiff);
            this.aFactor = ((UnivariatePolynomial)this.aFactor).add(this.aAdd.asPolyZ(false).toBigPoly().multiply(this.ring.modulus));
            this.bFactor = ((UnivariatePolynomial)this.bFactor).add(this.bAdd.asPolyZ(false).toBigPoly().multiply(this.ring.modulus));
        }

        private void liftCoFactors() {
            UnivariatePolynomialZp64 coFactorsDiff = UnivariatePolynomial.asOverZp64(((UnivariatePolynomial)((UnivariatePolynomial)((UnivariatePolynomial)((UnivariatePolynomial)this.aCoFactor).clone()).multiply((UnivariatePolynomial)this.aFactor).add(((UnivariatePolynomial)((UnivariatePolynomial)this.bCoFactor).clone()).multiply((UnivariatePolynomial)this.bFactor)).decrement()).negate()).divideOrNull(this.ring.modulus).setRing(this.initialDomain));
            this.calculateCoFactorsDiff(coFactorsDiff);
            this.aCoFactor = ((UnivariatePolynomial)this.aCoFactor).add(this.aAdd.asPolyZ(false).toBigPoly().multiply(this.ring.modulus));
            this.bCoFactor = ((UnivariatePolynomial)this.bCoFactor).add(this.bAdd.asPolyZ(false).toBigPoly().multiply(this.ring.modulus));
        }

        @Override
        public void lift() {
            this.liftFactors();
            this.liftCoFactors();
            this.ring = new IntegersZp(this.ring.modulus.multiply(this.initialDomain.modulus));
        }

        @Override
        public void liftLast() {
            this.liftFactors();
            this.ring = new IntegersZp(this.ring.modulus.multiply(this.initialDomain.modulus));
            this.bCoFactor = null;
            this.aCoFactor = null;
        }
    }

    public static final class lLinearLift
    extends LinearLiftAbstract<UnivariatePolynomialZ64>
    implements LiftableQuintet<UnivariatePolynomialZp64> {
        public final long initialModulus;
        public long modulus;

        private lLinearLift(long modulus, UnivariatePolynomialZ64 poly, UnivariatePolynomialZp64 aFactor, UnivariatePolynomialZp64 aFactorMonic, UnivariatePolynomialZp64 bFactor, UnivariatePolynomialZp64 aCoFactor, UnivariatePolynomialZp64 bCoFactor) {
            super(poly, (UnivariatePolynomialZ64)((UnivariatePolynomialZp64)HenselLifting.ensureMonic(aFactor)).asPolyZ(true).multiply(poly.lc()), bFactor.asPolyZ(true), aCoFactor.asPolyZ(true), bCoFactor.asPolyZ(true), aFactor, aFactorMonic, bFactor, aCoFactor, bCoFactor);
            this.initialModulus = modulus;
            this.modulus = modulus;
        }

        private lLinearLift(long modulus, UnivariatePolynomialZ64 poly, UnivariatePolynomialZp64 aFactor, UnivariatePolynomialZp64 bFactor, UnivariatePolynomialZp64 aCoFactor, UnivariatePolynomialZp64 bCoFactor) {
            this(modulus, poly, aFactor, aFactor.clone().monic(), bFactor, aCoFactor, bCoFactor);
        }

        @Override
        public UnivariatePolynomialZp64 polyMod() {
            return ((UnivariatePolynomialZ64)this.poly).modulus(this.modulus);
        }

        @Override
        public UnivariatePolynomialZp64 aFactorMod() {
            return ((UnivariatePolynomialZ64)this.aFactor).modulus(this.modulus);
        }

        @Override
        public UnivariatePolynomialZp64 bFactorMod() {
            return ((UnivariatePolynomialZ64)this.bFactor).modulus(this.modulus);
        }

        @Override
        public UnivariatePolynomialZp64 aCoFactorMod() {
            return this.aCoFactor == null ? null : ((UnivariatePolynomialZ64)this.aCoFactor).modulus(this.modulus);
        }

        @Override
        public UnivariatePolynomialZp64 bCoFactorMod() {
            return this.bCoFactor == null ? null : ((UnivariatePolynomialZ64)this.bCoFactor).modulus(this.modulus);
        }

        private void liftFactors() {
            UnivariatePolynomialZp64 factorsDiff = ((UnivariatePolynomialZ64)this.poly).clone().subtract(((UnivariatePolynomialZ64)this.aFactor).clone().multiply((UnivariatePolynomialZ64)this.bFactor)).divideOrNull(this.modulus).modulus(this.initialModulus);
            this.calculateFactorsDiff(factorsDiff);
            this.aFactor = ((UnivariatePolynomialZ64)this.aFactor).add((UnivariatePolynomialZ64)this.aAdd.asPolyZ(false).multiply(this.modulus));
            this.bFactor = ((UnivariatePolynomialZ64)this.bFactor).add((UnivariatePolynomialZ64)this.bAdd.asPolyZ(false).multiply(this.modulus));
        }

        private void liftCoFactors() {
            UnivariatePolynomialZp64 coFactorsDiff = ((UnivariatePolynomialZ64)((UnivariatePolynomialZ64)((UnivariatePolynomialZ64)this.aCoFactor).clone().multiply((UnivariatePolynomialZ64)this.aFactor).add(((UnivariatePolynomialZ64)this.bCoFactor).clone().multiply((UnivariatePolynomialZ64)this.bFactor)).decrement()).negate()).divideOrNull(this.modulus).modulus(this.initialModulus);
            this.calculateCoFactorsDiff(coFactorsDiff);
            this.aCoFactor = ((UnivariatePolynomialZ64)this.aCoFactor).add((UnivariatePolynomialZ64)this.aAdd.asPolyZ(false).multiply(this.modulus));
            this.bCoFactor = ((UnivariatePolynomialZ64)this.bCoFactor).add((UnivariatePolynomialZ64)this.bAdd.asPolyZ(false).multiply(this.modulus));
        }

        @Override
        public void lift() {
            this.liftFactors();
            this.liftCoFactors();
            this.modulus = MachineArithmetic.safeMultiply(this.modulus, this.initialModulus);
        }

        @Override
        public void liftLast() {
            this.liftFactors();
            this.modulus = MachineArithmetic.safeMultiply(this.modulus, this.initialModulus);
            this.bCoFactor = null;
            this.aCoFactor = null;
        }
    }

    private static class LinearLiftAbstract<PolyZ extends IUnivariatePolynomial<PolyZ>> {
        final PolyZ poly;
        PolyZ aFactor;
        PolyZ bFactor;
        PolyZ aCoFactor;
        PolyZ bCoFactor;
        final UnivariatePolynomialZp64 aFactorMod;
        final UnivariatePolynomialZp64 aFactorModMonic;
        final UnivariatePolynomialZp64 bFactorMod;
        final UnivariatePolynomialZp64 aCoFactorMod;
        final UnivariatePolynomialZp64 bCoFactorMod;
        final UnivariateDivision.InverseModMonomial<UnivariatePolynomialZp64> aFactorModMonicInv;
        final UnivariateDivision.InverseModMonomial<UnivariatePolynomialZp64> bFactorModInv;
        protected UnivariatePolynomialZp64 aAdd;
        protected UnivariatePolynomialZp64 bAdd;

        public LinearLiftAbstract(PolyZ poly, PolyZ aFactor, PolyZ bFactor, PolyZ aCoFactor, PolyZ bCoFactor, UnivariatePolynomialZp64 aFactorMod, UnivariatePolynomialZp64 aFactorModMonic, UnivariatePolynomialZp64 bFactorMod, UnivariatePolynomialZp64 aCoFactorMod, UnivariatePolynomialZp64 bCoFactorMod) {
            assert (bFactor.isMonic());
            this.poly = poly;
            this.aFactor = aFactor;
            this.bFactor = bFactor;
            this.aCoFactor = aCoFactor;
            this.bCoFactor = bCoFactor;
            this.aFactorMod = aFactorMod;
            this.aFactorModMonic = aFactorModMonic;
            this.bFactorMod = bFactorMod;
            this.aCoFactorMod = aCoFactorMod;
            this.bCoFactorMod = bCoFactorMod;
            this.aFactorModMonicInv = UnivariateDivision.fastDivisionPreConditioning(aFactorModMonic);
            this.bFactorModInv = UnivariateDivision.fastDivisionPreConditioning(bFactorMod);
        }

        final void calculateFactorsDiff(UnivariatePolynomialZp64 diff) {
            this.aAdd = diff.clone();
            this.aAdd = UnivariatePolynomialArithmetic.polyMod(this.aAdd, this.aFactorModMonic, this.aFactorModMonicInv, false);
            this.aAdd = this.aAdd.multiply(this.bCoFactorMod);
            this.aAdd = UnivariatePolynomialArithmetic.polyMod(this.aAdd, this.aFactorModMonic, this.aFactorModMonicInv, false);
            this.bAdd = diff.clone();
            this.bAdd = UnivariatePolynomialArithmetic.polyMod(this.bAdd, this.bFactorMod, this.bFactorModInv, false);
            this.bAdd = this.bAdd.multiply(this.aCoFactorMod);
            this.bAdd = UnivariatePolynomialArithmetic.polyMod(this.bAdd, this.bFactorMod, this.bFactorModInv, false);
        }

        final void calculateCoFactorsDiff(UnivariatePolynomialZp64 diff) {
            this.aAdd = diff.clone();
            this.aAdd = UnivariatePolynomialArithmetic.polyMod(this.aAdd, this.bFactorMod, this.bFactorModInv, false);
            this.aAdd = this.aAdd.multiply(this.aCoFactorMod);
            this.aAdd = UnivariatePolynomialArithmetic.polyMod(this.aAdd, this.bFactorMod, this.bFactorModInv, false);
            this.bAdd = diff.clone();
            this.bAdd = UnivariatePolynomialArithmetic.polyMod(this.bAdd, this.aFactorModMonic, this.aFactorModMonicInv, false);
            this.bAdd = this.bAdd.multiply(this.bCoFactorMod);
            this.bAdd = UnivariatePolynomialArithmetic.polyMod(this.bAdd, this.aFactorModMonic, this.aFactorModMonicInv, false);
        }
    }

    public static final class bQuadraticLift
    extends QuadraticLiftAbstract<UnivariatePolynomial<BigInteger>> {
        public IntegersZp ring;
        public final UnivariatePolynomial<BigInteger> base;

        public bQuadraticLift(BigInteger modulus, UnivariatePolynomial<BigInteger> base, UnivariatePolynomial<BigInteger> aFactor, UnivariatePolynomial<BigInteger> bFactor, UnivariatePolynomial<BigInteger> aCoFactor, UnivariatePolynomial<BigInteger> bCoFactor) {
            super(aFactor, bFactor, aCoFactor, bCoFactor);
            this.ring = new IntegersZp(modulus);
            this.base = base;
        }

        @Override
        public UnivariatePolynomial<BigInteger> polyMod() {
            return this.base.setRing(this.ring);
        }

        @Override
        void prepare() {
            this.ring = new IntegersZp(this.ring.modulus.multiply(this.ring.modulus));
            this.aFactor = ((UnivariatePolynomial)this.aFactor).setRingUnsafe(this.ring);
            this.bFactor = ((UnivariatePolynomial)this.bFactor).setRingUnsafe(this.ring);
            this.aCoFactor = ((UnivariatePolynomial)this.aCoFactor).setRingUnsafe(this.ring);
            this.bCoFactor = ((UnivariatePolynomial)this.bCoFactor).setRingUnsafe(this.ring);
        }
    }

    public static final class lQuadraticLift
    extends QuadraticLiftAbstract<UnivariatePolynomialZp64> {
        public long modulus;
        public final UnivariatePolynomialZ64 base;

        public lQuadraticLift(long modulus, UnivariatePolynomialZ64 base, UnivariatePolynomialZp64 aFactor, UnivariatePolynomialZp64 bFactor, UnivariatePolynomialZp64 aCoFactor, UnivariatePolynomialZp64 bCoFactor) {
            super(aFactor, bFactor, aCoFactor, bCoFactor);
            this.modulus = modulus;
            this.base = base;
        }

        @Override
        public UnivariatePolynomialZp64 polyMod() {
            return this.base.modulus(this.modulus, true);
        }

        @Override
        void prepare() {
            this.modulus = MachineArithmetic.safeMultiply(this.modulus, this.modulus);
            this.aFactor = ((UnivariatePolynomialZp64)this.aFactor).setModulusUnsafe(this.modulus);
            this.bFactor = ((UnivariatePolynomialZp64)this.bFactor).setModulusUnsafe(this.modulus);
            this.aCoFactor = ((UnivariatePolynomialZp64)this.aCoFactor).setModulusUnsafe(this.modulus);
            this.bCoFactor = ((UnivariatePolynomialZp64)this.bCoFactor).setModulusUnsafe(this.modulus);
        }
    }

    static abstract class QuadraticLiftAbstract<PolyZp extends IUnivariatePolynomial<PolyZp>>
    implements LiftableQuintet<PolyZp> {
        protected PolyZp aFactor;
        protected PolyZp bFactor;
        protected PolyZp aCoFactor;
        protected PolyZp bCoFactor;

        public QuadraticLiftAbstract(PolyZp aFactor, PolyZp bFactor, PolyZp aCoFactor, PolyZp bCoFactor) {
            this.aFactor = aFactor;
            this.bFactor = bFactor;
            this.aCoFactor = aCoFactor;
            this.bCoFactor = bCoFactor;
        }

        @Override
        public PolyZp aFactorMod() {
            return this.aFactor;
        }

        @Override
        public PolyZp bFactorMod() {
            return this.bFactor;
        }

        @Override
        public PolyZp aCoFactorMod() {
            return this.aCoFactor;
        }

        @Override
        public PolyZp bCoFactorMod() {
            return this.bCoFactor;
        }

        abstract void prepare();

        @Override
        public final void lift() {
            this.prepare();
            this.henselStep0(this.polyMod());
        }

        @Override
        public final void liftLast() {
            this.prepare();
            this.henselLastStep0(this.polyMod());
        }

        private void henselStep0(PolyZp baseMod) {
            IUnivariatePolynomial e = baseMod.subtract((IUnivariatePolynomial)((IUnivariatePolynomial)this.aFactor.clone().multiply(this.bFactor)));
            IUnivariatePolynomial[] qr = UnivariateDivision.divideAndRemainder((IUnivariatePolynomial)this.aCoFactor.clone().multiply(e), this.bFactor, (boolean)false);
            IUnivariatePolynomial q = qr[0];
            IUnivariatePolynomial r = qr[1];
            IUnivariatePolynomial aFactorNew = this.aFactor.clone().add(this.bCoFactor.clone().multiply(e)).add(this.aFactor.clone().multiply(q));
            IUnivariatePolynomial bFactorNew = this.bFactor.clone().add(r);
            IUnivariatePolynomial b = (IUnivariatePolynomial)this.aCoFactor.clone().multiply(aFactorNew).add(this.bCoFactor.clone().multiply(bFactorNew)).decrement();
            IUnivariatePolynomial[] cd = UnivariateDivision.divideAndRemainder((IUnivariatePolynomial)this.aCoFactor.clone().multiply(b), (IUnivariatePolynomial)bFactorNew, (boolean)false);
            IUnivariatePolynomial c = cd[0];
            IUnivariatePolynomial d = cd[1];
            IUnivariatePolynomial aCoFactorNew = this.aCoFactor.subtract((IUnivariatePolynomial)d);
            IUnivariatePolynomial bCoFactorNew = this.bCoFactor.subtract((IUnivariatePolynomial)this.bCoFactor.clone().multiply(b)).subtract(c.clone().multiply(aFactorNew));
            assert (aFactorNew.degree() == this.aFactor.degree()) : String.format("%s > %s", aFactorNew.degree(), this.aFactor.degree());
            assert (bFactorNew.degree() == this.bFactor.degree()) : String.format("%s > %s", bFactorNew.degree(), this.bFactor.degree());
            this.aFactor = aFactorNew;
            this.aCoFactor = aCoFactorNew;
            this.bFactor = bFactorNew;
            this.bCoFactor = bCoFactorNew;
            assert (this.bFactor.isMonic());
            assert (this.aCoFactor.degree() < this.bFactor.degree());
            assert (this.bCoFactor.degree() < this.aFactor.degree());
        }

        private void henselLastStep0(PolyZp baseMod) {
            IUnivariatePolynomial e = baseMod.subtract((IUnivariatePolynomial)((IUnivariatePolynomial)this.aFactor.clone().multiply(this.bFactor)));
            IUnivariatePolynomial[] qr = UnivariateDivision.divideAndRemainder((IUnivariatePolynomial)this.aCoFactor.multiply((IUnivariatePolynomial)e), this.bFactor, (boolean)false);
            IUnivariatePolynomial q = qr[0];
            IUnivariatePolynomial r = qr[1];
            IUnivariatePolynomial aFactorNew = this.aFactor.add((IUnivariatePolynomial)this.bCoFactor.multiply((IUnivariatePolynomial)e)).add(this.aFactor.clone().multiply(q));
            IUnivariatePolynomial bFactorNew = this.bFactor.add((IUnivariatePolynomial)r);
            this.aFactor = aFactorNew;
            this.aCoFactor = null;
            this.bFactor = bFactorNew;
            this.bCoFactor = null;
            assert (this.bFactor.isMonic());
        }
    }

    private static final class AdaptiveLift {
        final BigInteger initialModulus;
        final BigInteger finalModulus;
        final int nLinearIterations;
        final int nQuadraticIterations;

        public AdaptiveLift(BigInteger initialModulus, BigInteger desiredBound) {
            this.initialModulus = initialModulus;
            LiftingInfo nLinearIterations = HenselLifting.nIterations(initialModulus, desiredBound, false);
            if (nLinearIterations.nIterations < 64) {
                this.nLinearIterations = nLinearIterations.nIterations;
                this.nQuadraticIterations = -1;
                this.finalModulus = nLinearIterations.finalModulus;
            } else {
                LiftingInfo nQuadraticIterations = HenselLifting.nIterations(initialModulus, desiredBound, true);
                this.nLinearIterations = -1;
                this.nQuadraticIterations = nQuadraticIterations.nIterations;
                this.finalModulus = nQuadraticIterations.finalModulus;
            }
        }

        UnivariatePolynomial<BigInteger>[] lift(UnivariatePolynomial<BigInteger> poly, UnivariatePolynomialZp64 a, UnivariatePolynomialZp64 b) {
            boolean quadratic = this.nLinearIterations == -1;
            bLinearLift lift = quadratic ? HenselLifting.createQuadraticLift(this.initialModulus, poly, a.toBigPoly(), b.toBigPoly()) : HenselLifting.createLinearLift(this.initialModulus, poly, a, b);
            lift.lift(quadratic ? this.nQuadraticIterations : this.nLinearIterations);
            return new UnivariatePolynomial[]{(UnivariatePolynomial)lift.aFactorMod(), (UnivariatePolynomial)lift.bFactorMod()};
        }
    }

    static final class LiftingInfo {
        final int nIterations;
        final BigInteger finalModulus;

        private LiftingInfo(int nIterations, BigInteger finalModulus) {
            this.nIterations = nIterations;
            this.finalModulus = finalModulus;
        }
    }

    static interface LiftFactory<PolyZp extends IUnivariatePolynomial<PolyZp>> {
        public LiftableQuintet<UnivariatePolynomial<BigInteger>> createLift(BigInteger var1, UnivariatePolynomial<BigInteger> var2, PolyZp var3, PolyZp var4);
    }

    public static interface LiftableQuintet<PolyZp extends IUnivariatePolynomial<PolyZp>> {
        public PolyZp polyMod();

        public PolyZp aFactorMod();

        public PolyZp bFactorMod();

        public PolyZp aCoFactorMod();

        public PolyZp bCoFactorMod();

        public void lift();

        public void liftLast();

        default public void lift(int nIterations) {
            for (int i = 0; i < nIterations - 1; ++i) {
                this.lift();
            }
            this.liftLast();
        }

        default public void liftWithCoFactors(int nIterations) {
            for (int i = 0; i < nIterations; ++i) {
                this.lift();
            }
        }
    }
}

