/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.rings.ChineseRemainders;
import cc.redberry.rings.Integers;
import cc.redberry.rings.IntegersZp;
import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Rational;
import cc.redberry.rings.RationalReconstruction;
import cc.redberry.rings.Ring;
import cc.redberry.rings.Rings;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.bigint.BigIntegerUtil;
import cc.redberry.rings.poly.AlgebraicNumberField;
import cc.redberry.rings.poly.FiniteField;
import cc.redberry.rings.poly.IPolynomial;
import cc.redberry.rings.poly.MachineArithmetic;
import cc.redberry.rings.poly.MultipleFieldExtension;
import cc.redberry.rings.poly.MultivariateRing;
import cc.redberry.rings.poly.SimpleFieldExtension;
import cc.redberry.rings.poly.UnivariateRing;
import cc.redberry.rings.poly.Util;
import cc.redberry.rings.poly.multivar.AMonomial;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.MultivariateGCD;
import cc.redberry.rings.poly.univar.Conversions64bit;
import cc.redberry.rings.poly.univar.IUnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariateDivision;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZ64;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import cc.redberry.rings.poly.univar.UnivariateResultants;
import cc.redberry.rings.primes.PrimesIterator;
import cc.redberry.rings.primes.SmallPrimes;
import cc.redberry.rings.util.ArraysUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class UnivariateGCD {
    static int SWITCH_TO_HALF_GCD_ALGORITHM_DEGREE = 180;
    static int SWITCH_TO_HALF_GCD_H_MATRIX_DEGREE = 25;

    private UnivariateGCD() {
    }

    public static <T extends IUnivariatePolynomial<T>> T PolynomialGCD(T a, T b) {
        a.assertSameCoefficientRingWith(b);
        if (Util.isOverMultipleFieldExtension(a)) {
            return (T)UnivariateGCD.PolynomialGCDInMultipleFieldExtension((UnivariatePolynomial)a, (UnivariatePolynomial)b);
        }
        if (a.isOverFiniteField()) {
            return UnivariateGCD.HalfGCD(a, b);
        }
        if (a instanceof UnivariatePolynomialZ64) {
            return (T)UnivariateGCD.ModularGCD((UnivariatePolynomialZ64)a, (UnivariatePolynomialZ64)b);
        }
        if (a.isOverZ()) {
            return (T)UnivariateGCD.ModularGCD((UnivariatePolynomial)a, (UnivariatePolynomial)b);
        }
        if (Util.isOverRationals(a)) {
            return (T)UnivariateGCD.PolynomialGCDInQ((UnivariatePolynomial)a, (UnivariatePolynomial)b);
        }
        if (Util.isOverRingOfIntegersOfSimpleNumberField(a)) {
            return (T)UnivariateGCD.PolynomialGCDInRingOfIntegersOfNumberField((UnivariatePolynomial)a, (UnivariatePolynomial)b);
        }
        if (Util.isOverSimpleNumberField(a)) {
            return (T)UnivariateGCD.PolynomialGCDInNumberField((UnivariatePolynomial)a, (UnivariatePolynomial)b);
        }
        if (a.isOverField()) {
            return UnivariateGCD.HalfGCD(a, b);
        }
        T r = UnivariateGCD.tryNested(a, b);
        if (r != null) {
            return r;
        }
        T t = UnivariateGCD.trivialGCD(a, b);
        if (t != null) {
            return t;
        }
        return (T)UnivariateResultants.SubresultantPRS((UnivariatePolynomial)a, (UnivariatePolynomial)b).gcd();
    }

    private static <T extends IUnivariatePolynomial<T>> T trivialGCD(T a, T b) {
        if (a.isConstant() || b.isConstant()) {
            if (a.isOverField()) {
                return (T)((IUnivariatePolynomial)a.createOne());
            }
            if (a instanceof UnivariatePolynomialZ64) {
                return (T)((IUnivariatePolynomial)a.createConstant(MachineArithmetic.gcd(((UnivariatePolynomialZ64)a).content(), ((UnivariatePolynomialZ64)b).content())));
            }
            if (a instanceof UnivariatePolynomial) {
                return (T)((UnivariatePolynomial)a).createConstant(((UnivariatePolynomial)a).ring.gcd(((UnivariatePolynomial)a).content(), ((UnivariatePolynomial)b).content()));
            }
        }
        return null;
    }

    private static <T extends IUnivariatePolynomial<T>> T tryNested(T a, T b) {
        if (a instanceof UnivariatePolynomial && ((UnivariatePolynomial)a).ring instanceof MultivariateRing) {
            return (T)UnivariateGCD.PolynomialGCDOverMultivariate((UnivariatePolynomial)a, (UnivariatePolynomial)b);
        }
        return null;
    }

    private static <Term extends AMonomial<Term>, Poly extends AMultivariatePolynomial<Term, Poly>> UnivariatePolynomial<Poly> PolynomialGCDOverMultivariate(UnivariatePolynomial<Poly> a, UnivariatePolynomial<Poly> b) {
        return ((AMultivariatePolynomial)MultivariateGCD.PolynomialGCD(AMultivariatePolynomial.asMultivariate(a, 0, true), AMultivariatePolynomial.asMultivariate(b, 0, true))).asUnivariateEliminate(0);
    }

    private static <E> UnivariatePolynomial<Rational<E>> PolynomialGCDInQ(UnivariatePolynomial<Rational<E>> a, UnivariatePolynomial<Rational<E>> b) {
        Util.Tuple2<UnivariatePolynomial<E>, E> aRat = Util.toCommonDenominator(a);
        Util.Tuple2<UnivariatePolynomial<E>, E> bRat = Util.toCommonDenominator(b);
        return Util.asOverRationals(a.ring, UnivariateGCD.PolynomialGCD((UnivariatePolynomial)aRat._1, (UnivariatePolynomial)bRat._1)).monic();
    }

    private static <Term extends AMonomial<Term>, mPoly extends AMultivariatePolynomial<Term, mPoly>, sPoly extends IUnivariatePolynomial<sPoly>> UnivariatePolynomial<mPoly> PolynomialGCDInMultipleFieldExtension(UnivariatePolynomial<mPoly> a, UnivariatePolynomial<mPoly> b) {
        MultipleFieldExtension ring = (MultipleFieldExtension)a.ring;
        SimpleFieldExtension simpleExtension = ring.getSimpleExtension();
        return UnivariateGCD.PolynomialGCD(a.mapCoefficients(simpleExtension, ring::inverse), b.mapCoefficients(simpleExtension, ring::inverse)).mapCoefficients(ring, ring::image);
    }

    public static <T extends IUnivariatePolynomial<T>> T[] PolynomialExtendedGCD(T a, T b) {
        if (Util.isOverQ(a)) {
            return UnivariateGCD.ModularExtendedResultantGCDInQ((UnivariatePolynomial)a, (UnivariatePolynomial)b);
        }
        if (a.isOverZ()) {
            return UnivariateGCD.ModularExtendedResultantGCDInZ((UnivariatePolynomial)a, (UnivariatePolynomial)b);
        }
        if (a.isOverField()) {
            return UnivariateGCD.ExtendedHalfGCD(a, b);
        }
        throw new IllegalArgumentException("Polynomial over field is expected");
    }

    public static <T extends IUnivariatePolynomial<T>> T[] PolynomialFirstBezoutCoefficient(T a, T b) {
        if (a.isOverFiniteField() && Math.min(a.degree(), b.degree()) < 384) {
            return UnivariateGCD.EuclidFirstBezoutCoefficient(a, b);
        }
        return Arrays.copyOf(UnivariateGCD.PolynomialExtendedGCD(a, b), 2);
    }

    static UnivariatePolynomial<BigInteger>[] PolynomialExtendedGCDInZbyQ(UnivariatePolynomial<BigInteger> a, UnivariatePolynomial<BigInteger> b) {
        UnivariatePolynomial[] xgcd = (UnivariatePolynomial[])UnivariateGCD.PolynomialExtendedGCD(a.mapCoefficients(Rings.Q, Rings.Q::mkNumerator), b.mapCoefficients(Rings.Q, Rings.Q::mkNumerator));
        Util.Tuple2 gcd = Util.toCommonDenominator(xgcd[0]);
        Util.Tuple2 s = Util.toCommonDenominator(xgcd[1]);
        Util.Tuple2 t = Util.toCommonDenominator(xgcd[2]);
        BigInteger lcm = Rings.Z.lcm((BigInteger)gcd._2, (BigInteger)s._2, (BigInteger)t._2);
        return new UnivariatePolynomial[]{((UnivariatePolynomial)gcd._1).multiply(lcm.divideExact((BigInteger)gcd._2)), ((UnivariatePolynomial)s._1).multiply(lcm.divideExact((BigInteger)s._2)), ((UnivariatePolynomial)t._1).multiply(lcm.divideExact((BigInteger)t._2))};
    }

    public static <T extends IUnivariatePolynomial<T>> T PolynomialGCD(T ... polynomials) {
        T gcd = polynomials[0];
        for (int i = 1; i < polynomials.length; ++i) {
            gcd = UnivariateGCD.PolynomialGCD(gcd, polynomials[i]);
        }
        return gcd;
    }

    public static <T extends IUnivariatePolynomial<T>> T PolynomialGCD(Iterable<T> polynomials) {
        IUnivariatePolynomial gcd = null;
        for (IUnivariatePolynomial poly : polynomials) {
            gcd = gcd == null ? poly : UnivariateGCD.PolynomialGCD(gcd, poly);
        }
        return (T)gcd;
    }

    private static <T extends IUnivariatePolynomial<T>> T TrivialGCD(T a, T b) {
        if (a.isZero()) {
            return (T)UnivariateGCD.normalizeGCD(b.clone());
        }
        if (b.isZero()) {
            return (T)UnivariateGCD.normalizeGCD(a.clone());
        }
        if (a.isOne()) {
            return (T)a.clone();
        }
        if (b.isOne()) {
            return (T)b.clone();
        }
        if (a == b) {
            return (T)UnivariateGCD.normalizeGCD(a.clone());
        }
        return null;
    }

    public static <T extends IUnivariatePolynomial<T>> T EuclidGCD(T a, T b) {
        a.assertSameCoefficientRingWith(b);
        T trivialGCD = UnivariateGCD.TrivialGCD(a, b);
        if (trivialGCD != null) {
            return trivialGCD;
        }
        if (Conversions64bit.canConvertToZp64(a)) {
            return Conversions64bit.convert(UnivariateGCD.EuclidGCD(Conversions64bit.asOverZp64(a), Conversions64bit.asOverZp64(b)));
        }
        if (a.degree() < b.degree()) {
            return UnivariateGCD.EuclidGCD(b, a);
        }
        T x = a;
        T y = b;
        while (true) {
            T r;
            if ((r = UnivariateDivision.remainder(x, y, true)) == null) {
                throw new ArithmeticException("Not divisible with remainder: (" + x + ") / (" + y + ")");
            }
            if (r.isZero()) break;
            x = y;
            y = r;
        }
        return (T)UnivariateGCD.normalizeGCD(y == a ? y.clone() : (y == b ? y.clone() : y));
    }

    private static <T extends IUnivariatePolynomial<T>> T normalizeGCD(T gcd) {
        if (gcd.isOverField()) {
            return (T)((IUnivariatePolynomial)gcd.monic());
        }
        return gcd;
    }

    public static <T extends IUnivariatePolynomial<T>> T[] ExtendedEuclidGCD(T a, T b) {
        a.assertSameCoefficientRingWith(b);
        if (Conversions64bit.canConvertToZp64(a)) {
            return Conversions64bit.convert(a, (UnivariatePolynomialZp64[])((UnivariatePolynomialZp64[])UnivariateGCD.ExtendedEuclidGCD((IUnivariatePolynomial)Conversions64bit.asOverZp64(a), (IUnivariatePolynomial)Conversions64bit.asOverZp64(b))));
        }
        IUnivariatePolynomial s = (IUnivariatePolynomial)a.createZero();
        IUnivariatePolynomial old_s = (IUnivariatePolynomial)a.createOne();
        IUnivariatePolynomial t = (IUnivariatePolynomial)a.createOne();
        IUnivariatePolynomial old_t = (IUnivariatePolynomial)a.createZero();
        IPolynomial r = b.clone();
        IPolynomial old_r = a.clone();
        while (!r.isZero()) {
            IPolynomial q = UnivariateDivision.quotient(old_r, r, true);
            if (q == null) {
                throw new ArithmeticException("Not divisible with remainder: (" + old_r + ") / (" + r + ")");
            }
            IPolynomial tmp = old_r;
            old_r = r;
            r = tmp.clone().subtract((IUnivariatePolynomial)q.clone().multiply(r));
            tmp = old_s;
            old_s = s;
            s = tmp.clone().subtract(q.clone().multiply(s));
            tmp = old_t;
            old_t = t;
            t = tmp.clone().subtract(q.clone().multiply(t));
        }
        assert (old_r.equals(a.clone().multiply(old_s).add(b.clone().multiply(old_t)))) : a.clone().multiply(old_s).add(b.clone().multiply(old_t));
        IUnivariatePolynomial[] result = (IUnivariatePolynomial[])a.createArray(3);
        result[0] = old_r;
        result[1] = old_s;
        result[2] = old_t;
        return UnivariateGCD.normalizeExtendedGCD((IUnivariatePolynomial[])result);
    }

    static <T extends IUnivariatePolynomial<T>> T[] normalizeExtendedGCD(T[] xgcd) {
        if (!xgcd[0].isOverField()) {
            return xgcd;
        }
        if (xgcd[0].isZero()) {
            return xgcd;
        }
        xgcd[1].divideByLC(xgcd[0]);
        if (xgcd.length > 2) {
            xgcd[2].divideByLC(xgcd[0]);
        }
        xgcd[0].monic();
        return xgcd;
    }

    public static <T extends IUnivariatePolynomial<T>> T[] EuclidFirstBezoutCoefficient(T a, T b) {
        a.assertSameCoefficientRingWith(b);
        if (Conversions64bit.canConvertToZp64(a)) {
            return Conversions64bit.convert(a, (UnivariatePolynomialZp64[])((UnivariatePolynomialZp64[])UnivariateGCD.EuclidFirstBezoutCoefficient((IUnivariatePolynomial)Conversions64bit.asOverZp64(a), (IUnivariatePolynomial)Conversions64bit.asOverZp64(b))));
        }
        IUnivariatePolynomial s = (IUnivariatePolynomial)a.createZero();
        IUnivariatePolynomial old_s = (IUnivariatePolynomial)a.createOne();
        T r = b;
        T old_r = a;
        while (!r.isZero()) {
            T q = UnivariateDivision.quotient(old_r, r, true);
            if (q == null) {
                throw new ArithmeticException("Not divisible with remainder: (" + old_r + ") / (" + r + ")");
            }
            Object tmp = old_r;
            old_r = r;
            r = tmp.clone().subtract(q.clone().multiply(r));
            tmp = old_s;
            old_s = s;
            s = tmp.clone().subtract(q.clone().multiply(s));
        }
        IUnivariatePolynomial[] result = (IUnivariatePolynomial[])a.createArray(2);
        result[0] = old_r;
        result[1] = old_s;
        return UnivariateGCD.normalizeExtendedGCD((IUnivariatePolynomial[])result);
    }

    public static <T extends IUnivariatePolynomial<T>> T HalfGCD(T a, T b) {
        a.assertSameCoefficientRingWith(b);
        T trivialGCD = UnivariateGCD.TrivialGCD(a, b);
        if (trivialGCD != null) {
            return trivialGCD;
        }
        if (Conversions64bit.canConvertToZp64(a)) {
            return Conversions64bit.convert(UnivariateGCD.HalfGCD(Conversions64bit.asOverZp64(a), Conversions64bit.asOverZp64(b)));
        }
        if (a.degree() < b.degree()) {
            return UnivariateGCD.HalfGCD(b, a);
        }
        if (a.degree() == b.degree()) {
            b = UnivariateDivision.remainder(b, a, true);
        }
        while (a.degree() > SWITCH_TO_HALF_GCD_ALGORITHM_DEGREE && !b.isZero()) {
            IUnivariatePolynomial[] col = UnivariateGCD.reduceHalfGCD(a, b);
            a = col[0];
            b = col[1];
            if (b.isZero()) continue;
            Object remainder = UnivariateDivision.remainder(a, b, true);
            if (remainder == null) {
                throw new ArithmeticException("Not divisible with remainder: (" + a + ") / (" + b + ")");
            }
            a = b;
            b = remainder;
        }
        return UnivariateGCD.EuclidGCD(a, b);
    }

    public static <T extends IUnivariatePolynomial<T>> T[] ExtendedHalfGCD(T a, T b) {
        IUnivariatePolynomial t;
        IUnivariatePolynomial s;
        a.assertSameCoefficientRingWith(b);
        if (Conversions64bit.canConvertToZp64(a)) {
            return Conversions64bit.convert(a, (UnivariatePolynomialZp64[])((UnivariatePolynomialZp64[])UnivariateGCD.ExtendedHalfGCD((IUnivariatePolynomial)Conversions64bit.asOverZp64(a), (IUnivariatePolynomial)Conversions64bit.asOverZp64(b))));
        }
        if (a.degree() < b.degree()) {
            Object[] r = UnivariateGCD.ExtendedHalfGCD(b, a);
            ArraysUtil.swap(r, 1, 2);
            return r;
        }
        if (b.isZero()) {
            IUnivariatePolynomial[] result = (IUnivariatePolynomial[])a.createArray(3);
            result[0] = a.clone();
            result[1] = (IUnivariatePolynomial)a.createOne();
            result[2] = (IUnivariatePolynomial)a.createZero();
            return UnivariateGCD.normalizeExtendedGCD((IUnivariatePolynomial[])result);
        }
        a = a.clone();
        b = b.clone();
        IUnivariatePolynomial quotient = null;
        if (a.degree() == b.degree()) {
            IUnivariatePolynomial[] qd = UnivariateDivision.divideAndRemainder((IUnivariatePolynomial)a, (IUnivariatePolynomial)b, (boolean)true);
            if (qd == null) {
                throw new ArithmeticException("Not divisible with remainder: (" + a + ") / (" + b + ")");
            }
            quotient = qd[0];
            IUnivariatePolynomial remainder = qd[1];
            a = b;
            b = remainder;
        }
        IUnivariatePolynomial[][] hMatrix = UnivariateGCD.reduceExtendedHalfGCD((IUnivariatePolynomial)a, (IUnivariatePolynomial)b, (int)(a.degree() + 1));
        Object gcd = a;
        if (quotient != null) {
            s = hMatrix[0][1];
            t = quotient.multiply(hMatrix[0][1]);
            t = hMatrix[0][0].subtract(t);
        } else {
            s = hMatrix[0][0];
            t = hMatrix[0][1];
        }
        IUnivariatePolynomial[] result = (IUnivariatePolynomial[])a.createArray(3);
        result[0] = gcd;
        result[1] = s;
        result[2] = t;
        return UnivariateGCD.normalizeExtendedGCD((IUnivariatePolynomial[])result);
    }

    private static <T extends IUnivariatePolynomial<T>> T[][] hMatrixPlain(T a, T b, int degreeToReduce, boolean reduce) {
        IUnivariatePolynomial[][] hMatrix = UnivariateGCD.unitMatrix(a);
        int goal = a.degree() - degreeToReduce;
        if (b.degree() <= goal) {
            return hMatrix;
        }
        T tmpA = a;
        Object tmpB = b;
        while (tmpB.degree() > goal && !tmpB.isZero()) {
            IUnivariatePolynomial[] qd = UnivariateDivision.divideAndRemainder(tmpA, tmpB, (boolean)true);
            if (qd == null) {
                throw new ArithmeticException("Not divisible with remainder: (" + tmpA + ") / (" + tmpB + ")");
            }
            IUnivariatePolynomial quotient = qd[0];
            IUnivariatePolynomial remainder = qd[1];
            IUnivariatePolynomial tmp = quotient.clone().multiply(hMatrix[1][0]);
            tmp = hMatrix[0][0].clone().subtract(tmp);
            hMatrix[0][0] = hMatrix[1][0];
            hMatrix[1][0] = tmp;
            tmp = quotient.clone().multiply(hMatrix[1][1]);
            tmp = hMatrix[0][1].clone().subtract(tmp);
            hMatrix[0][1] = hMatrix[1][1];
            hMatrix[1][1] = tmp;
            tmpA = tmpB;
            tmpB = remainder;
        }
        if (reduce) {
            a.setAndDestroy(tmpA);
            b.setAndDestroy(tmpB);
        }
        return hMatrix;
    }

    private static <T extends IUnivariatePolynomial<T>> T[][] hMatrixHalfGCD(T a, T b, int d) {
        if (b.isZero() || b.degree() <= a.degree() - d) {
            return UnivariateGCD.unitMatrix(a);
        }
        int n = a.degree() - 2 * d + 2;
        if (n < 0) {
            n = 0;
        }
        Object a1 = a.clone().shiftLeft(n);
        Object b1 = b.clone().shiftLeft(n);
        if (d <= SWITCH_TO_HALF_GCD_H_MATRIX_DEGREE) {
            return UnivariateGCD.hMatrixPlain(a1, b1, (int)d, (boolean)false);
        }
        int dR = (d + 1) / 2;
        if (dR < 1) {
            dR = 1;
        }
        if (dR >= d) {
            dR = d - 1;
        }
        IUnivariatePolynomial[][] hMatrixR = UnivariateGCD.hMatrixHalfGCD(a1, b1, (int)dR);
        IUnivariatePolynomial[] col = UnivariateGCD.columnMultiply((IUnivariatePolynomial[][])hMatrixR, a1, b1);
        a1 = col[0];
        b1 = col[1];
        int dL = b1.degree() - a.degree() + n + d;
        if (b1.isZero() || dL <= 0) {
            return hMatrixR;
        }
        IUnivariatePolynomial[] qd = UnivariateDivision.divideAndRemainder(a1, (IUnivariatePolynomial)b1, (boolean)false);
        if (qd == null) {
            throw new ArithmeticException("Not divisible with remainder: (" + a1 + ") / (" + b1 + ")");
        }
        IUnivariatePolynomial quotient = qd[0];
        IUnivariatePolynomial remainder = qd[1];
        IUnivariatePolynomial[][] hMatrixL = UnivariateGCD.hMatrixHalfGCD((IUnivariatePolynomial)b1, (IUnivariatePolynomial)remainder, (int)dL);
        IUnivariatePolynomial tmp = quotient.clone().multiply(hMatrixR[1][0]);
        tmp = hMatrixR[0][0].clone().subtract(tmp);
        hMatrixR[0][0] = hMatrixR[1][0];
        hMatrixR[1][0] = tmp;
        tmp = quotient.clone().multiply(hMatrixR[1][1]);
        tmp = hMatrixR[0][1].clone().subtract(tmp);
        hMatrixR[0][1] = hMatrixR[1][1];
        hMatrixR[1][1] = tmp;
        return UnivariateGCD.matrixMultiply((IUnivariatePolynomial[][])hMatrixL, (IUnivariatePolynomial[][])hMatrixR);
    }

    static <T extends IUnivariatePolynomial<T>> T[][] reduceExtendedHalfGCD(T a, T b, int d) {
        assert (a.degree() >= b.degree());
        if (b.isZero() || b.degree() <= a.degree() - d) {
            return UnivariateGCD.unitMatrix(a);
        }
        int aDegree = a.degree();
        if (d <= SWITCH_TO_HALF_GCD_H_MATRIX_DEGREE) {
            return UnivariateGCD.hMatrixPlain(a, b, (int)d, (boolean)true);
        }
        int dL = (d + 1) / 2;
        if (dL < 1) {
            dL = 1;
        }
        if (dL >= d) {
            dL = d - 1;
        }
        IUnivariatePolynomial[][] hMatrixR = UnivariateGCD.hMatrixHalfGCD(a, b, (int)dL);
        IUnivariatePolynomial[] col = UnivariateGCD.columnMultiply((IUnivariatePolynomial[][])hMatrixR, a, b);
        a.setAndDestroy((IUnivariatePolynomial)col[0]);
        b.setAndDestroy((IUnivariatePolynomial)col[1]);
        int dR = b.degree() - aDegree + d;
        if (b.isZero() || dR <= 0) {
            return hMatrixR;
        }
        IUnivariatePolynomial[] qd = UnivariateDivision.divideAndRemainder(a, b, (boolean)true);
        if (qd == null) {
            throw new ArithmeticException("Not divisible with remainder: (" + a + ") / (" + b + ")");
        }
        IUnivariatePolynomial quotient = qd[0];
        IUnivariatePolynomial remainder = qd[1];
        a.setAndDestroy(b);
        b.setAndDestroy((IUnivariatePolynomial)remainder);
        IUnivariatePolynomial[][] hMatrixL = UnivariateGCD.reduceExtendedHalfGCD(a, b, (int)dR);
        IUnivariatePolynomial tmp = quotient.clone().multiply(hMatrixR[1][0]);
        tmp = hMatrixR[0][0].clone().subtract(tmp);
        hMatrixR[0][0] = hMatrixR[1][0];
        hMatrixR[1][0] = tmp;
        tmp = quotient.clone().multiply(hMatrixR[1][1]);
        tmp = hMatrixR[0][1].clone().subtract(tmp);
        hMatrixR[0][1] = hMatrixR[1][1];
        hMatrixR[1][1] = tmp;
        return UnivariateGCD.matrixMultiply((IUnivariatePolynomial[][])hMatrixL, (IUnivariatePolynomial[][])hMatrixR);
    }

    static <T extends IUnivariatePolynomial<T>> T[] reduceHalfGCD(T a, T b) {
        int d = (a.degree() + 1) / 2;
        if (b.isZero() || b.degree() <= a.degree() - d) {
            return (IUnivariatePolynomial[])a.createArray(a, (IPolynomial)b);
        }
        int aDegree = a.degree();
        int d1 = (d + 1) / 2;
        if (d1 < 1) {
            d1 = 1;
        }
        if (d1 >= d) {
            d1 = d - 1;
        }
        IUnivariatePolynomial[][] hMatrix = UnivariateGCD.hMatrixHalfGCD(a, b, (int)d1);
        IUnivariatePolynomial[] col = UnivariateGCD.columnMultiply((IUnivariatePolynomial[][])hMatrix, a, b);
        a = col[0];
        b = col[1];
        int d2 = b.degree() - aDegree + d;
        if (b.isZero() || d2 <= 0) {
            return (IUnivariatePolynomial[])a.createArray(a, (IPolynomial)b);
        }
        Object remainder = UnivariateDivision.remainder(a, b, true);
        if (remainder == null) {
            throw new ArithmeticException("Not divisible with remainder: (" + a + ") / (" + b + ")");
        }
        a = b;
        b = remainder;
        return UnivariateGCD.columnMultiply((IUnivariatePolynomial[][])UnivariateGCD.hMatrixHalfGCD(a, (IUnivariatePolynomial)b, (int)d2), a, (IUnivariatePolynomial)b);
    }

    private static <T extends IUnivariatePolynomial<T>> T[][] matrixMultiply(T[][] matrix1, T[][] matrix2) {
        IUnivariatePolynomial[][] r = (IUnivariatePolynomial[][])matrix1[0][0].createArray2d(2, 2);
        r[0][0] = ((IUnivariatePolynomial)matrix1[0][0].clone().multiply(matrix2[0][0])).add((IUnivariatePolynomial)matrix1[0][1].clone().multiply(matrix2[1][0]));
        r[0][1] = ((IUnivariatePolynomial)matrix1[0][0].clone().multiply(matrix2[0][1])).add((IUnivariatePolynomial)matrix1[0][1].clone().multiply(matrix2[1][1]));
        r[1][0] = ((IUnivariatePolynomial)matrix1[1][0].clone().multiply(matrix2[0][0])).add((IUnivariatePolynomial)matrix1[1][1].clone().multiply(matrix2[1][0]));
        r[1][1] = ((IUnivariatePolynomial)matrix1[1][0].clone().multiply(matrix2[0][1])).add((IUnivariatePolynomial)matrix1[1][1].clone().multiply(matrix2[1][1]));
        return r;
    }

    private static <T extends IUnivariatePolynomial<T>> T[] columnMultiply(T[][] hMatrix, T row1, T row2) {
        IUnivariatePolynomial[] resultColumn = (IUnivariatePolynomial[])row1.createArray(2);
        resultColumn[0] = hMatrix[0][0].clone().multiply(row1).add(hMatrix[0][1].clone().multiply(row2));
        resultColumn[1] = hMatrix[1][0].clone().multiply(row1).add(hMatrix[1][1].clone().multiply(row2));
        return resultColumn;
    }

    private static <T extends IUnivariatePolynomial<T>> T[][] unitMatrix(T factory) {
        IUnivariatePolynomial[][] m = (IUnivariatePolynomial[][])factory.createArray2d(2, 2);
        m[0][0] = (IUnivariatePolynomial)factory.createOne();
        m[0][1] = (IUnivariatePolynomial)factory.createZero();
        m[1][0] = (IUnivariatePolynomial)factory.createZero();
        m[1][1] = (IUnivariatePolynomial)factory.createOne();
        return m;
    }

    public static UnivariatePolynomialZ64 ModularGCD(UnivariatePolynomialZ64 a, UnivariatePolynomialZ64 b) {
        UnivariatePolynomialZ64 trivialGCD = UnivariateGCD.TrivialGCD(a, b);
        if (trivialGCD != null) {
            return trivialGCD;
        }
        if (a.degree < b.degree) {
            return UnivariateGCD.ModularGCD(b, a);
        }
        long aContent = a.content();
        long bContent = b.content();
        long contentGCD = MachineArithmetic.gcd(aContent, bContent);
        if (a.isConstant() || b.isConstant()) {
            return UnivariatePolynomialZ64.create(contentGCD);
        }
        return (UnivariatePolynomialZ64)UnivariateGCD.ModularGCD0(a.clone().divideOrNull(aContent), b.clone().divideOrNull(bContent)).multiply(contentGCD);
    }

    private static UnivariatePolynomialZ64 ModularGCD0(UnivariatePolynomialZ64 a, UnivariatePolynomialZ64 b) {
        assert (a.degree >= b.degree);
        long lcGCD = MachineArithmetic.gcd(a.lc(), b.lc());
        double bound = Math.max(a.mignotteBound(), b.mignotteBound()) * (double)lcGCD;
        UnivariatePolynomialZ64 previousBase = null;
        UnivariatePolynomialZp64 base = null;
        long basePrime = -1L;
        PrimesIterator primesLoop = new PrimesIterator(3L);
        while (true) {
            UnivariatePolynomialZp64 bMod;
            long prime = primesLoop.take();
            assert (prime != -1L) : "long overflow";
            if (a.lc() % prime == 0L || b.lc() % prime == 0L) continue;
            UnivariatePolynomialZp64 aMod = a.modulus(prime);
            UnivariatePolynomialZp64 modularGCD = UnivariateGCD.HalfGCD(aMod, bMod = b.modulus(prime));
            if (modularGCD == aMod || modularGCD == bMod) {
                modularGCD = modularGCD.clone();
            }
            if (modularGCD.degree == 0) {
                return UnivariatePolynomialZ64.one();
            }
            if (base == null || base.degree > modularGCD.degree) {
                modularGCD.monic(lcGCD);
                base = modularGCD;
                basePrime = prime;
                continue;
            }
            if (base.degree < modularGCD.degree) continue;
            long newBasePrime = MachineArithmetic.safeMultiply(basePrime, prime);
            long monicFactor = modularGCD.multiply(MachineArithmetic.modInverse(modularGCD.lc(), prime), modularGCD.ring.modulus(lcGCD));
            ChineseRemainders.ChineseRemaindersMagicZp64 magic = ChineseRemainders.createMagic(basePrime, prime);
            for (int i = 0; i <= base.degree; ++i) {
                long oth = modularGCD.multiply(modularGCD.data[i], monicFactor);
                base.data[i] = ChineseRemainders.ChineseRemainders(magic, base.data[i], oth);
            }
            base = base.setModulusUnsafe(newBasePrime);
            basePrime = newBasePrime;
            UnivariatePolynomialZ64 candidate = (UnivariatePolynomialZ64)base.asPolyZSymmetric().primitivePart();
            if ((double)basePrime >= 2.0 * bound || previousBase != null && candidate.equals(previousBase)) {
                previousBase = candidate;
                UnivariatePolynomialZ64[] div = UnivariateDivision.divideAndRemainder(b, candidate, true);
                if (div == null || !div[1].isZero() || (div = UnivariateDivision.divideAndRemainder(a, candidate, true)) == null || !div[1].isZero()) continue;
                return candidate;
            }
            previousBase = candidate;
        }
    }

    public static UnivariatePolynomial<BigInteger> ModularGCD(UnivariatePolynomial<BigInteger> a, UnivariatePolynomial<BigInteger> b) {
        if (!a.ring.equals(Rings.Z)) {
            throw new IllegalArgumentException("Only polynomials over integers ring are allowed; " + a.ring);
        }
        UnivariatePolynomial<BigInteger> trivialGCD = UnivariateGCD.TrivialGCD(a, b);
        if (trivialGCD != null) {
            return trivialGCD;
        }
        if (a.degree < b.degree) {
            return UnivariateGCD.ModularGCD(b, a);
        }
        BigInteger aContent = a.content();
        BigInteger bContent = b.content();
        BigInteger contentGCD = BigIntegerUtil.gcd(aContent, bContent);
        if (a.isConstant() || b.isConstant()) {
            return a.createConstant(contentGCD);
        }
        return UnivariateGCD.ModularGCD0(((UnivariatePolynomial)a.clone()).divideOrNull(aContent), ((UnivariatePolynomial)b.clone()).divideOrNull(bContent)).multiply(contentGCD);
    }

    private static UnivariatePolynomial<BigInteger> ModularGCD0(UnivariatePolynomial<BigInteger> a, UnivariatePolynomial<BigInteger> b) {
        assert (a.degree >= b.degree);
        BigInteger lcGCD = BigIntegerUtil.gcd(a.lc(), b.lc());
        BigInteger bound2 = BigIntegerUtil.max(UnivariatePolynomial.mignotteBound(a), UnivariatePolynomial.mignotteBound(b)).multiply(lcGCD).shiftLeft(1);
        if (bound2.isLong() && a.maxAbsCoefficient().isLong() && b.maxAbsCoefficient().isLong()) {
            try {
                return UnivariateGCD.ModularGCD(UnivariatePolynomial.asOverZ64(a), UnivariatePolynomial.asOverZ64(b)).toBigPoly();
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
        }
        UnivariatePolynomialZ64 previousBase = null;
        UnivariatePolynomialZp64 base = null;
        long basePrime = -1L;
        PrimesIterator primesLoop = new PrimesIterator(1031L);
        while (true) {
            UnivariatePolynomialZp64 bMod;
            long prime = primesLoop.take();
            assert (prime != -1L) : "long overflow";
            BigInteger bPrime = BigInteger.valueOf(prime);
            if (a.lc().remainder(bPrime).isZero() || b.lc().remainder(bPrime).isZero()) continue;
            IntegersZp bPrimeDomain = new IntegersZp(bPrime);
            UnivariatePolynomialZp64 aMod = UnivariatePolynomial.asOverZp64(a.setRing(bPrimeDomain));
            UnivariatePolynomialZp64 modularGCD = UnivariateGCD.HalfGCD(aMod, bMod = UnivariatePolynomial.asOverZp64(b.setRing(bPrimeDomain)));
            if (modularGCD == aMod || modularGCD == bMod) {
                modularGCD = modularGCD.clone();
            }
            if (modularGCD.degree == 0) {
                return a.createOne();
            }
            if (base == null || base.degree > modularGCD.degree) {
                long lLcGCD = lcGCD.mod(bPrime).longValueExact();
                modularGCD.monic(lLcGCD);
                base = modularGCD;
                basePrime = prime;
                continue;
            }
            if (base.degree < modularGCD.degree) continue;
            if (MachineArithmetic.isOverflowMultiply(basePrime, prime) || basePrime * prime > 0x3FFFFFFFFFFFFFFFL) break;
            long newBasePrime = basePrime * prime;
            long monicFactor = modularGCD.multiply(MachineArithmetic.modInverse(modularGCD.lc(), prime), lcGCD.mod(bPrime).longValueExact());
            ChineseRemainders.ChineseRemaindersMagicZp64 magic = ChineseRemainders.createMagic(basePrime, prime);
            for (int i = 0; i <= base.degree; ++i) {
                long oth = modularGCD.multiply(modularGCD.data[i], monicFactor);
                base.data[i] = ChineseRemainders.ChineseRemainders(magic, base.data[i], oth);
            }
            base = base.setModulusUnsafe(newBasePrime);
            basePrime = newBasePrime;
            UnivariatePolynomialZ64 lCandidate = (UnivariatePolynomialZ64)base.asPolyZSymmetric().primitivePart();
            if (BigInteger.valueOf(basePrime).compareTo(bound2) >= 0 || previousBase != null && lCandidate.equals(previousBase)) {
                previousBase = lCandidate;
                UnivariatePolynomial<BigInteger> candidate = lCandidate.toBigPoly();
                UnivariatePolynomial<BigInteger>[] div = UnivariateDivision.divideAndRemainder(b, candidate, true);
                if (div == null || !div[1].isZero() || (div = UnivariateDivision.divideAndRemainder(a, candidate, true)) == null || !div[1].isZero()) continue;
                return candidate;
            }
            previousBase = lCandidate;
        }
        IPolynomial bPreviousBase = null;
        UnivariatePolynomial<BigInteger> bBase = base.toBigPoly();
        BigInteger bBasePrime = BigInteger.valueOf(basePrime);
        while (true) {
            UnivariatePolynomialZp64 bMod;
            long prime = primesLoop.take();
            assert (prime != -1L) : "long overflow";
            BigInteger bPrime = BigInteger.valueOf(prime);
            if (a.lc().remainder(bPrime).isZero() || b.lc().remainder(bPrime).isZero()) continue;
            IntegersZp bPrimeDomain = new IntegersZp(bPrime);
            UnivariatePolynomialZp64 aMod = UnivariatePolynomial.asOverZp64(a.setRing(bPrimeDomain));
            UnivariatePolynomialZp64 modularGCD = UnivariateGCD.HalfGCD(aMod, bMod = UnivariatePolynomial.asOverZp64(b.setRing(bPrimeDomain)));
            if (modularGCD == aMod || modularGCD == bMod) {
                modularGCD = modularGCD.clone();
            }
            if (modularGCD.degree == 0) {
                return a.createOne();
            }
            if (bBase == null || bBase.degree > modularGCD.degree) {
                long lLcGCD = lcGCD.mod(bPrime).longValueExact();
                modularGCD.monic(lLcGCD);
                bBase = modularGCD.toBigPoly();
                bBasePrime = bPrime;
                continue;
            }
            if (bBase.degree < modularGCD.degree) continue;
            BigInteger newBasePrime = bBasePrime.multiply(bPrime);
            long monicFactor = modularGCD.multiply(MachineArithmetic.modInverse(modularGCD.lc(), prime), lcGCD.mod(bPrime).longValueExact());
            ChineseRemainders.ChineseRemaindersMagic<BigInteger> magic = ChineseRemainders.createMagic(Rings.Z, bBasePrime, bPrime);
            for (int i = 0; i <= bBase.degree; ++i) {
                long oth = modularGCD.multiply(modularGCD.data[i], monicFactor);
                ((BigInteger[])bBase.data)[i] = ChineseRemainders.ChineseRemainders(Rings.Z, magic, ((BigInteger[])bBase.data)[i], BigInteger.valueOf(oth));
            }
            bBase = bBase.setRingUnsafe(new IntegersZp(newBasePrime));
            bBasePrime = newBasePrime;
            IPolynomial candidate = UnivariatePolynomial.asPolyZSymmetric(bBase).primitivePart();
            if (bBasePrime.compareTo(bound2) >= 0 || bPreviousBase != null && ((UnivariatePolynomial)candidate).equals(bPreviousBase)) {
                bPreviousBase = candidate;
                UnivariatePolynomial<BigInteger>[] div = UnivariateDivision.divideAndRemainder(b, candidate, true);
                if (div == null || !div[1].isZero() || (div = UnivariateDivision.divideAndRemainder(a, candidate, true)) == null || !div[1].isZero()) continue;
                return candidate;
            }
            bPreviousBase = candidate;
        }
    }

    public static UnivariatePolynomial<Rational<BigInteger>>[] ModularExtendedRationalGCD(UnivariatePolynomial<Rational<BigInteger>> a, UnivariatePolynomial<Rational<BigInteger>> b) {
        if (a == b || a.equals(b)) {
            return new UnivariatePolynomial[]{a.createOne(), a.createZero(), a.clone()};
        }
        if (a.degree() < b.degree()) {
            Object[] r = UnivariateGCD.ModularExtendedRationalGCD(b, a);
            ArraysUtil.swap(r, 1, 2);
            return r;
        }
        if (b.isZero()) {
            IUnivariatePolynomial[] result = a.createArray(3);
            result[0] = a.clone();
            result[1] = a.createOne();
            result[2] = a.createZero();
            return (UnivariatePolynomial[])UnivariateGCD.normalizeExtendedGCD((IUnivariatePolynomial[])result);
        }
        Util.Tuple2 ac = Util.toCommonDenominator(a);
        Util.Tuple2 bc = Util.toCommonDenominator(b);
        UnivariatePolynomial az = (UnivariatePolynomial)ac._1;
        UnivariatePolynomial bz = (UnivariatePolynomial)bc._1;
        BigInteger aContent = (BigInteger)az.content();
        BigInteger bContent = (BigInteger)bz.content();
        UnivariatePolynomial<Rational<BigInteger>>[] xgcd = UnivariateGCD.ModularExtendedRationalGCD0(((UnivariatePolynomial)az.clone()).divideOrNull(aContent), ((UnivariatePolynomial)bz.clone()).divideOrNull(bContent));
        xgcd[1].multiply(new Rational<BigInteger>(Rings.Z, (BigInteger)ac._2, aContent));
        xgcd[2].multiply(new Rational<BigInteger>(Rings.Z, (BigInteger)bc._2, bContent));
        return xgcd;
    }

    static UnivariatePolynomial<Rational<BigInteger>>[] ModularExtendedRationalGCD0(UnivariatePolynomial<BigInteger> a, UnivariatePolynomial<BigInteger> b) {
        assert (a.degree >= b.degree);
        BigInteger lcGCD = BigIntegerUtil.gcd(a.lc(), b.lc());
        UnivariatePolynomial<Rational<BigInteger>> aRat = a.mapCoefficients(Rings.Q, c -> new Rational<BigInteger>(Rings.Z, (BigInteger)c));
        UnivariatePolynomial<Rational<BigInteger>> bRat = b.mapCoefficients(Rings.Q, c -> new Rational<BigInteger>(Rings.Z, (BigInteger)c));
        int degreeMax = Math.max(a.degree, b.degree);
        BigInteger bound2 = BigInteger.valueOf(degreeMax).increment().pow(degreeMax).multiply(BigIntegerUtil.max(a.normMax(), b.normMax()).pow(a.degree + b.degree)).multiply(lcGCD).shiftLeft(1);
        PrimesIterator primesLoop = new PrimesIterator(1031L);
        ArrayList<BigInteger> primes = new ArrayList<BigInteger>();
        List[] gst = new List[]{new ArrayList(), new ArrayList(), new ArrayList()};
        BigInteger primesMul = BigInteger.ONE;
        block0: while (true) {
            if (primesMul.compareTo(bound2) < 0) {
                long prime = primesLoop.take();
                BigInteger bPrime = BigInteger.valueOf(prime);
                if (a.lc().remainder(bPrime).isZero() || b.lc().remainder(bPrime).isZero()) continue;
                IntegersZp bPrimeDomain = new IntegersZp(bPrime);
                UnivariatePolynomialZp64 aMod = UnivariatePolynomial.asOverZp64(a.setRing(bPrimeDomain));
                UnivariatePolynomialZp64 bMod = UnivariatePolynomial.asOverZp64(b.setRing(bPrimeDomain));
                UnivariatePolynomialZp64[] modularXGCD = (UnivariatePolynomialZp64[])UnivariateGCD.ExtendedHalfGCD((IUnivariatePolynomial)aMod, (IUnivariatePolynomial)bMod);
                assert (modularXGCD[0].isMonic());
                if (!gst[0].isEmpty() && modularXGCD[0].degree > ((UnivariatePolynomial)gst[0].get((int)0)).degree) continue;
                if (!gst[0].isEmpty() && modularXGCD[0].degree < ((UnivariatePolynomial)gst[0].get((int)0)).degree) {
                    primes.clear();
                    primesMul = BigInteger.ONE;
                    Arrays.stream(gst).forEach(List::clear);
                }
                long lLcGCD = lcGCD.mod(bPrime).longValueExact();
                long lc = modularXGCD[0].lc();
                for (int i = 0; i < modularXGCD.length; ++i) {
                    gst[i].add(((UnivariatePolynomialZp64)modularXGCD[i].multiply(lLcGCD)).divide(lc).toBigPoly());
                }
                primes.add(bPrime);
                primesMul = primesMul.multiply(bPrime);
                continue;
            }
            UnivariatePolynomial[] xgcdBase = new UnivariatePolynomial[3];
            BigInteger[] primesArray = primes.toArray(new BigInteger[primes.size()]);
            for (int i = 0; i < 3; ++i) {
                xgcdBase[i] = UnivariatePolynomial.zero(Rings.Z);
                int deg = gst[i].stream().mapToInt(UnivariatePolynomial::degree).max().getAsInt();
                xgcdBase[i].ensureCapacity(deg);
                for (int j = 0; j <= deg; ++j) {
                    int jf = j;
                    BigInteger[] cfs = (BigInteger[])gst[i].stream().map(p -> (BigInteger)p.get(jf)).toArray(BigInteger[]::new);
                    ((BigInteger[])xgcdBase[i].data)[j] = ChineseRemainders.ChineseRemainders(primesArray, cfs);
                }
                xgcdBase[i].fixDegree();
            }
            while (true) {
                long lc;
                long lLcGCD;
                UnivariatePolynomial<Rational<BigInteger>>[] xgcd;
                if ((xgcd = UnivariateGCD.reconstructXGCD(aRat, bRat, xgcdBase, primesMul, bound2)) != null) {
                    return xgcd;
                }
                long prime = primesLoop.take();
                BigInteger bPrime = BigInteger.valueOf(prime);
                if (a.lc().remainder(bPrime).isZero() || b.lc().remainder(bPrime).isZero()) continue;
                IntegersZp bPrimeDomain = new IntegersZp(bPrime);
                UnivariatePolynomialZp64 aMod = UnivariatePolynomial.asOverZp64(a.setRing(bPrimeDomain));
                UnivariatePolynomialZp64 bMod = UnivariatePolynomial.asOverZp64(b.setRing(bPrimeDomain));
                UnivariatePolynomialZp64[] modularXGCD = (UnivariatePolynomialZp64[])UnivariateGCD.ExtendedHalfGCD((IUnivariatePolynomial)aMod, (IUnivariatePolynomial)bMod);
                assert (modularXGCD[0].isMonic());
                if (modularXGCD[0].degree > xgcdBase[0].degree) continue;
                if (modularXGCD[0].degree < xgcdBase[0].degree) {
                    primes.clear();
                    Arrays.stream(gst).forEach(List::clear);
                    lLcGCD = lcGCD.mod(bPrime).longValueExact();
                    lc = modularXGCD[0].lc();
                    for (int i = 0; i < modularXGCD.length; ++i) {
                        gst[i].add(((UnivariatePolynomialZp64)modularXGCD[i].multiply(lLcGCD)).divide(lc).toBigPoly());
                    }
                    primes.add(bPrime);
                    primesMul = bPrime;
                    continue block0;
                }
                lLcGCD = lcGCD.mod(bPrime).longValueExact();
                lc = modularXGCD[0].lc();
                for (UnivariatePolynomialZp64 m : modularXGCD) {
                    ((UnivariatePolynomialZp64)m.multiply(lLcGCD)).divide(lc);
                }
                ChineseRemainders.ChineseRemaindersMagic<BigInteger> magic = ChineseRemainders.createMagic(Rings.Z, primesMul, bPrime);
                for (int i = 0; i < 3; ++i) {
                    modularXGCD[i].ensureCapacity(xgcdBase[i].degree);
                    assert (modularXGCD[i].degree <= xgcdBase[i].degree);
                    for (int j = 0; j <= xgcdBase[i].degree; ++j) {
                        ((BigInteger[])xgcdBase[i].data)[j] = ChineseRemainders.ChineseRemainders(Rings.Z, magic, ((BigInteger[])xgcdBase[i].data)[j], BigInteger.valueOf(modularXGCD[i].data[j]));
                    }
                }
                primes.add(bPrime);
                primesMul = primesMul.multiply(bPrime);
            }
            break;
        }
    }

    private static UnivariatePolynomial<Rational<BigInteger>>[] reconstructXGCD(UnivariatePolynomial<Rational<BigInteger>> aRat, UnivariatePolynomial<Rational<BigInteger>> bRat, UnivariatePolynomial<BigInteger>[] xgcdBase, BigInteger prime, BigInteger bound2) {
        UnivariatePolynomial[] candidate = new UnivariatePolynomial[3];
        for (int i = 0; i < 3; ++i) {
            candidate[i] = UnivariatePolynomial.zero(Rings.Q);
            candidate[i].ensureCapacity(xgcdBase[i].degree);
            for (int j = 0; j <= xgcdBase[i].degree; ++j) {
                BigInteger[] numDen = RationalReconstruction.reconstruct(((BigInteger[])xgcdBase[i].data)[j], prime, bound2, bound2);
                if (numDen == null) {
                    return null;
                }
                ((Rational[])candidate[i].data)[j] = new Rational<BigInteger>(Rings.Z, numDen[0], numDen[1]);
            }
            candidate[i].fixDegree();
        }
        BigInteger content = candidate[0].mapCoefficients(Rings.Z, Rational::numerator).content();
        Rational<BigInteger> corr = new Rational<BigInteger>(Rings.Z, Rings.Z.getOne(), content);
        UnivariatePolynomial<Rational<BigInteger>> sCandidate = candidate[1].multiply(corr);
        UnivariatePolynomial<Rational<BigInteger>> tCandidate = candidate[2].multiply(corr);
        UnivariatePolynomial<Rational<BigInteger>> gCandidate = candidate[0].multiply(corr);
        UnivariatePolynomial<Rational<BigInteger>>[] bDiv = UnivariateDivision.divideAndRemainder(bRat, gCandidate, true);
        if (!bDiv[1].isZero()) {
            return null;
        }
        UnivariatePolynomial<Rational<BigInteger>>[] aDiv = UnivariateDivision.divideAndRemainder(aRat, gCandidate, true);
        if (!aDiv[1].isZero()) {
            return null;
        }
        if (!UnivariateGCD.satisfiesXGCD(aDiv[0], sCandidate, bDiv[0], tCandidate)) {
            return null;
        }
        return candidate;
    }

    private static boolean satisfiesXGCD(UnivariatePolynomial<Rational<BigInteger>> a, UnivariatePolynomial<Rational<BigInteger>> s, UnivariatePolynomial<Rational<BigInteger>> b, UnivariatePolynomial<Rational<BigInteger>> t) {
        Rational<BigInteger> zero = Rational.zero(Rings.Z);
        Rational<BigInteger> one = Rational.one(Rings.Z);
        for (Rational subs : new Rational[]{zero, one}) {
            Rational<BigInteger> ea = a.evaluate(subs);
            Rational<BigInteger> es = s.evaluate(subs);
            Rational<BigInteger> eb = b.evaluate(subs);
            Rational<BigInteger> et = t.evaluate(subs);
            if (ea.multiply((BigInteger)((Object)es)).add((Rational<BigInteger>)eb.multiply((BigInteger)((Object)et))).isOne()) continue;
            return false;
        }
        return a.multiply(s).add(b.multiply(t)).isOne();
    }

    public static UnivariatePolynomial<Rational<BigInteger>>[] ModularExtendedResultantGCDInQ(UnivariatePolynomial<Rational<BigInteger>> a, UnivariatePolynomial<Rational<BigInteger>> b) {
        Util.Tuple2 ra = Util.toCommonDenominator(a);
        Util.Tuple2 rb = Util.toCommonDenominator(b);
        UnivariatePolynomial<BigInteger>[] xgcdZ = UnivariateGCD.ModularExtendedResultantGCDInZ((UnivariatePolynomial)ra._1, (UnivariatePolynomial)rb._1);
        BigInteger content = Rings.Z.gcd(xgcdZ[0].content(), (BigInteger)ra._2, (BigInteger)rb._2);
        xgcdZ[0].divideExact(content);
        UnivariatePolynomial[] xgcd = (UnivariatePolynomial[])Arrays.stream(xgcdZ).map(p -> p.mapCoefficients(Rings.Q, Rings.Q::mkNumerator)).toArray(UnivariatePolynomial[]::new);
        xgcd[1].multiply(Rings.Q.mkNumerator(((BigInteger)ra._2).divideExact(content)));
        xgcd[2].multiply(Rings.Q.mkNumerator(((BigInteger)rb._2).divideExact(content)));
        return xgcd;
    }

    public static UnivariatePolynomial<BigInteger>[] ModularExtendedResultantGCDInZ(UnivariatePolynomial<BigInteger> a, UnivariatePolynomial<BigInteger> b) {
        if (a == b || a.equals(b)) {
            return new UnivariatePolynomial[]{a.createOne(), a.createZero(), a.clone()};
        }
        if (a.degree() < b.degree()) {
            Object[] r = UnivariateGCD.ModularExtendedResultantGCDInZ(b, a);
            ArraysUtil.swap(r, 1, 2);
            return r;
        }
        if (b.isZero()) {
            IUnivariatePolynomial[] result = a.createArray(3);
            result[0] = a.clone();
            result[1] = a.createOne();
            result[2] = a.createZero();
            return (UnivariatePolynomial[])UnivariateGCD.normalizeExtendedGCD((IUnivariatePolynomial[])result);
        }
        BigInteger aContent = a.content();
        BigInteger bContent = b.content();
        a = ((UnivariatePolynomial)a.clone()).divideExact(aContent);
        b = ((UnivariatePolynomial)b.clone()).divideExact(bContent);
        UnivariatePolynomial<BigInteger> gcd = UnivariateGCD.PolynomialGCD(a, b);
        a = UnivariateDivision.divideExact(a, gcd, false);
        b = UnivariateDivision.divideExact(b, gcd, false);
        UnivariatePolynomial<BigInteger>[] xgcd = UnivariateGCD.ModularExtendedResultantGCD0(a, b);
        xgcd[0].multiply(gcd);
        UnivariatePolynomial<BigInteger> g = xgcd[0];
        UnivariatePolynomial<BigInteger> s = xgcd[1];
        UnivariatePolynomial<BigInteger> t = xgcd[2];
        BigInteger as = Rings.Z.gcd(aContent, s.content());
        BigInteger bt = Rings.Z.gcd(bContent, t.content());
        aContent = aContent.divideExact(as);
        bContent = bContent.divideExact(bt);
        s.divideExact(as);
        t.divideExact(bt);
        t.multiply(aContent);
        g.multiply(aContent);
        s.multiply(bContent);
        g.multiply(bContent);
        return xgcd;
    }

    private static UnivariatePolynomial<BigInteger>[] ModularExtendedResultantGCD0(UnivariatePolynomial<BigInteger> a, UnivariatePolynomial<BigInteger> b) {
        assert (a.degree >= b.degree);
        BigInteger gcd = UnivariateResultants.ModularResultant(a, b);
        Object[] previousBase = null;
        UnivariatePolynomial[] base = null;
        BigInteger basePrime = null;
        PrimesIterator primesLoop = new PrimesIterator(SmallPrimes.nextPrime(0x10000000));
        while (true) {
            long prime = primesLoop.take();
            assert (prime != -1L) : "long overflow";
            BigInteger bPrime = BigInteger.valueOf(prime);
            if (a.lc().remainder(bPrime).isZero() || b.lc().remainder(bPrime).isZero()) continue;
            IntegersZp ring = new IntegersZp(bPrime);
            UnivariatePolynomialZp64 aMod = UnivariatePolynomial.asOverZp64(a.setRing(ring));
            UnivariatePolynomialZp64 bMod = UnivariatePolynomial.asOverZp64(b.setRing(ring));
            UnivariatePolynomialZp64[] modularXGCD = (UnivariatePolynomialZp64[])UnivariateGCD.PolynomialExtendedGCD((IUnivariatePolynomial)aMod, (IUnivariatePolynomial)bMod);
            if (modularXGCD[0].degree != 0) continue;
            assert (modularXGCD[0].isOne());
            long correction = gcd.mod(bPrime).longValueExact();
            Arrays.stream(modularXGCD).forEach(p -> p.multiply(correction));
            if (base == null) {
                base = (UnivariatePolynomial[])Arrays.stream(modularXGCD).map(UnivariatePolynomialZp64::toBigPoly).toArray(UnivariatePolynomial[]::new);
                basePrime = bPrime;
                continue;
            }
            ChineseRemainders.ChineseRemaindersMagic<BigInteger> magic = ChineseRemainders.createMagic(Rings.Z, basePrime, bPrime);
            BigInteger newBasePrime = basePrime.multiply(bPrime);
            for (int e = 0; e < 3; ++e) {
                base[e] = base[e].setRingUnsafe(new IntegersZp(newBasePrime));
                if (base[e].degree < modularXGCD[e].degree) {
                    base[e].ensureCapacity(modularXGCD[e].degree);
                }
                for (int i = 0; i <= base[e].degree; ++i) {
                    ((BigInteger[])base[e].data)[i] = ChineseRemainders.ChineseRemainders(Rings.Z, magic, (BigInteger)base[e].get(i), BigInteger.valueOf(modularXGCD[e].get(i)));
                }
                base[e].fixDegree();
            }
            basePrime = newBasePrime;
            Object[] candidate = (UnivariatePolynomial[])Arrays.stream(base).map(UnivariatePolynomial::asPolyZSymmetric).toArray(UnivariatePolynomial[]::new);
            BigInteger content = Rings.Z.gcd((BigInteger)candidate[0].content(), (BigInteger)candidate[1].content(), (BigInteger)candidate[2].content());
            Arrays.stream(candidate).forEach(p -> p.divideExact(content));
            if (previousBase != null && Arrays.equals(candidate, previousBase)) {
                previousBase = candidate;
                if (!UnivariateGCD.satisfiesXGCD(a, b, candidate)) continue;
                return candidate;
            }
            previousBase = candidate;
        }
    }

    private static <E> boolean satisfiesXGCD(UnivariatePolynomial<E> a, UnivariatePolynomial<E> b, UnivariatePolynomial<E>[] xgcd) {
        Ring ring = xgcd[0].ring;
        for (Object subs : ring.createArray(ring.getZero(), ring.getOne())) {
            E ea = a.evaluate(subs);
            E es = xgcd[1].evaluate(subs);
            E eb = b.evaluate(subs);
            E et = xgcd[2].evaluate(subs);
            E eg = xgcd[0].evaluate(subs);
            if (ring.addMutable(ring.multiplyMutable(ea, es), ring.multiplyMutable(eb, et)).equals(eg)) continue;
            return false;
        }
        return ((UnivariatePolynomial)a.clone()).multiply(xgcd[1]).add(((UnivariatePolynomial)b.clone()).multiply(xgcd[2])).equals(xgcd[0]);
    }

    private static <E> UnivariatePolynomial<UnivariatePolynomial<E>> TrivialGCDInNumberField(UnivariatePolynomial<UnivariatePolynomial<E>> a, UnivariatePolynomial<UnivariatePolynomial<E>> b) {
        AlgebraicNumberField ring;
        block5: {
            block4: {
                UnivariatePolynomial<UnivariatePolynomial<E>> trivialGCD = UnivariateGCD.TrivialGCD(a, b);
                if (trivialGCD != null) {
                    return trivialGCD;
                }
                ring = (AlgebraicNumberField)a.ring;
                if (!a.stream().allMatch(ring::isInTheBaseField)) break block4;
                if (b.stream().allMatch(ring::isInTheBaseField)) break block5;
            }
            return null;
        }
        UnivariatePolynomial<Object> ar = a.mapCoefficients(((UnivariatePolynomial)ring.getMinimalPolynomial()).ring, UnivariatePolynomial::cc);
        UnivariatePolynomial<Object> br = b.mapCoefficients(((UnivariatePolynomial)ring.getMinimalPolynomial()).ring, UnivariatePolynomial::cc);
        return UnivariateGCD.PolynomialGCD(ar, br).mapCoefficients(ring, cf -> UnivariatePolynomial.constant(((UnivariatePolynomial)ring.getMinimalPolynomial()).ring, cf));
    }

    public static UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> PolynomialGCDInNumberField(UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a, UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> b) {
        UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> simpleGCD = UnivariateGCD.TrivialGCDInNumberField(a, b);
        if (simpleGCD != null) {
            return simpleGCD;
        }
        AlgebraicNumberField numberField = (AlgebraicNumberField)((UnivariatePolynomial)a).ring;
        UnivariatePolynomial minimalPoly = (UnivariatePolynomial)numberField.getMinimalPolynomial();
        assert (numberField.isField());
        a = ((UnivariatePolynomial)a).clone();
        b = ((UnivariatePolynomial)b).clone();
        if (minimalPoly.stream().allMatch(Rational::isIntegral)) {
            UnivariatePolynomial<BigInteger> minimalPolyZ = minimalPoly.mapCoefficients(Rings.Z, Rational::numerator);
            AlgebraicNumberField<UnivariatePolynomial<BigInteger>> numberFieldZ = new AlgebraicNumberField<UnivariatePolynomial<BigInteger>>(minimalPolyZ);
            UnivariateGCD.removeDenominators((UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>>)a);
            UnivariateGCD.removeDenominators((UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>>)b);
            assert (((UnivariatePolynomial)a).stream().allMatch(p -> p.stream().allMatch(Rational::isIntegral)));
            assert (((UnivariatePolynomial)b).stream().allMatch(p -> p.stream().allMatch(Rational::isIntegral)));
            UnivariatePolynomial<UnivariatePolynomial<BigInteger>> gcdZ = UnivariateGCD.gcdAssociateInNumberField(((UnivariatePolynomial)a).mapCoefficients(numberFieldZ, cf -> cf.mapCoefficients(Rings.Z, Rational::numerator)), ((UnivariatePolynomial)b).mapCoefficients(numberFieldZ, cf -> cf.mapCoefficients(Rings.Z, Rational::numerator)));
            return gcdZ.mapCoefficients(numberField, p -> p.mapCoefficients(Rings.Q, cf -> new Rational<BigInteger>(Rings.Z, (BigInteger)cf))).monic();
        }
        BigInteger minPolyLeadCoeff = (BigInteger)Util.commonDenominator(minimalPoly);
        Rational<BigInteger> scale = new Rational<BigInteger>(Rings.Z, Rings.Z.getOne(), minPolyLeadCoeff);
        Rational<BigInteger> scaleReciprocal = scale.reciprocal();
        AlgebraicNumberField<IPolynomial> scaledNumberField = new AlgebraicNumberField<IPolynomial>(minimalPoly.scale(scale).monic());
        return UnivariateGCD.PolynomialGCDInNumberField(((UnivariatePolynomial)a).mapCoefficients(scaledNumberField, cf -> cf.scale(scale)), ((UnivariatePolynomial)b).mapCoefficients(scaledNumberField, cf -> cf.scale(scale))).mapCoefficients(numberField, cf -> cf.scale(scaleReciprocal));
    }

    private static void pseudoMonicize(UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a) {
        UnivariatePolynomial inv = a.ring.reciprocal(a.lc());
        a.multiply((UnivariatePolynomial<Rational<BigInteger>>)((UnivariatePolynomial)Util.toCommonDenominator(inv)._1).mapCoefficients(Rings.Q, Rings.Q::mkNumerator));
        assert (a.lc().isConstant());
    }

    static BigInteger removeDenominators(UnivariatePolynomial<UnivariatePolynomial<Rational<BigInteger>>> a) {
        BigInteger denominator = (BigInteger)Rings.Z.lcm(() -> a.stream().map(Util::commonDenominator).iterator());
        a.multiply((UnivariatePolynomial)a.ring.valueOfBigInteger(denominator));
        return denominator;
    }

    public static UnivariatePolynomial<UnivariatePolynomial<BigInteger>> PolynomialGCDInRingOfIntegersOfNumberField(UnivariatePolynomial<UnivariatePolynomial<BigInteger>> a, UnivariatePolynomial<UnivariatePolynomial<BigInteger>> b) {
        if (!a.lc().isConstant() || !b.lc().isConstant()) {
            throw new IllegalArgumentException("Univariate GCD in non-field extensions requires polynomials have integer leading coefficients.");
        }
        UnivariatePolynomial<BigInteger> aContent = a.content();
        UnivariatePolynomial<BigInteger> bContent = b.content();
        assert (aContent.isConstant());
        assert (bContent.isConstant());
        UnivariatePolynomial<BigInteger> contentGCD = aContent.createConstant(aContent.cc().gcd(bContent.cc()));
        a = ((UnivariatePolynomial)a.clone()).divideExact(aContent);
        b = ((UnivariatePolynomial)b.clone()).divideExact(bContent);
        return UnivariateGCD.gcdAssociateInNumberField0(a, b).multiply(contentGCD);
    }

    static UnivariatePolynomial<UnivariatePolynomial<BigInteger>> gcdAssociateInNumberField(UnivariatePolynomial<UnivariatePolynomial<BigInteger>> a, UnivariatePolynomial<UnivariatePolynomial<BigInteger>> b) {
        AlgebraicNumberField numberField = (AlgebraicNumberField)a.ring;
        UnivariateGCD.integerPrimitivePart(a);
        UnivariateGCD.integerPrimitivePart(b);
        if (!a.lc().isConstant()) {
            a.multiply(numberField.normalizer(a.lc()));
        }
        if (!b.lc().isConstant()) {
            b.multiply(numberField.normalizer(b.lc()));
        }
        UnivariateGCD.integerPrimitivePart(a);
        UnivariateGCD.integerPrimitivePart(b);
        UnivariatePolynomial<UnivariatePolynomial<BigInteger>> simpleGCD = UnivariateGCD.TrivialGCDInNumberField(a, b);
        if (simpleGCD != null) {
            return simpleGCD;
        }
        return UnivariateGCD.gcdAssociateInNumberField0(a, b);
    }

    static BigInteger integerPrimitivePart(UnivariatePolynomial<UnivariatePolynomial<BigInteger>> p) {
        BigInteger gcd = (BigInteger)Rings.Z.gcd(p.stream().flatMap(UnivariatePolynomial::stream).sorted().collect(Collectors.toList()));
        p.stream().forEach(cf -> cf.divideExact(gcd));
        return gcd;
    }

    static UnivariatePolynomial<UnivariatePolynomial<BigInteger>> gcdAssociateInNumberField0(UnivariatePolynomial<UnivariatePolynomial<BigInteger>> a, UnivariatePolynomial<UnivariatePolynomial<BigInteger>> b) {
        assert (a.lc().isConstant());
        assert (b.lc().isConstant());
        AlgebraicNumberField numberField = (AlgebraicNumberField)a.ring;
        UnivariateRing<Integers> auxRing = Rings.UnivariateRing(Rings.Z);
        UnivariatePolynomial minimalPoly = (UnivariatePolynomial)numberField.getMinimalPolynomial();
        BigInteger lcGCD = Rings.Z.gcd(a.lc().cc(), b.lc().cc());
        BigInteger disc = (BigInteger)UnivariateResultants.Discriminant(minimalPoly);
        BigInteger correctionFactor = disc.multiply(lcGCD);
        BigInteger crtPrime = null;
        UnivariatePolynomial<UnivariatePolynomial> gcd = null;
        IPolynomial prevCandidate = null;
        PrimesIterator primes = new PrimesIterator(0x100000L);
        while (true) {
            UnivariatePolynomial<UnivariatePolynomialZp64> gcdMod;
            long prime;
            IntegersZp64 zpRing;
            UnivariatePolynomialZp64 minimalPolyMod;
            if ((minimalPolyMod = UnivariatePolynomial.asOverZp64(minimalPoly, zpRing = new IntegersZp64(prime = primes.take()))).nNonZeroTerms() != minimalPoly.nNonZeroTerms()) {
                continue;
            }
            FiniteField<UnivariatePolynomialZp64> modRing = new FiniteField<UnivariatePolynomialZp64>(minimalPolyMod);
            UnivariatePolynomial<UnivariatePolynomialZp64> aMod = a.mapCoefficients(modRing, cf -> UnivariatePolynomial.asOverZp64(cf, zpRing));
            UnivariatePolynomial<UnivariatePolynomialZp64> bMod = b.mapCoefficients(modRing, cf -> UnivariatePolynomial.asOverZp64(cf, zpRing));
            try {
                gcdMod = UnivariateGCD.PolynomialGCD(aMod, bMod);
            }
            catch (Throwable e) {
                continue;
            }
            if (gcdMod.isConstant()) {
                return a.createOne();
            }
            gcdMod.multiply(correctionFactor.mod(prime).longValue());
            BigInteger bPrime = BigInteger.valueOf(prime);
            if (crtPrime == null || gcdMod.degree < gcd.degree) {
                crtPrime = bPrime;
                gcd = gcdMod.mapCoefficients(auxRing, cf -> cf.toBigPoly().setRing(Rings.Z));
                continue;
            }
            if (gcdMod.degree > gcd.degree) continue;
            ChineseRemainders.ChineseRemaindersMagic<BigInteger> magic = ChineseRemainders.createMagic(Rings.Z, crtPrime, bPrime);
            boolean updated = false;
            for (int i = gcd.degree; i >= 0; --i) {
                boolean u = UnivariateGCD.updateCRT(magic, ((UnivariatePolynomial[])gcd.data)[i], ((UnivariatePolynomialZp64[])gcdMod.data)[i]);
                if (!u) continue;
                updated = true;
            }
            crtPrime = crtPrime.multiply(bPrime);
            IntegersZp crtRing = new IntegersZp(crtPrime);
            IPolynomial candidate = gcd.mapCoefficients(numberField, cf -> numberField.valueOf(UnivariatePolynomial.asPolyZSymmetric(cf.setRingUnsafe(crtRing)))).primitivePart();
            if (prevCandidate == null) {
                prevCandidate = candidate;
                continue;
            }
            if (!updated || ((UnivariatePolynomial)prevCandidate).equals(candidate)) {
                UnivariatePolynomial<UnivariatePolynomial<BigInteger>> rem = UnivariateDivision.pseudoRemainderAdaptive(b, candidate, true);
                if (rem == null || !rem.isZero() || (rem = UnivariateDivision.pseudoRemainderAdaptive(a, candidate, true)) == null || !rem.isZero()) continue;
                return candidate;
            }
            prevCandidate = candidate;
        }
    }

    public static boolean updateCRT(ChineseRemainders.ChineseRemaindersMagic<BigInteger> magic, UnivariatePolynomial<BigInteger> accumulated, UnivariatePolynomialZp64 update) {
        boolean updated = false;
        accumulated.ensureCapacity(update.degree);
        for (int i = Math.max(accumulated.degree, update.degree); i >= 0; --i) {
            BigInteger newCf;
            BigInteger oldCf = accumulated.get(i);
            if (!oldCf.equals(newCf = ChineseRemainders.ChineseRemainders(Rings.Z, magic, oldCf, BigInteger.valueOf(update.get(i))))) {
                updated = true;
            }
            ((BigInteger[])accumulated.data)[i] = newCf;
        }
        accumulated.fixDegree();
        return updated;
    }
}

