/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.Ring;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZp64;
import gnu.trove.list.array.TLongArrayList;
import java.util.ArrayList;

public final class UnivariateInterpolation {
    private UnivariateInterpolation() {
    }

    private static void checkInput(long[] points, long[] values) {
        if (points.length != values.length) {
            throw new IllegalArgumentException();
        }
    }

    public static UnivariatePolynomialZp64 interpolateLagrange(long modulus, long[] points, long[] values) {
        UnivariateInterpolation.checkInput(points, values);
        int length = points.length;
        IntegersZp64 ring = new IntegersZp64(modulus);
        UnivariatePolynomialZp64 result = UnivariatePolynomialZp64.zero(ring);
        for (int i = 0; i < length; ++i) {
            UnivariatePolynomialZp64 interpolant = UnivariatePolynomialZp64.constant(modulus, values[i]);
            for (int j = 0; j < length; ++j) {
                if (j == i) continue;
                UnivariatePolynomialZp64 linear = ((UnivariatePolynomialZp64)result.createLinear(ring.negate(points[j]), 1L)).divide(ring.subtract(points[i], points[j]));
                interpolant = interpolant.multiply(linear);
            }
            result = result.add(interpolant);
        }
        return result;
    }

    public static <E> UnivariatePolynomial<E> interpolateLagrange(Ring<E> ring, E[] points, E[] values) {
        UnivariateInterpolation.checkInput(points, values);
        int length = points.length;
        UnivariatePolynomial<E> result = UnivariatePolynomial.zero(ring);
        for (int i = 0; i < length; ++i) {
            UnivariatePolynomial<E> interpolant = UnivariatePolynomial.constant(ring, values[i]);
            for (int j = 0; j < length; ++j) {
                if (j == i) continue;
                UnivariatePolynomial<E> linear = result.createLinear(ring.negate(points[j]), ring.getOne()).divideExact(ring.subtract(points[i], points[j]));
                interpolant = interpolant.multiply(linear);
            }
            result = result.add(interpolant);
        }
        return result;
    }

    public static UnivariatePolynomialZp64 interpolateNewton(long modulus, long[] points, long[] values) {
        return UnivariateInterpolation.interpolateNewton(new IntegersZp64(modulus), points, values);
    }

    public static UnivariatePolynomialZp64 interpolateNewton(IntegersZp64 ring, long[] points, long[] values) {
        UnivariateInterpolation.checkInput(points, values);
        return new InterpolationZp64(ring).update(points, values).getInterpolatingPolynomial();
    }

    private static void checkInput(Object[] points, Object[] values) {
        if (points.length != values.length) {
            throw new IllegalArgumentException();
        }
    }

    public static <E> UnivariatePolynomial<E> interpolateNewton(Ring<E> ring, E[] points, E[] values) {
        UnivariateInterpolation.checkInput(points, values);
        return new Interpolation<E>(ring).update(points, values).getInterpolatingPolynomial();
    }

    public static final class Interpolation<E> {
        private final Ring<E> ring;
        private final ArrayList<E> points = new ArrayList();
        private final ArrayList<E> values = new ArrayList();
        private final ArrayList<E> mixedRadix = new ArrayList();
        private final UnivariatePolynomial<E> lins;
        private final UnivariatePolynomial<E> poly;

        public Interpolation(Ring<E> ring) {
            this.ring = ring;
            this.lins = UnivariatePolynomial.one(ring);
            this.poly = UnivariatePolynomial.one(ring);
        }

        public Interpolation<E> update(E point, E value) {
            if (this.points.isEmpty()) {
                this.points.add(point);
                this.values.add(value);
                this.mixedRadix.add(value);
                this.poly.multiply(value);
                return this;
            }
            E reciprocal = this.ring.subtract(point, this.points.get(0));
            E accumulator = this.mixedRadix.get(0);
            for (int i = 1; i < this.points.size(); ++i) {
                accumulator = this.ring.add(accumulator, this.ring.multiply(this.mixedRadix.get(i), reciprocal));
                reciprocal = this.ring.multiply(reciprocal, this.ring.subtract(point, this.points.get(i)));
            }
            if (this.ring.isZero(reciprocal)) {
                throw new IllegalArgumentException("Point " + point + " was already used in interpolation.");
            }
            reciprocal = this.ring.reciprocal(reciprocal);
            this.mixedRadix.add(this.ring.multiply(reciprocal, this.ring.subtract(value, accumulator)));
            this.lins.multiply(this.lins.createLinear(this.ring.negate(this.points.get(this.points.size() - 1)), this.ring.getOne()));
            this.poly.add(((UnivariatePolynomial)this.lins.clone()).multiply(this.mixedRadix.get(this.mixedRadix.size() - 1)));
            this.points.add(point);
            this.values.add(value);
            return this;
        }

        public Interpolation<E> update(E[] points, E[] values) {
            for (int i = 0; i < points.length; ++i) {
                this.update(points[i], values[i]);
            }
            return this;
        }

        public UnivariatePolynomial<E> getInterpolatingPolynomial() {
            return this.poly;
        }

        public ArrayList<E> getPoints() {
            return this.points;
        }

        public ArrayList<E> getValues() {
            return this.values;
        }

        public int numberOfPoints() {
            return this.points.size();
        }
    }

    public static final class InterpolationZp64 {
        private final IntegersZp64 ring;
        private final TLongArrayList points = new TLongArrayList();
        private final TLongArrayList values = new TLongArrayList();
        private final TLongArrayList mixedRadix = new TLongArrayList();
        private final UnivariatePolynomialZp64 lins;
        private final UnivariatePolynomialZp64 poly;

        public InterpolationZp64(IntegersZp64 ring) {
            this.ring = ring;
            this.lins = UnivariatePolynomialZp64.one(ring);
            this.poly = UnivariatePolynomialZp64.one(ring);
        }

        public InterpolationZp64 update(long point, long value) {
            if (this.points.isEmpty()) {
                this.poly.multiply(value);
                this.points.add(point);
                this.values.add(value);
                this.mixedRadix.add(value);
                return this;
            }
            long reciprocal = this.poly.subtract(point, this.points.get(0));
            long accumulator = this.mixedRadix.get(0);
            for (int i = 1; i < this.points.size(); ++i) {
                accumulator = this.ring.add(accumulator, this.ring.multiply(this.mixedRadix.get(i), reciprocal));
                reciprocal = this.ring.multiply(reciprocal, this.ring.subtract(point, this.points.get(i)));
            }
            if (reciprocal == 0L) {
                throw new IllegalArgumentException("Point " + point + " was already used in interpolation.");
            }
            reciprocal = this.ring.reciprocal(reciprocal);
            this.mixedRadix.add(this.ring.multiply(reciprocal, this.ring.subtract(value, accumulator)));
            this.lins.multiply((UnivariatePolynomialZp64)this.lins.createLinear(this.ring.negate(this.points.get(this.points.size() - 1)), 1L));
            this.poly.add((UnivariatePolynomialZp64)this.lins.clone().multiply(this.mixedRadix.get(this.mixedRadix.size() - 1)));
            this.points.add(point);
            this.values.add(value);
            return this;
        }

        public InterpolationZp64 update(long[] points, long[] values) {
            for (int i = 0; i < points.length; ++i) {
                this.update(points[i], values[i]);
            }
            return this;
        }

        public UnivariatePolynomialZp64 getInterpolatingPolynomial() {
            return this.poly;
        }

        public TLongArrayList getPoints() {
            return this.points;
        }

        public TLongArrayList getValues() {
            return this.values;
        }

        public int numberOfPoints() {
            return this.points.size();
        }
    }
}

