/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.poly.univar;

import cc.redberry.rings.IntegersZp;
import cc.redberry.rings.IntegersZp64;
import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.io.IStringifier;
import cc.redberry.rings.poly.multivar.AMultivariatePolynomial;
import cc.redberry.rings.poly.multivar.DegreeVector;
import cc.redberry.rings.poly.multivar.MonomialOrder;
import cc.redberry.rings.poly.multivar.MultivariatePolynomialZp64;
import cc.redberry.rings.poly.univar.AUnivariatePolynomial64;
import cc.redberry.rings.poly.univar.UnivariatePolynomial;
import cc.redberry.rings.poly.univar.UnivariatePolynomialZ64;
import java.util.Arrays;
import java.util.Comparator;

public final class UnivariatePolynomialZp64
extends AUnivariatePolynomial64<UnivariatePolynomialZp64> {
    private static final long serialVersionUID = 1L;
    public final IntegersZp64 ring;

    private UnivariatePolynomialZp64(IntegersZp64 ring, long[] data, int degree) {
        this.ring = ring;
        this.data = data;
        this.degree = degree;
        assert (data.length > 0);
    }

    private UnivariatePolynomialZp64(IntegersZp64 ring, long[] data) {
        this(ring, data, data.length - 1);
        this.fixDegree();
    }

    private static void checkModulus(long modulus) {
        if (Long.compare(modulus, 0x3FFFFFFFFFFFFFFFL) > 0) {
            throw new IllegalArgumentException("Too large modulus. Modulus should be less than 2^62");
        }
    }

    @Deprecated
    public static UnivariatePolynomialZp64 parse(String string, long modulus) {
        return UnivariatePolynomialZp64.parse(string, new IntegersZp64(modulus));
    }

    @Deprecated
    public static UnivariatePolynomialZp64 parse(String string, IntegersZp64 modulus) {
        return UnivariatePolynomial.asOverZp64(UnivariatePolynomial.parse(string, modulus.asGenericRing()));
    }

    public static UnivariatePolynomialZp64 parse(String string, IntegersZp64 modulus, String variable) {
        return UnivariatePolynomial.asOverZp64(UnivariatePolynomial.parse(string, modulus.asGenericRing(), variable));
    }

    public static UnivariatePolynomialZp64 create(long modulus, long[] data) {
        return UnivariatePolynomialZp64.create(new IntegersZp64(modulus), data);
    }

    public static UnivariatePolynomialZp64 create(IntegersZp64 ring, long[] data) {
        ring.modulus(data);
        return new UnivariatePolynomialZp64(ring, data);
    }

    public static UnivariatePolynomialZp64 linear(long cc, long lc, long modulus) {
        return UnivariatePolynomialZp64.create(modulus, new long[]{cc, lc});
    }

    public static UnivariatePolynomialZp64 createUnsafe(long modulus, long[] data) {
        return new UnivariatePolynomialZp64(new IntegersZp64(modulus), data);
    }

    public static UnivariatePolynomialZp64 createUnsafe(IntegersZp64 ring, long[] data) {
        return new UnivariatePolynomialZp64(ring, data);
    }

    public static UnivariatePolynomialZp64 monomial(long modulus, long coefficient, int exponent) {
        IntegersZp64 ring = new IntegersZp64(modulus);
        coefficient = ring.modulus(coefficient);
        long[] data = new long[exponent + 1];
        data[exponent] = coefficient;
        return new UnivariatePolynomialZp64(ring, data);
    }

    public static UnivariatePolynomialZp64 constant(long modulus, long value) {
        return UnivariatePolynomialZp64.constant(new IntegersZp64(modulus), value);
    }

    public static UnivariatePolynomialZp64 constant(IntegersZp64 ring, long value) {
        return new UnivariatePolynomialZp64(ring, new long[]{ring.modulus(value)}, 0);
    }

    public static UnivariatePolynomialZp64 zero(long modulus) {
        return UnivariatePolynomialZp64.constant(modulus, 0L);
    }

    public static UnivariatePolynomialZp64 zero(IntegersZp64 ring) {
        return new UnivariatePolynomialZp64(ring, new long[]{0L}, 0);
    }

    public static UnivariatePolynomialZp64 one(long modulus) {
        return UnivariatePolynomialZp64.constant(modulus, 1L);
    }

    public static UnivariatePolynomialZp64 one(IntegersZp64 ring) {
        return new UnivariatePolynomialZp64(ring, new long[]{1L}, 0);
    }

    @Override
    public UnivariatePolynomialZp64 setCoefficientRingFrom(UnivariatePolynomialZp64 univariatePolynomialZp64) {
        return this.setModulus(univariatePolynomialZp64.ring);
    }

    public long modulus() {
        return this.ring.modulus;
    }

    public UnivariatePolynomialZp64 setModulusUnsafe(long newModulus) {
        return this.setModulusUnsafe(new IntegersZp64(newModulus));
    }

    public UnivariatePolynomialZp64 setModulusUnsafe(IntegersZp64 newModulus) {
        return new UnivariatePolynomialZp64(newModulus, this.data, this.degree);
    }

    public UnivariatePolynomialZp64 setModulus(long newModulus) {
        long[] newData = (long[])this.data.clone();
        IntegersZp64 newDomain = new IntegersZp64(newModulus);
        newDomain.modulus(newData);
        return new UnivariatePolynomialZp64(newDomain, newData);
    }

    public UnivariatePolynomialZp64 setModulus(IntegersZp64 newDomain) {
        long[] newData = (long[])this.data.clone();
        newDomain.modulus(newData);
        return new UnivariatePolynomialZp64(newDomain, newData);
    }

    public UnivariatePolynomialZ64 asPolyZSymmetric() {
        long[] newData = new long[this.degree + 1];
        for (int i = this.degree; i >= 0; --i) {
            newData[i] = this.ring.symmetricForm(this.data[i]);
        }
        return UnivariatePolynomialZ64.create(newData);
    }

    public UnivariatePolynomialZ64 asPolyZ(boolean copy) {
        return UnivariatePolynomialZ64.create(copy ? (long[])this.data.clone() : this.data);
    }

    public UnivariatePolynomialZp64[] createArray(int length) {
        return new UnivariatePolynomialZp64[length];
    }

    public UnivariatePolynomialZp64[] createArray(UnivariatePolynomialZp64 a, UnivariatePolynomialZp64 b) {
        return new UnivariatePolynomialZp64[]{a, b};
    }

    public UnivariatePolynomialZp64[][] createArray2d(int length) {
        return new UnivariatePolynomialZp64[length][];
    }

    public UnivariatePolynomialZp64[][] createArray2d(int length1, int length2) {
        return new UnivariatePolynomialZp64[length1][length2];
    }

    @Override
    public UnivariatePolynomialZp64 getRange(int from, int to) {
        return new UnivariatePolynomialZp64(this.ring, Arrays.copyOfRange(this.data, from, to));
    }

    @Override
    public boolean sameCoefficientRingWith(UnivariatePolynomialZp64 oth) {
        return this.ring.modulus == oth.ring.modulus;
    }

    @Override
    public UnivariatePolynomialZp64 createFromArray(long[] newData) {
        this.ring.modulus(newData);
        return new UnivariatePolynomialZp64(this.ring, newData);
    }

    @Override
    public UnivariatePolynomialZp64 createMonomial(long coefficient, int newDegree) {
        long[] newData = new long[newDegree + 1];
        newData[newDegree] = this.valueOf(coefficient);
        return new UnivariatePolynomialZp64(this.ring, newData, newDegree);
    }

    @Override
    public boolean isOverField() {
        return true;
    }

    @Override
    public boolean isOverFiniteField() {
        return true;
    }

    @Override
    public boolean isOverZ() {
        return false;
    }

    @Override
    public BigInteger coefficientRingCardinality() {
        return BigInteger.valueOf(this.modulus());
    }

    @Override
    public BigInteger coefficientRingCharacteristic() {
        return BigInteger.valueOf(this.modulus());
    }

    @Override
    public boolean isOverPerfectPower() {
        return this.ring.isPerfectPower();
    }

    @Override
    public BigInteger coefficientRingPerfectPowerBase() {
        return BigInteger.valueOf(this.ring.perfectPowerBase());
    }

    @Override
    public BigInteger coefficientRingPerfectPowerExponent() {
        return BigInteger.valueOf(this.ring.perfectPowerExponent());
    }

    @Override
    public long content() {
        return this.lc();
    }

    @Override
    long add(long a, long b) {
        return this.ring.add(a, b);
    }

    @Override
    long subtract(long a, long b) {
        return this.ring.subtract(a, b);
    }

    @Override
    long multiply(long a, long b) {
        return this.ring.multiply(a, b);
    }

    @Override
    long negate(long a) {
        return this.ring.negate(a);
    }

    @Override
    long valueOf(long a) {
        return this.ring.modulus(a);
    }

    @Override
    public UnivariatePolynomialZp64 monic() {
        if (this.isMonic()) {
            return this;
        }
        if (this.isZero()) {
            return this;
        }
        if (this.degree == 0) {
            this.data[0] = 1L;
            return this;
        }
        return (UnivariatePolynomialZp64)this.multiply(this.ring.reciprocal(this.lc()));
    }

    @Override
    public UnivariatePolynomialZp64 monic(long factor) {
        return (UnivariatePolynomialZp64)this.multiply(this.multiply(this.valueOf(factor), this.ring.reciprocal(this.lc())));
    }

    @Override
    public UnivariatePolynomialZp64 divideByLC(UnivariatePolynomialZp64 other) {
        return this.divide(other.lc());
    }

    public UnivariatePolynomialZp64 divide(long val) {
        return (UnivariatePolynomialZp64)this.multiply(this.ring.reciprocal(val));
    }

    @Override
    public UnivariatePolynomialZp64 multiplyByBigInteger(BigInteger factor) {
        return (UnivariatePolynomialZp64)this.multiply(factor.mod(BigInteger.valueOf(this.modulus())).longValueExact());
    }

    @Override
    public UnivariatePolynomialZp64 multiply(UnivariatePolynomialZp64 oth) {
        this.assertSameCoefficientRingWith(oth);
        if (this.isZero()) {
            return this;
        }
        if (oth.isZero()) {
            return (UnivariatePolynomialZp64)this.toZero();
        }
        if (this == oth) {
            return this.square();
        }
        this.assertSameCoefficientRingWith(oth);
        if (oth.degree == 0) {
            return (UnivariatePolynomialZp64)this.multiply(oth.data[0]);
        }
        if (this.degree == 0) {
            long factor = this.data[0];
            this.set(oth);
            return (UnivariatePolynomialZp64)this.multiply(factor);
        }
        double rBound = this.normMax() * oth.normMax() * (double)Math.max(this.degree + 1, oth.degree + 1);
        if (rBound < 9.223372036854776E18) {
            this.data = this.multiplyUnsafe0(oth);
            this.degree += oth.degree;
            this.ring.modulus(this.data);
            this.fixDegree();
        } else {
            this.data = this.multiplySafe0(oth);
            this.degree += oth.degree;
            this.fixDegree();
        }
        return this;
    }

    @Override
    public UnivariatePolynomialZp64 square() {
        if (this.isZero()) {
            return this;
        }
        if (this.degree == 0) {
            return (UnivariatePolynomialZp64)this.multiply(this.data[0]);
        }
        double norm1 = this.normMax();
        double rBound = norm1 * norm1 * (double)(this.degree + 1);
        if (rBound < 9.223372036854776E18) {
            this.data = this.squareUnsafe0();
            this.degree += this.degree;
            this.ring.modulus(this.data);
            this.fixDegree();
        } else {
            this.data = this.squareSafe0();
            this.degree += this.degree;
            this.fixDegree();
        }
        return this;
    }

    @Override
    public UnivariatePolynomialZp64 derivative() {
        if (this.isConstant()) {
            return (UnivariatePolynomialZp64)this.createZero();
        }
        long[] newData = new long[this.degree];
        if ((long)this.degree < this.ring.modulus) {
            for (int i = this.degree; i > 0; --i) {
                newData[i - 1] = this.multiply(this.data[i], i);
            }
        } else {
            int i = this.degree;
            while ((long)i >= this.ring.modulus) {
                newData[i - 1] = this.multiply(this.data[i], this.valueOf(i));
                --i;
            }
            while (i > 0) {
                newData[i - 1] = this.multiply(this.data[i], i);
                --i;
            }
        }
        return new UnivariatePolynomialZp64(this.ring, newData);
    }

    @Override
    public UnivariatePolynomial<BigInteger> toBigPoly() {
        return UnivariatePolynomial.createUnsafe(new IntegersZp(this.ring.modulus), this.dataToBigIntegers());
    }

    @Override
    public UnivariatePolynomialZp64 clone() {
        return new UnivariatePolynomialZp64(this.ring, (long[])this.data.clone(), this.degree);
    }

    @Override
    public UnivariatePolynomialZp64 parsePoly(String string) {
        return UnivariatePolynomialZ64.parse(string).modulus(this.ring);
    }

    @Override
    void multiplyClassicalSafe(long[] result, long[] a, int aFrom, int aTo, long[] b, int bFrom, int bTo) {
        if (this.ring.modulusFits32) {
            this.multiplyClassicalSafeTrick(result, a, aFrom, aTo, b, bFrom, bTo);
        } else {
            super.multiplyClassicalSafe(result, a, aFrom, aTo, b, bFrom, bTo);
        }
    }

    void multiplyClassicalSafeNoTrick(long[] result, long[] a, int aFrom, int aTo, long[] b, int bFrom, int bTo) {
        super.multiplyClassicalSafe(result, a, aFrom, aTo, b, bFrom, bTo);
    }

    final void multiplyClassicalSafeTrick(long[] result, long[] a, int aFrom, int aTo, long[] b, int bFrom, int bTo) {
        if (aTo - aFrom > bTo - bFrom) {
            this.multiplyClassicalSafeTrick(result, b, bFrom, bTo, a, aFrom, aTo);
            return;
        }
        long p2 = this.ring.modulus * this.ring.modulus;
        int aDegree = aTo - aFrom - 1;
        int bDegree = bTo - bFrom - 1;
        int resultDegree = aDegree + bDegree;
        for (int i = 0; i <= resultDegree; ++i) {
            long acc = 0L;
            int to = Math.min(i, aDegree);
            for (int j = Math.max(0, i - bDegree); j <= to; ++j) {
                if (acc > 0L) {
                    acc -= p2;
                }
                acc += a[aFrom + j] * b[bFrom + i - j];
            }
            result[i] = this.ring.modulus(acc);
        }
    }

    @Override
    public String coefficientRingToString(IStringifier<UnivariatePolynomialZp64> stringifier) {
        return this.ring.toString();
    }

    @Override
    public MultivariatePolynomialZp64 composition(AMultivariatePolynomial value) {
        if (!(value instanceof MultivariatePolynomialZp64)) {
            throw new IllegalArgumentException();
        }
        if (value.isOne()) {
            return this.asMultivariate();
        }
        if (value.isZero()) {
            return ((UnivariatePolynomialZp64)this.ccAsPoly()).asMultivariate();
        }
        MultivariatePolynomialZp64 result = (MultivariatePolynomialZp64)value.createZero();
        for (int i = this.degree; i >= 0; --i) {
            result = result.multiply((MultivariatePolynomialZp64)value).add(this.data[i]);
        }
        return result;
    }

    @Override
    public MultivariatePolynomialZp64 asMultivariate() {
        return this.asMultivariate((Comparator)MonomialOrder.DEFAULT);
    }

    @Override
    public MultivariatePolynomialZp64 asMultivariate(Comparator<DegreeVector> ordering) {
        return MultivariatePolynomialZp64.asMultivariate(this, 1, 0, ordering);
    }
}

