/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.primes;

import cc.redberry.rings.bigint.BigInteger;
import cc.redberry.rings.primes.QuadraticSieve;
import cc.redberry.rings.primes.SieveOfAtkin;
import cc.redberry.rings.primes.SmallPrimes;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.random.Well1024a;

public final class BigPrimes {
    private static final BigInteger MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final Well1024a privateRandom = new Well1024a(1918018385501579851L);

    private BigPrimes() {
    }

    public static boolean isPrime(long n) {
        if (n < Integer.MAX_VALUE) {
            return SmallPrimes.isPrime((int)n);
        }
        return BigPrimes.isPrime(BigInteger.valueOf(n));
    }

    public static boolean isPrime(BigInteger n) {
        if (n.signum() < 0) {
            throw new IllegalArgumentException("Argument must be positive");
        }
        if (n.compareTo(SieveOfAtkin.SmallPrimesSieve.getLimitAsBigInteger()) < 0) {
            return SieveOfAtkin.SmallPrimesSieve.isPrime(n.intValue());
        }
        if (n.compareTo(MAX_INT) < 0) {
            return SmallPrimes.isPrime(n.intValue());
        }
        for (int p : SmallPrimes.SmallPrimes12) {
            if (!n.mod(BigInteger.valueOf(p)).isZero()) continue;
            return false;
        }
        if (!n.isProbablePrime(5)) {
            return false;
        }
        if (BigPrimes.LucasPrimalityTest(n, 20, (RandomGenerator)privateRandom)) {
            return true;
        }
        return BigPrimes.findFactorHard(n).equals(n);
    }

    public static boolean LucasPrimalityTest(BigInteger n, int k, RandomGenerator rnd) {
        int bound = n.compareTo(MAX_INT) > 0 ? Integer.MAX_VALUE : n.intValue();
        BigInteger nMinusOne = n.decrement();
        List<BigInteger> factors = null;
        block0: while (k-- > 0) {
            BigInteger a = BigInteger.valueOf(7 + rnd.nextInt(bound - 7));
            if (!a.modPow(nMinusOne, n).isOne()) {
                return false;
            }
            if (factors == null) {
                factors = BigPrimes.primeFactors(nMinusOne);
            }
            for (BigInteger q : factors) {
                if (!a.modPow(nMinusOne.divide(q), n).isOne()) continue;
                continue block0;
            }
            return true;
        }
        return false;
    }

    public static BigInteger nextPrime(BigInteger n) {
        while (!BigPrimes.isPrime(n)) {
            n = n.nextProbablePrime();
        }
        return n;
    }

    public static long nextPrime(long n) {
        BigInteger nb = BigInteger.valueOf(n);
        while (!BigPrimes.isPrime(nb)) {
            nb = nb.nextProbablePrime();
        }
        return nb.longValueExact();
    }

    public static BigInteger fermat(BigInteger n, long upperBound) {
        long cnt = 0L;
        BigInteger x = QuadraticSieve.sqrtBigInt(n).add(BigInteger.ONE);
        BigInteger u = x.multiply(BigInteger.TWO).add(BigInteger.ONE);
        BigInteger v = BigInteger.ONE;
        BigInteger r = x.multiply(x).subtract(n);
        while (!r.isZero()) {
            if (++cnt > upperBound) {
                return BigInteger.ZERO;
            }
            while (r.compareTo(BigInteger.ZERO) > 0) {
                r = r.subtract(v);
                v = v.add(BigInteger.TWO);
            }
            if (r.compareTo(BigInteger.ZERO) >= 0) continue;
            r = r.add(u);
            u = u.add(BigInteger.TWO);
        }
        return u.subtract(v).divide(BigInteger.TWO);
    }

    public static BigInteger PollardRho(BigInteger n, int attempts, RandomGenerator rn) {
        BigInteger divisor;
        BigInteger x;
        if (n.mod(BigInteger.TWO).isZero()) {
            return BigInteger.TWO;
        }
        BigInteger c = new BigInteger(n.bitLength(), rn);
        BigInteger xx = x = new BigInteger(n.bitLength(), rn);
        do {
            x = x.multiply(x).mod(n).add(c).mod(n);
            xx = xx.multiply(xx).mod(n).add(c).mod(n);
            xx = xx.multiply(xx).mod(n).add(c).mod(n);
            divisor = x.subtract(xx).gcd(n);
        } while (attempts-- > 0 && divisor.isOne());
        return divisor.isOne() ? null : divisor;
    }

    public static BigInteger PollardRho(BigInteger n, long upperBound) {
        long range = 1L;
        long terms = 0L;
        BigInteger x1 = BigInteger.TWO;
        BigInteger x2 = BigInteger.FIVE;
        BigInteger product = BigInteger.ONE;
        while (terms <= upperBound) {
            long j;
            for (j = 1L; j <= range; ++j) {
                x2 = x2.multiply(x2).add(BigInteger.ONE).mod(n);
                product = product.multiply(x1.subtract(x2)).mod(n);
                if (terms++ > upperBound) break;
                if (terms % 5L != 0L) continue;
                BigInteger g = n.gcd(product);
                if (g.compareTo(BigInteger.ONE) > 0) {
                    return g;
                }
                product = BigInteger.ONE;
            }
            x1 = x2;
            range *= 2L;
            for (j = 1L; j <= range; ++j) {
                x2 = x2.multiply(x2).add(BigInteger.ONE).mod(n);
            }
        }
        return null;
    }

    public static BigInteger PollardP1(BigInteger n, long upperBound) {
        for (int outerCnt = 0; outerCnt < 5; ++outerCnt) {
            BigInteger m;
            switch (outerCnt) {
                case 0: {
                    m = BigInteger.TWO;
                    break;
                }
                case 1: {
                    m = BigInteger.THREE;
                    break;
                }
                case 2: {
                    m = BigInteger.FOUR;
                    break;
                }
                case 3: {
                    m = BigInteger.FIVE;
                    break;
                }
                case 4: {
                    m = BigInteger.SEVEN;
                    break;
                }
                default: {
                    m = BigInteger.TWO;
                }
            }
            BigInteger i = BigInteger.ONE;
            for (long cnt = 2L; cnt <= upperBound; ++cnt) {
                BigInteger g;
                i = i.add(BigInteger.ONE);
                m = m.modPow(i, n);
                if (cnt % 5L != 0L || (g = n.gcd(m.subtract(BigInteger.ONE))).compareTo(BigInteger.ONE) <= 0 || g.compareTo(n) >= 0) continue;
                return g;
            }
        }
        return null;
    }

    public static BigInteger QuadraticSieve(BigInteger n, int bound) {
        return new QuadraticSieve(n).quadraticSieve(bound);
    }

    static BigInteger findFactorHard(BigInteger n) {
        BigInteger r;
        int numBits = n.bitCount();
        if (numBits < 20 && (r = BigPrimes.PollardRho(n, 131072L)) != null) {
            return r;
        }
        if (numBits < 30) {
            r = BigPrimes.PollardRho(n, 1024, (RandomGenerator)privateRandom);
            if (r != null) {
                return r;
            }
            r = BigPrimes.PollardRho(n, 131072L);
            if (r != null) {
                return r;
            }
        }
        if (numBits < 60) {
            r = BigPrimes.PollardRho(n, 128L);
            if (r != null) {
                return r;
            }
            r = BigPrimes.PollardRho(n, 128, (RandomGenerator)privateRandom);
            if (r != null) {
                return r;
            }
            r = BigPrimes.PollardP1(n, 128L);
            if (r != null) {
                return r;
            }
            r = BigPrimes.PollardRho(n, 131072L);
            if (r != null) {
                return r;
            }
        }
        if ((r = BigPrimes.PollardRho(n, 128L)) != null) {
            return r;
        }
        r = BigPrimes.PollardP1(n, 128L);
        if (r != null) {
            return r;
        }
        r = BigPrimes.PollardRho(n, 1032, (RandomGenerator)privateRandom);
        if (r != null) {
            return r;
        }
        r = BigPrimes.PollardRho(n, 131072L);
        if (r != null) {
            return r;
        }
        r = BigPrimes.PollardP1(n, 131072L);
        if (r != null) {
            return r;
        }
        assert (n.compareTo(BigInteger.valueOf(32768)) >= 0) : n;
        r = BigPrimes.QuadraticSieve(n, 32768);
        assert (r != null);
        if (r.isOne()) {
            return n;
        }
        return r;
    }

    private static boolean checkKnownSmallPrime(BigInteger b) {
        return b.compareTo(SieveOfAtkin.SmallPrimesSieve.getLimitAsBigInteger()) < 0 && SieveOfAtkin.SmallPrimesSieve.isPrime(b.intValue());
    }

    public static long[] primeFactors(long num) {
        return BigPrimes.primeFactors(BigInteger.valueOf(num)).stream().mapToLong(BigInteger::longValueExact).toArray();
    }

    public static List<BigInteger> primeFactors(BigInteger num) {
        ArrayList<BigInteger> factors = new ArrayList<BigInteger>();
        if (num.compareTo(BigInteger.TWO) < 0) {
            factors.add(num);
            return factors;
        }
        if (BigPrimes.checkKnownSmallPrime(num)) {
            factors.add(num);
            return factors;
        }
        if ((num = BigPrimes.TrialDivision(num, factors)).isOne()) {
            return factors;
        }
        if (BigPrimes.isPrime(num)) {
            factors.add(num);
            return factors;
        }
        BigPrimes.HardFactor(num, factors);
        return factors;
    }

    static BigInteger TrialDivision(BigInteger num, ArrayList<BigInteger> factors) {
        for (int p : SmallPrimes.SmallPrimes12) {
            BigInteger prime = BigInteger.valueOf(p);
            BigInteger[] qr = num.divideAndRemainder(prime);
            while (qr[1].isZero()) {
                num = qr[0];
                factors.add(prime);
                qr = num.divideAndRemainder(prime);
            }
        }
        return num;
    }

    static void HardFactor(BigInteger num, ArrayList<BigInteger> factors) {
        while (true) {
            BigInteger factor;
            if ((factor = BigPrimes.findFactorHard(num)).isOne() || factor.equals(num)) {
                factors.add(num);
                return;
            }
            if (!BigPrimes.isPrime(factor)) {
                BigPrimes.HardFactor(factor, factors);
            } else {
                factors.add(factor);
            }
            num = num.divide(factor);
        }
    }
}

