/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TimeConstrained {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T timeConstrained0(Callable<T> lambda, long millis, T failExpr) throws InterruptedException, ExecutionException {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        FutureTask<T> task = new FutureTask<T>(lambda);
        executor.execute(task);
        try {
            T t = task.get(millis, TimeUnit.MILLISECONDS);
            return t;
        }
        catch (TimeoutException e) {
            T t = failExpr;
            return t;
        }
        finally {
            task.cancel(true);
            executor.shutdown();
        }
    }

    public static <T> T timeConstrained(Callable<T> lambda, long millis, T failExpr) {
        try {
            return TimeConstrained.timeConstrained0(lambda, millis, failExpr);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T timeConstrained(Callable<T> lambda, long millis) throws InterruptedException, ExecutionException {
        return TimeConstrained.timeConstrained0(lambda, millis, null);
    }
}

