/*
 * Decompiled with CFR 0.152.
 */
package cc.redberry.rings.util;

import org.apache.commons.math3.exception.MathIllegalStateException;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;

public final class TimeUnits {
    private TimeUnits() {
    }

    public static String nanosecondsToString(long nano) {
        String pf = "ns";
        if (nano / 1000L > 1L) {
            pf = "us";
            nano /= 1000L;
        }
        if (nano / 1000L > 1L) {
            pf = "ms";
            nano /= 1000L;
        }
        if (nano / 1000L > 1L) {
            pf = "s";
            nano /= 1000L;
        }
        return nano + pf;
    }

    public static String statisticsNanotime(DescriptiveStatistics stats) {
        return TimeUnits.statisticsNanotime(stats, false);
    }

    public static String statisticsNanotime(DescriptiveStatistics stats, boolean median) {
        return TimeUnits.nanosecondsToString((long)(median ? stats.getPercentile(0.5) : stats.getMean())) + " \u00b1 " + TimeUnits.nanosecondsToString((long)stats.getStandardDeviation());
    }

    private static String ns(double nano) {
        return TimeUnits.nanosecondsToString((long)nano);
    }

    public static String statisticsNanotimeFull(DescriptiveStatistics stats) {
        StringBuilder outBuffer = new StringBuilder();
        String endl = "\n";
        outBuffer.append("DescriptiveStatistics:").append(endl);
        outBuffer.append("n: ").append(stats.getN()).append(endl);
        outBuffer.append("min: ").append(TimeUnits.ns(stats.getMin())).append(endl);
        outBuffer.append("max: ").append(TimeUnits.ns(stats.getMax())).append(endl);
        outBuffer.append("mean: ").append(TimeUnits.ns(stats.getMean())).append(endl);
        outBuffer.append("std dev: ").append(TimeUnits.ns(stats.getStandardDeviation())).append(endl);
        try {
            outBuffer.append("median: ").append(TimeUnits.ns(stats.getPercentile(50.0))).append(endl);
        }
        catch (MathIllegalStateException ex) {
            outBuffer.append("median: unavailable").append(endl);
        }
        outBuffer.append("skewness: ").append(TimeUnits.ns(stats.getSkewness())).append(endl);
        outBuffer.append("kurtosis: ").append(TimeUnits.ns(stats.getKurtosis())).append(endl);
        return outBuffer.toString();
    }
}

