/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen;

import cc.redpen.RedPenException;
import cc.redpen.config.Configuration;
import cc.redpen.config.ConfigurationLoader;
import cc.redpen.config.ValidatorConfiguration;
import cc.redpen.model.Document;
import cc.redpen.model.ListBlock;
import cc.redpen.model.ListElement;
import cc.redpen.model.Paragraph;
import cc.redpen.model.Section;
import cc.redpen.model.Sentence;
import cc.redpen.parser.DocumentParser;
import cc.redpen.parser.PreprocessorRule;
import cc.redpen.parser.SentenceExtractor;
import cc.redpen.validator.ValidationError;
import cc.redpen.validator.Validator;
import cc.redpen.validator.ValidatorFactory;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedPen {
    private static final Logger LOG = LoggerFactory.getLogger(RedPen.class);
    public static final String VERSION = "1.9.0";
    private final Configuration configuration;
    private final SentenceExtractor sentenceExtractor;
    private final List<Validator> validators;

    public RedPen(File configFile) throws RedPenException {
        this(new ConfigurationLoader().load(configFile));
    }

    public RedPen(String configPath) throws RedPenException {
        this(new ConfigurationLoader().loadFromResource(configPath));
    }

    public RedPen(Configuration configuration) throws RedPenException {
        this.configuration = configuration;
        this.sentenceExtractor = new SentenceExtractor(configuration.getSymbolTable());
        this.validators = new ArrayList<Validator>();
    }

    private void initializeValidators() {
        this.validators.clear();
        for (ValidatorConfiguration config : this.configuration.getValidatorConfigs()) {
            try {
                this.validators.add(ValidatorFactory.getInstance(config, this.configuration));
            }
            catch (RedPenException e) {
                throw new IllegalStateException("Failed to initialize validators.", e);
            }
        }
    }

    public Document parse(DocumentParser parser, InputStream InputStream2) throws RedPenException {
        return parser.parse(InputStream2, this.sentenceExtractor, this.configuration.getTokenizer());
    }

    public Document parse(DocumentParser parser, String content) throws RedPenException {
        return parser.parse(content, this.sentenceExtractor, this.configuration.getTokenizer());
    }

    public List<Document> parse(DocumentParser parser, File[] files) throws RedPenException {
        ArrayList<Document> documents = new ArrayList<Document>();
        for (File file : files) {
            documents.add(parser.parse(file, this.sentenceExtractor, this.configuration.getTokenizer()));
        }
        return documents;
    }

    public Map<Document, List<ValidationError>> validate(List<Document> documents) {
        HashMap<Document, List<ValidationError>> docErrorsMap = new HashMap<Document, List<ValidationError>>();
        documents.forEach(e -> {
            List cfr_ignored_0 = docErrorsMap.put((Document)e, new ArrayList());
        });
        this.initializeValidators();
        this.runDocumentValidators(documents, docErrorsMap);
        this.runSectionValidators(documents, docErrorsMap);
        this.runSentenceValidators(documents, docErrorsMap);
        this.applyPreprocessorRules(documents, docErrorsMap);
        return docErrorsMap;
    }

    public List<ValidationError> validate(Document document) {
        ArrayList<Document> documents = new ArrayList<Document>();
        documents.add(document);
        Map<Document, List<ValidationError>> documentListMap = this.validate(documents);
        return documentListMap.get(document);
    }

    public List<Validator> getValidators() {
        return Collections.unmodifiableList(this.validators);
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    private void applyPreprocessorRules(Document document, List<ValidationError> errors) {
        HashSet<ValidationError> suppressedErrors = new HashSet<ValidationError>();
        if (document.getPreprocessorRules() != null) {
            for (ValidationError error : errors) {
                for (PreprocessorRule rule : document.getPreprocessorRules()) {
                    switch (rule.getRuleType()) {
                        case SUPPRESS: {
                            if (!rule.isTriggeredBy(document, error.getLineNumber(), error.getValidatorName())) break;
                            suppressedErrors.add(error);
                        }
                    }
                }
            }
        }
        errors.removeAll(suppressedErrors);
    }

    private void applyPreprocessorRules(List<Document> documents, Map<Document, List<ValidationError>> docErrorsMap) {
        for (Document document : documents) {
            this.applyPreprocessorRules(document, docErrorsMap.get(document));
        }
    }

    private void runDocumentValidators(List<Document> documents, Map<Document, List<ValidationError>> docErrorsMap) {
        for (Document document : documents) {
            ArrayList errors = new ArrayList();
            this.validators.forEach(e -> {
                e.setErrorList(errors);
                e.validate(document);
            });
            docErrorsMap.put(document, errors);
        }
    }

    private void runSectionValidators(List<Document> documents, Map<Document, List<ValidationError>> docErrorsMap) {
        for (Document document : documents) {
            for (Section section : document) {
                this.validators.forEach(e -> e.preValidate(section));
            }
        }
        for (Document document : documents) {
            for (Section section : document) {
                List<ValidationError> errors = docErrorsMap.get(document);
                this.validators.forEach(e -> {
                    e.setErrorList(errors);
                    e.validate(section);
                });
            }
        }
    }

    private void runSentenceValidators(List<Document> documents, Map<Document, List<ValidationError>> docErrorsMap) {
        for (Document document : documents) {
            for (Section section : document) {
                for (Paragraph paragraph : section.getParagraphs()) {
                    this.validators.forEach(e -> paragraph.getSentences().forEach(e::preValidate));
                }
                this.validators.forEach(e -> section.getHeaderContents().forEach(e::preValidate));
                for (ListBlock listBlock : section.getListBlocks()) {
                    for (ListElement listElement : listBlock.getListElements()) {
                        this.validators.forEach(e -> listElement.getSentences().forEach(e::preValidate));
                    }
                }
            }
        }
        for (Document document : documents) {
            for (Section section : document) {
                List<ValidationError> errors = docErrorsMap.get(document);
                for (Paragraph paragraph : section.getParagraphs()) {
                    this.validators.forEach(e -> {
                        e.setErrorList(errors);
                        paragraph.getSentences().forEach(sentence -> e.validate((Sentence)sentence));
                    });
                }
                this.validators.forEach(e -> {
                    e.setErrorList(errors);
                    section.getHeaderContents().forEach(sentence -> e.validate((Sentence)sentence));
                });
                for (ListBlock listBlock : section.getListBlocks()) {
                    for (ListElement listElement : listBlock.getListElements()) {
                        this.validators.forEach(e -> {
                            e.setErrorList(errors);
                            listElement.getSentences().forEach(sentence -> e.validate((Sentence)sentence));
                        });
                    }
                }
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedPen redPen = (RedPen)o;
        return Objects.equals(this.configuration, redPen.configuration);
    }

    public int hashCode() {
        return this.configuration != null ? this.configuration.hashCode() : 0;
    }

    public String toString() {
        return "RedPen{configuration=" + this.configuration + ", sentenceExtractor=" + this.sentenceExtractor + ", validators=" + this.validators + '}';
    }
}

