/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.config;

import cc.redpen.RedPenException;
import cc.redpen.config.Symbol;
import cc.redpen.config.SymbolTable;
import cc.redpen.config.ValidatorConfiguration;
import cc.redpen.tokenizer.JapaneseTokenizer;
import cc.redpen.tokenizer.RedPenTokenizer;
import cc.redpen.tokenizer.WhiteSpaceTokenizer;
import cc.redpen.validator.ValidatorFactory;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class Configuration
implements Serializable,
Cloneable {
    private SymbolTable symbolTable;
    private List<ValidatorConfiguration> validatorConfigs = new ArrayList<ValidatorConfiguration>();
    private final String lang;
    private transient RedPenTokenizer tokenizer;
    private final File home = new File(Optional.ofNullable(System.getProperty("REDPEN_HOME", System.getenv("REDPEN_HOME"))).orElse(""));
    private final File base;
    private final boolean secure;

    public static List<String> getDefaultConfigKeys() {
        return Arrays.asList("en", "ja", "ja.hankaku", "ja.zenkaku2", "ru");
    }

    Configuration(File base, SymbolTable symbolTable, List<ValidatorConfiguration> validatorConfigs, String lang, boolean secure) {
        this.base = base;
        this.symbolTable = symbolTable;
        this.validatorConfigs.addAll(validatorConfigs);
        this.lang = lang;
        this.secure = secure;
        this.initTokenizer();
    }

    private void initTokenizer() {
        this.tokenizer = this.lang.equals("ja") ? new JapaneseTokenizer() : new WhiteSpaceTokenizer();
    }

    public SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public List<ValidatorConfiguration> getValidatorConfigs() {
        return this.validatorConfigs;
    }

    public String getLang() {
        return this.lang;
    }

    public String getVariant() {
        return this.getSymbolTable().getVariant();
    }

    public RedPenTokenizer getTokenizer() {
        return this.tokenizer;
    }

    public String getKey() {
        if (this.getLang().equals("ja") && this.getVariant().equals("zenkaku")) {
            return "ja";
        }
        return this.getLang() + (StringUtils.isEmpty((CharSequence)this.getVariant()) ? "" : "." + this.getVariant());
    }

    public File getHome() {
        return this.home;
    }

    public File getBase() {
        return this.base;
    }

    public File findFile(String relativePath) throws RedPenException {
        File file;
        if (!this.secure && (file = new File(relativePath)).exists()) {
            return file;
        }
        if (this.base != null && this.secureExists(file = new File(this.base, relativePath), this.base)) {
            return file;
        }
        file = new File(this.home, relativePath);
        if (this.secureExists(file, this.home)) {
            return file;
        }
        throw new RedPenException(relativePath + " is not under " + (!this.secure ? "working directory (" + new File("").getAbsoluteFile() + "), " : "") + (this.base != null ? "base (" + this.base + "), " : "") + "$REDPEN_HOME (" + this.home.getAbsolutePath() + ").");
    }

    private boolean secureExists(File file, File base) {
        try {
            return file.exists() && (!this.secure || file.getCanonicalPath().startsWith(base.getCanonicalPath()));
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Configuration clone() {
        try {
            Configuration clone = (Configuration)super.clone();
            clone.validatorConfigs = this.validatorConfigs.stream().map(ValidatorConfiguration::clone).collect(Collectors.toList());
            clone.symbolTable = this.symbolTable.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTokenizer();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration that = (Configuration)o;
        return Objects.equals(this.lang, that.lang) && Objects.equals(this.symbolTable, that.symbolTable) && Objects.equals(this.validatorConfigs, that.validatorConfigs);
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return "Configuration{lang='" + this.lang + '\'' + ", tokenizer=" + this.tokenizer + ", validatorConfigs=" + this.validatorConfigs + ", symbolTable=" + this.symbolTable + '}';
    }

    public static ConfigurationBuilder builder() {
        return new ConfigurationBuilder();
    }

    public static ConfigurationBuilder builder(String key) {
        int dotPos = key.indexOf(46);
        ConfigurationBuilder builder = new ConfigurationBuilder().setLanguage(dotPos > 0 ? key.substring(0, dotPos) : key);
        if (dotPos > 0) {
            builder.setVariant(key.substring(dotPos + 1));
        }
        return builder;
    }

    public static class ConfigurationBuilder {
        private final List<ValidatorConfiguration> validatorConfigs = new ArrayList<ValidatorConfiguration>();
        private final List<Symbol> customSymbols = new ArrayList<Symbol>();
        private boolean built = false;
        private String lang = "en";
        private Optional<String> variant = Optional.empty();
        private File base;
        private boolean secure;

        private void checkBuilt() {
            if (this.built) {
                throw new IllegalStateException("Configuration already built.");
            }
        }

        public ConfigurationBuilder setLanguage(String lang) {
            this.checkBuilt();
            this.lang = lang;
            return this;
        }

        public ConfigurationBuilder setBaseDir(File base) {
            this.checkBuilt();
            this.base = base;
            return this;
        }

        public ConfigurationBuilder addSymbol(Symbol symbol) {
            this.checkBuilt();
            this.customSymbols.add(symbol);
            return this;
        }

        public ConfigurationBuilder addValidatorConfig(ValidatorConfiguration config) {
            this.checkBuilt();
            this.validatorConfigs.add(config);
            return this;
        }

        public ConfigurationBuilder addAvailableValidatorConfigs() {
            this.checkBuilt();
            this.validatorConfigs.addAll(ValidatorFactory.getConfigurations(this.lang));
            return this;
        }

        public ConfigurationBuilder setVariant(String variant) {
            this.checkBuilt();
            this.variant = Optional.of(variant);
            return this;
        }

        public ConfigurationBuilder secure() {
            this.checkBuilt();
            this.secure = true;
            return this;
        }

        public Configuration build() {
            this.checkBuilt();
            this.built = true;
            return new Configuration(this.base, new SymbolTable(this.lang, this.variant, this.customSymbols), this.validatorConfigs, this.lang, this.secure);
        }
    }
}

