/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.config;

import cc.redpen.config.Configuration;
import cc.redpen.config.Symbol;
import cc.redpen.config.SymbolTable;
import cc.redpen.config.SymbolType;
import cc.redpen.config.ValidatorConfiguration;
import cc.redpen.util.IndentingXMLStreamWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class ConfigurationExporter {
    public void export(Configuration config, OutputStream out) {
        try {
            XMLOutputFactory sf = XMLOutputFactory.newInstance();
            IndentingXMLStreamWriter sax = new IndentingXMLStreamWriter(sf.createXMLStreamWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
            this.addRoot(config, sax);
            this.addValidators(config.getValidatorConfigs(), sax);
            this.addNonDefaultSymbols(config.getSymbolTable(), sax);
            sax.writeEndElement();
            sax.flush();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private void addRoot(Configuration config, XMLStreamWriter sax) throws XMLStreamException {
        sax.writeStartElement("redpen-conf");
        sax.writeAttribute("lang", config.getLang());
        if (!config.getVariant().isEmpty()) {
            sax.writeAttribute("variant", config.getVariant());
        }
    }

    private void addValidators(List<ValidatorConfiguration> validators, XMLStreamWriter sax) throws XMLStreamException {
        if (validators.isEmpty()) {
            return;
        }
        sax.writeStartElement("validators");
        for (ValidatorConfiguration v : validators) {
            if (v.getProperties().isEmpty()) {
                sax.writeEmptyElement("validator");
            } else {
                sax.writeStartElement("validator");
            }
            sax.writeAttribute("name", v.getConfigurationName());
            for (Map.Entry<String, String> prop : v.getProperties().entrySet()) {
                sax.writeEmptyElement("property");
                sax.writeAttribute("name", prop.getKey());
                sax.writeAttribute("value", prop.getValue());
            }
            if (v.getProperties().isEmpty()) continue;
            sax.writeEndElement();
        }
        sax.writeEndElement();
    }

    private void addNonDefaultSymbols(SymbolTable symbolTable, XMLStreamWriter sax) throws XMLStreamException {
        Map<SymbolType, Symbol> defaults = symbolTable.getDefaultSymbols();
        List nonDefaultSymbols = symbolTable.getNames().stream().map(symbolTable::getSymbol).filter(s -> !s.equals(defaults.get((Object)s.getType()))).collect(Collectors.toList());
        if (nonDefaultSymbols.isEmpty()) {
            return;
        }
        sax.writeStartElement("symbols");
        for (Symbol symbol : nonDefaultSymbols) {
            sax.writeEmptyElement("symbol");
            sax.writeAttribute("name", symbol.getType().toString());
            sax.writeAttribute("value", String.valueOf(symbol.getValue()));
            if (symbol.getInvalidChars().length > 0) {
                sax.writeAttribute("invalid-chars", String.valueOf(symbol.getInvalidChars()));
            }
            if (symbol.isNeedBeforeSpace()) {
                sax.writeAttribute("before-space", "true");
            }
            if (!symbol.isNeedAfterSpace()) continue;
            sax.writeAttribute("after-space", "true");
        }
        sax.writeEndElement();
    }
}

