/*
 * Decompiled with CFR 0.152.
 */
package cc.redpen.config;

import cc.redpen.RedPenException;
import cc.redpen.config.Configuration;
import cc.redpen.config.Symbol;
import cc.redpen.config.SymbolType;
import cc.redpen.config.ValidatorConfiguration;
import cc.redpen.util.SAXErrorHandler;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigurationLoader {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationLoader.class);
    private boolean secure;

    private static Symbol createSymbol(Element element) throws RedPenException {
        if (!element.hasAttribute("name") || !element.hasAttribute("value")) {
            throw new IllegalStateException("Found element does not have name and value attribute...");
        }
        String value = element.getAttribute("value");
        if (value.length() != 1) {
            throw new RedPenException("value should be one character, specified: " + value);
        }
        char charValue = value.charAt(0);
        return new Symbol(SymbolType.valueOf(element.getAttribute("name")), charValue, element.getAttribute("invalid-chars"), Boolean.parseBoolean(element.getAttribute("before-space")), Boolean.parseBoolean(element.getAttribute("after-space")));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Document toDocument(InputStream input) throws RedPenException {
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        try (BufferedInputStream bis = new BufferedInputStream(input);){
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            dBuilder.setErrorHandler(new SAXErrorHandler());
            Document document = dBuilder.parse(bis);
            return document;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RedPenException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Configuration load(File configFile) throws RedPenException {
        LOG.info("Loading config from specified config file: \"{}\"", (Object)configFile.getAbsolutePath());
        try (FileInputStream fis = new FileInputStream(configFile);){
            Configuration configuration = this.load(fis, configFile.getParentFile());
            return configuration;
        }
        catch (IOException e) {
            throw new RedPenException(e);
        }
    }

    public Configuration loadFromResource(String resourcePath) throws RedPenException {
        return this.loadFromResource(resourcePath, null);
    }

    public Configuration loadFromResource(String resourcePath, File base) throws RedPenException {
        InputStream inputConfigStream = Configuration.class.getResourceAsStream(resourcePath);
        return this.load(inputConfigStream, base);
    }

    public Configuration loadFromString(String configString) throws RedPenException {
        return this.loadFromString(configString, null);
    }

    public Configuration loadFromString(String configString, File base) throws RedPenException {
        return this.load(new ByteArrayInputStream(configString.getBytes(StandardCharsets.UTF_8)), base);
    }

    public Configuration load(InputStream stream) throws RedPenException {
        return this.load(stream, null);
    }

    public Configuration load(InputStream stream, File base) throws RedPenException {
        Element rootElement;
        String language;
        Document doc = ConfigurationLoader.toDocument(stream);
        Configuration.ConfigurationBuilder configBuilder = new Configuration.ConfigurationBuilder().setBaseDir(base);
        if (this.secure) {
            configBuilder.secure();
        }
        if (!(language = (rootElement = this.getRootNode(doc, "redpen-conf")).getAttribute("lang")).isEmpty()) {
            LOG.info("Language is set to \"{}\"", (Object)language);
        } else {
            LOG.warn("No language configuration...");
            LOG.info("Set language to en");
            language = "en";
        }
        String variant = rootElement.getAttribute("variant");
        if (variant.isEmpty() && !(variant = rootElement.getAttribute("type")).isEmpty()) {
            LOG.info("Deprecated: use \"variant\" attribute instead of \"type\"");
        }
        if (variant.isEmpty()) {
            LOG.warn("No variant configuration...");
        } else {
            LOG.info("Variant is set to \"{}\"", (Object)variant);
        }
        NodeList validatorConfigElementList = this.getSpecifiedNodeList(rootElement, "validators");
        if (validatorConfigElementList == null) {
            LOG.warn("There is no validators block");
        } else {
            NodeList validatorElementList = validatorConfigElementList.item(0).getChildNodes();
            this.extractValidatorConfigurations(configBuilder, validatorElementList);
        }
        NodeList symbolTableConfigElementList = this.getSpecifiedNodeList(rootElement, "symbols");
        configBuilder.setLanguage(language);
        if (!variant.isEmpty()) {
            configBuilder.setVariant(variant);
        }
        if (symbolTableConfigElementList != null) {
            this.extractSymbolConfig(configBuilder, symbolTableConfigElementList, language);
        }
        return configBuilder.build();
    }

    private void extractValidatorConfigurations(Configuration.ConfigurationBuilder configBuilder, NodeList validatorElementList) {
        LinkedHashMap<String, ValidatorConfiguration> validatorConfigurations = new LinkedHashMap<String, ValidatorConfiguration>();
        for (int i = 0; i < validatorElementList.getLength(); ++i) {
            Node nNode = validatorElementList.item(i);
            if (nNode.getNodeType() != 1) continue;
            Element element = (Element)nNode;
            if (element.getNodeName().equals("validator")) {
                String currentValidatorName = element.getAttribute("name");
                ValidatorConfiguration currentConfiguration = new ValidatorConfiguration(currentValidatorName);
                if (validatorConfigurations.containsKey(currentValidatorName)) {
                    LOG.warn("Duplicated validator configuration was found: " + currentValidatorName);
                }
                validatorConfigurations.put(currentValidatorName, currentConfiguration);
                NodeList propertyElementList = nNode.getChildNodes();
                this.extractProperties(currentConfiguration, propertyElementList);
                continue;
            }
            LOG.warn("Invalid block: \"" + element.getNodeName() + "\"");
            LOG.warn("Skip this block ...");
        }
        validatorConfigurations.values().forEach(configBuilder::addValidatorConfig);
    }

    private void extractProperties(ValidatorConfiguration currentConfiguration, NodeList propertyElementList) {
        for (int j = 0; j < propertyElementList.getLength(); ++j) {
            Element propertyElement;
            Node pNode = propertyElementList.item(j);
            if (pNode.getNodeType() != 1 || !(propertyElement = (Element)pNode).getNodeName().equals("property") || currentConfiguration == null) continue;
            currentConfiguration.addProperty(propertyElement.getAttribute("name"), propertyElement.getAttribute("value"));
        }
    }

    private void extractSymbolConfig(Configuration.ConfigurationBuilder configBuilder, NodeList symbolTableConfigElementList, String language) throws RedPenException {
        configBuilder.setLanguage(language);
        NodeList symbolTableElementList = this.getSpecifiedNodeList((Element)symbolTableConfigElementList.item(0), "symbol");
        if (symbolTableElementList == null) {
            LOG.warn("there is no character block");
            return;
        }
        for (int temp = 0; temp < symbolTableElementList.getLength(); ++temp) {
            Node nNode = symbolTableElementList.item(temp);
            if (nNode.getNodeType() != 1) continue;
            Element element = (Element)nNode;
            Symbol currentSymbol = ConfigurationLoader.createSymbol(element);
            configBuilder.addSymbol(currentSymbol);
        }
    }

    private NodeList getSpecifiedNodeList(Element rootElement, String elementName) {
        NodeList elementList = rootElement.getElementsByTagName(elementName);
        if (elementList.getLength() == 0) {
            LOG.info("No \"" + elementName + "\" block found in the configuration");
            return null;
        }
        if (elementList.getLength() > 1) {
            LOG.info("More than one \"" + elementName + " \" blocks in the configuration");
        }
        return elementList;
    }

    private Element getRootNode(Document doc, String rootTag) {
        doc.getDocumentElement().normalize();
        NodeList rootConfigElementList = doc.getElementsByTagName(rootTag);
        if (rootConfigElementList.getLength() == 0) {
            throw new IllegalStateException("No \"" + rootTag + "\" block found in the configuration");
        }
        if (rootConfigElementList.getLength() > 1) {
            LOG.warn("More than one \"" + rootTag + "\" blocks in the configuration");
        }
        Node root = rootConfigElementList.item(0);
        Element rootElement = (Element)root;
        LOG.info("Succeeded to load configuration file");
        return rootElement;
    }

    public ConfigurationLoader secure() {
        this.secure = true;
        return this;
    }
}

